/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.gdb.launching;

import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.eclipse.cdt.debug.mi.core.IMILaunchConfigurationConstants;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.concurrent.Sequence;
import org.eclipse.dd.dsf.debug.service.command.ICommand;
import org.eclipse.dd.dsf.gdb.service.GDBRunControl;
import org.eclipse.dd.dsf.gdb.service.GdbProcesses;
import org.eclipse.dd.dsf.gdb.service.control.GDBControl;
import org.eclipse.dd.dsf.mi.core.command.DsfMIBreakInsert;
import org.eclipse.dd.dsf.mi.core.command.DsfMIExecRun;
import org.eclipse.dd.dsf.mi.core.output.DsfMIBreakInsertInfo;
import org.eclipse.dd.dsf.mi.core.output.DsfMIInfo;
import org.eclipse.dd.dsf.mi.event.DsfMIStoppedEvent;
import org.eclipse.dd.dsf.mi.service.ExpressionService;
import org.eclipse.dd.dsf.mi.service.MIBreakpoints;
import org.eclipse.dd.dsf.mi.service.MIMemory;
import org.eclipse.dd.dsf.mi.service.MIRegisters;
import org.eclipse.dd.dsf.mi.service.MIStack;
import org.eclipse.dd.dsf.mi.service.StepQueueManager;
import org.eclipse.dd.dsf.service.DsfServiceEventHandler;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.debug.core.ILaunchConfiguration;

public class LaunchSequence
extends Sequence {
    Sequence.Step[] fSteps = new Sequence.Step[]{new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            LaunchSequence.this.fConnection = new GDBControl(LaunchSequence.this.fSession, LaunchSequence.this.getGDBPath(), LaunchSequence.this.fExecPath, GDBControl.SessionType.RUN, 30);
            LaunchSequence.this.fConnection.initialize(requestMonitor);
        }
    }, new Sequence.Step(){
        private boolean fStopInMain = false;
        private String fStopSymbol = null;

        private boolean readStopAtMain(RequestMonitor requestMonitor) {
            try {
                this.fStopInMain = LaunchSequence.this.fConfig.getAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN", false);
            }
            catch (CoreException e) {
                requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", -1, "Cannot retrieve the entry point symbol", (Throwable)e));
                requestMonitor.done();
                return false;
            }
            return true;
        }

        private boolean readStopSymbol(RequestMonitor requestMonitor) {
            try {
                this.fStopSymbol = LaunchSequence.this.fConfig.getAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN_SYMBOL", "main");
            }
            catch (CoreException e) {
                requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", 5014, "Cannot retrieve the entry point symbol", (Throwable)e));
                requestMonitor.done();
                return false;
            }
            return true;
        }

        public void execute(final RequestMonitor requestMonitor) {
            if (!this.readStopAtMain(requestMonitor)) {
                return;
            }
            if (!this.fStopInMain) {
                requestMonitor.done();
                return;
            }
            if (!this.readStopSymbol(requestMonitor)) {
                return;
            }
            final EntryPointHitEventListener entryPointHitListener = new EntryPointHitEventListener(requestMonitor);
            LaunchSequence.this.fSession.addServiceEventListener((Object)entryPointHitListener, null);
            LaunchSequence.this.fSession.getExecutor().schedule(new Runnable(){

                public void run() {
                    if (!entryPointHitListener.fFinished) {
                        entryPointHitListener.fAborted = true;
                        LaunchSequence.this.fSession.removeServiceEventListener((Object)entryPointHitListener);
                        requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", 5010, "Timed out running to entry point.", null));
                        requestMonitor.done();
                    }
                }
            }, 60L, TimeUnit.SECONDS);
            LaunchSequence.this.fConnection.queueCommand((ICommand)new DsfMIBreakInsert(true, false, null, 0, this.fStopSymbol, 0), (DataRequestMonitor)new DataRequestMonitor<DsfMIBreakInsertInfo>((Executor)LaunchSequence.this.getExecutor(), requestMonitor){

                protected void handleOK() {
                    LaunchSequence.this.fConnection.queueCommand((ICommand)new DsfMIExecRun(new String[0]), (DataRequestMonitor)new DataRequestMonitor<DsfMIInfo>((Executor)LaunchSequence.this.getExecutor(), requestMonitor){

                        protected void handleOK() {
                        }
                    });
                }
            });
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            new GDBRunControl(LaunchSequence.this.fSession).initialize(requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            new StepQueueManager(LaunchSequence.this.fSession).initialize(requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            new GdbProcesses(LaunchSequence.this.fSession).initialize(requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            new MIMemory(LaunchSequence.this.fSession).initialize(requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            new MIStack(LaunchSequence.this.fSession).initialize(requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            new ExpressionService(LaunchSequence.this.fSession).initialize(requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            new MIBreakpoints(LaunchSequence.this.fSession, "org.eclipse.cdt.debug.core").initialize(requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            new MIRegisters(LaunchSequence.this.fSession).initialize(requestMonitor);
        }
    }};
    DsfSession fSession;
    ILaunchConfiguration fConfig;
    IPath fExecPath;
    GDBControl fConnection;

    public LaunchSequence(DsfSession session, ILaunchConfiguration config, IPath execPath) {
        super(session.getExecutor());
        this.fSession = session;
        this.fConfig = config;
        this.fExecPath = execPath;
    }

    public Sequence.Step[] getSteps() {
        return this.fSteps;
    }

    private IPath getGDBPath() {
        Path retVal = new Path("gdb.exe");
        try {
            retVal = new Path(this.fConfig.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUG_NAME, "gdb"));
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return retVal;
    }

    public class EntryPointHitEventListener {
        boolean fAborted = false;
        boolean fFinished = false;
        final RequestMonitor fRequestMonitor;

        EntryPointHitEventListener(RequestMonitor requestMonitor) {
            this.fRequestMonitor = requestMonitor;
        }

        @DsfServiceEventHandler
        public void eventDispatched(DsfMIStoppedEvent e) {
            this.fFinished = true;
            if (!this.fAborted) {
                LaunchSequence.this.fSession.removeServiceEventListener((Object)this);
                this.fRequestMonitor.done();
            }
        }
    }
}

