/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.gdb.service;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.Executor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.gdb.service.control.GDBControl;
import org.eclipse.dd.dsf.mi.event.DsfMIThreadExitEvent;
import org.eclipse.dd.dsf.mi.service.MIRunControl;
import org.eclipse.dd.dsf.service.DsfSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GDBRunControl
extends MIRunControl {
    private GDBControl fGdb;
    private IRunControl.IExecutionDMContext[] fOldExecutionCtxts;

    public GDBRunControl(DsfSession session) {
        super(session);
    }

    public void initialize(final RequestMonitor requestMonitor) {
        super.initialize(new RequestMonitor((Executor)this.getExecutor(), requestMonitor){

            public void handleOK() {
                GDBRunControl.this.doInitialize(requestMonitor);
            }
        });
    }

    private void doInitialize(RequestMonitor requestMonitor) {
        this.fGdb = (GDBControl)this.getServicesTracker().getService(GDBControl.class);
        this.register(new String[]{IRunControl.class.getName(), MIRunControl.class.getName()}, new Hashtable());
        requestMonitor.done();
    }

    public void shutdown(RequestMonitor requestMonitor) {
        this.unregister();
        super.shutdown(requestMonitor);
    }

    public void suspend(IDMContext<?> context, RequestMonitor requestMonitor) {
        if (this.canSuspend(context)) {
            this.fGdb.interrupt();
        } else {
            requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", 10001, "Context cannot be suspended.", null));
        }
        requestMonitor.done();
    }

    public void getExecutionContexts(IRunControl.IContainerDMContext c, final DataRequestMonitor<IRunControl.IExecutionDMContext[]> rm) {
        DataRequestMonitor<IRunControl.IExecutionDMContext[]> rm1 = new DataRequestMonitor<IRunControl.IExecutionDMContext[]>((Executor)this.getExecutor(), rm){

            protected void handleOK() {
                GDBRunControl.this.raiseExitEvents((IRunControl.IExecutionDMContext[])this.getData());
                GDBRunControl.access$202(GDBRunControl.this, (IRunControl.IExecutionDMContext[])this.getData());
                rm.setData((Object)GDBRunControl.this.fOldExecutionCtxts);
                rm.done();
            }
        };
        super.getExecutionContexts(c, (DataRequestMonitor)rm1);
    }

    private void raiseExitEvents(IRunControl.IExecutionDMContext[] ctxts) {
        if (ctxts == null || this.fOldExecutionCtxts == null) {
            return;
        }
        List<IRunControl.IExecutionDMContext> list = Arrays.asList(ctxts);
        List<IRunControl.IExecutionDMContext> oldThreadList = Arrays.asList(this.fOldExecutionCtxts);
        for (IRunControl.IExecutionDMContext ctxt : oldThreadList) {
            if (list.contains(ctxt)) continue;
            DsfMIThreadExitEvent e = new DsfMIThreadExitEvent(((MIRunControl.MIExecutionDMC)ctxt).getThreadId());
            this.getSession().dispatchEvent((Object)e, this.getProperties());
        }
    }

    static /* synthetic */ IRunControl.IExecutionDMContext[] access$202(GDBRunControl x0, IRunControl.IExecutionDMContext[] x1) {
        x0.fOldExecutionCtxts = x1;
        return x1;
    }
}

