/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.gdb.service;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.datamodel.AbstractDMContext;
import org.eclipse.dd.dsf.datamodel.AbstractDMEvent;
import org.eclipse.dd.dsf.datamodel.DMContexts;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.datamodel.IDMData;
import org.eclipse.dd.dsf.datamodel.IDMService;
import org.eclipse.dd.dsf.datamodel.ServiceDMContext;
import org.eclipse.dd.dsf.debug.service.INativeProcesses;
import org.eclipse.dd.dsf.debug.service.command.ICommand;
import org.eclipse.dd.dsf.debug.service.command.ICommandControl;
import org.eclipse.dd.dsf.gdb.service.control.GDBControl;
import org.eclipse.dd.dsf.mi.core.command.DsfCLIInfoThreads;
import org.eclipse.dd.dsf.mi.core.command.DsfMIGDBExit;
import org.eclipse.dd.dsf.mi.core.output.DsfCLIInfoThreadsInfo;
import org.eclipse.dd.dsf.mi.core.output.DsfMIInfo;
import org.eclipse.dd.dsf.mi.event.DsfMIInferiorExitEvent;
import org.eclipse.dd.dsf.mi.event.DsfMIInferiorSignalExitEvent;
import org.eclipse.dd.dsf.mi.event.DsfMIThreadExitEvent;
import org.eclipse.dd.dsf.mi.service.MIRunControl;
import org.eclipse.dd.dsf.service.AbstractDsfService;
import org.eclipse.dd.dsf.service.DsfServiceEventHandler;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.gdb.DsfGdbPlugin;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GdbProcesses
extends AbstractDsfService
implements INativeProcesses {
    private IDMContext<INativeProcesses> fServiceContext;
    private GDBProcessDMC fProcessDMC;
    private ICommandControl fConnection;
    private MIRunControl fRunControl;

    public GdbProcesses(DsfSession session) {
        super(session);
    }

    public void initialize(final RequestMonitor requestMonitor) {
        super.initialize(new RequestMonitor((Executor)this.getExecutor(), requestMonitor){

            public void handleOK() {
                GdbProcesses.this.doInitialize(requestMonitor);
            }
        });
    }

    private void doInitialize(RequestMonitor requestMonitor) {
        this.register(new String[]{INativeProcesses.class.getName(), GdbProcesses.class.getName()}, new Hashtable());
        this.fConnection = (ICommandControl)this.getServicesTracker().getService(ICommandControl.class);
        this.fRunControl = (MIRunControl)this.getServicesTracker().getService(MIRunControl.class);
        this.getSession().addServiceEventListener((Object)this, null);
        this.fServiceContext = new ServiceDMContext((IDMService)this, "#native_processes");
        this.fProcessDMC = new GDBProcessDMC(this);
        requestMonitor.done();
    }

    public void shutdown(RequestMonitor requestMonitor) {
        this.unregister();
        this.getSession().removeServiceEventListener((Object)this);
        super.shutdown(requestMonitor);
    }

    public IDMContext<?> getServiceContext() {
        return this.fServiceContext;
    }

    public boolean isValid() {
        return true;
    }

    public <V extends IDMData> void getModelData(IDMContext<V> dmc, DataRequestMonitor<V> rm) {
        if (dmc instanceof GDBProcessDMC) {
            rm.setData((Object)this.getProcessData());
            rm.done();
        } else if (dmc instanceof GDBThreadDMC) {
            this.getThreadData((GDBThreadDMC)dmc, rm);
        } else if (dmc == this.fServiceContext) {
            rm.setData((Object)this);
            rm.done();
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", 10002, "Unknown DMC type", null));
            rm.done();
        }
    }

    protected BundleContext getBundleContext() {
        return DsfGdbPlugin.getBundleContext();
    }

    public void getProcessesBeingDebugged(DataRequestMonitor<INativeProcesses.IProcessDMContext[]> rm) {
        rm.setData((Object)new INativeProcesses.IProcessDMContext[]{this.fProcessDMC});
        rm.done();
    }

    private GDBProcessData getProcessData() {
        return new GDBProcessData();
    }

    public INativeProcesses.IThreadDMContext getThreadForDebugContext(IDMContext<?> ctx) {
        MIRunControl.MIExecutionDMC execCtx = (MIRunControl.MIExecutionDMC)DMContexts.getAncestorOfType(ctx, MIRunControl.MIExecutionDMC.class);
        if (execCtx != null) {
            return new GDBThreadDMC(this, execCtx.getThreadId());
        }
        return null;
    }

    public INativeProcesses.IProcessDMContext getProcessForDebugContext(IDMContext<?> execCtx) {
        return this.fProcessDMC;
    }

    public void canTerminate(IDMContext<?> ctx, DataRequestMonitor<Boolean> rm) {
        GDBProcessDMC procCtx = (GDBProcessDMC)DMContexts.getAncestorOfType(ctx, GDBProcessDMC.class);
        if (procCtx != null && procCtx.equals((Object)this.fProcessDMC)) {
            rm.setData((Object)Boolean.TRUE);
        } else {
            rm.setData((Object)Boolean.FALSE);
        }
        rm.done();
    }

    public void terminate(IDMContext<?> ctx, final RequestMonitor rm) {
        GDBProcessDMC procCtx = (GDBProcessDMC)DMContexts.getAncestorOfType(ctx, GDBProcessDMC.class);
        if (procCtx != null && procCtx.equals((Object)this.fProcessDMC)) {
            DsfMIGDBExit cmd = new DsfMIGDBExit();
            this.fConnection.queueCommand((ICommand)cmd, (DataRequestMonitor)new DataRequestMonitor<DsfMIInfo>((Executor)this.getExecutor(), rm){

                public void handleOK() {
                    rm.done();
                }
            });
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", 10002, "Invalid thread context", null));
            rm.done();
        }
    }

    public void attachDebuggerToProcess(INativeProcesses.IProcessDMContext procCtx, RequestMonitor rm) {
        rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", 10003, "Operation not supported", null));
        rm.done();
    }

    public void debugNewProcess(String file, DataRequestMonitor<INativeProcesses.IProcessDMContext> rm) {
        rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", 10003, "Operation not supported", null));
        rm.done();
    }

    public void getRunningProcesses(DataRequestMonitor<INativeProcesses.IProcessDMContext[]> rm) {
        rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", 10003, "Operation not supported", null));
        rm.done();
    }

    public void runNewProcess(String file, DataRequestMonitor<INativeProcesses.IProcessDMContext> rm) {
        rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", 10003, "Operation not supported", null));
        rm.done();
    }

    public INativeProcesses.IProcessDMContext getProcessDMC() {
        return this.fProcessDMC;
    }

    private void getThreadData(final GDBThreadDMC dmc, final DataRequestMonitor<INativeProcesses.IThreadDMData> rm) {
        this.fRunControl.getCache().execute((ICommand)new DsfCLIInfoThreads(), (DataRequestMonitor)new DataRequestMonitor<DsfCLIInfoThreadsInfo>((Executor)this.getExecutor(), rm){

            protected void handleOK() {
                rm.setData((Object)GdbProcesses.this.createThreadInfo(dmc, (DsfCLIInfoThreadsInfo)this.getData()));
                rm.done();
            }
        });
    }

    @DsfServiceEventHandler
    public void eventDispatched(DsfMIInferiorExitEvent e) {
        this.getSession().dispatchEvent((Object)new GDBInferiorProcessExitedEvent(this.fServiceContext, this.fProcessDMC), this.getProperties());
    }

    @DsfServiceEventHandler
    public void eventDispatched(DsfMIInferiorSignalExitEvent e) {
        this.getSession().dispatchEvent((Object)new GDBInferiorProcessExitedEvent(this.fServiceContext, this.fProcessDMC), this.getProperties());
    }

    @DsfServiceEventHandler
    public void eventDispatched(DsfMIThreadExitEvent e) {
        this.getSession().dispatchEvent((Object)new GDBInferiorProcessExitedEvent(this.fServiceContext, this.fProcessDMC), this.getProperties());
    }

    @DsfServiceEventHandler
    public void eventDispatched(GDBControl.ExitedEvent e) {
        this.getSession().dispatchEvent((Object)new GDBInferiorProcessExitedEvent(this.fServiceContext, this.fProcessDMC), this.getProperties());
    }

    private GDBThreadData createThreadInfo(GDBThreadDMC dmc, DsfCLIInfoThreadsInfo info) {
        List threadInfo = info.getThreadInfo();
        Iterator iter = threadInfo.iterator();
        GDBThreadData data = new GDBThreadData("", "");
        while (iter.hasNext()) {
            DsfCLIInfoThreadsInfo.ThreadInfo thread = (DsfCLIInfoThreadsInfo.ThreadInfo)iter.next();
            if (Integer.parseInt(thread.getId()) != dmc.getId()) continue;
            data = new GDBThreadData(thread.getOsId(), thread.getName());
        }
        return data;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GDBInferiorProcessExitedEvent
    extends AbstractDMEvent<IDMContext<INativeProcesses>>
    implements INativeProcesses.IProcessExitedEvent {
        private final GDBProcessDMC fProcessDmc;

        public GDBInferiorProcessExitedEvent(IDMContext<INativeProcesses> dmc, GDBProcessDMC processDmc) {
            super(dmc);
            this.fProcessDmc = processDmc;
        }

        public INativeProcesses.IProcessDMContext getProcess() {
            return this.fProcessDmc;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class GDBProcessDMC
    extends AbstractDMContext<INativeProcesses.IProcessDMData>
    implements INativeProcesses.IProcessDMContext {
        public GDBProcessDMC(GdbProcesses service) {
            super((IDMService)service, new IDMContext[]{service.getServiceContext()});
        }

        public String toString() {
            return this.baseToString() + ".debug_process";
        }

        public boolean equals(Object obj) {
            return obj == this;
        }

        public int hashCode() {
            return ((Object)((Object)this)).getClass().hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class GDBProcessData
    implements INativeProcesses.IProcessDMData {
        GDBProcessData() {
        }

        public boolean isValid() {
            return GdbProcesses.this.getServicesTracker() != null && GdbProcesses.this.getServicesTracker().getService(GDBControl.class) != null;
        }

        public String getName() {
            GDBControl gdb = (GDBControl)GdbProcesses.this.getServicesTracker().getService(GDBControl.class);
            if (gdb != null) {
                return gdb.getExecutablePath().lastSegment();
            }
            return "Default Target Core";
        }

        public String getId() {
            return "";
        }

        public boolean isDebuggerAttached() {
            return true;
        }

        public IDMContext<?> getDebugContext() {
            return GdbProcesses.this.fRunControl.getContainerDMC();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class GDBThreadDMC
    extends AbstractDMContext<INativeProcesses.IThreadDMData>
    implements INativeProcesses.IThreadDMContext {
        int fThreadId;

        public GDBThreadDMC(GdbProcesses service, int threadId) {
            super((IDMService)service, new IDMContext[]{service.getServiceContext()});
            this.fThreadId = threadId;
        }

        public int getId() {
            return this.fThreadId;
        }

        public String toString() {
            return this.baseToString() + ".thread [" + this.fThreadId + "]";
        }

        public boolean equals(Object obj) {
            return super.baseEquals(obj) && ((GDBThreadDMC)((Object)obj)).fThreadId == this.fThreadId;
        }

        public int hashCode() {
            return super.baseHashCode() ^ this.fThreadId;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class GDBThreadData
    implements INativeProcesses.IThreadDMData {
        String fId;
        String fName = "";

        public GDBThreadData(String id, String name) {
            this.fId = id;
            this.fName = name;
        }

        public boolean isValid() {
            return GdbProcesses.this.getServicesTracker() != null && GdbProcesses.this.getServicesTracker().getService(GDBControl.class) != null;
        }

        public String getName() {
            return this.fName;
        }

        public String getId() {
            return this.fId;
        }

        public boolean isDebuggerAttached() {
            return true;
        }

        public IDMContext<?> getDebugContext() {
            return new GDBThreadDMC((GdbProcesses)GdbProcesses.this.getServicesTracker().getService(GdbProcesses.class), Integer.parseInt(this.getId()));
        }
    }
}

