/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.ui.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.dd.dsf.concurrent.DefaultDsfExecutor;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SWTDispatchDsfExecutor
extends DefaultDsfExecutor {
    private <V> Callable<V> createSWTDispatchCallable(final Callable<V> callable) {
        return new Callable<V>(){

            @Override
            public V call() throws Exception {
                final Object[] v = new Object[1];
                final Throwable[] e = new Throwable[1];
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        try {
                            v[0] = callable.call();
                        }
                        catch (Throwable exception) {
                            e[0] = exception;
                        }
                    }
                });
                if (e[0] instanceof RuntimeException) {
                    throw (RuntimeException)e[0];
                }
                if (e[0] instanceof Exception) {
                    throw (Exception)e[0];
                }
                return v[0];
            }
        };
    }

    private Runnable createSWTDispatchRunnable(final Runnable runnable) {
        return new Runnable(){

            public void run() {
                final Throwable[] e = new Throwable[1];
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        try {
                            runnable.run();
                        }
                        catch (Throwable exception) {
                            e[0] = exception;
                        }
                    }
                });
                if (e[0] instanceof RuntimeException) {
                    throw (RuntimeException)e[0];
                }
            }
        };
    }

    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return super.schedule(this.createSWTDispatchCallable(callable), delay, unit);
    }

    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return super.schedule(this.createSWTDispatchRunnable(command), delay, unit);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return super.scheduleAtFixedRate(this.createSWTDispatchRunnable(command), initialDelay, period, unit);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return super.scheduleWithFixedDelay(this.createSWTDispatchRunnable(command), initialDelay, delay, unit);
    }

    public void execute(Runnable command) {
        super.execute(this.createSWTDispatchRunnable(command));
    }

    public <T> Future<T> submit(Callable<T> callable) {
        return super.submit(this.createSWTDispatchCallable(callable));
    }

    public <T> Future<T> submit(Runnable command, T result) {
        return super.submit(this.createSWTDispatchRunnable(command), result);
    }

    public Future<?> submit(Runnable command) {
        return super.submit(this.createSWTDispatchRunnable(command));
    }
}

