/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.ui.viewmodel.dm;

import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DsfRunnable;
import org.eclipse.dd.dsf.concurrent.Immutable;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.datamodel.DMContexts;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.datamodel.IDMData;
import org.eclipse.dd.dsf.datamodel.IDMEvent;
import org.eclipse.dd.dsf.datamodel.IDMService;
import org.eclipse.dd.dsf.service.DsfServicesTracker;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.dsf.service.IDsfService;
import org.eclipse.dd.dsf.ui.DsfUIPlugin;
import org.eclipse.dd.dsf.ui.viewmodel.AbstractVMLayoutNode;
import org.eclipse.dd.dsf.ui.viewmodel.AbstractVMProvider;
import org.eclipse.dd.dsf.ui.viewmodel.IVMContext;
import org.eclipse.dd.dsf.ui.viewmodel.IVMLayoutNode;
import org.eclipse.dd.dsf.ui.viewmodel.VMDelta;
import org.eclipse.dd.dsf.ui.viewmodel.update.VMCacheManager;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDMVMLayoutNode<V extends IDMData>
extends AbstractVMLayoutNode
implements IElementLabelProvider {
    private DsfSession fSession;
    private DsfServicesTracker fServicesTracker;
    private Class<? extends IDMContext<V>> fDMCClassType;

    public AbstractDMVMLayoutNode(AbstractVMProvider provider, DsfSession session, Class<? extends IDMContext<V>> dmcClassType) {
        super(provider);
        this.fSession = session;
        this.fServicesTracker = new DsfServicesTracker(DsfUIPlugin.getBundleContext(), session.getId());
        this.fDMCClassType = dmcClassType;
    }

    @Override
    public void dispose() {
        this.fServicesTracker.dispose();
        super.dispose();
    }

    protected DsfSession getSession() {
        return this.fSession;
    }

    protected DsfServicesTracker getServicesTracker() {
        return this.fServicesTracker;
    }

    @Override
    protected boolean checkUpdate(IViewerUpdate update) {
        IDMContext<?> dmc;
        if (!super.checkUpdate(update)) {
            return false;
        }
        Object element = update.getElement();
        if (element instanceof DMVMContext && ((dmc = ((DMVMContext)element).getDMC()).getSessionId() != this.getSession().getId() || !DsfSession.isSessionActive((String)dmc.getSessionId()))) {
            this.handleFailedUpdate(update);
            return false;
        }
        return true;
    }

    protected boolean checkDmc(IDMContext<?> dmc, IViewerUpdate update) {
        if (dmc == null) {
            update.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.ui", 10001, "No valid context found.", null));
            this.handleFailedUpdate(update);
            return false;
        }
        return true;
    }

    protected boolean checkService(Class<? extends IDsfService> serviceClass, String filter, IViewerUpdate update) {
        if (this.getServicesTracker().getService(serviceClass, filter) == null) {
            update.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.ui", 10001, "Service " + serviceClass.getName() + " not available.", null));
            this.handleFailedUpdate(update);
            return false;
        }
        return true;
    }

    @Override
    public void updateHasElements(final IHasChildrenUpdate[] updates) {
        try {
            this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    AbstractDMVMLayoutNode.this.updateHasElementsInSessionThread(updates);
                }
            });
        }
        catch (RejectedExecutionException e) {
            for (IHasChildrenUpdate update : updates) {
                this.handleFailedUpdate((IViewerUpdate)update);
            }
        }
    }

    protected void updateHasElementsInSessionThread(IHasChildrenUpdate[] updates) {
        for (final IHasChildrenUpdate update : updates) {
            if (!this.checkUpdate((IViewerUpdate)update)) continue;
            this.updateElementsInSessionThread((AbstractVMLayoutNode)this.new AbstractVMLayoutNode.ElementsUpdate(new DataRequestMonitor<List<Object>>((Executor)this.getSession().getExecutor(), null){

                protected void handleCompleted() {
                    if (!AbstractDMVMLayoutNode.this.checkUpdate((IViewerUpdate)update)) {
                        return;
                    }
                    if (this.getStatus().isOK()) {
                        update.setHasChilren(((List)this.getData()).size() != 0);
                    } else {
                        update.setHasChilren(false);
                    }
                    update.done();
                }
            }, update.getElementPath()));
        }
    }

    @Override
    public void updateElementCount(final IChildrenCountUpdate update) {
        if (!this.checkUpdate((IViewerUpdate)update)) {
            return;
        }
        try {
            this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    if (!AbstractDMVMLayoutNode.this.checkUpdate((IViewerUpdate)update)) {
                        return;
                    }
                    AbstractDMVMLayoutNode.this.updateElementCountInSessionThread(update);
                }
            });
        }
        catch (RejectedExecutionException e) {
            this.handleFailedUpdate((IViewerUpdate)update);
        }
    }

    protected void updateElementCountInSessionThread(final IChildrenCountUpdate update) {
        this.updateElementsInSessionThread((AbstractVMLayoutNode)this.new AbstractVMLayoutNode.ElementsUpdate(new DataRequestMonitor<List<Object>>((Executor)this.getSession().getExecutor(), null){

            protected void handleCompleted() {
                if (!AbstractDMVMLayoutNode.this.checkUpdate((IViewerUpdate)update)) {
                    return;
                }
                if (this.getStatus().isOK()) {
                    update.setChildCount(((List)this.getData()).size());
                } else {
                    update.setChildCount(0);
                }
                update.done();
            }
        }, update.getElementPath()));
    }

    @Override
    public void updateElements(final IChildrenUpdate update) {
        if (!this.checkUpdate((IViewerUpdate)update)) {
            return;
        }
        try {
            this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    if (!AbstractDMVMLayoutNode.this.checkUpdate((IViewerUpdate)update)) {
                        return;
                    }
                    AbstractDMVMLayoutNode.this.updateElementsInSessionThread(update);
                }
            });
        }
        catch (RejectedExecutionException e) {
            this.handleFailedUpdate((IViewerUpdate)update);
        }
    }

    protected abstract void updateElementsInSessionThread(IChildrenUpdate var1);

    public void update(final ILabelUpdate[] updates) {
        try {
            this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    AbstractDMVMLayoutNode.this.updateLabelInSessionThread(updates);
                }
            });
        }
        catch (RejectedExecutionException e) {
            for (ILabelUpdate update : updates) {
                this.handleFailedUpdate((IViewerUpdate)update);
            }
        }
    }

    protected void updateLabelInSessionThread(ILabelUpdate[] updates) {
        for (final ILabelUpdate update : updates) {
            final IDMContext<V> dmc = this.findDmcInPath(update.getElementPath(), this.fDMCClassType);
            if (!this.checkDmc(dmc, (IViewerUpdate)update) || !this.checkService(null, dmc.getServiceFilter(), (IViewerUpdate)update)) continue;
            VMCacheManager.getVMCacheManager().getCache(update.getPresentationContext()).getModelData((IDMService)this.getServicesTracker().getService(null, dmc.getServiceFilter()), dmc, new DataRequestMonitor<V>((Executor)this.getSession().getExecutor(), null){

                protected void handleCompleted() {
                    if (!this.getStatus().isOK() || !((IDMData)this.getData()).isValid()) {
                        assert (this.getStatus().isOK() || this.getStatus().getCode() != 10005 || this.getStatus().getCode() != 10003);
                        AbstractDMVMLayoutNode.this.handleFailedUpdate((IViewerUpdate)update);
                        return;
                    }
                    String[] localColumns = update.getPresentationContext().getColumns();
                    if (localColumns == null) {
                        localColumns = new String[]{null};
                    }
                    for (int i = 0; i < localColumns.length; ++i) {
                        AbstractDMVMLayoutNode.this.fillColumnLabel(dmc, (IDMData)this.getData(), localColumns[i], i, update);
                    }
                    update.done();
                }
            }, this.getExecutor());
        }
    }

    protected void fillColumnLabel(IDMContext<V> dmContext, V dmData, String columnId, int idx, ILabelUpdate update) {
        update.setLabel("", idx);
    }

    @Override
    public int getDeltaFlags(Object e) {
        int flags = 0;
        if (e instanceof IDMEvent) {
            flags = this.getNodeDeltaFlagsForDMEvent((IDMEvent)e);
        }
        return flags | super.getDeltaFlags(e);
    }

    protected int getNodeDeltaFlagsForDMEvent(IDMEvent<?> e) {
        return 0;
    }

    @Override
    public void buildDelta(final Object e, final VMDelta parentDelta, final int nodeOffset, final RequestMonitor requestMonitor) {
        if (e instanceof IDMEvent) {
            if (DsfSession.isSessionActive((String)this.getSession().getId())) {
                this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

                    public void run() {
                        AbstractDMVMLayoutNode.this.buildDeltaForDMEvent((IDMEvent)e, parentDelta, nodeOffset, requestMonitor);
                    }
                });
            } else {
                if (this.isDisposed()) {
                    return;
                }
                requestMonitor.done();
            }
        } else {
            super.buildDelta(e, parentDelta, nodeOffset, requestMonitor);
        }
    }

    protected void buildDeltaForDMEvent(final IDMEvent<?> event, final VMDelta parentDelta, final int nodeOffset, final RequestMonitor requestMonitor) {
        IDMContext dmc = DMContexts.getAncestorOfType((IDMContext)event.getDMContext(), this.fDMCClassType);
        if (dmc != null) {
            final IVMContext vmc = this.createVMContext(DMContexts.getAncestorOfType((IDMContext)event.getDMContext(), this.fDMCClassType));
            final Map<IVMLayoutNode, Integer> childNodeDeltas = this.getChildNodesWithDeltaFlags(event);
            if (childNodeDeltas.size() == 0) {
                requestMonitor.done();
                return;
            }
            boolean calculateIndex = false;
            for (int childDelta : childNodeDeltas.values()) {
                if ((childDelta & 0x300000) == 0) continue;
                calculateIndex = true;
                break;
            }
            if (calculateIndex) {
                this.updateElements((AbstractVMLayoutNode)this.new AbstractVMLayoutNode.ElementsUpdate(new DataRequestMonitor<List<Object>>((Executor)this.getExecutor(), null){

                    protected void handleCompleted() {
                        int i;
                        if (AbstractDMVMLayoutNode.this.isDisposed()) {
                            return;
                        }
                        if (!this.getStatus().isOK() || ((List)this.getData()).isEmpty()) {
                            requestMonitor.done();
                            return;
                        }
                        for (i = 0; i < ((List)this.getData()).size() && !vmc.equals(((List)this.getData()).get(i)); ++i) {
                        }
                        if (i == ((List)this.getData()).size()) {
                            requestMonitor.done();
                            return;
                        }
                        VMDelta delta = parentDelta.addNode((Object)vmc, nodeOffset + i, 0);
                        AbstractDMVMLayoutNode.this.callChildNodesToBuildDelta(childNodeDeltas, delta, event, requestMonitor);
                    }
                }, (IModelDelta)parentDelta));
            } else {
                VMDelta delta = parentDelta.addNode(vmc, 0);
                this.callChildNodesToBuildDelta(childNodeDeltas, delta, event, requestMonitor);
            }
        } else {
            super.buildDelta(event, parentDelta, nodeOffset, requestMonitor);
        }
    }

    protected IVMContext[] dmcs2vmcs(IDMContext<V>[] dmcs) {
        IVMContext[] vmContexts = new IVMContext[dmcs.length];
        for (int i = 0; i < dmcs.length; ++i) {
            vmContexts[i] = new DMVMContext(dmcs[i]);
        }
        return vmContexts;
    }

    protected void fillUpdateWithVMCs(IChildrenUpdate update, IDMContext<V>[] dmcs) {
        int startIdx = update.getOffset() != -1 ? update.getOffset() : 0;
        int endIdx = update.getLength() != -1 ? startIdx + update.getLength() : dmcs.length;
        for (int i = startIdx; i < endIdx && i < dmcs.length; ++i) {
            update.setChild((Object)this.createVMContext(dmcs[i]), i);
        }
    }

    protected IVMContext createVMContext(IDMContext<V> dmc) {
        return new DMVMContext(dmc);
    }

    public <T extends IDMContext> T findDmcInPath(TreePath path, Class<T> dmcType) {
        IDMContext<?> dmc;
        Object retVal = null;
        for (int i = path.getSegmentCount() - 1; !(i < 0 || path.getSegment(i) instanceof DMVMContext && (dmc = ((DMVMContext)path.getSegment(i)).getDMC()).getSessionId().equals(this.getSession().getId()) && (retVal = DMContexts.getAncestorOfType(dmc, dmcType)) != null); --i) {
        }
        if (retVal == null) {
            Object inputObject = this.getVMProvider().getRootElement();
            if (inputObject instanceof ITreeSelection) {
                ITreeSelection inputSelection = (ITreeSelection)inputObject;
                if (inputSelection.getPaths().length == 1) {
                    retVal = this.findDmcInPath(inputSelection.getPaths()[0], dmcType);
                }
            } else if (inputObject instanceof IStructuredSelection) {
                Object rootElement = ((IStructuredSelection)inputObject).getFirstElement();
                if (rootElement instanceof DMVMContext) {
                    retVal = DMContexts.getAncestorOfType(((DMVMContext)rootElement).getDMC(), dmcType);
                }
            } else if (inputObject instanceof DMVMContext) {
                retVal = DMContexts.getAncestorOfType(((DMVMContext)inputObject).getDMC(), dmcType);
            }
        }
        return (T)retVal;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Immutable
    public class DMVMContext
    extends AbstractVMLayoutNode.AbstractVMContext {
        private final IDMContext<?> fDmc;

        public DMVMContext(IDMContext<?> dmc) {
            super(AbstractDMVMLayoutNode.this.getVMProvider().getVMAdapter(), AbstractDMVMLayoutNode.this);
            this.fDmc = dmc;
        }

        public IDMContext<?> getDMC() {
            return this.fDmc;
        }

        @Override
        public Object getAdapter(Class adapter) {
            Object superAdapter = super.getAdapter(adapter);
            if (superAdapter != null) {
                return superAdapter;
            }
            if (adapter.isInstance(this.fDmc)) {
                return this.fDmc;
            }
            return this.fDmc.getAdapter(adapter);
        }

        @Override
        public boolean equals(Object other) {
            if (!(other instanceof DMVMContext)) {
                return false;
            }
            DMVMContext otherVmc = (DMVMContext)other;
            return AbstractDMVMLayoutNode.this.equals(otherVmc.getLayoutNode()) && this.fDmc.equals(otherVmc.fDmc);
        }

        @Override
        public int hashCode() {
            return AbstractDMVMLayoutNode.this.hashCode() + this.fDmc.hashCode();
        }

        public String toString() {
            return this.fDmc.toString();
        }
    }
}

