/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.ui.viewmodel.dm;

import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.datamodel.IDMEvent;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.dsf.ui.viewmodel.AbstractVMAdapter;
import org.eclipse.dd.dsf.ui.viewmodel.IVMRootLayoutNode;
import org.eclipse.dd.dsf.ui.viewmodel.dm.AbstractDMVMProvider;
import org.eclipse.dd.dsf.ui.viewmodel.update.VMCacheManager;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ModelDelta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDMVMProviderWithCache
extends AbstractDMVMProvider
implements VMCacheManager.CacheListener {
    @Override
    public void cacheFlushed(Object context) {
        if (this.getPresentationContext().equals(context)) {
            this.getModelProxy().fireModelChanged((IModelDelta)new ModelDelta(this.getRootElement(), 1024));
        }
    }

    public AbstractDMVMProviderWithCache(AbstractVMAdapter adapter, IPresentationContext presentationContext, DsfSession session) {
        super(adapter, presentationContext, session);
        VMCacheManager.getVMCacheManager().addCacheListener(this.getPresentationContext(), this);
    }

    public void flush(IDMContext<?> dmc, boolean archive) {
        VMCacheManager.getVMCacheManager().flush(this.getPresentationContext(), dmc, archive);
    }

    @Override
    public void update(IHasChildrenUpdate[] updates) {
        super.update(VMCacheManager.getVMCacheManager().getCache(this.getPresentationContext()).update(updates));
    }

    @Override
    public void update(IChildrenCountUpdate[] updates) {
        super.update(VMCacheManager.getVMCacheManager().getCache(this.getPresentationContext()).update(updates));
    }

    @Override
    public void update(IChildrenUpdate[] updates) {
        super.update(VMCacheManager.getVMCacheManager().getCache(this.getPresentationContext()).update(updates));
    }

    @Override
    protected void handleEvent(final Object event) {
        try {
            this.getExecutor().execute(new Runnable(){

                public void run() {
                    if (AbstractDMVMProviderWithCache.this.isDisposed()) {
                        return;
                    }
                    IVMRootLayoutNode rootLayoutNode = AbstractDMVMProviderWithCache.this.getRootLayoutNode();
                    if (rootLayoutNode != null && rootLayoutNode.getDeltaFlags(event) != 0) {
                        rootLayoutNode.createDelta(event, new DataRequestMonitor<IModelDelta>((Executor)AbstractDMVMProviderWithCache.this.getExecutor(), null){

                            public void handleCompleted() {
                                if (event instanceof IDMEvent) {
                                    VMCacheManager.getVMCacheManager().getCache(AbstractDMVMProviderWithCache.this.getPresentationContext()).handleEvent((IDMEvent)event);
                                }
                                if (this.getStatus().isOK()) {
                                    AbstractDMVMProviderWithCache.this.getModelProxy().fireModelChangedNonDispatch((IModelDelta)this.getData());
                                }
                            }

                            public String toString() {
                                return "Result of a delta for event: '" + event.toString() + "' in VMP: '" + AbstractDMVMProviderWithCache.this + "'" + "\n" + ((IModelDelta)this.getData()).toString();
                            }
                        });
                    }
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    @Override
    public void dispose() {
        VMCacheManager.getVMCacheManager().removeCacheListener(this.getPresentationContext(), this);
        super.dispose();
    }
}

