/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.ui.viewmodel.update;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DsfExecutor;
import org.eclipse.dd.dsf.concurrent.MultiRequestMonitor;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.concurrent.ThreadSafe;
import org.eclipse.dd.dsf.datamodel.AbstractDMContext;
import org.eclipse.dd.dsf.datamodel.DMContexts;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.datamodel.IDMData;
import org.eclipse.dd.dsf.datamodel.IDMEvent;
import org.eclipse.dd.dsf.datamodel.IDMService;
import org.eclipse.dd.dsf.ui.viewmodel.VMElementsCountUpdate;
import org.eclipse.dd.dsf.ui.viewmodel.VMElementsUpdate;
import org.eclipse.dd.dsf.ui.viewmodel.VMHasElementsUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public abstract class VMCache {
    private static final int MAX_CACHE_SIZE = 1000;
    protected Executor fExecutor = new Executor(){

        public void execute(Runnable command) {
            command.run();
        }
    };
    private final Map<IDMContext<?>, CacheValue> fCacheData = new HashMap(200, 0.75f);
    private final CacheValue fCacheListHead = new CacheValue(null);
    private boolean fDisposed = false;

    public VMCache() {
        this.fCacheListHead.fNext = this.fCacheListHead;
        this.fCacheListHead.fPrevious = this.fCacheListHead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VMCache(VMCache oldCache) {
        if (oldCache != null) {
            VMCache vMCache = oldCache;
            synchronized (vMCache) {
                this.fCacheData.putAll(oldCache.fCacheData);
                this.fCacheListHead.fNext = oldCache.fCacheListHead.fNext;
                oldCache.fCacheListHead.fNext.fPrevious = this.fCacheListHead;
                this.fCacheListHead.fPrevious = oldCache.fCacheListHead.fPrevious;
                oldCache.fCacheListHead.fPrevious.fNext = this.fCacheListHead;
                oldCache.fCacheData.clear();
                oldCache.fCacheListHead.fNext = oldCache.fCacheListHead;
                oldCache.fCacheListHead.fPrevious = oldCache.fCacheListHead;
            }
        } else {
            this.fCacheListHead.fNext = this.fCacheListHead;
            this.fCacheListHead.fPrevious = this.fCacheListHead;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        VMCache vMCache = this;
        synchronized (vMCache) {
            this.fDisposed = true;
        }
        this.fCacheData.clear();
        this.fCacheListHead.fNext = this.fCacheListHead;
        this.fCacheListHead.fPrevious = this.fCacheListHead;
    }

    protected synchronized boolean isDisposed() {
        return this.fDisposed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flush(IDMContext<?> dmcToFlush, boolean archive) {
        Map<IDMContext<?>, CacheValue> map = this.fCacheData;
        synchronized (map) {
            CacheValue value = this.fCacheListHead.fPrevious;
            while (value != this.fCacheListHead) {
                if (value.fDMContext instanceof FlushMarkerDMContext) {
                    IDMContext<?> valueFlushContext = ((FlushMarkerDMContext)value.fDMContext).getFlushContext();
                    if (dmcToFlush == null || valueFlushContext != null && DMContexts.isAncestorOf(valueFlushContext, dmcToFlush)) {
                        this.fCacheData.remove(value.fDMContext);
                        value.remove();
                    }
                    if (valueFlushContext == null || dmcToFlush != null && DMContexts.isAncestorOf(dmcToFlush, valueFlushContext)) {
                        break;
                    }
                } else if (dmcToFlush == null || DMContexts.isAncestorOf((IDMContext)value.fDMContext, dmcToFlush)) {
                    if (archive) {
                        Object dataOrStatus = value.fDataOrStatus.get();
                        if (dataOrStatus instanceof IDMData) {
                            value.fArchiveData.set((IDMData)dataOrStatus);
                            value.fDataOrStatus.set(null);
                        } else if (value.fArchiveData.get() != null) {
                            value.fDataOrStatus.set(null);
                        } else {
                            this.fCacheData.remove(value.fDMContext);
                            value.remove();
                        }
                    } else if (value.fArchiveData.get() != null) {
                        value.fDataOrStatus.set(null);
                    } else {
                        this.fCacheData.remove(value.fDMContext);
                        value.remove();
                    }
                    value.fHasChildren.set(null);
                    value.fChildrenCount.set(null);
                    value.fChildren.set(null);
                }
                value = value.fPrevious;
            }
            CacheValue flushMakerValue = new CacheValue((IDMContext<?>)new FlushMarkerDMContext(dmcToFlush));
            this.fCacheData.put(flushMakerValue.fDMContext, flushMakerValue);
            flushMakerValue.insert(this.fCacheListHead);
        }
    }

    protected boolean isCacheEnabled() {
        return !this.isDisposed();
    }

    protected boolean isCacheReadEnabled() {
        return !this.isDisposed();
    }

    protected boolean isCacheWriteEnabled() {
        return !this.isDisposed();
    }

    protected IDMContext<?> getDMContextKey(IViewerUpdate update) {
        if (update.getElement() instanceof IAdaptable) {
            return (IDMContext)((IAdaptable)update.getElement()).getAdapter(IDMContext.class);
        }
        return null;
    }

    protected synchronized CacheValue getCacheValue(IDMContext<?> key) {
        assert (key != null);
        CacheValue value = this.fCacheData.get(key);
        if (value == null) {
            value = new CacheValue(key);
            this.fCacheData.put(key, value);
            value.insert(this.fCacheListHead);
            if (this.fCacheData.size() > 1000) {
                this.fCacheData.remove(this.fCacheListHead.fNext.fDMContext);
                this.fCacheListHead.fNext.remove();
            }
        } else {
            value.remove();
            value.insert(this.fCacheListHead);
        }
        return value;
    }

    public IHasChildrenUpdate[] update(IHasChildrenUpdate[] updates) {
        if (!this.isCacheEnabled()) {
            return updates;
        }
        LinkedList<IHasChildrenUpdate> missUpdates = new LinkedList<IHasChildrenUpdate>();
        for (final IHasChildrenUpdate update : updates) {
            IDMContext<?> key = this.getDMContextKey((IViewerUpdate)update);
            if (key != null) {
                final CacheValue value = this.getCacheValue(key);
                Boolean hasChildren = value.fHasChildren.get();
                if (this.isCacheReadEnabled() && hasChildren != null) {
                    update.setHasChilren(hasChildren.booleanValue());
                    update.done();
                    continue;
                }
                missUpdates.add(new VMHasElementsUpdate(update, new DataRequestMonitor<Boolean>(this.fExecutor, null){

                    protected void handleCompleted() {
                        if (this.getStatus().isOK()) {
                            if (VMCache.this.isCacheWriteEnabled()) {
                                value.fHasChildren.set((Boolean)this.getData());
                            }
                            update.setHasChilren(((Boolean)this.getData()).booleanValue());
                        }
                        update.done();
                    }
                }));
                continue;
            }
            missUpdates.add(update);
        }
        return missUpdates.toArray(new IHasChildrenUpdate[missUpdates.size()]);
    }

    public IChildrenCountUpdate[] update(IChildrenCountUpdate[] updates) {
        if (!this.isCacheEnabled()) {
            return updates;
        }
        LinkedList<IChildrenCountUpdate> missUpdates = new LinkedList<IChildrenCountUpdate>();
        for (final IChildrenCountUpdate update : updates) {
            IDMContext<?> key = this.getDMContextKey((IViewerUpdate)update);
            if (key != null) {
                final CacheValue value = this.getCacheValue(key);
                Integer childrenCount = value.fChildrenCount.get();
                if (this.isCacheReadEnabled() && childrenCount != null) {
                    update.setChildCount(childrenCount.intValue());
                    update.done();
                    continue;
                }
                missUpdates.add(new VMElementsCountUpdate((IViewerUpdate)update, new DataRequestMonitor<Integer>(this.fExecutor, null){

                    protected void handleCompleted() {
                        if (this.getStatus().isOK()) {
                            if (VMCache.this.isCacheWriteEnabled()) {
                                value.fChildrenCount.set((Integer)this.getData());
                            }
                            update.setChildCount(((Integer)this.getData()).intValue());
                        }
                        update.done();
                    }
                }));
                continue;
            }
            missUpdates.add(update);
        }
        return missUpdates.toArray(new IChildrenCountUpdate[missUpdates.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IChildrenUpdate[] update(IChildrenUpdate[] updates) {
        if (!this.isCacheEnabled()) {
            return updates;
        }
        LinkedList<IChildrenUpdate> updatesEntirelyMissingFromCache = new LinkedList<IChildrenUpdate>();
        for (final IChildrenUpdate update : updates) {
            IDMContext<?> key = this.getDMContextKey((IViewerUpdate)update);
            if (key != null) {
                CacheValue value = this.getCacheValue(key);
                Map<Integer, Object> children = value.fChildren.get();
                if (this.isCacheReadEnabled() && children != null) {
                    LinkedList<Integer> childrenMissingFromCache = new LinkedList<Integer>();
                    for (int i = update.getOffset(); i < update.getOffset() + update.getLength(); ++i) {
                        childrenMissingFromCache.add(i);
                    }
                    Map<Integer, Object> i = children;
                    synchronized (i) {
                        childrenMissingFromCache.removeAll(children.keySet());
                    }
                    if (childrenMissingFromCache.size() > 0) {
                        final HashMap<5, VMElementsUpdate> associationsRequestMonitorToChildUpdate = new HashMap<5, VMElementsUpdate>();
                        MultiRequestMonitor<DataRequestMonitor<List<Object>>> childrenMultiRequestMon = new MultiRequestMonitor<DataRequestMonitor<List<Object>>>(this.fExecutor, null){

                            protected void handleCompleted() {
                                if (this.getStatus().isOK()) {
                                    for (DataRequestMonitor monitor : this.getRequestMonitors()) {
                                        int offset = ((IChildrenUpdate)associationsRequestMonitorToChildUpdate.get(monitor)).getOffset();
                                        for (Object child : (List)monitor.getData()) {
                                            update.setChild(child, offset++);
                                        }
                                    }
                                } else {
                                    update.setStatus(this.getStatus());
                                }
                                update.done();
                            }
                        };
                        while (childrenMissingFromCache.size() > 0) {
                            int offset = (Integer)childrenMissingFromCache.get(0);
                            childrenMissingFromCache.remove(0);
                            int length = 1;
                            while (childrenMissingFromCache.size() > 0 && (Integer)childrenMissingFromCache.get(0) == offset + length) {
                                ++length;
                                childrenMissingFromCache.remove(0);
                            }
                            DataRequestMonitor<List<Object>> partialUpdateMonitor = new DataRequestMonitor<List<Object>>(this.fExecutor, null, (MultiRequestMonitor)childrenMultiRequestMon){
                                final /* synthetic */ MultiRequestMonitor val$childrenMultiRequestMon;
                                {
                                    this.val$childrenMultiRequestMon = multiRequestMonitor;
                                    super(x0, x1);
                                }

                                protected void handleCompleted() {
                                    this.val$childrenMultiRequestMon.requestMonitorDone((RequestMonitor)this);
                                }
                            };
                            VMElementsUpdate partialUpdate = new VMElementsUpdate(update, offset, length, (DataRequestMonitor<List<Object>>)((DataRequestMonitor)childrenMultiRequestMon.add((RequestMonitor)partialUpdateMonitor)));
                            associationsRequestMonitorToChildUpdate.put(partialUpdateMonitor, partialUpdate);
                            updatesEntirelyMissingFromCache.add(partialUpdate);
                        }
                        continue;
                    }
                    for (int position = update.getOffset(); position < update.getOffset() + update.getLength(); ++position) {
                        update.setChild(children.get(position), position);
                    }
                    update.done();
                    continue;
                }
                updatesEntirelyMissingFromCache.add(update);
                continue;
            }
            updatesEntirelyMissingFromCache.add(update);
        }
        updates = new IChildrenUpdate[updatesEntirelyMissingFromCache.size()];
        for (int i = 0; i < updates.length; ++i) {
            final IChildrenUpdate update = (IChildrenUpdate)updatesEntirelyMissingFromCache.get(i);
            IDMContext<?> key = this.getDMContextKey((IViewerUpdate)update);
            if (key != null) {
                final CacheValue value = this.getCacheValue(key);
                updates[i] = new VMElementsUpdate(update, update.getOffset(), update.getLength(), (DataRequestMonitor)new DataRequestMonitor<List<Object>>(this.fExecutor, null){

                    protected void handleCompleted() {
                        if (this.getData() != null) {
                            for (int j = 0; j < ((List)this.getData()).size(); ++j) {
                                if (VMCache.this.isCacheWriteEnabled()) {
                                    Integer childrenCount = value.fChildrenCount.get();
                                    childrenCount = childrenCount != null ? childrenCount : 0;
                                    int capacity = Math.max(childrenCount * 4 / 3, 32);
                                    value.fChildren.compareAndSet(null, Collections.synchronizedMap(new HashMap(capacity)));
                                    Map<Integer, Object> children = value.fChildren.get();
                                    if (children != null) {
                                        children.put(update.getOffset() + j, ((List)this.getData()).get(j));
                                    }
                                }
                                update.setChild(((List)this.getData()).get(j), update.getOffset() + j);
                            }
                        }
                        update.done();
                    }
                }){

                    public void done() {
                        DataRequestMonitor rm = (DataRequestMonitor)this.fRequestMonitor;
                        rm.setData((Object)this.fElements);
                        super.done();
                    }
                };
                continue;
            }
            updates[i] = update;
        }
        return updates;
    }

    public <V extends IDMData> void getModelData(IDMService service, IDMContext<V> dmc, final DataRequestMonitor<V> rm, DsfExecutor executor) {
        if (!this.isCacheEnabled()) {
            service.getModelData(dmc, rm);
            return;
        }
        final CacheValue value = this.getCacheValue(dmc);
        Object data = value.fDataOrStatus.get();
        if (data != null && this.isCacheReadEnabled()) {
            if (data instanceof IDMData) {
                rm.setData((Object)((IDMData)data));
            } else {
                rm.setStatus((IStatus)data);
            }
            rm.done();
        } else {
            service.getModelData(dmc, new DataRequestMonitor<V>((Executor)executor, null){

                protected void handleCompleted() {
                    if (VMCache.this.isCacheWriteEnabled() && !this.isCanceled()) {
                        if (this.getStatus().isOK()) {
                            value.fDataOrStatus.set(this.getData());
                        } else {
                            value.fDataOrStatus.set(this.getStatus());
                        }
                    }
                    if (this.getStatus().isOK()) {
                        rm.setData(this.getData());
                    } else {
                        rm.setStatus(this.getStatus());
                    }
                    rm.done();
                }

                public synchronized void setCanceled(boolean canceled) {
                    rm.setCanceled(canceled);
                    super.setCanceled(canceled);
                }

                public void setMultiStatus(String pluginId, int code, String message, IStatus subStatus) {
                    rm.setMultiStatus(pluginId, code, message, subStatus);
                    super.setMultiStatus(pluginId, code, message, subStatus);
                }

                public synchronized void setStatus(IStatus status) {
                    rm.setStatus(status);
                    super.setStatus(status);
                }

                public synchronized boolean isCanceled() {
                    return rm.isCanceled() || super.isCanceled();
                }
            });
        }
    }

    public IDMData getArchivedModelData(IDMContext dmc) {
        CacheValue value = this.fCacheData.get(dmc);
        if (value != null) {
            return value.fArchiveData.get();
        }
        return null;
    }

    public abstract void handleEvent(IDMEvent var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class CacheValue {
        private IDMContext<?> fDMContext;
        private CacheValue fNext;
        private CacheValue fPrevious;
        protected final AtomicReference<Boolean> fHasChildren = new AtomicReference();
        protected final AtomicReference<Integer> fChildrenCount = new AtomicReference();
        protected final AtomicReference<Map<Integer, Object>> fChildren = new AtomicReference();
        protected final AtomicReference<Object> fDataOrStatus = new AtomicReference();
        protected final AtomicReference<IDMData> fArchiveData = new AtomicReference();

        CacheValue(IDMContext<?> dmc) {
            this.fDMContext = dmc;
        }

        void insert(CacheValue nextValue) {
            this.fNext = nextValue;
            this.fPrevious = nextValue.fPrevious;
            this.fPrevious.fNext = this;
            this.fNext.fPrevious = this;
        }

        void remove() {
            this.fPrevious.fNext = this.fNext;
            this.fNext.fPrevious = this.fPrevious;
        }

        public String toString() {
            return "[hasChildren=" + this.fHasChildren + ", childrenCount=" + this.fChildrenCount + ", children=" + this.fChildren + ", data/status=" + this.fDataOrStatus + ", oldData=" + this.fArchiveData + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FlushMarkerDMContext
    extends AbstractDMContext<IDMData> {
        FlushMarkerDMContext(IDMContext<?> flushContext) {
            IDMContext[] iDMContextArray;
            if (flushContext != null) {
                IDMContext[] iDMContextArray2 = new IDMContext[1];
                iDMContextArray = iDMContextArray2;
                iDMContextArray2[0] = flushContext;
            } else {
                iDMContextArray = new IDMContext[]{};
            }
            super("", "", iDMContextArray);
        }

        IDMContext<?> getFlushContext() {
            return this.getParents().length != 0 ? this.getParents()[0] : null;
        }

        public boolean equals(Object obj) {
            return this.baseEquals(obj);
        }

        public int hashCode() {
            return this.baseHashCode();
        }

        public String toString() {
            return this.baseToString() + ".flushMarker";
        }
    }
}

