/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.mi.service.command.output;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dd.mi.service.command.output.MIBreakpoint;
import org.eclipse.dd.mi.service.command.output.MIInfo;
import org.eclipse.dd.mi.service.command.output.MIList;
import org.eclipse.dd.mi.service.command.output.MIOutput;
import org.eclipse.dd.mi.service.command.output.MIResult;
import org.eclipse.dd.mi.service.command.output.MIResultRecord;
import org.eclipse.dd.mi.service.command.output.MITuple;
import org.eclipse.dd.mi.service.command.output.MIValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MIBreakListInfo
extends MIInfo {
    MIBreakpoint[] breakpoints;

    public MIBreakListInfo(MIOutput rr) {
        super(rr);
    }

    public MIBreakpoint[] getMIBreakpoints() {
        if (this.breakpoints == null) {
            this.parse();
        }
        return this.breakpoints;
    }

    void parse() {
        MIOutput out;
        MIResultRecord rr;
        ArrayList<MIBreakpoint> aList = new ArrayList<MIBreakpoint>(1);
        if (this.isDone() && (rr = (out = this.getMIOutput()).getMIResultRecord()) != null) {
            MIResult[] results = rr.getMIResults();
            for (int i = 0; i < results.length; ++i) {
                String var = results[i].getVariable();
                if (!var.equals("BreakpointTable")) continue;
                this.parseTable(results[i].getMIValue(), aList);
            }
        }
        this.breakpoints = aList.toArray(new MIBreakpoint[aList.size()]);
    }

    void parseTable(MIValue val, List<MIBreakpoint> aList) {
        if (val instanceof MITuple) {
            MIResult[] table = ((MITuple)val).getMIResults();
            for (int j = 0; j < table.length; ++j) {
                String variable = table[j].getVariable();
                if (!variable.equals("body")) continue;
                this.parseBody(table[j].getMIValue(), aList);
            }
        }
    }

    void parseBody(MIValue body, List<MIBreakpoint> aList) {
        if (body instanceof MIList) {
            MIResult[] bkpts = ((MIList)body).getMIResults();
            for (int i = 0; i < bkpts.length; ++i) {
                MIValue value;
                String b = bkpts[i].getVariable();
                if (!b.equals("bkpt") || !((value = bkpts[i].getMIValue()) instanceof MITuple)) continue;
                aList.add(new MIBreakpoint((MITuple)value));
            }
        }
    }
}

