/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.mi.service.command.output;

import java.math.BigInteger;
import org.eclipse.dd.mi.service.command.output.MIConst;
import org.eclipse.dd.mi.service.command.output.MIInfo;
import org.eclipse.dd.mi.service.command.output.MIList;
import org.eclipse.dd.mi.service.command.output.MIOutput;
import org.eclipse.dd.mi.service.command.output.MIResult;
import org.eclipse.dd.mi.service.command.output.MIResultRecord;
import org.eclipse.dd.mi.service.command.output.MITuple;
import org.eclipse.dd.mi.service.command.output.MIValue;
import org.eclipse.debug.core.model.MemoryByte;

public class MIDataReadMemoryInfo
extends MIInfo {
    BigInteger fAddress = new BigInteger("0");
    int fBytesRead;
    int fBytesRequested;
    MemoryByte[] fMemoryBlock = new MemoryByte[0];

    public MIDataReadMemoryInfo(MIOutput output) {
        super(output);
        if (this.isDone()) {
            this.parseResult(1);
        }
    }

    public MIDataReadMemoryInfo(MIOutput output, int word_size) {
        super(output);
        if (this.isDone()) {
            this.parseResult(word_size);
        }
    }

    private void parseResult(int word_size) {
        MIOutput output = this.getMIOutput();
        MIResultRecord record = output.getMIResultRecord();
        if (record != null) {
            MIResult[] results = record.getMIResults();
            for (int i = 0; i < results.length; ++i) {
                String size;
                MIValue value;
                String var = results[i].getVariable();
                if (var.equals("addr") && (value = results[i].getMIValue()) instanceof MIConst) {
                    String address = ((MIConst)value).getCString();
                    this.fAddress = new BigInteger(address.substring(2), 16);
                }
                if (var.equals("total-bytes") && (value = results[i].getMIValue()) instanceof MIConst) {
                    size = ((MIConst)value).getCString();
                    this.fBytesRead = Integer.parseInt(size);
                }
                if (var.equals("total-bytes") && (value = results[i].getMIValue()) instanceof MIConst) {
                    size = ((MIConst)value).getCString();
                    this.fBytesRequested = Integer.parseInt(size);
                    this.fMemoryBlock = new MemoryByte[this.fBytesRequested];
                    for (int j = 0; j < this.fMemoryBlock.length; ++j) {
                        this.fMemoryBlock[j] = new MemoryByte(0, 0);
                    }
                }
                if (!var.equals("memory") || !((value = results[i].getMIValue()) instanceof MIList)) continue;
                this.parseMemoryLines((MIList)value, word_size);
            }
        }
    }

    private void parseMemoryLines(MIList lines, int word_size) {
        MIValue[] lineValues = lines.getMIValues();
        for (int i = 0; i < lineValues.length; ++i) {
            MIValue value;
            if (!(lineValues[i] instanceof MITuple)) continue;
            MITuple tuple = (MITuple)lineValues[i];
            MIResult[] results = tuple.getMIResults();
            int offset = 0;
            MIValue addrValue = results[0].getMIValue();
            if (addrValue instanceof MIConst) {
                String address = ((MIConst)addrValue).getCString();
                BigInteger startAddress = new BigInteger(address.substring(2), 16);
                offset = startAddress.subtract(this.fAddress).intValue();
            }
            if (!((value = results[1].getMIValue()) instanceof MIList)) continue;
            MIList list = (MIList)value;
            MIValue[] values = list.getMIValues();
            MemoryByte[] byteValues = new MemoryByte[values.length * word_size];
            for (int j = 0; j < values.length; ++j) {
                if (!(values[j] instanceof MIConst)) continue;
                String str = ((MIConst)values[j]).getCString();
                try {
                    long word = Long.decode(str.trim());
                    for (int k = 0; k < word_size; ++k) {
                        int bit_shift = (word_size - k - 1) * 8;
                        byteValues[j * word_size + k] = new MemoryByte((byte)((word >> bit_shift) % 256L));
                    }
                    continue;
                }
                catch (NumberFormatException e) {
                    for (int k = 0; k < word_size; ++k) {
                        byteValues[j * word_size + k] = new MemoryByte(-1, 0);
                    }
                }
            }
            System.arraycopy(byteValues, 0, this.fMemoryBlock, offset, byteValues.length);
        }
    }

    public MemoryByte[] getMIMemoryBlock() {
        return this.fMemoryBlock;
    }
}

