/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.gdb.internal.provisional.launching;

import java.util.List;
import java.util.concurrent.Executor;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CSourceLookupDirector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DsfExecutor;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.concurrent.Sequence;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.debug.service.IBreakpoints;
import org.eclipse.dd.dsf.debug.service.ISourceLookup;
import org.eclipse.dd.dsf.debug.service.command.ICommand;
import org.eclipse.dd.dsf.service.DsfServicesTracker;
import org.eclipse.dd.gdb.internal.GdbPlugin;
import org.eclipse.dd.gdb.internal.provisional.actions.IConnect;
import org.eclipse.dd.gdb.internal.provisional.launching.GdbLaunch;
import org.eclipse.dd.gdb.internal.provisional.service.IGDBBackend;
import org.eclipse.dd.gdb.internal.provisional.service.SessionType;
import org.eclipse.dd.gdb.internal.provisional.service.command.IGDBControl;
import org.eclipse.dd.mi.service.CSourceLookup;
import org.eclipse.dd.mi.service.IMIProcesses;
import org.eclipse.dd.mi.service.MIBreakpointsManager;
import org.eclipse.dd.mi.service.command.commands.CLISource;
import org.eclipse.dd.mi.service.command.commands.MIEnvironmentCD;
import org.eclipse.dd.mi.service.command.commands.MIFileExecAndSymbols;
import org.eclipse.dd.mi.service.command.commands.MIGDBSetArgs;
import org.eclipse.dd.mi.service.command.commands.MIGDBSetAutoSolib;
import org.eclipse.dd.mi.service.command.commands.MIGDBSetNonStop;
import org.eclipse.dd.mi.service.command.commands.MIGDBSetSolibSearchPath;
import org.eclipse.dd.mi.service.command.commands.MITargetSelect;
import org.eclipse.dd.mi.service.command.commands.RawCommand;
import org.eclipse.dd.mi.service.command.output.MIInfo;

public class FinalLaunchSequence
extends Sequence {
    Sequence.Step[] fSteps = new Sequence.Step[]{new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            FinalLaunchSequence.this.fTracker = new DsfServicesTracker(GdbPlugin.getBundleContext(), FinalLaunchSequence.this.fLaunch.getSession().getId());
            requestMonitor.done();
        }

        public void rollBack(RequestMonitor requestMonitor) {
            if (FinalLaunchSequence.this.fTracker != null) {
                FinalLaunchSequence.this.fTracker.dispose();
            }
            FinalLaunchSequence.this.fTracker = null;
            requestMonitor.done();
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            FinalLaunchSequence.this.fGDBBackend = (IGDBBackend)FinalLaunchSequence.this.fTracker.getService(IGDBBackend.class);
            if (FinalLaunchSequence.this.fGDBBackend == null) {
                requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", -1, "Cannot obtain GDBBackend service", null));
            }
            requestMonitor.done();
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            FinalLaunchSequence.this.fCommandControl = (IGDBControl)FinalLaunchSequence.this.fTracker.getService(IGDBControl.class);
            if (FinalLaunchSequence.this.fCommandControl == null) {
                requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", -1, "Cannot obtain control service", null));
            }
            requestMonitor.done();
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            FinalLaunchSequence.this.fProcService = (IMIProcesses)FinalLaunchSequence.this.fTracker.getService(IMIProcesses.class);
            if (FinalLaunchSequence.this.fProcService == null) {
                requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", -1, "Cannot obtain process service", null));
            }
            requestMonitor.done();
        }
    }, new Sequence.Step(){

        public void execute(final RequestMonitor requestMonitor) {
            try {
                final String gdbinitFile = FinalLaunchSequence.this.fGDBBackend.getGDBInitFile();
                if (gdbinitFile != null && gdbinitFile.length() > 0) {
                    FinalLaunchSequence.this.fCommandControl.queueCommand((ICommand)new CLISource(FinalLaunchSequence.this.fCommandControl.getContext(), gdbinitFile), (DataRequestMonitor)new DataRequestMonitor<MIInfo>((Executor)FinalLaunchSequence.this.getExecutor(), requestMonitor){

                        protected void handleCompleted() {
                            if (!gdbinitFile.equals(".gdbinit")) {
                                requestMonitor.setStatus(this.getStatus());
                            }
                            requestMonitor.done();
                        }
                    });
                } else {
                    requestMonitor.done();
                }
            }
            catch (CoreException e) {
                requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", -1, "Cannot get gdbinit option", (Throwable)e));
                requestMonitor.done();
            }
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            boolean noFileCommand = false;
            try {
                noFileCommand = FinalLaunchSequence.this.fLaunch.getLaunchConfiguration().getAttribute("org.eclipse.dd.gdb.USE_SOLIB_SYMBOLS_FOR_APP", false);
            }
            catch (CoreException e) {
                requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", -1, "Cannot read use solib symbols for app options", (Throwable)e));
                requestMonitor.done();
                return;
            }
            IPath execPath = FinalLaunchSequence.this.fGDBBackend.getProgramPath();
            if (!noFileCommand && execPath != null && !execPath.isEmpty()) {
                FinalLaunchSequence.this.fCommandControl.queueCommand((ICommand)new MIFileExecAndSymbols(FinalLaunchSequence.this.fCommandControl.getContext(), execPath.toPortableString()), new DataRequestMonitor((Executor)FinalLaunchSequence.this.getExecutor(), requestMonitor));
            } else {
                requestMonitor.done();
            }
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            try {
                String args = FinalLaunchSequence.this.fGDBBackend.getProgramArguments();
                if (args != null) {
                    FinalLaunchSequence.this.fCommandControl.queueCommand((ICommand)new MIGDBSetArgs(FinalLaunchSequence.this.fCommandControl.getContext(), args), new DataRequestMonitor((Executor)FinalLaunchSequence.this.getExecutor(), requestMonitor));
                } else {
                    requestMonitor.done();
                }
            }
            catch (CoreException e) {
                requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", -1, "Cannot get inferior arguments", (Throwable)e));
                requestMonitor.done();
            }
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            IPath dir = null;
            try {
                dir = FinalLaunchSequence.this.fGDBBackend.getGDBWorkingDirectory();
            }
            catch (CoreException e) {
                requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", -1, "Cannot get working directory", (Throwable)e));
                requestMonitor.done();
                return;
            }
            if (dir != null) {
                FinalLaunchSequence.this.fCommandControl.queueCommand((ICommand)new MIEnvironmentCD(FinalLaunchSequence.this.fCommandControl.getContext(), dir.toPortableString()), new DataRequestMonitor((Executor)FinalLaunchSequence.this.getExecutor(), requestMonitor));
            } else {
                requestMonitor.done();
            }
        }
    }, new Sequence.Step(){

        public void execute(final RequestMonitor requestMonitor) {
            boolean isNonStop = false;
            try {
                isNonStop = FinalLaunchSequence.this.fLaunch.getLaunchConfiguration().getAttribute("org.eclipse.dd.gdb.NON_STOP", false);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            if (isNonStop) {
                FinalLaunchSequence.this.fCommandControl.queueCommand((ICommand)new RawCommand((IDMContext)FinalLaunchSequence.this.fCommandControl.getContext(), "set target-async on"), (DataRequestMonitor)new DataRequestMonitor<MIInfo>((Executor)FinalLaunchSequence.this.getExecutor(), requestMonitor){

                    protected void handleSuccess() {
                        FinalLaunchSequence.this.fCommandControl.queueCommand((ICommand)new RawCommand((IDMContext)FinalLaunchSequence.this.fCommandControl.getContext(), "set pagination off"), (DataRequestMonitor)new DataRequestMonitor<MIInfo>((Executor)FinalLaunchSequence.this.getExecutor(), requestMonitor){

                            protected void handleSuccess() {
                                FinalLaunchSequence.this.fCommandControl.queueCommand((ICommand)new MIGDBSetNonStop(FinalLaunchSequence.this.fCommandControl.getContext(), true), new DataRequestMonitor((Executor)FinalLaunchSequence.this.getExecutor(), requestMonitor));
                            }
                        });
                    }
                });
            } else {
                requestMonitor.done();
            }
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            try {
                boolean autolib = FinalLaunchSequence.this.fLaunch.getLaunchConfiguration().getAttribute("org.eclipse.dd.gdb.AUTO_SOLIB", true);
                FinalLaunchSequence.this.fCommandControl.queueCommand((ICommand)new MIGDBSetAutoSolib(FinalLaunchSequence.this.fCommandControl.getContext(), autolib), new DataRequestMonitor((Executor)FinalLaunchSequence.this.getExecutor(), requestMonitor));
            }
            catch (CoreException e) {
                requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", -1, "Cannot set shared library option", (Throwable)e));
                requestMonitor.done();
            }
        }
    }, new Sequence.Step(){

        public void execute(final RequestMonitor requestMonitor) {
            try {
                List<String> p = FinalLaunchSequence.this.fGDBBackend.getSharedLibraryPaths();
                if (p.size() > 0) {
                    String[] paths = p.toArray(new String[p.size()]);
                    FinalLaunchSequence.this.fCommandControl.queueCommand((ICommand)new MIGDBSetSolibSearchPath(FinalLaunchSequence.this.fCommandControl.getContext(), paths), (DataRequestMonitor)new DataRequestMonitor<MIInfo>((Executor)FinalLaunchSequence.this.getExecutor(), requestMonitor){

                        protected void handleSuccess() {
                            requestMonitor.done();
                        }
                    });
                } else {
                    requestMonitor.done();
                }
            }
            catch (CoreException e) {
                requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", -1, "Cannot set share library paths", (Throwable)e));
                requestMonitor.done();
            }
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            CSourceLookup sourceLookup = (CSourceLookup)FinalLaunchSequence.this.fTracker.getService(CSourceLookup.class);
            CSourceLookupDirector locator = (CSourceLookupDirector)FinalLaunchSequence.this.fLaunch.getSourceLocator();
            ISourceLookup.ISourceLookupDMContext sourceLookupDmc = (ISourceLookup.ISourceLookupDMContext)FinalLaunchSequence.this.fCommandControl.getContext();
            sourceLookup.setSourceLookupPath(sourceLookupDmc, locator.getSourceContainers(), requestMonitor);
        }
    }, new Sequence.Step(){
        private boolean fTcpConnection;
        private String fRemoteTcpHost;
        private String fRemoteTcpPort;
        private String fSerialDevice;

        private boolean checkConnectionType(RequestMonitor requestMonitor) {
            try {
                this.fTcpConnection = FinalLaunchSequence.this.fLaunch.getLaunchConfiguration().getAttribute("org.eclipse.dd.gdb.REMOTE_TCP", false);
            }
            catch (CoreException e) {
                requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", -1, "Cannot retrieve connection mode", (Throwable)e));
                requestMonitor.done();
                return false;
            }
            return true;
        }

        private boolean getSerialDevice(RequestMonitor requestMonitor) {
            try {
                this.fSerialDevice = FinalLaunchSequence.this.fLaunch.getLaunchConfiguration().getAttribute("org.eclipse.dd.gdb.DEV", "invalid");
            }
            catch (CoreException e) {
                requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", -1, "Cannot retrieve serial device", (Throwable)e));
                requestMonitor.done();
                return false;
            }
            return true;
        }

        private boolean getTcpHost(RequestMonitor requestMonitor) {
            try {
                this.fRemoteTcpHost = FinalLaunchSequence.this.fLaunch.getLaunchConfiguration().getAttribute("org.eclipse.dd.gdb.HOST", "invalid");
            }
            catch (CoreException e) {
                requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", -1, "Cannot retrieve remote TCP host", (Throwable)e));
                requestMonitor.done();
                return false;
            }
            return true;
        }

        private boolean getTcpPort(RequestMonitor requestMonitor) {
            try {
                this.fRemoteTcpPort = FinalLaunchSequence.this.fLaunch.getLaunchConfiguration().getAttribute("org.eclipse.dd.gdb.PORT", "invalid");
            }
            catch (CoreException e) {
                requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", -1, "Cannot retrieve remote TCP port", (Throwable)e));
                requestMonitor.done();
                return false;
            }
            return true;
        }

        public void execute(RequestMonitor requestMonitor) {
            if (FinalLaunchSequence.this.fSessionType == SessionType.REMOTE) {
                if (!this.checkConnectionType(requestMonitor)) {
                    return;
                }
                if (this.fTcpConnection) {
                    if (!this.getTcpHost(requestMonitor)) {
                        return;
                    }
                    if (!this.getTcpPort(requestMonitor)) {
                        return;
                    }
                    FinalLaunchSequence.this.fCommandControl.queueCommand((ICommand)new MITargetSelect((IDMContext)FinalLaunchSequence.this.fCommandControl.getContext(), this.fRemoteTcpHost, this.fRemoteTcpPort, FinalLaunchSequence.this.fAttach), new DataRequestMonitor((Executor)FinalLaunchSequence.this.getExecutor(), requestMonitor));
                } else {
                    if (!this.getSerialDevice(requestMonitor)) {
                        return;
                    }
                    FinalLaunchSequence.this.fCommandControl.queueCommand((ICommand)new MITargetSelect((IDMContext)FinalLaunchSequence.this.fCommandControl.getContext(), this.fSerialDevice, FinalLaunchSequence.this.fAttach), new DataRequestMonitor((Executor)FinalLaunchSequence.this.getExecutor(), requestMonitor));
                }
            } else {
                requestMonitor.done();
            }
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            if (FinalLaunchSequence.this.fAttach && FinalLaunchSequence.this.fSessionType != SessionType.REMOTE) {
                int pid = -1;
                try {
                    pid = FinalLaunchSequence.this.fLaunch.getLaunchConfiguration().getAttribute("org.eclipse.cdt.launch.ATTACH_PROCESS_ID", -1);
                }
                catch (CoreException e) {
                    // empty catch block
                }
                if (pid != -1) {
                    FinalLaunchSequence.this.fProcService.attachDebuggerToProcess(FinalLaunchSequence.this.fProcService.createProcessContext(FinalLaunchSequence.this.fCommandControl.getContext(), Integer.toString(pid)), new DataRequestMonitor((Executor)FinalLaunchSequence.this.getExecutor(), requestMonitor));
                } else {
                    IConnect connectCommand = (IConnect)FinalLaunchSequence.this.fLaunch.getSession().getModelAdapter(IConnect.class);
                    if (connectCommand != null) {
                        connectCommand.connect(requestMonitor);
                    } else {
                        requestMonitor.done();
                    }
                }
            } else {
                requestMonitor.done();
            }
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            MIBreakpointsManager bpmService = (MIBreakpointsManager)FinalLaunchSequence.this.fTracker.getService(MIBreakpointsManager.class);
            IBreakpoints.IBreakpointsTargetDMContext breakpointDmc = (IBreakpoints.IBreakpointsTargetDMContext)FinalLaunchSequence.this.fCommandControl.getContext();
            bpmService.startTrackingBreakpoints(breakpointDmc, requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            FinalLaunchSequence.this.fCommandControl.start(FinalLaunchSequence.this.fLaunch, requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            FinalLaunchSequence.this.fTracker.dispose();
            FinalLaunchSequence.this.fTracker = null;
            requestMonitor.done();
        }
    }};
    GdbLaunch fLaunch;
    SessionType fSessionType;
    boolean fAttach;
    private IGDBControl fCommandControl;
    private IGDBBackend fGDBBackend;
    private IMIProcesses fProcService;
    DsfServicesTracker fTracker;

    public FinalLaunchSequence(DsfExecutor executor, GdbLaunch launch, SessionType sessionType, boolean attach, IProgressMonitor pm) {
        super(executor, pm, "Configuring GDB", "Aborting configuring GDB");
        this.fLaunch = launch;
        this.fSessionType = sessionType;
        this.fAttach = attach;
    }

    public Sequence.Step[] getSteps() {
        return this.fSteps;
    }
}

