/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.checker.ui.preferences;

import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.dd.ipxact.checker.core.FilePathResolver;
import org.eclipse.dd.ipxact.editor.core.utils.OSVariable;

public class PreferencesSupport {
    public static final String NAMESPACE = "org.eclipse.dd.ipxact.checker.ui";
    public static final String PREF_FILE_PATH_VARIABLES = "FilePathVariables";
    public static final String PREF_FILE_PATH_ROOTS = "FilePathRoots";
    public static final String PREF_USE_FILE_PATH_SYSTEM_ENV_VARS = "FilePathUseSystemEnvVars";

    public static String[][] parseString(String stringList) {
        String[][] data = null;
        try {
            if (stringList != null && stringList.length() > 2) {
                String[] rows = stringList.split("\n");
                data = new String[rows.length][2];
                for (int row = 0; row < rows.length; ++row) {
                    String[] values = rows[row].split("\t");
                    data[row] = values;
                }
            }
        }
        catch (Exception e) {
            data = new String[0][2];
        }
        return data;
    }

    public static String createString(String[][] items) {
        int itemCount = items.length;
        StringBuilder stringBuilder = new StringBuilder();
        for (int item = 0; item < itemCount; ++item) {
            String[] values = items[item];
            stringBuilder.append(values[0]);
            stringBuilder.append('\t');
            stringBuilder.append(values[1]);
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    public static void initializeFromPreferences(FilePathResolver resolver) throws Exception {
        boolean includeSystemEnvVars;
        IPreferencesService preferenceService = Platform.getPreferencesService();
        String value = preferenceService.getString(NAMESPACE, PREF_FILE_PATH_ROOTS, "", null);
        String[] filePathRoots = value.split(";");
        for (int index = 0; index < filePathRoots.length; ++index) {
            resolver.addPathItem(filePathRoots[index]);
        }
        value = preferenceService.getString(NAMESPACE, PREF_FILE_PATH_VARIABLES, "", null);
        String[][] filePathVariables = PreferencesSupport.parseString(value);
        if (filePathVariables != null) {
            for (int index = 0; index < filePathVariables.length; ++index) {
                String[] item = filePathVariables[index];
                value = item[1];
                if (value.indexOf(92) != -1) {
                    value = value.replaceAll("\\\\", "/");
                }
                resolver.addVariable(item[0], value);
            }
        }
        if (includeSystemEnvVars = preferenceService.getBoolean(NAMESPACE, PREF_USE_FILE_PATH_SYSTEM_ENV_VARS, false, null)) {
            Map<String, String> sysEnvVars = System.getenv();
            for (Map.Entry<String, String> entry : sysEnvVars.entrySet()) {
                String variable = entry.getKey().toUpperCase();
                if (!OSVariable.isValidVariableName((String)variable) || (value = entry.getValue()).length() <= 0) continue;
                if (value.indexOf(92) != -1) {
                    value = value.replaceAll("\\\\", "/");
                }
                resolver.addVariable(variable, value);
            }
        }
    }
}

