/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.debug.ui.memory.transport.actions;

import org.eclipse.dd.debug.ui.memory.transport.ExportMemoryDialog;
import org.eclipse.dd.debug.ui.memory.transport.MemoryTransportPlugin;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.internal.ui.views.memory.MemoryView;
import org.eclipse.debug.ui.memory.IMemoryRendering;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class ExportMemoryAction
implements IViewActionDelegate {
    private MemoryView fView;

    public void init(IViewPart view) {
        if (view instanceof MemoryView) {
            this.fView = (MemoryView)view;
        }
    }

    private IMemoryBlock getMemoryBlock(ISelection selection) {
        IMemoryBlock memBlock = null;
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection strucSel = (IStructuredSelection)selection;
            if (strucSel.isEmpty()) {
                return null;
            }
            Object obj = strucSel.getFirstElement();
            if (obj == null) {
                return null;
            }
            if (obj instanceof IMemoryRendering) {
                memBlock = ((IMemoryRendering)obj).getMemoryBlock();
            } else if (obj instanceof IMemoryBlock) {
                memBlock = (IMemoryBlock)obj;
            }
        }
        return memBlock;
    }

    public void run(IAction action) {
        ISelection selection = this.fView.getSite().getSelectionProvider().getSelection();
        IMemoryBlock memBlock = this.getMemoryBlock(selection);
        if (memBlock == null) {
            return;
        }
        ExportMemoryDialog dialog = new ExportMemoryDialog(MemoryTransportPlugin.getShell(), memBlock);
        dialog.open();
        dialog.getResult();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        action.setEnabled(this.getMemoryBlock(selection) != null);
    }
}

