/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.mi.service;

import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.dd.dsf.concurrent.Immutable;
import org.eclipse.dd.dsf.service.IDsfService;

public interface IMIBackend
extends IDsfService {
    public String getId();

    public void destroy();

    public State getState();

    public int getExitCode();

    public InputStream getMIInputStream();

    public OutputStream getMIOutputStream();

    @Immutable
    public static class BackendStateChangedEvent {
        private final String fSessionId;
        private final String fBackendId;
        private final State fState;

        public BackendStateChangedEvent(String sessionId, String backendId, State state) {
            this.fSessionId = sessionId;
            this.fBackendId = backendId;
            this.fState = state;
        }

        public String getSessionId() {
            return this.fSessionId;
        }

        public String getBackendId() {
            return this.fBackendId;
        }

        public State getState() {
            return this.fState;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        NOT_INITIALIZED,
        STARTED,
        TERMINATED;

    }
}

