/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.checker.core.models;

import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.dd.ipxact.checker.core.CheckList;
import org.eclipse.dd.ipxact.checker.core.ICheckerReporter;
import org.eclipse.dd.ipxact.checker.core.Messages;
import org.eclipse.dd.ipxact.checker.core.models.CheckVisitor;
import org.eclipse.dd.ipxact.checker.core.models.HierarchicalConnection;
import org.eclipse.dd.ipxact.checker.core.utils.Utilities;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDocument;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.ComponentSignal;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.SignalMapElement;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.SpiritNode;

public class Check69Visitor
extends CheckVisitor {
    public Check69Visitor(ICheckerReporter reporter) {
        super(reporter);
    }

    public boolean visit(HierarchicalConnection hierarchicalConnection) {
        String message = Messages.Check69Visitor_0;
        Map signalMapElements = hierarchicalConnection.busInterface.getSignalNames();
        Map refSignalNames = hierarchicalConnection.refBusInterface.getSignalNames();
        if (signalMapElements != null && refSignalNames != null) {
            Map<String, ComponentSignal> componentSignals = Utilities.getComponentSignals((SpiritDocument)hierarchicalConnection.busInterfaceDoc);
            Map<String, ComponentSignal> refComponentSignals = Utilities.getComponentSignals((SpiritDocument)hierarchicalConnection.refBusInterfaceDoc);
            for (SignalMapElement signalMapElement : signalMapElements.values()) {
                String componentSignalName = signalMapElement.getName();
                ComponentSignal componentSignal = componentSignals.get(componentSignalName);
                ComponentSignal refComponentSignal = refComponentSignals.get(componentSignalName);
                if (componentSignal == null || refComponentSignal == null) continue;
                SpiritNode clockDriverNode = componentSignal.getClockDriver();
                SpiritNode refClockDriverNode = refComponentSignal.getClockDriver();
                if (clockDriverNode != null && refClockDriverNode == null || clockDriverNode == null && refClockDriverNode != null) {
                    this.reporter.report(CheckList.CHECK_69, null, MessageFormat.format(message, this.getPresence(clockDriverNode), componentSignal, hierarchicalConnection.busInterfaceDoc.getVlnv(), this.getPresence(refClockDriverNode), refComponentSignal, hierarchicalConnection.refBusInterfaceDoc.getVlnv()));
                    ++this.problems;
                    continue;
                }
                if (clockDriverNode == null || Utilities.compareNodes(clockDriverNode.getNode(), refClockDriverNode.getNode())) continue;
                this.reporter.report(CheckList.CHECK_69, null, MessageFormat.format(message, "", componentSignal, hierarchicalConnection.busInterfaceDoc.getVlnv(), "", refComponentSignal, hierarchicalConnection.refBusInterfaceDoc.getVlnv()));
                ++this.problems;
            }
        }
        return true;
    }

    private String getPresence(Object object) {
        return object != null ? "" : Messages.Check69Visitor_Missing;
    }
}

