/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.ui.concurrent;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Display;

public class SimpleDisplayExecutor
implements Executor {
    private static Map<Display, SimpleDisplayExecutor> fExecutors = Collections.synchronizedMap(new HashMap());
    private final Display fDisplay;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SimpleDisplayExecutor getSimpleDisplayExecutor(Display display) {
        Map<Display, SimpleDisplayExecutor> map = fExecutors;
        synchronized (map) {
            SimpleDisplayExecutor executor = fExecutors.get(display);
            if (executor == null) {
                executor = new SimpleDisplayExecutor(display);
                fExecutors.put(display, executor);
            }
            return executor;
        }
    }

    private SimpleDisplayExecutor(Display display) {
        this.fDisplay = display;
    }

    public void execute(Runnable command) {
        try {
            this.fDisplay.asyncExec(command);
        }
        catch (SWTException e) {
            if (e.code == 45) {
                throw new RejectedExecutionException("Display " + this.fDisplay + " is disposed", e);
            }
            throw e;
        }
    }
}

