/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.examples.dsf.filebrowser;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.ui.viewmodel.IVMContext;
import org.eclipse.dd.dsf.ui.viewmodel.IVMNode;
import org.eclipse.dd.dsf.ui.viewmodel.IVMProvider;
import org.eclipse.dd.dsf.ui.viewmodel.VMDelta;
import org.eclipse.dd.examples.dsf.filebrowser.FileBrowserVMProvider;
import org.eclipse.dd.examples.dsf.filebrowser.FileVMContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FileVMNode
implements IElementLabelProvider,
IVMNode {
    private final FileBrowserVMProvider fProvider;
    private final IVMNode[] fChildNodes = new IVMNode[]{this};
    private static final File[] EMPTY_FILE_LIST = new File[0];

    public FileVMNode(FileBrowserVMProvider provider) {
        this.fProvider = provider;
    }

    public String toString() {
        return "FileVMNode";
    }

    public void dispose() {
    }

    public void setChildNodes(IVMNode[] childNodes) {
        throw new UnsupportedOperationException("This node does not support children.");
    }

    public IVMNode[] getChildNodes() {
        return this.fChildNodes;
    }

    public void update(final IHasChildrenUpdate[] updates) {
        new Job(""){
            {
                super(x0);
                this.setSystem(true);
                this.setPriority(10);
            }

            protected IStatus run(IProgressMonitor monitor) {
                for (IHasChildrenUpdate update : updates) {
                    FileVMContext vmc = (FileVMContext)((Object)update.getElement());
                    update.setHasChilren(vmc.getFile().isDirectory());
                    update.done();
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public void update(final IChildrenCountUpdate[] updates) {
        new Job(""){
            {
                super(x0);
                this.setSystem(true);
                this.setPriority(10);
            }

            protected IStatus run(IProgressMonitor monitor) {
                for (IChildrenCountUpdate update : updates) {
                    update.setChildCount(FileVMNode.this.getFiles((IViewerUpdate)update).length);
                    update.done();
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public void update(final IChildrenUpdate[] updates) {
        new Job(""){
            {
                super(x0);
                this.setSystem(true);
                this.setPriority(10);
            }

            protected IStatus run(IProgressMonitor monitor) {
                for (IChildrenUpdate update : updates) {
                    File[] files = FileVMNode.this.getFiles((IViewerUpdate)update);
                    int offset = update.getOffset() != -1 ? update.getOffset() : 0;
                    int length = update.getLength() != -1 ? update.getLength() : files.length;
                    for (int i = offset; i < files.length && i < offset + length; ++i) {
                        update.setChild((Object)new FileVMContext(FileVMNode.this, files[i]), i);
                    }
                    update.done();
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public void update(final ILabelUpdate[] updates) {
        new Job(""){
            {
                super(x0);
                this.setSystem(true);
                this.setPriority(10);
            }

            protected IStatus run(IProgressMonitor monitor) {
                for (ILabelUpdate update : updates) {
                    update.setLabel(FileVMNode.this.getLabel((FileVMContext)((Object)update.getElement())), 0);
                    update.done();
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private File[] getFiles(IViewerUpdate update) {
        FileVMContext vmc = (FileVMContext)((Object)update.getElement());
        File[] files = vmc.getFile().listFiles();
        return files != null ? files : EMPTY_FILE_LIST;
    }

    private String getLabel(FileVMContext vmc) {
        return vmc.getFile().getName();
    }

    public void getContextsForEvent(VMDelta parentDelta, Object event, DataRequestMonitor<IVMContext[]> rm) {
        rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.ui", 10003, "", null));
        rm.done();
    }

    public int getDeltaFlags(Object e) {
        int retVal = 0;
        if (e instanceof String) {
            retVal |= 0x300000;
        }
        return retVal;
    }

    public void buildDelta(final Object event, final VMDelta parentDelta, final int nodeOffset, final RequestMonitor requestMonitor) {
        if (event instanceof String) {
            new Job(""){
                {
                    super(x0);
                    this.setSystem(true);
                    this.setPriority(10);
                }

                protected IStatus run(IProgressMonitor monitor) {
                    File eventFile = new File((String)event);
                    File parentFile = null;
                    if (parentDelta.getElement() instanceof FileVMContext) {
                        parentFile = ((FileVMContext)((Object)parentDelta.getElement())).getFile();
                    }
                    if (eventFile.exists() && parentFile != null) {
                        LinkedList<File> filePath = new LinkedList<File>();
                        for (File file = eventFile; file != null && !file.equals(parentFile); file = file.getParentFile()) {
                            filePath.add(0, file);
                        }
                        if (filePath.size() != 0) {
                            VMDelta delta = parentDelta;
                            File[] allFilesInDirectory = parentFile.listFiles();
                            for (File pathSegment : filePath) {
                                assert (allFilesInDirectory != null);
                                File[] pathSegmentDirectoryFiles = pathSegment.listFiles();
                                delta = delta.addNode((Object)new FileVMContext(FileVMNode.this, pathSegment), nodeOffset + Arrays.asList(allFilesInDirectory).indexOf(pathSegment), 0, pathSegmentDirectoryFiles != null ? pathSegmentDirectoryFiles.length : 0);
                                allFilesInDirectory = pathSegmentDirectoryFiles;
                            }
                            delta.setFlags(delta.getFlags() | 0x200000 | 0x100000);
                        }
                    }
                    requestMonitor.done();
                    return Status.OK_STATUS;
                }
            }.schedule();
        } else {
            requestMonitor.done();
        }
    }

    protected Map<IVMNode, Integer> getChildNodesWithDeltas(Object e) {
        HashMap<IVMNode, Integer> nodes = new HashMap<IVMNode, Integer>();
        for (IVMNode childNode : this.getChildNodes()) {
            int delta = childNode.getDeltaFlags(e);
            if (delta == 0) continue;
            nodes.put(childNode, delta);
        }
        return nodes;
    }

    public IVMProvider getVMProvider() {
        return this.fProvider;
    }
}

