/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.mi.service.command.output;

import java.util.ArrayList;
import org.eclipse.dd.dsf.debug.service.IInstruction;
import org.eclipse.dd.dsf.debug.service.IMixedInstruction;
import org.eclipse.dd.mi.service.command.output.MIConst;
import org.eclipse.dd.mi.service.command.output.MIInstruction;
import org.eclipse.dd.mi.service.command.output.MIList;
import org.eclipse.dd.mi.service.command.output.MIResult;
import org.eclipse.dd.mi.service.command.output.MITuple;
import org.eclipse.dd.mi.service.command.output.MIValue;

public class MIMixedInstruction
implements IMixedInstruction {
    private String fileName = "";
    private int lineNumber = 0;
    private MIInstruction[] assemblyCode;

    public MIMixedInstruction(MITuple tuple) {
        this.parse(tuple);
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public IInstruction[] getInstructions() {
        return this.assemblyCode;
    }

    private void parse(MITuple tuple) {
        ArrayList<MIInstruction> instructions = new ArrayList<MIInstruction>();
        MIResult[] results = tuple.getMIResults();
        for (int i = 0; i < results.length; ++i) {
            String var = results[i].getVariable();
            MIValue value = results[i].getMIValue();
            String str = "";
            if (value != null && value instanceof MIConst) {
                str = ((MIConst)value).getCString();
            }
            if (var.equals("line")) {
                try {
                    this.lineNumber = Integer.parseInt(str.trim());
                }
                catch (NumberFormatException e) {}
                continue;
            }
            if (var.equals("file")) {
                this.fileName = str;
                continue;
            }
            if (!var.equals("line_asm_insn") || !(value instanceof MIList)) continue;
            MIList list = (MIList)value;
            MIValue[] values = list.getMIValues();
            for (int j = 0; j < values.length; ++j) {
                if (!(values[j] instanceof MITuple)) continue;
                instructions.add(new MIInstruction((MITuple)values[j]));
            }
        }
        this.assemblyCode = instructions.toArray(new MIInstruction[instructions.size()]);
    }
}

