/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.editor.ui.dialog;

import java.text.MessageFormat;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDocument;
import org.eclipse.dd.ipxact.editor.core.document.Vlnv;
import org.eclipse.dd.ipxact.editor.core.object.ComponentInstance;
import org.eclipse.dd.ipxact.editor.ui.Messages;
import org.eclipse.dd.ipxact.editor.ui.dialog.NewInstanceValidator;
import org.eclipse.dd.ipxact.editor.ui.utils.EditorHelper;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CreateNewInstanceDialog
extends InputDialog {
    private Vlnv componentId;

    public CreateNewInstanceDialog(Shell parentShell, Vlnv componentId) {
        super(parentShell, Messages.CreateNewInstanceDialog_NewComponentInstance, MessageFormat.format(Messages.CreateNewInstanceDialog_EnterAName, componentId), componentId.toString(), (IInputValidator)new NewInstanceValidator());
        this.componentId = componentId;
        this.setBlockOnOpen(true);
    }

    public static boolean addComponentToDesign(Shell shell, Document targetDoc, Vlnv vlnv) {
        CreateNewInstanceDialog dlg = new CreateNewInstanceDialog(shell, vlnv);
        if (0 == dlg.open()) {
            CreateNewInstanceDialog.insertComponentInstance(targetDoc, dlg.getNewInstance());
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void insertComponentInstance(Document doc, ComponentInstance componentInstance) {
        Element rootNode = doc.getDocumentElement();
        String namespace = SpiritDocument.getSchemaURI((Document)doc);
        String prefix = rootNode.getPrefix() + ':';
        try {
            EditorHelper.beginUndoRecording(rootNode, doc, Messages.CreateNewInstanceDialog_InsertComponentInstance);
            Element componentInstancesElement = EditorHelper.maybeInsertElementNS(rootNode, namespace, prefix, "componentInstances");
            if (componentInstancesElement != null) {
                componentInstancesElement.appendChild(componentInstance.getXMLRootNode(doc));
            }
        }
        finally {
            EditorHelper.endUndoRecording(rootNode, doc);
        }
    }

    public ComponentInstance getNewInstance() {
        ComponentInstance ci = new ComponentInstance(this.componentId);
        ci.setInstanceName(this.getValue());
        return ci;
    }
}

