/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.mi.service.command.output;

import org.eclipse.dd.mi.service.command.output.MIArg;
import org.eclipse.dd.mi.service.command.output.MIConst;
import org.eclipse.dd.mi.service.command.output.MIList;
import org.eclipse.dd.mi.service.command.output.MIResult;
import org.eclipse.dd.mi.service.command.output.MITuple;
import org.eclipse.dd.mi.service.command.output.MIValue;

public class MIFrame {
    int level;
    String addr;
    String func = "";
    String file = "";
    String fullname = "";
    int line;
    MIArg[] args = new MIArg[0];

    public MIFrame(MITuple tuple) {
        this.parse(tuple);
    }

    public MIArg[] getArgs() {
        return this.args;
    }

    public String getFile() {
        String fname = this.getFullname();
        return fname.length() != 0 ? fname : this.file;
    }

    public String getFullname() {
        return this.fullname;
    }

    public String getFunction() {
        return this.func;
    }

    public int getLine() {
        return this.line;
    }

    public String getAddress() {
        return this.addr;
    }

    public int getLevel() {
        return this.level;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("level=\"" + this.level + "\"");
        buffer.append(",addr=\"" + this.addr + "\"");
        buffer.append(",func=\"" + this.func + "\"");
        buffer.append(",file=\"" + this.file + "\"");
        buffer.append(",line=\"").append(this.line).append('\"');
        buffer.append(",args=[");
        for (int i = 0; i < this.args.length; ++i) {
            if (i != 0) {
                buffer.append(',');
            }
            buffer.append("{name=\"" + this.args[i].getName() + "\"");
            buffer.append(",value=\"" + this.args[i].getValue() + "\"}");
        }
        buffer.append(']');
        return buffer.toString();
    }

    void parse(MITuple tuple) {
        MIResult[] results = tuple.getMIResults();
        for (int i = 0; i < results.length; ++i) {
            String var = results[i].getVariable();
            MIValue value = results[i].getMIValue();
            String str = "";
            if (value != null && value instanceof MIConst) {
                str = ((MIConst)value).getCString();
            }
            if (var.equals("level")) {
                try {
                    this.level = Integer.parseInt(str.trim());
                }
                catch (NumberFormatException e) {}
                continue;
            }
            if (var.equals("addr")) {
                try {
                    this.addr = str.trim();
                }
                catch (NumberFormatException e) {}
                continue;
            }
            if (var.equals("func")) {
                this.func = null;
                if (str == null) continue;
                if ((str = str.trim()).equals("??")) {
                    this.func = "";
                    continue;
                }
                int end = str.indexOf(40);
                if (end != -1) {
                    this.func = str.substring(0, end);
                    continue;
                }
                this.func = str;
                continue;
            }
            if (var.equals("file")) {
                this.file = str;
                continue;
            }
            if (var.equals("fullname")) {
                this.fullname = str;
                continue;
            }
            if (var.equals("line")) {
                try {
                    this.line = Integer.parseInt(str.trim());
                }
                catch (NumberFormatException e) {}
                continue;
            }
            if (!var.equals("args")) continue;
            if (value instanceof MIList) {
                this.args = MIArg.getMIArgs((MIList)value);
                continue;
            }
            if (!(value instanceof MITuple)) continue;
            this.args = MIArg.getMIArgs((MITuple)value);
        }
    }
}

