/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.checker.ui.preferences;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dd.ipxact.checker.ui.Messages;
import org.eclipse.dd.ipxact.editor.ui.utils.AutoResizeTableLayout;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public abstract class AbstractTableFieldEditor
extends FieldEditor {
    Table theTable;
    Composite buttonBox;
    public static final int ADD_BUTTON = 0;
    public static final int REMOVE_BUTTON = 1;
    public static final int EDIT_BUTTON = 2;
    public static final int UP_BUTTON = 3;
    public static final int DOWN_BUTTON = 4;
    Button addButton;
    Button removeButton;
    Button editButton;
    Button upButton;
    Button downButton;
    Button[] buttons;
    private SelectionListener selectionListener;

    protected AbstractTableFieldEditor(String name, String labelText, Composite parent) {
        this.init(name, labelText);
        this.createControl(parent);
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Label control = this.getLabelControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns;
        control.setLayoutData((Object)gd);
        this.theTable = this.getTableControl(parent);
        gd = new GridData(1808);
        gd.verticalAlignment = 4;
        gd.horizontalSpan = numColumns - 1;
        gd.grabExcessHorizontalSpace = true;
        this.theTable.setLayoutData((Object)gd);
        this.buttonBox = this.getButtonBoxControl(parent);
        gd = new GridData();
        gd.verticalAlignment = 1;
        this.buttonBox.setLayoutData((Object)gd);
    }

    public abstract TableColumn[] createTableColumns(Table var1);

    public Table getTableControl(Composite parent) {
        if (this.theTable == null) {
            this.theTable = new Table(parent, 68356);
            AutoResizeTableLayout layout = new AutoResizeTableLayout(this.theTable);
            this.theTable.setLayout((Layout)layout);
            TableColumn[] tableColumns = this.createTableColumns(this.theTable);
            int columnCount = tableColumns.length;
            for (int col = 0; col < columnCount; ++col) {
                layout.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
            }
            this.theTable.setFont(parent.getFont());
            this.theTable.addSelectionListener(this.getSelectionListener());
            this.theTable.setHeaderVisible(true);
            this.theTable.setLinesVisible(true);
            this.theTable.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    AbstractTableFieldEditor.this.theTable = null;
                }
            });
        } else {
            this.checkParent((Control)this.theTable, parent);
        }
        return this.theTable;
    }

    public Composite getButtonBoxControl(Composite parent) {
        if (this.buttonBox == null) {
            this.buttonBox = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginWidth = 0;
            this.buttonBox.setLayout((Layout)layout);
            this.createButtons(this.buttonBox);
            this.buttonBox.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    AbstractTableFieldEditor.this.addButton = null;
                    AbstractTableFieldEditor.this.removeButton = null;
                    AbstractTableFieldEditor.this.editButton = null;
                    AbstractTableFieldEditor.this.upButton = null;
                    AbstractTableFieldEditor.this.downButton = null;
                    AbstractTableFieldEditor.this.buttonBox = null;
                    AbstractTableFieldEditor.this.buttons = null;
                }
            });
        } else {
            this.checkParent((Control)this.buttonBox, parent);
        }
        this.selectionChanged();
        return this.buttonBox;
    }

    private void createButtons(Composite box) {
        this.addButton = this.createPushButton(box, Messages.AbstractTableFieldEditor_New);
        this.removeButton = this.createPushButton(box, Messages.AbstractTableFieldEditor_Remove);
        this.editButton = this.createPushButton(box, Messages.AbstractTableFieldEditor_Edit);
        this.upButton = this.createPushButton(box, Messages.AbstractTableFieldEditor_Up);
        this.downButton = this.createPushButton(box, Messages.AbstractTableFieldEditor_Down);
        this.buttons = new Button[5];
        this.buttons[0] = this.addButton;
        this.buttons[1] = this.removeButton;
        this.buttons[2] = this.editButton;
        this.buttons[3] = this.upButton;
        this.buttons[4] = this.downButton;
    }

    private Button createPushButton(Composite parent, String text) {
        Button button = new Button(parent, 8);
        button.setText(text);
        button.setFont(parent.getFont());
        GridData data = new GridData(768);
        int widthHint = this.convertHorizontalDLUsToPixels((Control)button, 61);
        data.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData((Object)data);
        button.addSelectionListener(this.getSelectionListener());
        return button;
    }

    public Button getButton(int id) {
        return this.buttons[id];
    }

    private SelectionListener getSelectionListener() {
        if (this.selectionListener == null) {
            this.createSelectionListener();
        }
        return this.selectionListener;
    }

    private void createSelectionListener() {
        this.selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Widget widget = event.widget;
                if (widget == AbstractTableFieldEditor.this.addButton) {
                    AbstractTableFieldEditor.this.addPressed();
                } else if (widget == AbstractTableFieldEditor.this.removeButton) {
                    AbstractTableFieldEditor.this.removePressed();
                } else if (widget == AbstractTableFieldEditor.this.editButton) {
                    AbstractTableFieldEditor.this.editPressed();
                } else if (widget == AbstractTableFieldEditor.this.upButton) {
                    AbstractTableFieldEditor.this.upPressed();
                } else if (widget == AbstractTableFieldEditor.this.downButton) {
                    AbstractTableFieldEditor.this.downPressed();
                } else if (widget == AbstractTableFieldEditor.this.theTable) {
                    AbstractTableFieldEditor.this.selectionChanged();
                }
            }
        };
    }

    void selectionChanged() {
        int index = this.theTable.getSelectionIndex();
        int size = this.theTable.getItemCount();
        this.removeButton.setEnabled(index >= 0);
        this.editButton.setEnabled(index >= 0);
        this.upButton.setEnabled(size > 1 && index > 0);
        this.downButton.setEnabled(size > 1 && index >= 0 && index < size - 1);
    }

    public void setEnabled(boolean enabled, Composite parent) {
        super.setEnabled(enabled, parent);
        this.getTableControl(parent).setEnabled(enabled);
        this.addButton.setEnabled(enabled);
        this.removeButton.setEnabled(enabled);
        this.editButton.setEnabled(enabled);
        this.upButton.setEnabled(enabled);
        this.downButton.setEnabled(enabled);
    }

    public void setFocus() {
        if (this.theTable != null) {
            this.theTable.setFocus();
        }
    }

    public int getNumberOfControls() {
        return 2;
    }

    protected void adjustForNumColumns(int numColumns) {
        Label control = this.getLabelControl();
        ((GridData)control.getLayoutData()).horizontalSpan = numColumns;
        ((GridData)this.theTable.getLayoutData()).horizontalSpan = numColumns - 1;
    }

    protected abstract String createString(String[][] var1);

    protected abstract String[][] parseString(String var1);

    protected void doLoad() {
        if (this.theTable != null) {
            String s = this.getPreferenceStore().getString(this.getPreferenceName());
            this.createTableItems(s);
        }
    }

    protected void doLoadDefault() {
        if (this.theTable != null) {
            this.theTable.removeAll();
            String s = this.getPreferenceStore().getDefaultString(this.getPreferenceName());
            this.createTableItems(s);
        }
    }

    private void createTableItems(String s) {
        String[][] array = this.parseString(s);
        if (array == null) {
            return;
        }
        int tableColumnCount = this.theTable.getColumnCount();
        for (int i = 0; i < array.length; ++i) {
            String[] values = array[i];
            TableItem tableItem = new TableItem(this.theTable, 16384);
            int min = Math.min(tableColumnCount, values.length);
            for (int col = 0; col < min; ++col) {
                String value = values[col];
                if (value == null) {
                    value = "";
                }
                tableItem.setText(col, value);
            }
        }
    }

    protected void doStore() {
        int tableItemCount = this.theTable.getItemCount();
        int tableColumnCount = this.theTable.getColumnCount();
        String[][] data = new String[tableItemCount][tableColumnCount];
        for (int item = 0; item < tableItemCount; ++item) {
            TableItem tableItem = this.theTable.getItem(item);
            for (int col = 0; col < tableColumnCount; ++col) {
                data[item][col] = tableItem.getText(col);
            }
        }
        String s = this.createString(data);
        if (s != null) {
            this.getPreferenceStore().setValue(this.getPreferenceName(), s);
        }
    }

    protected abstract TableItem createNewTableItem(Table var1);

    protected abstract String[] editTableItem(Table var1, String[] var2);

    void addPressed() {
        this.setPresentsDefaultValue(false);
        TableItem tableItem = this.createNewTableItem(this.theTable);
        if (tableItem != null) {
            this.selectionChanged();
        }
    }

    void removePressed() {
        this.setPresentsDefaultValue(false);
        int index = this.theTable.getSelectionIndex();
        if (index >= 0) {
            this.theTable.remove(index);
            this.selectionChanged();
        }
    }

    void editPressed() {
        this.setPresentsDefaultValue(false);
        int index = this.theTable.getSelectionIndex();
        if (index >= 0) {
            TableItem[] selection = this.theTable.getSelection();
            Assert.isTrue((selection.length == 1 ? 1 : 0) != 0);
            TableItem item = selection[0];
            int tableColumnCount = this.theTable.getColumnCount();
            String[] values = new String[tableColumnCount];
            for (int col = 0; col < tableColumnCount; ++col) {
                values[col] = item.getText(col);
            }
            if ((values = this.editTableItem(this.theTable, values)) != null) {
                int min = Math.min(tableColumnCount, values.length);
                for (int col = 0; col < min; ++col) {
                    String value = values[col];
                    if (value == null) {
                        value = "";
                    }
                    item.setText(col, value);
                }
                this.selectionChanged();
            }
        }
    }

    void upPressed() {
        this.swap(true);
    }

    void downPressed() {
        this.swap(false);
    }

    private void swap(boolean up) {
        int target;
        this.setPresentsDefaultValue(false);
        int index = this.theTable.getSelectionIndex();
        int n = target = up ? index - 1 : index + 1;
        if (index >= 0) {
            TableItem[] selection = this.theTable.getSelection();
            Assert.isTrue((selection.length == 1 ? 1 : 0) != 0);
            TableItem item = selection[0];
            int tableColumnCount = this.theTable.getColumnCount();
            String[] values = new String[tableColumnCount];
            for (int col = 0; col < tableColumnCount; ++col) {
                values[col] = item.getText(col);
            }
            TableItem targetItem = this.theTable.getItem(target);
            for (int col = 0; col < tableColumnCount; ++col) {
                item.setText(col, targetItem.getText(col));
                targetItem.setText(col, values[col]);
            }
            this.theTable.setSelection(target);
        }
        this.selectionChanged();
    }
}

