/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.tests.gdb;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import org.eclipse.dd.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.ImmediateExecutor;
import org.eclipse.dd.dsf.concurrent.Query;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.datamodel.CompositeDMContext;
import org.eclipse.dd.dsf.datamodel.DMContexts;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.debug.service.IFormattedValues;
import org.eclipse.dd.dsf.debug.service.IProcesses;
import org.eclipse.dd.dsf.debug.service.IRegisters;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.debug.service.IStack;
import org.eclipse.dd.dsf.debug.service.command.ICommandControlService;
import org.eclipse.dd.dsf.service.DsfServicesTracker;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.mi.service.IMIExecutionDMContext;
import org.eclipse.dd.mi.service.IMIProcesses;
import org.eclipse.dd.mi.service.command.events.MIStoppedEvent;
import org.eclipse.dd.tests.gdb.framework.AsyncCompletionWaitor;
import org.eclipse.dd.tests.gdb.framework.BackgroundRunner;
import org.eclipse.dd.tests.gdb.framework.BaseTestCase;
import org.eclipse.dd.tests.gdb.framework.SyncUtil;
import org.eclipse.dd.tests.gdb.launching.TestsPlugin;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=BackgroundRunner.class)
public class MIRegistersTest
extends BaseTestCase {
    final int NUMBER_OF_REGISTERS = 50;
    private static final String EXEC_PATH = "data/launch/bin/";
    private static final String EXEC_NAME = "MultiThread.exe";
    private static final String SRC_NAME = "MultiThread.cc";
    private DsfSession fSession;
    private DsfServicesTracker fServicesTracker;
    private IRunControl.IContainerDMContext fContainerDmc;
    private IRegisters fRegService;
    private static String REGISTER_VALUE = "";

    @Before
    public void init() throws Exception {
        this.fSession = this.getGDBLaunch().getSession();
        this.fServicesTracker = new DsfServicesTracker(TestsPlugin.getBundleContext(), this.fSession.getId());
        ICommandControlService commandControl = (ICommandControlService)this.fServicesTracker.getService(ICommandControlService.class);
        IMIProcesses procService = (IMIProcesses)this.fServicesTracker.getService(IMIProcesses.class);
        IProcesses.IProcessDMContext procDmc = procService.createProcessContext(commandControl.getContext(), "");
        this.fContainerDmc = procService.createContainerContext(procDmc, "");
        this.fRegService = (IRegisters)this.fServicesTracker.getService(IRegisters.class);
    }

    @BeforeClass
    public static void beforeClassMethod() {
        MIRegistersTest.setLaunchAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", "data/launch/bin/MultiThread.exe");
    }

    @After
    public void tearDown() {
        this.fServicesTracker.dispose();
        this.fRegService = null;
    }

    private IRegisters.IRegisterGroupDMContext getRegisterGroup() throws Throwable {
        final AsyncCompletionWaitor fWait = new AsyncCompletionWaitor();
        DataRequestMonitor<IRegisters.IRegisterGroupDMContext[]> regGroupDone = new DataRequestMonitor<IRegisters.IRegisterGroupDMContext[]>((Executor)this.fRegService.getExecutor(), null){

            protected void handleCompleted() {
                if (this.isSuccess()) {
                    fWait.setReturnInfo(this.getData());
                }
                fWait.waitFinished(this.getStatus());
            }
        };
        this.fRegService.getExecutor().submit(new Runnable((DataRequestMonitor)regGroupDone){
            final /* synthetic */ DataRequestMonitor val$regGroupDone;
            {
                this.val$regGroupDone = dataRequestMonitor;
            }

            public void run() {
                MIRegistersTest.this.fRegService.getRegisterGroups((IDMContext)MIRegistersTest.this.fContainerDmc, this.val$regGroupDone);
            }
        });
        fWait.waitUntilDone(0);
        Assert.assertTrue((String)fWait.getMessage(), (boolean)fWait.isOK());
        IRegisters.IRegisterGroupDMContext[] regGroupsDMCs = (IRegisters.IRegisterGroupDMContext[])fWait.getReturnInfo();
        Assert.assertTrue((String)("There was more than one register group (" + regGroupsDMCs.length + ")"), (regGroupsDMCs.length == 1 ? 1 : 0) != 0);
        fWait.waitReset();
        return regGroupsDMCs[0];
    }

    private IRegisters.IRegisterDMContext[] getRegisters(final IStack.IFrameDMContext frameDmc) throws Throwable {
        final AsyncCompletionWaitor fWait = new AsyncCompletionWaitor();
        final IRegisters.IRegisterGroupDMContext regGroupsDMC = this.getRegisterGroup();
        this.fRegService.getExecutor().submit(new Runnable(){

            public void run() {
                MIRegistersTest.this.fRegService.getRegisters((IDMContext)new CompositeDMContext(new IDMContext[]{regGroupsDMC, frameDmc}), (DataRequestMonitor)new DataRequestMonitor<IRegisters.IRegisterDMContext[]>((Executor)MIRegistersTest.this.fRegService.getExecutor(), null){

                    protected void handleCompleted() {
                        if (this.isSuccess()) {
                            fWait.setReturnInfo(this.getData());
                        }
                        fWait.waitFinished(this.getStatus());
                    }
                });
            }
        });
        fWait.waitUntilDone(0);
        Assert.assertTrue((String)fWait.getMessage(), (boolean)fWait.isOK());
        IRegisters.IRegisterDMContext[] regContexts = (IRegisters.IRegisterDMContext[])fWait.getReturnInfo();
        fWait.waitReset();
        Assert.assertTrue((String)("The number of registers should have been 50 instead of " + regContexts.length), (regContexts.length == 50 ? 1 : 0) != 0);
        return regContexts;
    }

    @Test
    public void getRegisterGroups() throws Throwable {
        final IRegisters.IRegisterGroupDMContext regGroupsDMC = this.getRegisterGroup();
        Query<IRegisters.IRegisterGroupDMData> query = new Query<IRegisters.IRegisterGroupDMData>(){

            protected void execute(DataRequestMonitor<IRegisters.IRegisterGroupDMData> rm) {
                MIRegistersTest.this.fRegService.getRegisterGroupData(regGroupsDMC, rm);
            }
        };
        this.fSession.getExecutor().execute((Runnable)query);
        IRegisters.IRegisterGroupDMData data = (IRegisters.IRegisterGroupDMData)query.get();
        Assert.assertTrue((String)("The name of the main group should be: General Registers instead of: " + data.getName()), (boolean)data.getName().equals("General Registers"));
    }

    @Test
    public void getRegistersLength() throws Throwable {
        MIStoppedEvent stoppedEvent = this.getInitialStoppedEvent();
        IStack.IFrameDMContext frameDmc = SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 0);
        IRegisters.IRegisterDMContext[] regDMCs = this.getRegisters(frameDmc);
        Assert.assertTrue((String)("The number of registers should have been 50 instead of " + regDMCs.length), (regDMCs.length == 50 ? 1 : 0) != 0);
    }

    @Test
    public void getRegisters() throws Throwable {
        IRegisters.IRegisterDMData[] datas;
        MIStoppedEvent stoppedEvent = this.getInitialStoppedEvent();
        IStack.IFrameDMContext frameDmc = SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 0);
        final IRegisters.IRegisterDMContext[] regDMCs = this.getRegisters(frameDmc);
        List<String> regNames = Arrays.asList("eax", "ecx", "edx", "ebx", "esp", "ebp", "esi", "edi", "eip", "eflags", "cs", "ss", "ds", "es", "fs", "gs", "st0", "st1", "st2", "st3", "st4", "st5", "st6", "st7", "fctrl", "fstat", "ftag", "fiseg", "fioff", "foseg", "fooff", "fop", "xmm0", "xmm1", "xmm2", "xmm3", "xmm4", "xmm5", "xmm6", "xmm7", "mxcsr", "orig_eax", "mm0", "mm1", "mm2", "mm3", "mm4", "mm5", "mm6", "mm7");
        Query<IRegisters.IRegisterDMData[]> query = new Query<IRegisters.IRegisterDMData[]>(){

            protected void execute(DataRequestMonitor<IRegisters.IRegisterDMData[]> rm) {
                final IRegisters.IRegisterDMData[] datas = new IRegisters.IRegisterDMData[regDMCs.length];
                rm.setData((Object)datas);
                final CountingRequestMonitor countingRm = new CountingRequestMonitor(ImmediateExecutor.getInstance(), rm);
                countingRm.setDoneCount(regDMCs.length);
                int i = 0;
                while (i < regDMCs.length) {
                    final int index = i++;
                    MIRegistersTest.this.fRegService.getRegisterData(regDMCs[index], (DataRequestMonitor)new DataRequestMonitor<IRegisters.IRegisterDMData>(ImmediateExecutor.getInstance(), (RequestMonitor)countingRm){

                        protected void handleSuccess() {
                            datas[index] = (IRegisters.IRegisterDMData)this.getData();
                            countingRm.done();
                        }
                    });
                }
            }
        };
        this.fSession.getExecutor().execute((Runnable)query);
        for (IRegisters.IRegisterDMData data : datas = (IRegisters.IRegisterDMData[])query.get()) {
            String regName = data.getName();
            Assert.assertFalse((String)("GDB does not support register name: " + regName), (!regNames.contains(regName) ? 1 : 0) != 0);
        }
    }

    private String getModelDataForRegisterDataValue(IStack.IFrameDMContext frameDmc, String format, int regNo) throws Throwable {
        final AsyncCompletionWaitor wait = new AsyncCompletionWaitor();
        IRegisters.IRegisterDMContext[] regDMCs = this.getRegisters(frameDmc);
        final IFormattedValues.FormattedValueDMContext valueDmc = this.fRegService.getFormattedValueContext((IFormattedValues.IFormattedDataDMContext)regDMCs[regNo], format);
        DataRequestMonitor<IFormattedValues.FormattedValueDMData> regRm = new DataRequestMonitor<IFormattedValues.FormattedValueDMData>((Executor)this.fRegService.getExecutor(), null){

            protected void handleCompleted() {
                if (this.isSuccess()) {
                    wait.setReturnInfo(this.getData());
                }
                wait.waitFinished(this.getStatus());
            }
        };
        this.fRegService.getExecutor().submit(new Runnable((DataRequestMonitor)regRm){
            final /* synthetic */ DataRequestMonitor val$regRm;
            {
                this.val$regRm = dataRequestMonitor;
            }

            public void run() {
                MIRegistersTest.this.fRegService.getFormattedExpressionValue(valueDmc, this.val$regRm);
            }
        });
        wait.waitUntilDone(0);
        Assert.assertTrue((String)wait.getMessage(), (boolean)wait.isOK());
        IFormattedValues.FormattedValueDMData data = (IFormattedValues.FormattedValueDMData)wait.getReturnInfo();
        return data.getFormattedValue();
    }

    @Test
    public void getModelDataForRegisterDataValueInDifferentNumberFormats() throws Throwable {
        String val;
        MIStoppedEvent stoppedEvent = this.getInitialStoppedEvent();
        IStack.IFrameDMContext frameDmc = SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 0);
        REGISTER_VALUE = val = this.getModelDataForRegisterDataValue(frameDmc, "NATURAL.Format", 0);
        Assert.assertTrue((String)"Register Value is not in NATURAL format ", (Integer.parseInt(val) == Integer.parseInt(REGISTER_VALUE) ? 1 : 0) != 0);
        val = this.getModelDataForRegisterDataValue(frameDmc, "HEX.Format", 0);
        Assert.assertTrue((String)"Register Value is not in HEX_FORMAT ", (boolean)val.startsWith("0x"));
        val = this.getModelDataForRegisterDataValue(frameDmc, "BINARY.Format", 0);
        Assert.assertEquals((String)"Register Value is not in BINARY_FORMAT ", (Object)val, (Object)Integer.toBinaryString(Integer.parseInt(REGISTER_VALUE)));
        val = this.getModelDataForRegisterDataValue(frameDmc, "DECIMAL.Format", 0);
        Assert.assertEquals((String)"Register Value is not in DECIMAL_FORMAT", (Object)Integer.parseInt(val), (Object)Integer.parseInt(REGISTER_VALUE));
        val = this.getModelDataForRegisterDataValue(frameDmc, "OCTAL.Format", 0);
        Assert.assertTrue((String)"Register Value is not in OCTAL_FORMAT ", (boolean)val.startsWith("0"));
    }

    @Test
    public void compareRegisterForMultipleExecutionContexts() throws Throwable {
        MIStoppedEvent stoppedEvent = SyncUtil.SyncRunToLine(SRC_NAME, "22");
        IRunControl.IContainerDMContext containerDmc = (IRunControl.IContainerDMContext)DMContexts.getAncestorOfType((IDMContext)stoppedEvent.getDMContext(), IRunControl.IContainerDMContext.class);
        IMIExecutionDMContext execDmc = SyncUtil.SyncCreateExecutionContext(containerDmc, 2);
        IStack.IFrameDMContext frameDmc2 = SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)execDmc, 0);
        String thread2RegVal0 = this.getModelDataForRegisterDataValue(frameDmc2, "NATURAL.Format", 0);
        String thread2RegVal1 = this.getModelDataForRegisterDataValue(frameDmc2, "NATURAL.Format", 1);
        String thread2RegVal2 = this.getModelDataForRegisterDataValue(frameDmc2, "NATURAL.Format", 2);
        String thread2RegVal3 = this.getModelDataForRegisterDataValue(frameDmc2, "NATURAL.Format", 3);
        String thread2RegVal4 = this.getModelDataForRegisterDataValue(frameDmc2, "NATURAL.Format", 4);
        String thread2RegVal5 = this.getModelDataForRegisterDataValue(frameDmc2, "NATURAL.Format", 5);
        execDmc = SyncUtil.SyncCreateExecutionContext(containerDmc, 2);
        IStack.IFrameDMContext frameDmc1 = SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)execDmc, 0);
        this.getModelDataForRegisterDataValue(frameDmc1, "NATURAL.Format", 0);
        String dupliThread2RegVal0 = this.getModelDataForRegisterDataValue(frameDmc2, "NATURAL.Format", 0);
        String dupliThread2RegVal1 = this.getModelDataForRegisterDataValue(frameDmc2, "NATURAL.Format", 1);
        String dupliThread2RegVal2 = this.getModelDataForRegisterDataValue(frameDmc2, "NATURAL.Format", 2);
        String dupliThread2RegVal3 = this.getModelDataForRegisterDataValue(frameDmc2, "NATURAL.Format", 3);
        String dupliThread2RegVal4 = this.getModelDataForRegisterDataValue(frameDmc2, "NATURAL.Format", 4);
        String dupliThread2RegVal5 = this.getModelDataForRegisterDataValue(frameDmc2, "NATURAL.Format", 5);
        Assert.assertTrue((String)"Multiple context not working. Execution Context is not reset to 2", (boolean)thread2RegVal0.equals(dupliThread2RegVal0));
        Assert.assertTrue((String)"Multiple context not working. Execution Context is not reset to 2", (boolean)thread2RegVal1.equals(dupliThread2RegVal1));
        Assert.assertTrue((String)"Multiple context not working. Execution Context is not reset to 2", (boolean)thread2RegVal2.equals(dupliThread2RegVal2));
        Assert.assertTrue((String)"Multiple context not working. Execution Context is not reset to 2", (boolean)thread2RegVal3.equals(dupliThread2RegVal3));
        Assert.assertTrue((String)"Multiple context not working. Execution Context is not reset to 2", (boolean)thread2RegVal4.equals(dupliThread2RegVal4));
        Assert.assertTrue((String)"Multiple context not working. Execution Context is not reset to 2", (boolean)thread2RegVal5.equals(dupliThread2RegVal5));
    }

    private void writeRegister(IStack.IFrameDMContext frameDmc, final int regIndex, final String regValue, final String formatId) throws Throwable {
        final AsyncCompletionWaitor fWait = new AsyncCompletionWaitor();
        final IRegisters.IRegisterDMContext[] regDMCs = this.getRegisters(frameDmc);
        this.fRegService.getExecutor().submit(new Runnable(){

            public void run() {
                MIRegistersTest.this.fRegService.writeRegister(regDMCs[regIndex], regValue, formatId, new RequestMonitor((Executor)MIRegistersTest.this.fRegService.getExecutor(), null){

                    protected void handleCompleted() {
                        fWait.waitFinished(this.getStatus());
                    }
                });
            }
        });
        fWait.waitUntilDone(0);
        fWait.waitReset();
    }

    @Test
    public void writeRegisterNaturalFormat() throws Throwable {
        MIStoppedEvent stoppedEvent = this.getInitialStoppedEvent();
        IStack.IFrameDMContext frameDmc = SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 0);
        String regValue = "10";
        int regIndex = 3;
        this.writeRegister(frameDmc, 3, regValue, "NATURAL.Format");
        String val = this.getModelDataForRegisterDataValue(frameDmc, "NATURAL.Format", regIndex);
        Assert.assertTrue((String)("Failed writing register. New value should have been " + regValue), (boolean)regValue.equals(val));
    }

    @Test
    public void writeRegisterHEXFormat() throws Throwable {
        MIStoppedEvent stoppedEvent = this.getInitialStoppedEvent();
        IStack.IFrameDMContext frameDmc = SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 0);
        String regValue = "0x10";
        int regIndex = 3;
        this.writeRegister(frameDmc, 3, regValue, "HEX.Format");
        String val = this.getModelDataForRegisterDataValue(frameDmc, "HEX.Format", regIndex);
        Assert.assertTrue((String)("Failed writing register. New value should have been " + regValue), (boolean)regValue.equals(val));
    }

    @Test
    @Ignore
    public void writeRegisterBinaryFormat() throws Throwable {
        MIStoppedEvent stoppedEvent = this.getInitialStoppedEvent();
        IStack.IFrameDMContext frameDmc = SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 0);
        String regValue = "10";
        int regIndex = 3;
        this.writeRegister(frameDmc, 3, regValue, "BINARY.Format");
        String val = this.getModelDataForRegisterDataValue(frameDmc, "BINARY.Format", regIndex);
        Assert.assertTrue((String)("Failed writing register. New value should have been " + regValue + " instead of " + val), (boolean)regValue.equals(val));
    }

    @Test
    public void writeRegisterOctalFormat() throws Throwable {
        MIStoppedEvent stoppedEvent = this.getInitialStoppedEvent();
        IStack.IFrameDMContext frameDmc = SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 0);
        String regValue = "012";
        int regIndex = 3;
        this.writeRegister(frameDmc, 3, regValue, "OCTAL.Format");
        String val = this.getModelDataForRegisterDataValue(frameDmc, "OCTAL.Format", regIndex);
        Assert.assertTrue((String)("Failed writing register. New value should have been " + regValue + "instead of " + val), (boolean)regValue.equals(val));
    }
}

