/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.gdb.internal.provisional.service;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.cdt.utils.spawner.Spawner;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.dd.dsf.concurrent.DsfRunnable;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.concurrent.Sequence;
import org.eclipse.dd.dsf.service.AbstractDsfService;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.gdb.internal.GdbPlugin;
import org.eclipse.dd.gdb.internal.provisional.launching.LaunchUtils;
import org.eclipse.dd.gdb.internal.provisional.service.IGDBBackend;
import org.eclipse.dd.gdb.internal.provisional.service.SessionType;
import org.eclipse.dd.gdb.internal.provisional.service.command.GDBControl;
import org.eclipse.dd.mi.service.IMIBackend;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GDBBackend
extends AbstractDsfService
implements IGDBBackend {
    private ILaunchConfiguration fLaunchConfiguration;
    private IPath fProgramPath;
    private IPath fGDBWorkingDirectory;
    private String fGDBInitFile;
    private List<String> fSharedLibPaths;
    private String fProgramArguments;
    private SessionType fSessionType;
    private Boolean fAttach;
    private final String fBackendId = "gdb[" + Integer.toString(fgInstanceCounter++) + "]";
    private static int fgInstanceCounter = 0;
    private MonitorJob fMonitorJob;
    private Process fProcess;
    private int fGDBExitValue;
    private int fGDBLaunchTimeout = 30;

    public GDBBackend(DsfSession session, ILaunchConfiguration lc) {
        super(session);
        this.fLaunchConfiguration = lc;
        try {
            ICProject cproject = LaunchUtils.getCProject(lc);
            this.fProgramPath = LaunchUtils.verifyProgramPath(lc, cproject);
        }
        catch (CoreException e) {
            this.fProgramPath = new Path("");
        }
    }

    public void initialize(final RequestMonitor requestMonitor) {
        super.initialize(new RequestMonitor((Executor)this.getExecutor(), requestMonitor){

            protected void handleSuccess() {
                GDBBackend.this.doInitialize(requestMonitor);
            }
        });
    }

    public void doInitialize(RequestMonitor requestMonitor) {
        final Sequence.Step[] initializeSteps = new Sequence.Step[]{new GDBProcessStep(GDBControl.InitializationShutdownStep.Direction.INITIALIZING), new MonitorJobStep(GDBControl.InitializationShutdownStep.Direction.INITIALIZING), new RegisterStep(GDBControl.InitializationShutdownStep.Direction.INITIALIZING)};
        Sequence startupSequence = new Sequence(this.getExecutor(), requestMonitor){

            public Sequence.Step[] getSteps() {
                return initializeSteps;
            }
        };
        this.getExecutor().execute((Runnable)startupSequence);
    }

    public void shutdown(RequestMonitor requestMonitor) {
        final Sequence.Step[] shutdownSteps = new Sequence.Step[]{new RegisterStep(GDBControl.InitializationShutdownStep.Direction.SHUTTING_DOWN), new MonitorJobStep(GDBControl.InitializationShutdownStep.Direction.SHUTTING_DOWN), new GDBProcessStep(GDBControl.InitializationShutdownStep.Direction.SHUTTING_DOWN)};
        Sequence shutdownSequence = new Sequence(this.getExecutor(), requestMonitor){

            public Sequence.Step[] getSteps() {
                return shutdownSteps;
            }
        };
        this.getExecutor().execute((Runnable)shutdownSequence);
    }

    private IPath getGDBPath() {
        return LaunchUtils.getGDBPath(this.fLaunchConfiguration);
    }

    protected String getGDBCommandLine() {
        StringBuffer gdbCommandLine = new StringBuffer(this.getGDBPath().toOSString());
        gdbCommandLine.append(" --interpreter");
        gdbCommandLine.append(" mi2");
        gdbCommandLine.append(" --nx");
        return gdbCommandLine.toString();
    }

    @Override
    public String getGDBInitFile() throws CoreException {
        if (this.fGDBInitFile == null) {
            this.fGDBInitFile = this.fLaunchConfiguration.getAttribute("org.eclipse.dd.gdb.GDB_INIT", ".gdbinit");
        }
        return this.fGDBInitFile;
    }

    @Override
    public IPath getGDBWorkingDirectory() throws CoreException {
        if (this.fGDBWorkingDirectory == null) {
            ICProject cp;
            String expandedLocation;
            Object path = null;
            String location = this.fLaunchConfiguration.getAttribute("org.eclipse.cdt.launch.WORKING_DIRECTORY", (String)null);
            if (location != null && (expandedLocation = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(location)).length() > 0) {
                path = new Path(expandedLocation);
            }
            if (path != null) {
                if (path.isAbsolute()) {
                    File dir = new File(path.toPortableString());
                    if (!dir.isDirectory()) {
                        path = null;
                    }
                } else {
                    IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
                    path = res instanceof IContainer && res.exists() ? res.getLocation() : null;
                }
            }
            if (path == null && (cp = LaunchUtils.getCProject(this.fLaunchConfiguration)) != null) {
                IProject p = cp.getProject();
                path = p.getLocation();
            }
            this.fGDBWorkingDirectory = path;
        }
        return this.fGDBWorkingDirectory;
    }

    @Override
    public String getProgramArguments() throws CoreException {
        if (this.fProgramArguments == null) {
            this.fProgramArguments = this.fLaunchConfiguration.getAttribute("org.eclipse.cdt.launch.PROGRAM_ARGUMENTS", (String)null);
            if (this.fProgramArguments != null) {
                this.fProgramArguments = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(this.fProgramArguments);
            }
        }
        return this.fProgramArguments;
    }

    @Override
    public IPath getProgramPath() {
        return this.fProgramPath;
    }

    @Override
    public List<String> getSharedLibraryPaths() throws CoreException {
        if (this.fSharedLibPaths == null) {
            this.fSharedLibPaths = this.fLaunchConfiguration.getAttribute("org.eclipse.dd.gdb.SOLIB_PATH", new ArrayList(0));
        }
        return this.fSharedLibPaths;
    }

    protected Process launchGDBProcess(String commandLine) throws CoreException {
        Process proc = null;
        try {
            proc = ProcessFactory.getFactory().exec(commandLine);
        }
        catch (IOException e) {
            String message = "Error while launching command " + commandLine;
            throw new CoreException((IStatus)new Status(4, "org.eclipse.dd.gdb", -1, message, (Throwable)e));
        }
        return proc;
    }

    public Process getProcess() {
        return this.fProcess;
    }

    public OutputStream getMIOutputStream() {
        return this.fProcess.getOutputStream();
    }

    public InputStream getMIInputStream() {
        return this.fProcess.getInputStream();
    }

    public String getId() {
        return this.fBackendId;
    }

    @Override
    public void interrupt() {
        if (this.fProcess instanceof Spawner) {
            Spawner gdbSpawner = (Spawner)this.fProcess;
            gdbSpawner.interrupt();
        }
    }

    public void destroy() {
        if (this.getState() == IMIBackend.State.STARTED) {
            this.fProcess.destroy();
        }
    }

    public IMIBackend.State getState() {
        if (this.fMonitorJob == null) {
            return IMIBackend.State.NOT_INITIALIZED;
        }
        if (this.fMonitorJob.fExited) {
            return IMIBackend.State.TERMINATED;
        }
        return IMIBackend.State.STARTED;
    }

    public int getExitCode() {
        return this.fGDBExitValue;
    }

    @Override
    public SessionType getSessionType() {
        if (this.fSessionType == null) {
            this.fSessionType = LaunchUtils.getSessionType(this.fLaunchConfiguration);
        }
        return this.fSessionType;
    }

    @Override
    public boolean getIsAttachSession() {
        if (this.fAttach == null) {
            this.fAttach = LaunchUtils.getIsAttach(this.fLaunchConfiguration);
        }
        return this.fAttach;
    }

    protected BundleContext getBundleContext() {
        return GdbPlugin.getBundleContext();
    }

    protected class GDBProcessStep
    extends GDBControl.InitializationShutdownStep {
        GDBProcessStep(GDBControl.InitializationShutdownStep.Direction direction) {
            super(direction);
        }

        public void initialize(final RequestMonitor requestMonitor) {
            class GDBLaunchMonitor {
                boolean fLaunched = false;
                boolean fTimedOut = false;

                GDBLaunchMonitor() {
                }
            }
            final GDBLaunchMonitor fGDBLaunchMonitor = new GDBLaunchMonitor();
            final RequestMonitor gdbLaunchRequestMonitor = new RequestMonitor((Executor)GDBBackend.this.getExecutor(), requestMonitor){
                {
                    super(x0, x1);
                }

                protected void handleCompleted() {
                    if (!fGDBLaunchMonitor.fTimedOut) {
                        fGDBLaunchMonitor.fLaunched = true;
                        if (!this.isSuccess()) {
                            requestMonitor.setStatus(this.getStatus());
                        }
                        requestMonitor.done();
                    }
                }
            };
            final Job startGdbJob = new Job("Start GDB Process Job"){
                {
                    super(x0);
                    this.setSystem(true);
                }

                protected IStatus run(IProgressMonitor monitor) {
                    if (gdbLaunchRequestMonitor.isCanceled()) {
                        gdbLaunchRequestMonitor.setStatus((IStatus)new Status(8, "org.eclipse.dd.gdb", -1, "Canceled starting GDB", null));
                        gdbLaunchRequestMonitor.done();
                        return Status.OK_STATUS;
                    }
                    String commandLine = GDBBackend.this.getGDBCommandLine();
                    try {
                        GDBBackend.this.fProcess = GDBBackend.this.launchGDBProcess(commandLine);
                    }
                    catch (CoreException e) {
                        gdbLaunchRequestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", -1, e.getMessage(), (Throwable)e));
                        gdbLaunchRequestMonitor.done();
                        return Status.OK_STATUS;
                    }
                    try {
                        String line;
                        InputStreamReader r = new InputStreamReader(GDBBackend.this.getMIInputStream());
                        BufferedReader reader = new BufferedReader(r);
                        while ((line = reader.readLine()) != null && !(line = line.trim()).endsWith("(gdb)")) {
                        }
                    }
                    catch (IOException e) {
                        gdbLaunchRequestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", -1, "Error reading GDB STDOUT", (Throwable)e));
                        gdbLaunchRequestMonitor.done();
                        return Status.OK_STATUS;
                    }
                    gdbLaunchRequestMonitor.done();
                    return Status.OK_STATUS;
                }
            };
            startGdbJob.schedule();
            GDBBackend.this.getExecutor().schedule(new Runnable(){
                {
                }

                public void run() {
                    if (!fGDBLaunchMonitor.fLaunched) {
                        fGDBLaunchMonitor.fTimedOut = true;
                        Thread jobThread = startGdbJob.getThread();
                        if (jobThread != null) {
                            jobThread.interrupt();
                        }
                        requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", 5010, "Timed out trying to launch GDB.", null));
                        requestMonitor.done();
                    }
                }
            }, (long)GDBBackend.this.fGDBLaunchTimeout, TimeUnit.SECONDS);
        }

        protected void shutdown(final RequestMonitor requestMonitor) {
            new Job("Terminating GDB process."){
                {
                    super(x0);
                    this.setSystem(true);
                }

                protected IStatus run(IProgressMonitor monitor) {
                    GDBBackend.this.destroy();
                    for (int attempts = 0; attempts < 10; ++attempts) {
                        try {
                            GDBBackend.this.fGDBExitValue = GDBBackend.this.fProcess.exitValue();
                            requestMonitor.done();
                            return Status.OK_STATUS;
                        }
                        catch (IllegalThreadStateException ie) {
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            continue;
                        }
                    }
                    requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", 10004, "Process terminate failed", null));
                    requestMonitor.done();
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }

    private class MonitorJob
    extends Job {
        boolean fExited;
        DsfRunnable fMonitorStarted;
        Process fMonProcess;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            Process process = this.fMonProcess;
            synchronized (process) {
                GDBBackend.this.getExecutor().submit((Runnable)this.fMonitorStarted);
                while (!this.fExited) {
                    try {
                        this.fMonProcess.waitFor();
                        GDBBackend.this.fGDBExitValue = this.fMonProcess.exitValue();
                    }
                    catch (InterruptedException ie) {
                        Thread.interrupted();
                    }
                    finally {
                        this.fExited = true;
                        GDBBackend.this.getSession().dispatchEvent((Object)new IMIBackend.BackendStateChangedEvent(GDBBackend.this.getSession().getId(), GDBBackend.this.getId(), IMIBackend.State.TERMINATED), GDBBackend.this.getProperties());
                    }
                }
            }
            return Status.OK_STATUS;
        }

        MonitorJob(Process process, DsfRunnable monitorStarted) {
            super("GDB process monitor job.");
            this.fExited = false;
            this.fMonProcess = process;
            this.fMonitorStarted = monitorStarted;
            this.setSystem(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void kill() {
            Process process = this.fMonProcess;
            synchronized (process) {
                if (!this.fExited) {
                    this.getThread().interrupt();
                }
            }
        }
    }

    protected class MonitorJobStep
    extends GDBControl.InitializationShutdownStep {
        MonitorJobStep(GDBControl.InitializationShutdownStep.Direction direction) {
            super(direction);
        }

        public void initialize(final RequestMonitor requestMonitor) {
            GDBBackend.this.fMonitorJob = new MonitorJob(GDBBackend.this.fProcess, new DsfRunnable(){

                public void run() {
                    requestMonitor.done();
                }
            });
            GDBBackend.this.fMonitorJob.schedule();
        }

        protected void shutdown(RequestMonitor requestMonitor) {
            if (!((GDBBackend)GDBBackend.this).fMonitorJob.fExited) {
                GDBBackend.this.fMonitorJob.kill();
            }
            requestMonitor.done();
        }
    }

    protected class RegisterStep
    extends GDBControl.InitializationShutdownStep {
        RegisterStep(GDBControl.InitializationShutdownStep.Direction direction) {
            super(direction);
        }

        public void initialize(RequestMonitor requestMonitor) {
            GDBBackend.this.register(new String[]{IMIBackend.class.getName(), IGDBBackend.class.getName()}, new Hashtable());
            GDBBackend.this.getSession().dispatchEvent((Object)new IMIBackend.BackendStateChangedEvent(GDBBackend.this.getSession().getId(), GDBBackend.this.getId(), IMIBackend.State.STARTED), GDBBackend.this.getProperties());
            requestMonitor.done();
        }

        protected void shutdown(RequestMonitor requestMonitor) {
            GDBBackend.this.unregister();
            requestMonitor.done();
        }
    }
}

