/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.gdb.internal.provisional.service.command;

import java.io.OutputStream;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.utils.pty.PTY;
import org.eclipse.dd.dsf.concurrent.DsfRunnable;
import org.eclipse.dd.dsf.concurrent.ThreadSafeAndProhibitedFromDsfExecutor;
import org.eclipse.dd.dsf.debug.service.command.ICommandControlService;
import org.eclipse.dd.gdb.internal.provisional.service.IGDBBackend;
import org.eclipse.dd.mi.service.command.MIInferiorProcess;

class GDBInferiorProcess
extends MIInferiorProcess {
    private IGDBBackend fBackend;

    public GDBInferiorProcess(ICommandControlService commandControl, IGDBBackend backend, PTY p) {
        super(commandControl, p);
        this.fBackend = backend;
    }

    public GDBInferiorProcess(ICommandControlService commandControl, IGDBBackend backend, OutputStream gdbOutputStream) {
        super(commandControl, gdbOutputStream);
        this.fBackend = backend;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ThreadSafeAndProhibitedFromDsfExecutor(value="getSession#getExecutor")
    public void destroy() {
        try {
            this.getSession().getExecutor().submit((Runnable)new DsfRunnable(){

                public void run() {
                    if (GDBInferiorProcess.this.isDisposed() || !GDBInferiorProcess.this.getSession().isActive()) {
                        return;
                    }
                    if (!GDBInferiorProcess.this.fBackend.getIsAttachSession() && GDBInferiorProcess.this.getState() == MIInferiorProcess.State.RUNNING) {
                        GDBInferiorProcess.this.fBackend.interrupt();
                    }
                }
            }).get();
        }
        catch (RejectedExecutionException e) {
        }
        catch (InterruptedException e) {
        }
        catch (ExecutionException executionException) {
        }
        finally {
            super.destroy();
        }
    }
}

