/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.launch;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.dd.dsf.concurrent.DsfRunnable;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.concurrent.ThreadSafe;
import org.eclipse.dd.dsf.datamodel.DMContexts;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.datamodel.IDMEvent;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.launch.DelayedStackRefreshUpdatePolicy;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.launch.ExpandStackEvent;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.launch.FullStackRefreshEvent;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.launch.LaunchRootVMNode;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.launch.StackFramesVMNode;
import org.eclipse.dd.dsf.debug.internal.ui.DsfDebugUIPlugin;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.dsf.ui.viewmodel.AbstractVMAdapter;
import org.eclipse.dd.dsf.ui.viewmodel.IRootVMNode;
import org.eclipse.dd.dsf.ui.viewmodel.IVMModelProxy;
import org.eclipse.dd.dsf.ui.viewmodel.IVMNode;
import org.eclipse.dd.dsf.ui.viewmodel.datamodel.AbstractDMVMProvider;
import org.eclipse.dd.dsf.ui.viewmodel.update.AutomaticUpdatePolicy;
import org.eclipse.dd.dsf.ui.viewmodel.update.IVMUpdatePolicy;
import org.eclipse.dd.dsf.ui.viewmodel.update.ManualUpdatePolicy;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractLaunchVMProvider
extends AbstractDMVMProvider
implements IDebugEventSetListener,
ILaunchesListener2 {
    private static final int FRAME_UPDATE_DELAY = 200;
    private final Map<IRunControl.IExecutionDMContext, ScheduledFuture<?>> fRefreshStackFramesFutures = new HashMap();
    private IPropertyChangeListener fPreferencesListener;

    @ThreadSafe
    public AbstractLaunchVMProvider(AbstractVMAdapter adapter, IPresentationContext presentationContext, DsfSession session) {
        super(adapter, presentationContext, session);
        final IPreferenceStore store = DsfDebugUIPlugin.getDefault().getPreferenceStore();
        if (store.getBoolean("stackFrameLimitEnable")) {
            this.getPresentationContext().setProperty("stackFrameLimit", (Object)store.getInt("stackFrameLimit"));
        }
        this.fPreferencesListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                AbstractLaunchVMProvider.this.handlePropertyChanged(store, event);
            }
        };
        store.addPropertyChangeListener(this.fPreferencesListener);
    }

    protected IVMUpdatePolicy[] createUpdateModes() {
        return new IVMUpdatePolicy[]{new DelayedStackRefreshUpdatePolicy((IVMUpdatePolicy)new AutomaticUpdatePolicy()), new DelayedStackRefreshUpdatePolicy((IVMUpdatePolicy)new ManualUpdatePolicy())};
    }

    public void handleDebugEvents(final DebugEvent[] events) {
        if (this.isDisposed()) {
            return;
        }
        try {
            this.getExecutor().execute(new Runnable(){

                public void run() {
                    if (AbstractLaunchVMProvider.this.isDisposed()) {
                        return;
                    }
                    for (DebugEvent event : events) {
                        AbstractLaunchVMProvider.this.handleEvent(event);
                    }
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    public void handleEvent(Object event, RequestMonitor rm) {
        if (event instanceof DoubleClickEvent && !this.isDisposed()) {
            StackFramesVMNode.IncompleteStackVMContext incStackVmc;
            IVMNode node;
            Object element;
            ISelection selection = ((DoubleClickEvent)event).getSelection();
            if (selection instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof StackFramesVMNode.IncompleteStackVMContext && (node = (incStackVmc = (StackFramesVMNode.IncompleteStackVMContext)((Object)element)).getVMNode()) instanceof StackFramesVMNode && node.getVMProvider() == this) {
                IRunControl.IExecutionDMContext exeCtx = incStackVmc.getExecutionDMContext();
                ((StackFramesVMNode)node).incrementStackFrameLimit(exeCtx);
                final ExpandStackEvent expandStackEvent = new ExpandStackEvent(exeCtx);
                this.getExecutor().execute((Runnable)new DsfRunnable(){

                    public void run() {
                        AbstractLaunchVMProvider.this.handleEvent((Object)expandStackEvent, null);
                    }
                });
            }
            if (rm != null) {
                rm.done();
            }
            return;
        }
        super.handleEvent(event, rm);
    }

    protected void handleEvent(IVMModelProxy proxyStrategy, Object event, RequestMonitor rm) {
        IRunControl.IExecutionDMContext exeContext;
        ScheduledFuture<?> refreshStackFramesFuture;
        super.handleEvent(proxyStrategy, event, rm);
        if (event instanceof IRunControl.ISuspendedDMEvent) {
            final IRunControl.IExecutionDMContext exeContext2 = (IRunControl.IExecutionDMContext)((IRunControl.ISuspendedDMEvent)event).getDMContext();
            ScheduledFuture refreshStackFramesFuture2 = this.getRefreshFuture(exeContext2);
            if (refreshStackFramesFuture2 != null) {
                refreshStackFramesFuture2.cancel(false);
            }
            refreshStackFramesFuture2 = this.getSession().getExecutor().schedule((Runnable)new DsfRunnable(){

                public void run() {
                    if (AbstractLaunchVMProvider.this.getSession().isActive()) {
                        AbstractLaunchVMProvider.this.getExecutor().execute(new Runnable(){

                            public void run() {
                                ScheduledFuture future = (ScheduledFuture)AbstractLaunchVMProvider.this.fRefreshStackFramesFutures.get(exeContext2);
                                if (future != null && !AbstractLaunchVMProvider.this.isDisposed()) {
                                    AbstractLaunchVMProvider.this.fRefreshStackFramesFutures.remove(exeContext2);
                                    AbstractLaunchVMProvider.this.handleEvent((Object)new FullStackRefreshEvent(exeContext2), null);
                                }
                            }
                        });
                    }
                }
            }, 200L, TimeUnit.MILLISECONDS);
            this.fRefreshStackFramesFutures.put(exeContext2, refreshStackFramesFuture2);
        } else if (event instanceof IRunControl.IResumedDMEvent && (refreshStackFramesFuture = this.fRefreshStackFramesFutures.get(exeContext = (IRunControl.IExecutionDMContext)((IRunControl.IResumedDMEvent)event).getDMContext())) != null) {
            refreshStackFramesFuture.cancel(false);
            this.fRefreshStackFramesFutures.remove(exeContext);
        }
    }

    private ScheduledFuture<?> getRefreshFuture(IRunControl.IExecutionDMContext execCtx) {
        for (IRunControl.IExecutionDMContext refreshCtx : this.fRefreshStackFramesFutures.keySet()) {
            if (!refreshCtx.equals(execCtx) && !DMContexts.isAncestorOf((IDMContext)refreshCtx, (IDMContext)execCtx)) continue;
            return this.fRefreshStackFramesFutures.remove(refreshCtx);
        }
        return null;
    }

    public void dispose() {
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchesListener)this);
        IPreferenceStore store = DsfDebugUIPlugin.getDefault().getPreferenceStore();
        store.removePropertyChangeListener(this.fPreferencesListener);
        super.dispose();
    }

    public void launchesAdded(ILaunch[] launches) {
        this.handleLaunchesEvent(new LaunchRootVMNode.LaunchesEvent(launches, LaunchRootVMNode.LaunchesEvent.Type.ADDED));
    }

    public void launchesRemoved(ILaunch[] launches) {
        this.handleLaunchesEvent(new LaunchRootVMNode.LaunchesEvent(launches, LaunchRootVMNode.LaunchesEvent.Type.REMOVED));
    }

    public void launchesChanged(ILaunch[] launches) {
        this.handleLaunchesEvent(new LaunchRootVMNode.LaunchesEvent(launches, LaunchRootVMNode.LaunchesEvent.Type.CHANGED));
    }

    public void launchesTerminated(ILaunch[] launches) {
        this.handleLaunchesEvent(new LaunchRootVMNode.LaunchesEvent(launches, LaunchRootVMNode.LaunchesEvent.Type.TERMINATED));
    }

    private void handleLaunchesEvent(final LaunchRootVMNode.LaunchesEvent event) {
        if (this.isDisposed()) {
            return;
        }
        try {
            this.getExecutor().execute(new Runnable(){

                public void run() {
                    if (AbstractLaunchVMProvider.this.isDisposed()) {
                        return;
                    }
                    IRootVMNode rootLayoutNode = AbstractLaunchVMProvider.this.getRootVMNode();
                    if (rootLayoutNode != null && rootLayoutNode.getDeltaFlags((Object)event) != 0) {
                        AbstractLaunchVMProvider.this.handleEvent(event);
                    }
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    protected boolean canSkipHandlingEvent(Object newEvent, Object eventToSkip) {
        IDMContext eventToSkipDmc;
        IDMContext newEventDmc;
        if (newEvent instanceof IRunControl.IStartedDMEvent || newEvent instanceof IRunControl.IExitedDMEvent) {
            return false;
        }
        return newEvent instanceof IRunControl.ISuspendedDMEvent && eventToSkip instanceof IDMEvent && ((newEventDmc = ((IDMEvent)newEvent).getDMContext()).equals(eventToSkipDmc = ((IDMEvent)eventToSkip).getDMContext()) || DMContexts.isAncestorOf((IDMContext)eventToSkipDmc, (IDMContext)newEventDmc));
    }

    protected void handlePropertyChanged(IPreferenceStore store, final PropertyChangeEvent event) {
        String property = event.getProperty();
        if ("stackFrameLimitEnable".equals(property) || "stackFrameLimit".equals(property)) {
            if (store.getBoolean("stackFrameLimitEnable")) {
                this.getPresentationContext().setProperty("stackFrameLimit", (Object)store.getInt("stackFrameLimit"));
            } else {
                this.getPresentationContext().setProperty("stackFrameLimit", null);
            }
            this.getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    AbstractLaunchVMProvider.this.handleEvent(event);
                }
            });
        }
    }
}

