/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.mi.service.command.output;

import org.eclipse.dd.dsf.debug.service.command.ICommand;
import org.eclipse.dd.dsf.debug.service.command.ICommandResult;
import org.eclipse.dd.mi.service.command.output.MIConst;
import org.eclipse.dd.mi.service.command.output.MIOutput;
import org.eclipse.dd.mi.service.command.output.MIResult;
import org.eclipse.dd.mi.service.command.output.MIResultRecord;
import org.eclipse.dd.mi.service.command.output.MIValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MIInfo
implements ICommandResult {
    private final MIOutput miOutput;

    public MIInfo(MIOutput record) {
        this.miOutput = record;
    }

    public MIOutput getMIOutput() {
        return this.miOutput;
    }

    public boolean isDone() {
        return this.isResultClass("done");
    }

    public boolean isRunning() {
        return this.isResultClass("running");
    }

    public boolean isConnected() {
        return this.isResultClass("connected");
    }

    public boolean isError() {
        return this.isResultClass("error");
    }

    public boolean isExit() {
        return this.isResultClass("exit");
    }

    public String toString() {
        if (this.miOutput != null) {
            return this.miOutput.toString();
        }
        return "";
    }

    boolean isResultClass(String rc) {
        MIResultRecord rr;
        if (this.miOutput != null && (rr = this.miOutput.getMIResultRecord()) != null) {
            String clazz = rr.getResultClass();
            return clazz.equals(rc);
        }
        return false;
    }

    public String getErrorMsg() {
        MIResultRecord rr;
        if (this.miOutput != null && (rr = this.miOutput.getMIResultRecord()) != null) {
            MIResult[] results = rr.getMIResults();
            for (int i = 0; i < results.length; ++i) {
                MIValue value;
                String var = results[i].getVariable();
                if (!var.equals("msg") || !((value = results[i].getMIValue()) instanceof MIConst)) continue;
                String s = ((MIConst)value).getCString();
                return s;
            }
        }
        return "";
    }

    public <V extends ICommandResult> V getSubsetResult(ICommand<V> command) {
        return null;
    }
}

