/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.modules.detail;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import org.eclipse.cdt.debug.ui.ICDebugUIConstants;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.Query;
import org.eclipse.dd.dsf.datamodel.DMContexts;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.modules.detail.ModulesAbstractDetailPane;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.modules.detail.ModulesMessages;
import org.eclipse.dd.dsf.debug.internal.ui.DsfDebugUIPlugin;
import org.eclipse.dd.dsf.debug.internal.ui.viewmodel.detailsupport.MessagesForDetailPane;
import org.eclipse.dd.dsf.debug.internal.ui.viewmodel.detailsupport.TextViewerAction;
import org.eclipse.dd.dsf.debug.service.IModules;
import org.eclipse.dd.dsf.service.DsfServicesTracker;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.progress.WorkbenchJob;

public class ModuleDetailPane
extends ModulesAbstractDetailPane
implements IAdaptable,
IPropertyChangeListener {
    protected static final String DETAIL_COPY_ACTION = ActionFactory.COPY.getId() + ".SourceDetailPane";
    protected static final String DETAIL_SELECT_ALL_ACTION = IDebugView.SELECT_ALL_ACTION + ".SourceDetailPane";
    public static final String ID = "ModuleDetailPane";
    public static final String NAME = "Module Viewer";
    public static final String DESCRIPTION = "A detail pane that is based on a source viewer.  Displays as text and has actions for assigning values, content assist and text modifications.";
    private SourceViewer fSourceViewer;
    private DetailJob fDetailJob = null;
    private IDocument fDetailDocument;

    public Control createControl(Composite parent) {
        this.createSourceViewer(parent);
        if (this.isInView()) {
            this.createViewSpecificComponents();
            this.createActions();
            DsfDebugUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
            JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)this);
        }
        return this.fSourceViewer.getControl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void display(IStructuredSelection selection) {
        if (selection == null) {
            this.clearSourceViewer();
            return;
        }
        if (this.isInView()) {
            this.fSourceViewer.setEditable(true);
        }
        if (selection.isEmpty()) {
            this.clearSourceViewer();
            return;
        }
        ModuleDetailPane moduleDetailPane = this;
        synchronized (moduleDetailPane) {
            if (this.fDetailJob != null) {
                this.fDetailJob.cancel();
            }
            this.fDetailJob = new DetailJob(selection.getFirstElement());
            this.fDetailJob.schedule();
        }
    }

    protected void clearSourceViewer() {
        if (this.fDetailJob != null) {
            this.fDetailJob.cancel();
        }
        this.fDetailDocument.set("");
        this.fSourceViewer.setEditable(false);
    }

    public void dispose() {
        super.dispose();
        if (this.fDetailJob != null) {
            this.fDetailJob.cancel();
        }
        if (this.fSourceViewer != null && this.fSourceViewer.getControl() != null) {
            this.fSourceViewer.getControl().dispose();
        }
        if (this.isInView()) {
            DsfDebugUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
            JFaceResources.getFontRegistry().removeListener((IPropertyChangeListener)this);
        }
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public String getID() {
        return ID;
    }

    public String getName() {
        return NAME;
    }

    public boolean setFocus() {
        if (this.fSourceViewer != null) {
            this.fSourceViewer.getTextWidget().setFocus();
            return true;
        }
        return false;
    }

    public Object getAdapter(Class adapter) {
        if (ITextViewer.class.equals((Object)adapter)) {
            return this.fSourceViewer;
        }
        return null;
    }

    public void propertyChange(PropertyChangeEvent event) {
        String propertyName = event.getProperty();
        if (propertyName.equals("org.eclipse.dd.dsf.debug.uiDetailPaneFont")) {
            this.fSourceViewer.getTextWidget().setFont(JFaceResources.getFont((String)"org.eclipse.dd.dsf.debug.uiDetailPaneFont"));
        }
    }

    private void createSourceViewer(Composite parent) {
        this.fSourceViewer = new SourceViewer(parent, null, 768);
        this.fSourceViewer.setDocument(this.getDetailDocument());
        this.fSourceViewer.getTextWidget().setFont(JFaceResources.getFont((String)"org.eclipse.dd.dsf.debug.uiDetailPaneFont"));
        this.fSourceViewer.getTextWidget().setWordWrap(DsfDebugUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.dd.dsf.debug.ui.detail_pane_word_wrap"));
        this.fSourceViewer.setEditable(false);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.fSourceViewer.getTextWidget(), "org.eclipse.debug.ui.detail_pane_context");
        Control control = this.fSourceViewer.getControl();
        GridData gd = new GridData(1808);
        control.setLayoutData((Object)gd);
    }

    protected IDocument getDetailDocument() {
        if (this.fDetailDocument == null) {
            this.fDetailDocument = new Document();
        }
        return this.fDetailDocument;
    }

    private void createViewSpecificComponents() {
        this.getDetailDocument().addDocumentListener(new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                ModuleDetailPane.this.updateSelectionDependentActions();
            }
        });
        this.fSourceViewer.getSelectionProvider().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ModuleDetailPane.this.updateSelectionDependentActions();
            }
        });
        this.fSourceViewer.getControl().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ModuleDetailPane.this.getViewSite().setSelectionProvider(ModuleDetailPane.this.fSourceViewer.getSelectionProvider());
                ModuleDetailPane.this.setGlobalAction(IDebugView.SELECT_ALL_ACTION, ModuleDetailPane.this.getAction(DETAIL_SELECT_ALL_ACTION));
                ModuleDetailPane.this.setGlobalAction(IDebugView.COPY_ACTION, ModuleDetailPane.this.getAction(DETAIL_COPY_ACTION));
                ModuleDetailPane.this.getViewSite().getActionBars().updateActionBars();
            }

            public void focusLost(FocusEvent e) {
                ModuleDetailPane.this.getViewSite().setSelectionProvider(null);
                ModuleDetailPane.this.setGlobalAction(IDebugView.SELECT_ALL_ACTION, null);
                ModuleDetailPane.this.setGlobalAction(IDebugView.COPY_ACTION, null);
                ModuleDetailPane.this.getViewSite().getActionBars().updateActionBars();
            }
        });
        this.createDetailContextMenu((Control)this.fSourceViewer.getTextWidget());
    }

    protected void createDetailContextMenu(Control menuControl) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                ModuleDetailPane.this.fillDetailContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(menuControl);
        menuControl.setMenu(menu);
        this.getViewSite().registerContextMenu(ICDebugUIConstants.MODULES_VIEW_DETAIL_ID, menuMgr, this.fSourceViewer.getSelectionProvider());
    }

    protected void fillDetailContextMenu(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("modulesGroup"));
        menu.add((IContributionItem)new Separator());
        menu.add(this.getAction(DETAIL_COPY_ACTION));
        menu.add(this.getAction(DETAIL_SELECT_ALL_ACTION));
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new Separator("additions"));
    }

    private void createActions() {
        TextViewerAction textAction = new TextViewerAction((ITextViewer)this.fSourceViewer, 7);
        textAction.configureAction(MessagesForDetailPane.DetailPane_Select_All, "", "");
        textAction.setActionDefinitionId("org.eclipse.ui.edit.selectAll");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)textAction, "org.eclipse.debug.ui.detail_pane_select_all_action_context");
        this.setAction(DETAIL_SELECT_ALL_ACTION, (IAction)textAction);
        textAction = new TextViewerAction((ITextViewer)this.fSourceViewer, 4);
        textAction.configureAction(MessagesForDetailPane.DetailPane_Copy, "", "");
        textAction.setActionDefinitionId("org.eclipse.ui.edit.copy");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)textAction, "org.eclipse.debug.ui.detail_pane_copy_action_context");
        this.setAction(DETAIL_COPY_ACTION, (IAction)textAction);
        this.setSelectionDependantAction(DETAIL_COPY_ACTION);
        this.updateSelectionDependentActions();
    }

    private String getModuleDetail(IModules.IModuleDMData module) {
        StringBuffer sb = new StringBuffer();
        String type = null;
        type = ModulesMessages.getString("ModulesView.SharedLibrary");
        if (type != null) {
            sb.append(ModulesMessages.getString("ModulesView.Type"));
            sb.append(type);
            sb.append('\n');
        }
        sb.append(ModulesMessages.getString("ModulesView.Symbols"));
        sb.append(module.isSymbolsLoaded() ? ModulesMessages.getString("ModulesView.Loaded") : ModulesMessages.getString("ModulesView.NotLoaded"));
        sb.append('\n');
        sb.append(ModulesMessages.getString("ModulesView.SymbolsFile"));
        sb.append(module.getFile());
        sb.append('\n');
        String baseAddress = module.getBaseAddress();
        sb.append(ModulesMessages.getString("ModulesView.BaseAddress"));
        sb.append(baseAddress);
        sb.append('\n');
        long size = module.getSize();
        if (size > 0L) {
            sb.append(ModulesMessages.getString("ModulesView.Size"));
            sb.append(size);
            sb.append('\n');
        }
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class GetModuleDetailsQuery
    extends Query<Object> {
        private IModules.IModuleDMContext fDmc;

        public GetModuleDetailsQuery(IModules.IModuleDMContext dmc) {
            this.fDmc = dmc;
        }

        protected void execute(final DataRequestMonitor<Object> rm) {
            final DsfSession session = DsfSession.getSession((String)this.fDmc.getSessionId());
            if (session == null) {
                this.cancel(false);
                return;
            }
            DsfServicesTracker tracker = new DsfServicesTracker(DsfDebugUIPlugin.getBundleContext(), this.fDmc.getSessionId());
            IModules service = (IModules)tracker.getService(IModules.class);
            tracker.dispose();
            if (service == null) {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.debug.ui", 10001, "Service unavailable", null));
                rm.done();
                return;
            }
            service.getModuleData(this.fDmc, (DataRequestMonitor)new DataRequestMonitor<IModules.IModuleDMData>((Executor)session.getExecutor(), rm){

                protected void handleCompleted() {
                    if (!DsfSession.isSessionActive((String)session.getId())) {
                        GetModuleDetailsQuery.this.cancel(false);
                        return;
                    }
                    super.handleCompleted();
                }

                protected void handleSuccess() {
                    rm.setData(this.getData());
                    rm.done();
                }
            });
        }
    }

    class DetailJob
    extends Job {
        private Object fElement;
        private IProgressMonitor fMonitor;

        public DetailJob(Object element) {
            super("compute module details");
            this.setSystem(true);
            this.fElement = element;
        }

        protected IStatus run(IProgressMonitor monitor) {
            this.fMonitor = monitor;
            IModules.IModuleDMContext dmc = null;
            if (this.fElement instanceof IDMVMContext) {
                IDMContext vmcdmc = ((IDMVMContext)this.fElement).getDMContext();
                dmc = (IModules.IModuleDMContext)DMContexts.getAncestorOfType((IDMContext)vmcdmc, IModules.IModuleDMContext.class);
            }
            if (dmc == null) {
                return Status.OK_STATUS;
            }
            DsfSession session = DsfSession.getSession((String)dmc.getSessionId());
            if (session == null) {
                return Status.OK_STATUS;
            }
            GetModuleDetailsQuery query = new GetModuleDetailsQuery(dmc);
            session.getExecutor().execute((Runnable)((Object)query));
            try {
                this.detailComputed(ModuleDetailPane.this.getModuleDetail((IModules.IModuleDMData)query.get()));
            }
            catch (InterruptedException e) {
                assert (false);
                return Status.OK_STATUS;
            }
            catch (ExecutionException e) {
                return Status.OK_STATUS;
            }
            return Status.OK_STATUS;
        }

        private void detailComputed(final String result) {
            if (!this.fMonitor.isCanceled()) {
                WorkbenchJob setDetail = new WorkbenchJob("set details"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        if (!DetailJob.this.fMonitor.isCanceled()) {
                            ModuleDetailPane.this.getDetailDocument().set(result);
                        }
                        return Status.OK_STATUS;
                    }
                };
                setDetail.setSystem(true);
                setDetail.schedule();
            }
        }
    }
}

