/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.gdb.internal.ui.viewmodel.launch;

import java.util.concurrent.RejectedExecutionException;
import org.eclipse.dd.dsf.concurrent.DsfRunnable;
import org.eclipse.dd.dsf.concurrent.ThreadSafe;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.launch.AbstractLaunchVMProvider;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.launch.LaunchRootVMNode;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.launch.StackFramesVMNode;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.launch.StandardProcessVMNode;
import org.eclipse.dd.dsf.debug.service.ICachingService;
import org.eclipse.dd.dsf.debug.service.IProcesses;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.debug.service.IStack;
import org.eclipse.dd.dsf.debug.service.command.ICommandControlService;
import org.eclipse.dd.dsf.service.DsfServicesTracker;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.dsf.ui.viewmodel.AbstractVMAdapter;
import org.eclipse.dd.dsf.ui.viewmodel.AbstractVMProvider;
import org.eclipse.dd.dsf.ui.viewmodel.IRootVMNode;
import org.eclipse.dd.dsf.ui.viewmodel.IVMNode;
import org.eclipse.dd.dsf.ui.viewmodel.datamodel.AbstractDMVMProvider;
import org.eclipse.dd.gdb.internal.ui.GdbUIPlugin;
import org.eclipse.dd.gdb.internal.ui.viewmodel.launch.ContainerVMNode;
import org.eclipse.dd.gdb.internal.ui.viewmodel.launch.ThreadVMNode;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;

public class LaunchVMProvider
extends AbstractLaunchVMProvider
implements IDebugEventSetListener,
ILaunchesListener2 {
    @ThreadSafe
    public LaunchVMProvider(AbstractVMAdapter adapter, IPresentationContext presentationContext, DsfSession session) {
        super(adapter, presentationContext, session);
        LaunchRootVMNode launchNode = new LaunchRootVMNode((AbstractVMProvider)this);
        this.setRootNode((IRootVMNode)launchNode);
        ContainerVMNode containerNode = new ContainerVMNode((AbstractDMVMProvider)this, this.getSession());
        StandardProcessVMNode processesNode = new StandardProcessVMNode((AbstractVMProvider)this);
        this.addChildNodes((IVMNode)launchNode, new IVMNode[]{containerNode, processesNode});
        ThreadVMNode threadsNode = new ThreadVMNode((AbstractDMVMProvider)this, this.getSession());
        this.addChildNodes((IVMNode)containerNode, new IVMNode[]{threadsNode});
        StackFramesVMNode stackFramesNode = new StackFramesVMNode((AbstractDMVMProvider)this, this.getSession());
        this.addChildNodes((IVMNode)threadsNode, new IVMNode[]{stackFramesNode});
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)this);
    }

    public void dispose() {
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchesListener)this);
        super.dispose();
    }

    protected boolean canSkipHandlingEvent(Object newEvent, Object eventToSkip) {
        if (eventToSkip instanceof ICommandControlService.ICommandControlInitializedDMEvent || eventToSkip instanceof ICommandControlService.ICommandControlShutdownDMEvent) {
            return false;
        }
        return super.canSkipHandlingEvent(newEvent, eventToSkip);
    }

    public void refresh() {
        super.refresh();
        try {
            this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    IRunControl runControlService;
                    IStack stackService;
                    DsfServicesTracker tracker = new DsfServicesTracker(GdbUIPlugin.getBundleContext(), LaunchVMProvider.this.getSession().getId());
                    IProcesses processesService = (IProcesses)tracker.getService(IProcesses.class);
                    if (processesService instanceof ICachingService) {
                        ((ICachingService)processesService).flushCache(null);
                    }
                    if ((stackService = (IStack)tracker.getService(IStack.class)) instanceof ICachingService) {
                        ((ICachingService)stackService).flushCache(null);
                    }
                    if ((runControlService = (IRunControl)tracker.getService(IRunControl.class)) instanceof ICachingService) {
                        ((ICachingService)runControlService).flushCache(null);
                    }
                    tracker.dispose();
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }
}

