/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.gdb.internal.ui.viewmodel.launch;

import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DsfRunnable;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.launch.AbstractContainerVMNode;
import org.eclipse.dd.dsf.debug.service.IProcesses;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.debug.service.command.ICommandControlService;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.dsf.ui.concurrent.ViewerDataRequestMonitor;
import org.eclipse.dd.dsf.ui.viewmodel.VMDelta;
import org.eclipse.dd.dsf.ui.viewmodel.datamodel.AbstractDMVMProvider;
import org.eclipse.dd.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementCompareRequest;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementMementoProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementMementoRequest;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.ui.IMemento;

public class ContainerVMNode
extends AbstractContainerVMNode
implements IElementMementoProvider {
    private final String MEMENTO_NAME = "CONTAINER_MEMENTO_NAME";

    public ContainerVMNode(AbstractDMVMProvider provider, DsfSession session) {
        super(provider, session);
    }

    public String toString() {
        return "ContainerVMNode(" + this.getSession().getId() + ")";
    }

    protected void updateElementsInSessionThread(final IChildrenUpdate update) {
        IProcesses processService = (IProcesses)this.getServicesTracker().getService(IProcesses.class);
        ICommandControlService controlService = (ICommandControlService)this.getServicesTracker().getService(ICommandControlService.class);
        if (processService == null || controlService == null) {
            this.handleFailedUpdate((IViewerUpdate)update);
            return;
        }
        processService.getProcessesBeingDebugged((IDMContext)controlService.getContext(), (DataRequestMonitor)new ViewerDataRequestMonitor<IDMContext[]>(this.getExecutor(), (IViewerUpdate)update){

            public void handleCompleted() {
                if (!this.isSuccess()) {
                    ContainerVMNode.this.handleFailedUpdate((IViewerUpdate)update);
                    return;
                }
                if (this.getData() != null) {
                    ContainerVMNode.this.fillUpdateWithVMCs(update, (IDMContext[])this.getData());
                }
                update.done();
            }
        });
    }

    protected void updateLabelInSessionThread(final ILabelUpdate update) {
        IProcesses processService = (IProcesses)this.getServicesTracker().getService(IProcesses.class);
        IRunControl runControl = (IRunControl)this.getServicesTracker().getService(IRunControl.class);
        if (processService == null || runControl == null) {
            this.handleFailedUpdate((IViewerUpdate)update);
            return;
        }
        IProcesses.IProcessDMContext procDmc = (IProcesses.IProcessDMContext)this.findDmcInPath(update.getViewerInput(), update.getElementPath(), IProcesses.IProcessDMContext.class);
        IRunControl.IContainerDMContext contDmc = (IRunControl.IContainerDMContext)this.findDmcInPath(update.getViewerInput(), update.getElementPath(), IRunControl.IContainerDMContext.class);
        String imageKey = null;
        imageKey = runControl.isSuspended((IRunControl.IExecutionDMContext)contDmc) ? "IMG_OBJS_THREAD_SUSPENDED" : "IMG_OBJS_THREAD_RUNNING";
        update.setImageDescriptor(DebugUITools.getImageDescriptor((String)imageKey), 0);
        processService.getExecutionData((IProcesses.IThreadDMContext)procDmc, (DataRequestMonitor)new ViewerDataRequestMonitor<IProcesses.IThreadDMData>(this.getExecutor(), (IViewerUpdate)update){

            public void handleCompleted() {
                if (!this.isSuccess()) {
                    update.setLabel("<unavailable>", 0);
                    update.done();
                    return;
                }
                StringBuilder builder = new StringBuilder();
                builder.append(((IProcesses.IThreadDMData)this.getData()).getName());
                if (((IProcesses.IThreadDMData)this.getData()).getId() != null && ((IProcesses.IThreadDMData)this.getData()).getId().length() > 0) {
                    builder.append("[" + ((IProcesses.IThreadDMData)this.getData()).getId() + "]");
                }
                update.setLabel(builder.toString(), 0);
                update.done();
            }
        });
    }

    public int getDeltaFlags(Object e) {
        if (e instanceof ICommandControlService.ICommandControlShutdownDMEvent) {
            return 1024;
        }
        return super.getDeltaFlags(e);
    }

    public void buildDelta(Object e, VMDelta parentDelta, int nodeOffset, RequestMonitor requestMonitor) {
        if (!(e instanceof ICommandControlService.ICommandControlShutdownDMEvent)) {
            super.buildDelta(e, parentDelta, nodeOffset, requestMonitor);
            return;
        }
        parentDelta.setFlags(parentDelta.getFlags() | 0x400);
        requestMonitor.done();
    }

    public void compareElements(IElementCompareRequest[] requests) {
        for (final IElementCompareRequest request : requests) {
            IProcesses.IProcessDMContext procDmc;
            IDMContext dmc;
            Object element = request.getElement();
            final IMemento memento = request.getMemento();
            String mementoName = memento.getString("CONTAINER_MEMENTO_NAME");
            if (mementoName != null && element instanceof IDMVMContext && (dmc = ((IDMVMContext)element).getDMContext()) instanceof IRunControl.IContainerDMContext && (procDmc = (IProcesses.IProcessDMContext)this.findDmcInPath(request.getViewerInput(), request.getElementPath(), IProcesses.IProcessDMContext.class)) != null) {
                try {
                    this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

                        public void run() {
                            IProcesses processService = (IProcesses)ContainerVMNode.this.getServicesTracker().getService(IProcesses.class);
                            if (processService != null) {
                                processService.getExecutionData((IProcesses.IThreadDMContext)procDmc, (DataRequestMonitor)new ViewerDataRequestMonitor<IProcesses.IThreadDMData>((Executor)processService.getExecutor(), (IViewerUpdate)request){

                                    protected void handleCompleted() {
                                        if (this.getStatus().isOK()) {
                                            memento.putString("CONTAINER_MEMENTO_NAME", "Container." + ((IProcesses.IThreadDMData)this.getData()).getName() + ((IProcesses.IThreadDMData)this.getData()).getId());
                                        }
                                        request.done();
                                    }
                                });
                            } else {
                                request.done();
                            }
                        }
                    });
                }
                catch (RejectedExecutionException e) {
                    request.done();
                }
                continue;
            }
            request.done();
        }
    }

    public void encodeElements(IElementMementoRequest[] requests) {
        for (final IElementMementoRequest request : requests) {
            IProcesses.IProcessDMContext procDmc;
            IDMContext dmc;
            Object element = request.getElement();
            final IMemento memento = request.getMemento();
            if (element instanceof IDMVMContext && (dmc = ((IDMVMContext)element).getDMContext()) instanceof IRunControl.IContainerDMContext && (procDmc = (IProcesses.IProcessDMContext)this.findDmcInPath(request.getViewerInput(), request.getElementPath(), IProcesses.IProcessDMContext.class)) != null) {
                try {
                    this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

                        public void run() {
                            IProcesses processService = (IProcesses)ContainerVMNode.this.getServicesTracker().getService(IProcesses.class);
                            if (processService != null) {
                                processService.getExecutionData((IProcesses.IThreadDMContext)procDmc, (DataRequestMonitor)new ViewerDataRequestMonitor<IProcesses.IThreadDMData>((Executor)processService.getExecutor(), (IViewerUpdate)request){

                                    protected void handleCompleted() {
                                        if (this.getStatus().isOK()) {
                                            memento.putString("CONTAINER_MEMENTO_NAME", "Container." + ((IProcesses.IThreadDMData)this.getData()).getName() + ((IProcesses.IThreadDMData)this.getData()).getId());
                                        }
                                        request.done();
                                    }
                                });
                            } else {
                                request.done();
                            }
                        }
                    });
                }
                catch (RejectedExecutionException e) {
                    request.done();
                }
                continue;
            }
            request.done();
        }
    }
}

