/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.datamodel;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.dd.dsf.concurrent.ThreadSafe;
import org.eclipse.dd.dsf.datamodel.IDMContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DMContexts {
    public static final IDMContext[] EMPTY_CONTEXTS_ARRAY = new IDMContext[0];

    @ThreadSafe
    public static <V extends IDMContext> V getAncestorOfType(IDMContext ctx, Class<V> ancestorType) {
        if (ctx == null) {
            return null;
        }
        if (ancestorType.isAssignableFrom(ctx.getClass())) {
            return (V)ctx;
        }
        LinkedHashSet<IDMContext> nodes = new LinkedHashSet<IDMContext>();
        nodes.addAll(Arrays.asList(ctx.getParents()));
        while (!nodes.isEmpty()) {
            LinkedHashSet<IDMContext> parents = nodes;
            nodes = new LinkedHashSet();
            for (IDMContext parent : parents) {
                if (ancestorType.isAssignableFrom(parent.getClass())) {
                    return (V)parent;
                }
                nodes.addAll(Arrays.asList(parent.getParents()));
            }
        }
        return null;
    }

    @ThreadSafe
    public static <V extends IDMContext> V[] getAllAncestorsOfType(IDMContext ctx, Class<V> ancestorType) {
        if (ctx == null) {
            return null;
        }
        LinkedHashSet<IDMContext> requestedAncestors = new LinkedHashSet<IDMContext>();
        LinkedHashSet<IDMContext> nodes = new LinkedHashSet<IDMContext>();
        nodes.add(ctx);
        while (!nodes.isEmpty()) {
            LinkedHashSet<IDMContext> parents = nodes;
            nodes = new LinkedHashSet();
            for (IDMContext parent : parents) {
                if (ancestorType.isAssignableFrom(parent.getClass())) {
                    requestedAncestors.add(parent);
                }
                nodes.addAll(Arrays.asList(parent.getParents()));
            }
        }
        if (requestedAncestors.isEmpty()) {
            return null;
        }
        IDMContext[] v = (IDMContext[])Array.newInstance(ancestorType, 0);
        return requestedAncestors.toArray(v);
    }

    @ThreadSafe
    public static boolean isAncestorOf(IDMContext dmc, IDMContext potentialAncestor) {
        for (IDMContext parentDmc : dmc.getParents()) {
            if (!potentialAncestor.equals(parentDmc)) continue;
            return true;
        }
        for (IDMContext parentDmc : dmc.getParents()) {
            if (!DMContexts.isAncestorOf(parentDmc, potentialAncestor)) continue;
            return true;
        }
        return false;
    }

    @ThreadSafe
    public static List<IDMContext> toList(IDMContext dmc) {
        ArrayList<IDMContext> list = new ArrayList<IDMContext>();
        list.add(dmc);
        for (IDMContext parentDmc : dmc.getParents()) {
            list.addAll(DMContexts.toList(parentDmc));
        }
        return list;
    }
}

