/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.mi.service.command.output;

import org.eclipse.dd.mi.service.command.output.MIConst;
import org.eclipse.dd.mi.service.command.output.MIInfo;
import org.eclipse.dd.mi.service.command.output.MIList;
import org.eclipse.dd.mi.service.command.output.MIOutput;
import org.eclipse.dd.mi.service.command.output.MIResult;
import org.eclipse.dd.mi.service.command.output.MIResultRecord;
import org.eclipse.dd.mi.service.command.output.MIThread;
import org.eclipse.dd.mi.service.command.output.MITuple;
import org.eclipse.dd.mi.service.command.output.MIValue;

public class MIThreadInfoInfo
extends MIInfo {
    private String fCurrentThread = null;
    private MIThread[] fThreadList = null;

    public MIThreadInfoInfo(MIOutput out) {
        super(out);
        this.parse();
    }

    public String getCurrentThread() {
        return this.fCurrentThread;
    }

    public MIThread[] getThreadList() {
        return this.fThreadList;
    }

    private void parse() {
        MIOutput out;
        MIResultRecord rr;
        if (this.isDone() && (rr = (out = this.getMIOutput()).getMIResultRecord()) != null) {
            MIResult[] results = rr.getMIResults();
            for (int i = 0; i < results.length; ++i) {
                MIValue value;
                String var = results[i].getVariable();
                if (var.equals("threads")) {
                    MIValue val = results[i].getMIValue();
                    if (!(val instanceof MIList)) continue;
                    this.parseThreads((MIList)val);
                    continue;
                }
                if (!var.equals("current-thread-id") || !((value = results[i].getMIValue()) instanceof MIConst)) continue;
                this.fCurrentThread = ((MIConst)value).getCString().trim();
            }
        }
        if (this.fThreadList == null) {
            this.fThreadList = new MIThread[0];
        }
    }

    private void parseThreads(MIList list) {
        MIValue[] values = list.getMIValues();
        this.fThreadList = new MIThread[values.length];
        for (int i = 0; i < values.length; ++i) {
            this.fThreadList[i] = MIThread.parse((MITuple)values[i]);
        }
    }
}

