/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.editor.ui.dialog;

import java.util.List;
import org.eclipse.dd.ipxact.editor.core.document.SpiritBusDefinitionDocument;
import org.eclipse.dd.ipxact.editor.core.document.SpiritComponentDocument;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDesignDocument;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDocument;
import org.eclipse.dd.ipxact.editor.core.library.FileDetails;
import org.eclipse.dd.ipxact.editor.core.library.SpiritResourceLibrary;
import org.eclipse.dd.ipxact.editor.ui.Messages;
import org.eclipse.dd.ipxact.editor.ui.SpiritUiPlugin;
import org.eclipse.dd.ipxact.editor.ui.utils.AutoResizeTableLayout;
import org.eclipse.dd.ipxact.editor.ui.utils.DialogSettingsHelper;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.dialogs.ListDialog;

public class FileListDialog
extends ListDialog {
    private final String documentType;

    public FileListDialog(Shell parent, String title, String message, String documentType) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        this.setWidthInChars(150);
        this.documentType = documentType;
        this.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
        this.setLabelProvider((ILabelProvider)new TableLabelProvider());
        FileListDialog.setDefaultImage((Image)SpiritUiPlugin.getImage("spirit.gif"));
        this.setMessage(message);
        this.setTitle(title);
        this.setDialogBoundsSettings(DialogSettingsHelper.getSection("FileListDialog"), this.getDialogBoundsStrategy());
    }

    protected Control createDialogArea(Composite container) {
        Control area = super.createDialogArea(container);
        TableViewer tableViewer = this.getTableViewer();
        Table table = tableViewer.getTable();
        AutoResizeTableLayout layout = new AutoResizeTableLayout(table);
        table.setLayout((Layout)layout);
        TableColumn tableColumn = new TableColumn(table, 16384);
        tableColumn.setText("VLNV");
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(300));
        tableColumn = new TableColumn(table, 16384);
        tableColumn.setText(Messages.FileListDialog_File);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(600));
        tableViewer.setComparator((ViewerComparator)new TableViewerComparator(tableViewer));
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        tableViewer.setInput((Object)this.buildInput());
        tableViewer.addFilter((ViewerFilter)new DocumentTypeTableFilter(this.documentType));
        return area;
    }

    private FileDetails[] buildInput() {
        List fileDetails = SpiritResourceLibrary.getDefault().getFileDetails();
        return fileDetails.toArray(new FileDetails[fileDetails.size()]);
    }

    protected Control createButtonBar(Composite parent) {
        Control bar = super.createButtonBar(parent);
        this.setOkButtonEnabled(false);
        this.getTableViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                FileListDialog.this.setOkButtonEnabled(!event.getSelection().isEmpty());
            }
        });
        return bar;
    }

    void setOkButtonEnabled(boolean enabled) {
        this.getButton(0).setEnabled(enabled);
    }

    class TableViewerComparator
    extends ViewerComparator {
        boolean isSortedByVlnv = true;
        boolean isReversed = false;

        public TableViewerComparator(final TableViewer tableViewer) {
            Table table = tableViewer.getTable();
            int columns = table.getColumnCount();
            for (int index = 0; index < columns; ++index) {
                table.getColumn(index).addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        boolean isColumn0;
                        boolean bl = isColumn0 = tableViewer.getTable().getColumn(0) == e.getSource();
                        TableViewerComparator.this.isReversed = isColumn0 == TableViewerComparator.this.isSortedByVlnv ? !TableViewerComparator.this.isReversed : false;
                        TableViewerComparator.this.isSortedByVlnv = isColumn0;
                        tableViewer.refresh();
                    }
                });
            }
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            String s2;
            String s1;
            if (this.isSortedByVlnv) {
                s1 = ((FileDetails)e1).getVlnv().toString();
                s2 = ((FileDetails)e2).getVlnv().toString();
            } else {
                s1 = ((FileDetails)e1).getFile().getPath();
                s2 = ((FileDetails)e2).getFile().getPath();
            }
            int result = s1.compareToIgnoreCase(s2);
            if (this.isReversed) {
                result = -result;
            }
            return result;
        }
    }

    class DocumentTypeTableFilter
    extends ViewerFilter {
        private String rootTagName;

        public DocumentTypeTableFilter(String rootTagName) {
            this.rootTagName = rootTagName;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            FileDetails fileDetails = (FileDetails)element;
            SpiritDocument spiritDocument = fileDetails.getSpiritDocument();
            return spiritDocument.getRootTagName().equals(this.rootTagName);
        }
    }

    class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        TableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                SpiritDocument doc = ((FileDetails)element).getSpiritDocument();
                String imageKey = null;
                imageKey = doc instanceof SpiritBusDefinitionDocument ? "spirit_bus_def.gif" : (doc instanceof SpiritComponentDocument ? "spirit_component.gif" : (doc instanceof SpiritDesignDocument ? "spirit_design.gif" : "spirit.gif"));
                return SpiritUiPlugin.getImage(imageKey);
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            FileDetails fileDetails = (FileDetails)element;
            switch (columnIndex) {
                case 0: {
                    return fileDetails.getVlnv().toString();
                }
                case 1: {
                    return fileDetails.getFile().getPath();
                }
            }
            return Messages.FileListDialog_InvalidData + columnIndex;
        }
    }
}

