/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.editor.core.spiritnodes;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.AddressBlock;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.ConflictingWidthsException;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.MemoryMapElement;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bank
extends MemoryMapElement {
    public Bank(Element e) {
        super(e);
    }

    @Override
    public long getWidth() throws ConflictingWidthsException {
        if (this.getSpiritAttribute("bankAlignment").equals("parallel")) {
            long width = 0L;
            for (MemoryMapElement child : this.getChildren()) {
                width += child.getWidth();
            }
            return width;
        }
        long width = -1L;
        for (MemoryMapElement child : this.getChildren()) {
            long childWidth = child.getWidth();
            if (width != -1L && childWidth != width) {
                throw new ConflictingWidthsException(child, width, childWidth);
            }
            width = childWidth;
        }
        return width;
    }

    private List<MemoryMapElement> getChildren() {
        ArrayList<MemoryMapElement> result = new ArrayList<MemoryMapElement>();
        for (Bank bank : this.getChildren("bank", Bank.class)) {
            result.add(bank);
        }
        for (AddressBlock addressBlock : this.getChildren("addressBlock", AddressBlock.class)) {
            result.add(addressBlock);
        }
        return result;
    }
}

