/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.tests.gdb;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.debug.service.IBreakpoints;
import org.eclipse.dd.dsf.debug.service.IExpressions;
import org.eclipse.dd.dsf.debug.service.IFormattedValues;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.debug.service.IStack;
import org.eclipse.dd.dsf.debug.service.command.ICommandControlService;
import org.eclipse.dd.dsf.service.DsfServiceEventHandler;
import org.eclipse.dd.dsf.service.DsfServicesTracker;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.mi.service.MIBreakpointDMData;
import org.eclipse.dd.mi.service.MIBreakpoints;
import org.eclipse.dd.mi.service.MIRunControl;
import org.eclipse.dd.mi.service.command.events.MIBreakpointHitEvent;
import org.eclipse.dd.mi.service.command.events.MIStoppedEvent;
import org.eclipse.dd.mi.service.command.events.MIWatchpointScopeEvent;
import org.eclipse.dd.mi.service.command.events.MIWatchpointTriggerEvent;
import org.eclipse.dd.tests.gdb.framework.AsyncCompletionWaitor;
import org.eclipse.dd.tests.gdb.framework.BackgroundRunner;
import org.eclipse.dd.tests.gdb.framework.BaseTestCase;
import org.eclipse.dd.tests.gdb.framework.SyncUtil;
import org.eclipse.dd.tests.gdb.launching.TestsPlugin;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=BackgroundRunner.class)
public class MIBreakpointsTest
extends BaseTestCase {
    public static final String PLUGIN_ID = "org.eclipse.cdt.debug.core";
    public static final String TEST_APPL = "data/launch/bin/BreakpointTestApp.exe";
    public static final String SOURCE_PATH = "data/launch/src";
    public static final String SOURCE_PROJECT = "MIBreakpointsTest";
    public static final String SOURCE_FOLDER = "src";
    public static final String SOURCE_FILE = "BreakpointTestApp.cc";
    private final AsyncCompletionWaitor fWait = new AsyncCompletionWaitor();
    private DsfSession fSession;
    private IBreakpoints.IBreakpointsTargetDMContext fBreakpointsDmc;
    private DsfServicesTracker fServicesTracker;
    private MIRunControl fRunControl;
    private IBreakpoints fBreakpointService;
    private static Boolean lock = true;
    final int BP_ADDED = Events.BP_ADDED.ordinal();
    final int BP_UPDATED = Events.BP_UPDATED.ordinal();
    final int BP_REMOVED = Events.BP_REMOVED.ordinal();
    final int BP_HIT = Events.BP_HIT.ordinal();
    final int WP_HIT = Events.WP_HIT.ordinal();
    final int WP_OOS = Events.WP_OOS.ordinal();
    private int[] fBreakpointEvents = new int[Events.values().length];
    private boolean fBreakpointEvent;
    private int fBreakpointEventCount;
    private int fBreakpointRef;
    final String BREAKPOINT_TYPE_TAG = "org.eclipse.dd.dsf.debug.breakpoint.type";
    final String BREAKPOINT_TAG = "breakpoint";
    final String WATCHPOINT_TAG = "watchpoint";
    final String FILE_NAME_TAG = "org.eclipse.dd.dsf.debug.breakpoint.fileName";
    final String LINE_NUMBER_TAG = "org.eclipse.dd.dsf.debug.breakpoint.lineNumber";
    final String FUNCTION_TAG = "org.eclipse.dd.dsf.debug.breakpoint.function";
    final String ADDRESS_TAG = "org.eclipse.dd.dsf.debug.breakpoint.address";
    final String CONDITION_TAG = "org.eclipse.dd.dsf.debug.breakpoint.condition";
    final String IGNORE_COUNT_TAG = "org.eclipse.dd.dsf.debug.breakpoint.ignoreCount";
    final String IS_ENABLED_TAG = "org.eclipse.dd.dsf.debug.breakpoint.isEnabled";
    final String THREAD_ID_TAG = "org.eclipse.dd.dsf.debug.breakpoint.mi.threadId";
    final String NUMBER_TAG = "org.eclipse.dd.dsf.debug.breakpoint.mi.number";
    final String EXPRESSION_TAG = "org.eclipse.dd.dsf.debug.breakpoint.expression";
    final String READ_TAG = "org.eclipse.dd.dsf.debug.breakpoint.read";
    final String WRITE_TAG = "org.eclipse.dd.dsf.debug.breakpoint.write";
    private final int LINE_NUMBER_1 = 20;
    private final int LINE_NUMBER_2 = 21;
    private final int LINE_NUMBER_3 = 27;
    private final int LINE_NUMBER_4 = 35;
    private final String FUNCTION = "zeroBlocks";
    private final String SIGNED_FUNCTION = "zeroBlocks(int)";
    private final String NO_CONDITION = "";
    private final String CONDITION_1 = "i == 128";
    private final String CONDITION_2 = "i == 64";
    private final String CONDITION_3 = "j == 20";
    private final int IGNORE_COUNT_1 = 128;
    private final int IGNORE_COUNT_2 = 20;
    private final String EXPRESSION_1 = "charBlock[20]";
    private final String EXPRESSION_2 = "j";
    final String UNKNOWN_EXECUTION_CONTEXT = "Unknown execution context";
    final String INVALID_BREAKPOINT_LOCATION = "Invalid breakpoint location";
    final String BREAKPOINT_INSERTION_FAILURE = "Breakpoint insertion failure";
    final String UNKNOWN_BREAKPOINT = "Unknown breakpoint";

    @BeforeClass
    public static void testSuiteInitialization() {
        MIBreakpointsTest.setLaunchAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", TEST_APPL);
    }

    @AfterClass
    public static void testSuiteCleanup() {
    }

    @Before
    public void testCaseInitialization() {
        this.fSession = this.getGDBLaunch().getSession();
        this.fServicesTracker = new DsfServicesTracker(TestsPlugin.getBundleContext(), this.fSession.getId());
        assert (this.fServicesTracker != null);
        ICommandControlService commandControl = (ICommandControlService)this.fServicesTracker.getService(ICommandControlService.class);
        this.fBreakpointsDmc = (IBreakpoints.IBreakpointsTargetDMContext)commandControl.getContext();
        assert (this.fBreakpointsDmc != null);
        this.fRunControl = (MIRunControl)this.fServicesTracker.getService(MIRunControl.class);
        assert (this.fRunControl != null);
        this.fBreakpointService = (IBreakpoints)this.fServicesTracker.getService(IBreakpoints.class);
        assert (this.fBreakpointService != null);
        this.fRunControl.getSession().addServiceEventListener((Object)this, null);
        this.clearEventCounters();
    }

    @After
    public void testCaseCleanup() {
        this.fRunControl.getSession().removeServiceEventListener((Object)this);
        this.fBreakpointService = null;
        this.fRunControl = null;
        this.fServicesTracker.dispose();
        this.fServicesTracker = null;
        this.clearEventCounters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DsfServiceEventHandler
    public void eventDispatched(IBreakpoints.IBreakpointsAddedEvent e) {
        Boolean bl = lock;
        synchronized (bl) {
            int n = this.BP_ADDED;
            this.fBreakpointEvents[n] = this.fBreakpointEvents[n] + 1;
            ++this.fBreakpointEventCount;
            this.fBreakpointRef = ((MIBreakpoints.MIBreakpointDMContext)e.getBreakpoints()[0]).getReference();
            this.fBreakpointEvent = true;
            lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DsfServiceEventHandler
    public void eventDispatched(IBreakpoints.IBreakpointsUpdatedEvent e) {
        Boolean bl = lock;
        synchronized (bl) {
            int n = this.BP_UPDATED;
            this.fBreakpointEvents[n] = this.fBreakpointEvents[n] + 1;
            ++this.fBreakpointEventCount;
            this.fBreakpointRef = ((MIBreakpoints.MIBreakpointDMContext)e.getBreakpoints()[0]).getReference();
            this.fBreakpointEvent = true;
            lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DsfServiceEventHandler
    public void eventDispatched(IBreakpoints.IBreakpointsRemovedEvent e) {
        Boolean bl = lock;
        synchronized (bl) {
            int n = this.BP_REMOVED;
            this.fBreakpointEvents[n] = this.fBreakpointEvents[n] + 1;
            ++this.fBreakpointEventCount;
            this.fBreakpointRef = ((MIBreakpoints.MIBreakpointDMContext)e.getBreakpoints()[0]).getReference();
            this.fBreakpointEvent = true;
            lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DsfServiceEventHandler
    public void eventDispatched(MIBreakpointHitEvent e) {
        Boolean bl = lock;
        synchronized (bl) {
            int n = this.BP_HIT;
            this.fBreakpointEvents[n] = this.fBreakpointEvents[n] + 1;
            ++this.fBreakpointEventCount;
            this.fBreakpointRef = e.getNumber();
            this.fBreakpointEvent = true;
            lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DsfServiceEventHandler
    public void eventDispatched(MIWatchpointTriggerEvent e) {
        Boolean bl = lock;
        synchronized (bl) {
            int n = this.WP_HIT;
            this.fBreakpointEvents[n] = this.fBreakpointEvents[n] + 1;
            ++this.fBreakpointEventCount;
            this.fBreakpointRef = e.getNumber();
            this.fBreakpointEvent = true;
            lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DsfServiceEventHandler
    public void eventDispatched(MIWatchpointScopeEvent e) {
        Boolean bl = lock;
        synchronized (bl) {
            int n = this.WP_OOS;
            this.fBreakpointEvents[n] = this.fBreakpointEvents[n] + 1;
            ++this.fBreakpointEventCount;
            this.fBreakpointRef = e.getNumber();
            this.fBreakpointEvent = true;
            lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearEventCounters() {
        Boolean bl = lock;
        synchronized (bl) {
            for (int i = 0; i < this.fBreakpointEvents.length; ++i) {
                this.fBreakpointEvents[i] = 0;
            }
            this.fBreakpointEvent = false;
            this.fBreakpointEventCount = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getBreakpointEventCount(int event) {
        int count = 0;
        Boolean bl = lock;
        synchronized (bl) {
            count = this.fBreakpointEvents[event];
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForBreakpointEvent() {
        Boolean bl = lock;
        synchronized (bl) {
            while (!this.fBreakpointEvent) {
                try {
                    lock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.fBreakpointEvent = false;
        }
    }

    private BigInteger evaluateExpression(IDMContext ctx, String expression) throws Throwable {
        final IExpressions fExpressionService = (IExpressions)this.fServicesTracker.getService(IExpressions.class);
        assert (fExpressionService != null);
        IExpressions.IExpressionDMContext expressionDMC = SyncUtil.SyncCreateExpression(ctx, expression);
        final IFormattedValues.FormattedValueDMContext formattedValueDMC = SyncUtil.SyncGetFormattedValue((IFormattedValues)fExpressionService, (IFormattedValues.IFormattedDataDMContext)expressionDMC, "DECIMAL.Format");
        DataRequestMonitor<IFormattedValues.FormattedValueDMData> drm = new DataRequestMonitor<IFormattedValues.FormattedValueDMData>((Executor)this.fSession.getExecutor(), null){

            protected void handleCompleted() {
                if (this.isSuccess()) {
                    MIBreakpointsTest.this.fWait.setReturnInfo(this.getData());
                }
                MIBreakpointsTest.this.fWait.waitFinished(this.getStatus());
            }
        };
        this.fWait.waitReset();
        this.fSession.getExecutor().submit(new Runnable((DataRequestMonitor)drm){
            final /* synthetic */ DataRequestMonitor val$drm;
            {
                this.val$drm = dataRequestMonitor;
            }

            public void run() {
                fExpressionService.getFormattedExpressionValue(formattedValueDMC, this.val$drm);
            }
        });
        this.fWait.waitUntilDone(0);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        String result = "";
        Object returnInfo = this.fWait.getReturnInfo();
        if (returnInfo instanceof IFormattedValues.FormattedValueDMData) {
            result = ((IFormattedValues.FormattedValueDMData)returnInfo).getFormattedValue();
        }
        return new BigInteger(result);
    }

    private IBreakpoints.IBreakpointDMContext[] getBreakpoints(final IBreakpoints.IBreakpointsTargetDMContext context) throws InterruptedException {
        this.fWait.waitReset();
        DataRequestMonitor<IBreakpoints.IBreakpointDMContext[]> drm = new DataRequestMonitor<IBreakpoints.IBreakpointDMContext[]>((Executor)this.fBreakpointService.getExecutor(), null){

            protected void handleCompleted() {
                MIBreakpointsTest.this.fWait.waitFinished(this.getStatus());
            }
        };
        this.fWait.waitReset();
        this.fBreakpointService.getExecutor().submit(new Runnable((DataRequestMonitor)drm){
            final /* synthetic */ DataRequestMonitor val$drm;
            {
                this.val$drm = dataRequestMonitor;
            }

            public void run() {
                MIBreakpointsTest.this.fBreakpointService.getBreakpoints(context, this.val$drm);
            }
        });
        this.fWait.waitUntilDone(0);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        return (IBreakpoints.IBreakpointDMContext[])drm.getData();
    }

    private IBreakpoints.IBreakpointDMData getBreakpoint(final IBreakpoints.IBreakpointDMContext breakpoint) throws InterruptedException {
        this.fWait.waitReset();
        DataRequestMonitor<IBreakpoints.IBreakpointDMData> drm = new DataRequestMonitor<IBreakpoints.IBreakpointDMData>((Executor)this.fBreakpointService.getExecutor(), null){

            protected void handleCompleted() {
                MIBreakpointsTest.this.fWait.waitFinished(this.getStatus());
            }
        };
        this.fWait.waitReset();
        this.fBreakpointService.getExecutor().submit(new Runnable((DataRequestMonitor)drm){
            final /* synthetic */ DataRequestMonitor val$drm;
            {
                this.val$drm = dataRequestMonitor;
            }

            public void run() {
                MIBreakpointsTest.this.fBreakpointService.getBreakpointDMData(breakpoint, this.val$drm);
            }
        });
        this.fWait.waitUntilDone(0);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        return (IBreakpoints.IBreakpointDMData)drm.getData();
    }

    private IBreakpoints.IBreakpointDMContext insertBreakpoint(final IBreakpoints.IBreakpointsTargetDMContext context, final Map<String, Object> attributes) throws InterruptedException {
        this.fWait.waitReset();
        DataRequestMonitor<IBreakpoints.IBreakpointDMContext> drm = new DataRequestMonitor<IBreakpoints.IBreakpointDMContext>((Executor)this.fBreakpointService.getExecutor(), null){

            protected void handleCompleted() {
                MIBreakpointsTest.this.fWait.waitFinished(this.getStatus());
            }
        };
        this.fBreakpointService.getExecutor().submit(new Runnable((DataRequestMonitor)drm){
            final /* synthetic */ DataRequestMonitor val$drm;
            {
                this.val$drm = dataRequestMonitor;
            }

            public void run() {
                MIBreakpointsTest.this.fBreakpointService.insertBreakpoint(context, attributes, this.val$drm);
            }
        });
        this.fWait.waitUntilDone(0);
        return (IBreakpoints.IBreakpointDMContext)drm.getData();
    }

    private void removeBreakpoint(final IBreakpoints.IBreakpointDMContext breakpoint) throws InterruptedException {
        this.fWait.waitReset();
        final RequestMonitor rm = new RequestMonitor((Executor)this.fBreakpointService.getExecutor(), null){

            protected void handleCompleted() {
                MIBreakpointsTest.this.fWait.waitFinished(this.getStatus());
            }
        };
        this.fBreakpointService.getExecutor().submit(new Runnable(){

            public void run() {
                MIBreakpointsTest.this.fBreakpointService.removeBreakpoint(breakpoint, rm);
            }
        });
        this.fWait.waitUntilDone(0);
    }

    private void updateBreakpoint(final IBreakpoints.IBreakpointDMContext breakpoint, final Map<String, Object> delta) throws InterruptedException {
        this.fWait.waitReset();
        final RequestMonitor rm = new RequestMonitor((Executor)this.fBreakpointService.getExecutor(), null){

            protected void handleCompleted() {
                MIBreakpointsTest.this.fWait.waitFinished(this.getStatus());
            }
        };
        this.fBreakpointService.getExecutor().submit(new Runnable(){

            public void run() {
                MIBreakpointsTest.this.fBreakpointService.updateBreakpoint(breakpoint, delta, rm);
            }
        });
        this.fWait.waitUntilDone(0);
    }

    @Test
    public void insertBreakpoint_InvalidContext() throws Throwable {
        HashMap<String, Object> breakpoint = new HashMap<String, Object>();
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.type", "breakpoint");
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.fileName", SOURCE_FILE);
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.lineNumber", 20);
        String expected = "Unknown execution context";
        this.insertBreakpoint(null, breakpoint);
        Assert.assertFalse((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        Assert.assertTrue((String)("Wrong error message: expected '" + expected + "', received '" + this.fWait.getMessage() + "'"), (boolean)this.fWait.getMessage().contains(expected));
        Assert.assertTrue((String)("BreakpointEvent problem: expected 0 BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == 0 ? 1 : 0) != 0);
    }

    @Test
    public void insertBreakpoint_InvalidFileName() throws Throwable {
        HashMap<String, Object> breakpoint = new HashMap<String, Object>();
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.type", "breakpoint");
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.fileName", "BreakpointTestApp.cc_bad");
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.lineNumber", 20);
        String expected = "Breakpoint insertion failure";
        this.insertBreakpoint(this.fBreakpointsDmc, breakpoint);
        Assert.assertFalse((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        Assert.assertTrue((String)("Wrong error message: expected '" + expected + "', received '" + this.fWait.getMessage() + "'"), (boolean)this.fWait.getMessage().contains(expected));
        Assert.assertTrue((String)("BreakpointEvent problem: expected 0 BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == 0 ? 1 : 0) != 0);
    }

    @Test
    public void insertBreakpoint_InvalidLineNumber() throws Throwable {
        HashMap<String, Object> breakpoint = new HashMap<String, Object>();
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.type", "breakpoint");
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.fileName", SOURCE_FILE);
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.lineNumber", 0);
        String expected = "Breakpoint insertion failure";
        this.insertBreakpoint(this.fBreakpointsDmc, breakpoint);
        Assert.assertFalse((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        Assert.assertTrue((String)("Wrong error message: expected '" + expected + "', received '" + this.fWait.getMessage() + "'"), (boolean)this.fWait.getMessage().contains(expected));
        Assert.assertTrue((String)("BreakpointEvent problem: expected 0 BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == 0 ? 1 : 0) != 0);
    }

    @Test
    public void insertBreakpoint_InvalidFunctionName() throws Throwable {
        HashMap<String, Object> breakpoint = new HashMap<String, Object>();
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.type", "breakpoint");
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.fileName", SOURCE_FILE);
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.function", "invalid-function-name");
        String expected = "Breakpoint insertion failure";
        this.insertBreakpoint(this.fBreakpointsDmc, breakpoint);
        Assert.assertFalse((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        Assert.assertTrue((String)("Wrong error message: expected '" + expected + "', received '" + this.fWait.getMessage() + "'"), (boolean)this.fWait.getMessage().contains(expected));
        Assert.assertTrue((String)("BreakpointEvent problem: expected 0 BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == 0 ? 1 : 0) != 0);
    }

    @Test
    public void insertBreakpoint_InvalidAddress() throws Throwable {
        HashMap<String, Object> breakpoint = new HashMap<String, Object>();
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.type", "breakpoint");
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.address", "0x0z");
        String expected = "Breakpoint insertion failure";
        this.insertBreakpoint(this.fBreakpointsDmc, breakpoint);
        Assert.assertFalse((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        Assert.assertTrue((String)("Wrong error message: expected '" + expected + "', received '" + this.fWait.getMessage() + "'"), (boolean)this.fWait.getMessage().contains(expected));
        Assert.assertTrue((String)("BreakpointEvent problem: expected 0 BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == 0 ? 1 : 0) != 0);
    }

    @Test
    public void insertBreakpoint_Address() throws Throwable {
        HashMap<String, Object> breakpoint = new HashMap<String, Object>();
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.type", "breakpoint");
        BigInteger ADDRESS = new BigInteger("00affe00", 16);
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.address", "0x" + ADDRESS.toString(16));
        IBreakpoints.IBreakpointDMContext ref = this.insertBreakpoint(this.fBreakpointsDmc, breakpoint);
        this.waitForBreakpointEvent();
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT_ADDED event(s), received " + this.getBreakpointEventCount(this.BP_ADDED)), (this.getBreakpointEventCount(this.BP_ADDED) == 1 ? 1 : 0) != 0);
        this.clearEventCounters();
        MIBreakpointDMData breakpoint1 = (MIBreakpointDMData)this.getBreakpoint(ref);
        Assert.assertEquals((String)"BreakpointService problem: breakpoint mismatch (wrong address)", (Object)breakpoint1.getAddresses()[0].getValue(), (Object)ADDRESS);
        Assert.assertTrue((String)"BreakpointService problem: breakpoint mismatch (wrong condition)", (boolean)breakpoint1.getCondition().equals(""));
        Assert.assertTrue((String)"BreakpointService problem: breakpoint mismatch (wrong ignore count)", (breakpoint1.getIgnoreCount() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"BreakpointService problem: breakpoint mismatch (wrong state)", (boolean)breakpoint1.isEnabled());
        IBreakpoints.IBreakpointDMContext[] breakpoints = this.getBreakpoints(this.fBreakpointsDmc);
        Assert.assertTrue((String)("BreakpointService problem: expected 1 breakpoint(s), received " + breakpoints.length), (breakpoints.length == 1 ? 1 : 0) != 0);
        MIBreakpointDMData breakpoint2 = (MIBreakpointDMData)this.getBreakpoint(breakpoints[0]);
        Assert.assertTrue((String)"BreakpointService problem: breakpoint mismatch", (boolean)breakpoint1.equals(breakpoint2));
    }

    @Test
    public void insertBreakpoint_LineNumber() throws Throwable {
        HashMap<String, Object> breakpoint = new HashMap<String, Object>();
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.type", "breakpoint");
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.fileName", SOURCE_FILE);
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.lineNumber", 20);
        IBreakpoints.IBreakpointDMContext ref = this.insertBreakpoint(this.fBreakpointsDmc, breakpoint);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        this.waitForBreakpointEvent();
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT_ADDED event(s), received " + this.getBreakpointEventCount(this.BP_ADDED)), (this.getBreakpointEventCount(this.BP_ADDED) == 1 ? 1 : 0) != 0);
        this.clearEventCounters();
        MIBreakpointDMData breakpoint1 = (MIBreakpointDMData)this.getBreakpoint(ref);
        Assert.assertTrue((String)"BreakpointService problem: breakpoint mismatch (wrong file name)", (boolean)breakpoint1.getFileName().equals(SOURCE_FILE));
        Assert.assertTrue((String)"BreakpointService problem: breakpoint mismatch (wrong line number)", (breakpoint1.getLineNumber() == 20 ? 1 : 0) != 0);
        Assert.assertTrue((String)"BreakpointService problem: breakpoint mismatch (wrong condition)", (boolean)breakpoint1.getCondition().equals(""));
        Assert.assertTrue((String)"BreakpointService problem: breakpoint mismatch (wrong ignore count)", (breakpoint1.getIgnoreCount() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"BreakpointService problem: breakpoint mismatch (wrong state)", (boolean)breakpoint1.isEnabled());
        IBreakpoints.IBreakpointDMContext[] breakpoints = this.getBreakpoints(this.fBreakpointsDmc);
        Assert.assertTrue((String)("BreakpointService problem: expected 1 breakpoint(s), received " + breakpoints.length), (breakpoints.length == 1 ? 1 : 0) != 0);
        MIBreakpointDMData breakpoint2 = (MIBreakpointDMData)this.getBreakpoint(breakpoints[0]);
        Assert.assertTrue((String)"BreakpointService problem: breakpoint mismatch", (boolean)breakpoint1.equals(breakpoint2));
    }

    @Test
    public void insertBreakpoint_Disabled() throws Throwable {
        HashMap<String, Object> breakpoint = new HashMap<String, Object>();
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.type", "breakpoint");
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.fileName", SOURCE_FILE);
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.lineNumber", 20);
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.isEnabled", false);
        IBreakpoints.IBreakpointDMContext ref = this.insertBreakpoint(this.fBreakpointsDmc, breakpoint);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        this.waitForBreakpointEvent();
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT_ADDED event(s), received " + this.getBreakpointEventCount(this.BP_ADDED)), (this.getBreakpointEventCount(this.BP_ADDED) == 1 ? 1 : 0) != 0);
        this.clearEventCounters();
        MIBreakpointDMData breakpoint1 = (MIBreakpointDMData)this.getBreakpoint(ref);
        Assert.assertTrue((String)"BreakpointService problem: breakpoint mismatch (wrong file name)", (boolean)breakpoint1.getFileName().equals(SOURCE_FILE));
        Assert.assertTrue((String)"BreakpointService problem: breakpoint mismatch (wrong line number)", (breakpoint1.getLineNumber() == 20 ? 1 : 0) != 0);
        Assert.assertTrue((String)"BreakpointService problem: breakpoint mismatch (wrong condition)", (boolean)breakpoint1.getCondition().equals(""));
        Assert.assertTrue((String)"BreakpointService problem: breakpoint mismatch (wrong ignore count)", (breakpoint1.getIgnoreCount() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"BreakpointService problem: breakpoint mismatch (wrong state)", (!breakpoint1.isEnabled() ? 1 : 0) != 0);
        IBreakpoints.IBreakpointDMContext[] breakpoints = this.getBreakpoints(this.fBreakpointsDmc);
        Assert.assertTrue((String)("BreakpointService problem: expected 1 breakpoint(s), received " + breakpoints.length), (breakpoints.length == 1 ? 1 : 0) != 0);
        MIBreakpointDMData breakpoint2 = (MIBreakpointDMData)this.getBreakpoint(breakpoints[0]);
        Assert.assertTrue((String)"BreakpointService problem: breakpoint mismatch", (boolean)breakpoint1.equals(breakpoint2));
    }

    @Test
    public void insertBreakpoint_FunctionName() throws Throwable {
        HashMap<String, Object> breakpoint = new HashMap<String, Object>();
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.type", "breakpoint");
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.fileName", SOURCE_FILE);
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.function", "zeroBlocks");
        IBreakpoints.IBreakpointDMContext ref = this.insertBreakpoint(this.fBreakpointsDmc, breakpoint);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        this.waitForBreakpointEvent();
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT_ADDED event(s), received " + this.getBreakpointEventCount(this.BP_ADDED)), (this.getBreakpointEventCount(this.BP_ADDED) == 1 ? 1 : 0) != 0);
        this.clearEventCounters();
        MIBreakpointDMData breakpoint1 = (MIBreakpointDMData)this.getBreakpoint(ref);
        Assert.assertTrue((String)"BreakpointService problem: breakpoint mismatch (wrong file name)", (boolean)breakpoint1.getFileName().equals(SOURCE_FILE));
        Assert.assertTrue((String)"BreakpointService problem: breakpoint mismatch (wrong function)", (boolean)breakpoint1.getFunctionName().equals("zeroBlocks(int)"));
        Assert.assertTrue((String)"BreakpointService problem: breakpoint mismatch (wrong condition)", (boolean)breakpoint1.getCondition().equals(""));
        Assert.assertTrue((String)"BreakpointService problem: breakpoint mismatch (wrong ignore count)", (breakpoint1.getIgnoreCount() == 0 ? 1 : 0) != 0);
        IBreakpoints.IBreakpointDMContext[] breakpoints = this.getBreakpoints(this.fBreakpointsDmc);
        Assert.assertTrue((String)("BreakpointService problem: expected 1 breakpoint(s), received " + breakpoints.length), (breakpoints.length == 1 ? 1 : 0) != 0);
        MIBreakpointDMData breakpoint2 = (MIBreakpointDMData)this.getBreakpoint(breakpoints[0]);
        Assert.assertTrue((String)"BreakpointService problem: breakpoint mismatch", (boolean)breakpoint1.equals(breakpoint2));
    }

    @Test
    public void insertBreakpoint_Condition() throws Throwable {
        HashMap<String, Object> breakpoint = new HashMap<String, Object>();
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.type", "breakpoint");
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.fileName", SOURCE_FILE);
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.lineNumber", 20);
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.condition", "i == 128");
        IBreakpoints.IBreakpointDMContext ref = this.insertBreakpoint(this.fBreakpointsDmc, breakpoint);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        this.waitForBreakpointEvent();
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT_ADDED event(s), received " + this.getBreakpointEventCount(this.BP_ADDED)), (this.getBreakpointEventCount(this.BP_ADDED) == 1 ? 1 : 0) != 0);
        this.clearEventCounters();
        MIBreakpointDMData breakpoint1 = (MIBreakpointDMData)this.getBreakpoint(ref);
        Assert.assertTrue((String)"BreakpointService problem: breakpoint mismatch (wrong file name)", (boolean)breakpoint1.getFileName().equals(SOURCE_FILE));
        Assert.assertTrue((String)"BreakpointService problem: breakpoint mismatch (wrong line number)", (breakpoint1.getLineNumber() == 20 ? 1 : 0) != 0);
        Assert.assertTrue((String)"BreakpointService problem: breakpoint mismatch (wrong condition)", (boolean)breakpoint1.getCondition().equals("i == 128"));
        Assert.assertTrue((String)"BreakpointService problem: breakpoint mismatch (wrong ignore count)", (breakpoint1.getIgnoreCount() == 0 ? 1 : 0) != 0);
        IBreakpoints.IBreakpointDMContext[] breakpoints = this.getBreakpoints(this.fBreakpointsDmc);
        Assert.assertTrue((String)("BreakpointService problem: expected 1 breakpoint(s), received " + breakpoints.length), (breakpoints.length == 1 ? 1 : 0) != 0);
        MIBreakpointDMData breakpoint2 = (MIBreakpointDMData)this.getBreakpoint(breakpoints[0]);
        Assert.assertTrue((String)"BreakpointService problem: breakpoint mismatch", (boolean)breakpoint1.equals(breakpoint2));
    }

    @Test
    public void insertBreakpoint_IgnoreCnt() throws Throwable {
        HashMap<String, Object> breakpoint = new HashMap<String, Object>();
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.type", "breakpoint");
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.fileName", SOURCE_FILE);
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.lineNumber", 20);
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.ignoreCount", 128);
        IBreakpoints.IBreakpointDMContext ref = this.insertBreakpoint(this.fBreakpointsDmc, breakpoint);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        this.waitForBreakpointEvent();
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT_ADDED event(s), received " + this.getBreakpointEventCount(this.BP_ADDED)), (this.getBreakpointEventCount(this.BP_ADDED) == 1 ? 1 : 0) != 0);
        this.clearEventCounters();
        MIBreakpointDMData breakpoint1 = (MIBreakpointDMData)this.getBreakpoint(ref);
        Assert.assertTrue((String)"BreakpointService problem: breakpoint mismatch (wrong file name)", (boolean)breakpoint1.getFileName().equals(SOURCE_FILE));
        Assert.assertTrue((String)"BreakpointService problem: breakpoint mismatch (wrong line number)", (breakpoint1.getLineNumber() == 20 ? 1 : 0) != 0);
        Assert.assertTrue((String)"BreakpointService problem: breakpoint mismatch (wrong condition)", (boolean)breakpoint1.getCondition().equals(""));
        Assert.assertTrue((String)"BreakpointService problem: breakpoint mismatch (wrong ignore count)", (breakpoint1.getIgnoreCount() == 128 ? 1 : 0) != 0);
        IBreakpoints.IBreakpointDMContext[] breakpoints = this.getBreakpoints(this.fBreakpointsDmc);
        Assert.assertTrue((String)("BreakpointService problem: expected 1 breakpoint(s), received " + breakpoints.length), (breakpoints.length == 1 ? 1 : 0) != 0);
        MIBreakpointDMData breakpoint2 = (MIBreakpointDMData)this.getBreakpoint(breakpoints[0]);
        Assert.assertTrue((String)"BreakpointService problem: breakpoint mismatch", (boolean)breakpoint1.equals(breakpoint2));
    }

    @Test
    public void insertBreakpoint_MultipleBreakpoints() throws Throwable {
        HashMap<String, Object> breakpoint = new HashMap<String, Object>();
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.type", "breakpoint");
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.fileName", SOURCE_FILE);
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.lineNumber", 20);
        IBreakpoints.IBreakpointDMContext ref = this.insertBreakpoint(this.fBreakpointsDmc, breakpoint);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        this.waitForBreakpointEvent();
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT_ADDED event(s), received " + this.getBreakpointEventCount(this.BP_ADDED)), (this.getBreakpointEventCount(this.BP_ADDED) == 1 ? 1 : 0) != 0);
        this.clearEventCounters();
        MIBreakpointDMData breakpoint1 = (MIBreakpointDMData)this.getBreakpoint(ref);
        Assert.assertTrue((String)"BreakpointService problem: breakpoint mismatch (wrong file name)", (boolean)breakpoint1.getFileName().equals(SOURCE_FILE));
        Assert.assertTrue((String)"BreakpointService problem: breakpoint mismatch (wrong line number)", (breakpoint1.getLineNumber() == 20 ? 1 : 0) != 0);
        Assert.assertTrue((String)"BreakpointService problem: breakpoint mismatch (wrong condition)", (boolean)breakpoint1.getCondition().equals(""));
        Assert.assertTrue((String)"BreakpointService problem: breakpoint mismatch (wrong ignore count)", (breakpoint1.getIgnoreCount() == 0 ? 1 : 0) != 0);
        breakpoint = new HashMap();
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.type", "breakpoint");
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.fileName", SOURCE_FILE);
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.function", "zeroBlocks");
        ref = this.insertBreakpoint(this.fBreakpointsDmc, breakpoint);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        this.waitForBreakpointEvent();
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT_ADDED event(s), received " + this.getBreakpointEventCount(this.BP_ADDED)), (this.getBreakpointEventCount(this.BP_ADDED) == 1 ? 1 : 0) != 0);
        this.clearEventCounters();
        MIBreakpointDMData breakpoint2 = (MIBreakpointDMData)this.getBreakpoint(ref);
        Assert.assertTrue((String)"BreakpointService problem: breakpoint mismatch (wrong file name)", (boolean)breakpoint2.getFileName().equals(SOURCE_FILE));
        Assert.assertTrue((String)"BreakpointService problem: breakpoint mismatch (wrong function)", (boolean)breakpoint2.getFunctionName().equals("zeroBlocks(int)"));
        Assert.assertTrue((String)"BreakpointService problem: breakpoint mismatch (wrong condition)", (boolean)breakpoint2.getCondition().equals(""));
        Assert.assertTrue((String)"BreakpointService problem: breakpoint mismatch (wrong ignore count)", (breakpoint2.getIgnoreCount() == 0 ? 1 : 0) != 0);
        IBreakpoints.IBreakpointDMContext[] breakpoints = this.getBreakpoints(this.fBreakpointsDmc);
        Assert.assertTrue((String)("BreakpointService problem: expected 2 breakpoint(s), received " + breakpoints.length), (breakpoints.length == 2 ? 1 : 0) != 0);
        MIBreakpointDMData svc_bp1 = (MIBreakpointDMData)this.getBreakpoint(breakpoints[0]);
        MIBreakpointDMData svc_bp2 = (MIBreakpointDMData)this.getBreakpoint(breakpoints[1]);
        int ref1 = breakpoint1.getNumber();
        int ref2 = svc_bp1.getNumber();
        if (ref1 == ref2) {
            Assert.assertTrue((String)"BreakpointService problem: breakpoint mismatch", (boolean)svc_bp1.equals(breakpoint1));
            Assert.assertTrue((String)"BreakpointService problem: breakpoint mismatch", (boolean)svc_bp2.equals(breakpoint2));
        } else {
            Assert.assertTrue((String)"BreakpointService problem: breakpoint mismatch", (boolean)svc_bp1.equals(breakpoint2));
            Assert.assertTrue((String)"BreakpointService problem: breakpoint mismatch", (boolean)svc_bp2.equals(breakpoint1));
        }
    }

    @Test
    public void insertBreakpoint_Duplicate() throws Throwable {
        HashMap<String, Object> breakpoint = new HashMap<String, Object>();
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.type", "breakpoint");
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.fileName", SOURCE_FILE);
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.lineNumber", 20);
        IBreakpoints.IBreakpointDMContext ref = this.insertBreakpoint(this.fBreakpointsDmc, breakpoint);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        this.waitForBreakpointEvent();
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT_ADDED event(s), received " + this.getBreakpointEventCount(this.BP_ADDED)), (this.getBreakpointEventCount(this.BP_ADDED) == 1 ? 1 : 0) != 0);
        this.clearEventCounters();
        MIBreakpointDMData breakpoint1 = (MIBreakpointDMData)this.getBreakpoint(ref);
        Assert.assertTrue((String)"BreakpointService problem: breakpoint mismatch (wrong file name)", (boolean)breakpoint1.getFileName().equals(SOURCE_FILE));
        Assert.assertTrue((String)"BreakpointService problem: breakpoint mismatch (wrong line number)", (breakpoint1.getLineNumber() == 20 ? 1 : 0) != 0);
        Assert.assertTrue((String)"BreakpointService problem: breakpoint mismatch (wrong condition)", (boolean)breakpoint1.getCondition().equals(""));
        Assert.assertTrue((String)"BreakpointService problem: breakpoint mismatch (wrong ignore count)", (breakpoint1.getIgnoreCount() == 0 ? 1 : 0) != 0);
        ref = this.insertBreakpoint(this.fBreakpointsDmc, breakpoint);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        this.waitForBreakpointEvent();
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT_ADDED event(s), received " + this.getBreakpointEventCount(this.BP_ADDED)), (this.getBreakpointEventCount(this.BP_ADDED) == 1 ? 1 : 0) != 0);
        this.clearEventCounters();
        MIBreakpointDMData breakpoint2 = (MIBreakpointDMData)this.getBreakpoint(ref);
        Assert.assertTrue((String)"BreakpointService problem: breakpoint mismatch (wrong file name)", (boolean)breakpoint2.getFileName().equals(SOURCE_FILE));
        Assert.assertTrue((String)"BreakpointService problem: breakpoint mismatch (wrong line number)", (breakpoint2.getLineNumber() == 20 ? 1 : 0) != 0);
        Assert.assertTrue((String)"BreakpointService problem: breakpoint mismatch (wrong condition)", (boolean)breakpoint2.getCondition().equals(""));
        Assert.assertTrue((String)"BreakpointService problem: breakpoint mismatch (wrong ignore count)", (breakpoint2.getIgnoreCount() == 0 ? 1 : 0) != 0);
        IBreakpoints.IBreakpointDMContext[] breakpoints = this.getBreakpoints(this.fBreakpointsDmc);
        Assert.assertTrue((String)("BreakpointService problem: expected 2 breakpoint(s), received " + breakpoints.length), (breakpoints.length == 2 ? 1 : 0) != 0);
        MIBreakpointDMData svc_bp1 = (MIBreakpointDMData)this.getBreakpoint(breakpoints[0]);
        MIBreakpointDMData svc_bp2 = (MIBreakpointDMData)this.getBreakpoint(breakpoints[1]);
        int ref1 = breakpoint1.getNumber();
        int ref2 = svc_bp1.getNumber();
        if (ref1 == ref2) {
            Assert.assertTrue((String)"BreakpointService problem: breakpoint mismatch", (boolean)svc_bp1.equals(breakpoint1));
            Assert.assertTrue((String)"BreakpointService problem: breakpoint mismatch", (boolean)svc_bp2.equals(breakpoint2));
        } else {
            Assert.assertTrue((String)"BreakpointService problem: breakpoint mismatch", (boolean)svc_bp1.equals(breakpoint2));
            Assert.assertTrue((String)"BreakpointService problem: breakpoint mismatch", (boolean)svc_bp2.equals(breakpoint1));
        }
    }

    @Test
    public void insertWatchpoint_Write() throws Throwable {
        HashMap<String, Object> watchpoint = new HashMap<String, Object>();
        watchpoint.put("org.eclipse.dd.dsf.debug.breakpoint.type", "watchpoint");
        watchpoint.put("org.eclipse.dd.dsf.debug.breakpoint.expression", "charBlock[20]");
        watchpoint.put("org.eclipse.dd.dsf.debug.breakpoint.write", true);
        IBreakpoints.IBreakpointDMContext ref = this.insertBreakpoint(this.fBreakpointsDmc, watchpoint);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        this.waitForBreakpointEvent();
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT_ADDED event(s), received " + this.getBreakpointEventCount(this.BP_ADDED)), (this.getBreakpointEventCount(this.BP_ADDED) == 1 ? 1 : 0) != 0);
        this.clearEventCounters();
        MIBreakpointDMData watchpoint1 = (MIBreakpointDMData)this.getBreakpoint(ref);
        Assert.assertTrue((String)"BreakpointService problem: watchpoint mismatch (wrong expression)", (boolean)watchpoint1.getExpression().equals("charBlock[20]"));
        Assert.assertTrue((String)"BreakpointService problem: watchpoint mismatch (wrong read state)", (!watchpoint1.isReadWatchpoint() ? 1 : 0) != 0);
        Assert.assertTrue((String)"BreakpointService problem: watchpoint mismatch (wrong write state)", (boolean)watchpoint1.isWriteWatchpoint());
        Assert.assertTrue((String)"BreakpointService problem: watchpoint mismatch (wrong access state)", (!watchpoint1.isAccessWatchpoint() ? 1 : 0) != 0);
        IBreakpoints.IBreakpointDMContext[] watchpoints = this.getBreakpoints(this.fBreakpointsDmc);
        Assert.assertTrue((String)("BreakpointService problem: expected 1 watchpoints(s), received " + watchpoints.length), (watchpoints.length == 1 ? 1 : 0) != 0);
        MIBreakpointDMData watchpoint2 = (MIBreakpointDMData)this.getBreakpoint(watchpoints[0]);
        Assert.assertTrue((String)"BreakpointService problem: breakpoint mismatch", (boolean)watchpoint1.equals(watchpoint2));
    }

    @Test
    public void insertWatchpoint_Read() throws Throwable {
        HashMap<String, Object> watchpoint = new HashMap<String, Object>();
        watchpoint.put("org.eclipse.dd.dsf.debug.breakpoint.type", "watchpoint");
        watchpoint.put("org.eclipse.dd.dsf.debug.breakpoint.expression", "charBlock[20]");
        watchpoint.put("org.eclipse.dd.dsf.debug.breakpoint.read", true);
        IBreakpoints.IBreakpointDMContext ref = this.insertBreakpoint(this.fBreakpointsDmc, watchpoint);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        this.waitForBreakpointEvent();
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT_ADDED event(s), received " + this.getBreakpointEventCount(this.BP_ADDED)), (this.getBreakpointEventCount(this.BP_ADDED) == 1 ? 1 : 0) != 0);
        this.clearEventCounters();
        MIBreakpointDMData watchpoint1 = (MIBreakpointDMData)this.getBreakpoint(ref);
        Assert.assertTrue((String)"BreakpointService problem: watchpoint mismatch (wrong expression)", (boolean)watchpoint1.getExpression().equals("charBlock[20]"));
        Assert.assertTrue((String)"BreakpointService problem: watchpoint mismatch (wrong read state)", (boolean)watchpoint1.isReadWatchpoint());
        Assert.assertTrue((String)"BreakpointService problem: watchpoint mismatch (wrong write state)", (!watchpoint1.isWriteWatchpoint() ? 1 : 0) != 0);
        Assert.assertTrue((String)"BreakpointService problem: watchpoint mismatch (wrong access state)", (!watchpoint1.isAccessWatchpoint() ? 1 : 0) != 0);
        IBreakpoints.IBreakpointDMContext[] watchpoints = this.getBreakpoints(this.fBreakpointsDmc);
        Assert.assertTrue((String)("BreakpointService problem: expected 1 watchpoints(s), received " + watchpoints.length), (watchpoints.length == 1 ? 1 : 0) != 0);
        MIBreakpointDMData watchpoint2 = (MIBreakpointDMData)this.getBreakpoint(watchpoints[0]);
        Assert.assertTrue((String)"BreakpointService problem: breakpoint mismatch", (boolean)watchpoint1.equals(watchpoint2));
    }

    @Test
    public void insertWatchpoint_Access() throws Throwable {
        HashMap<String, Object> watchpoint = new HashMap<String, Object>();
        watchpoint.put("org.eclipse.dd.dsf.debug.breakpoint.type", "watchpoint");
        watchpoint.put("org.eclipse.dd.dsf.debug.breakpoint.expression", "charBlock[20]");
        watchpoint.put("org.eclipse.dd.dsf.debug.breakpoint.read", true);
        watchpoint.put("org.eclipse.dd.dsf.debug.breakpoint.write", true);
        IBreakpoints.IBreakpointDMContext ref = this.insertBreakpoint(this.fBreakpointsDmc, watchpoint);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        this.waitForBreakpointEvent();
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT_ADDED event(s), received " + this.getBreakpointEventCount(this.BP_ADDED)), (this.getBreakpointEventCount(this.BP_ADDED) == 1 ? 1 : 0) != 0);
        this.clearEventCounters();
        MIBreakpointDMData watchpoint1 = (MIBreakpointDMData)this.getBreakpoint(ref);
        Assert.assertTrue((String)"BreakpointService problem: watchpoint mismatch (wrong expression)", (boolean)watchpoint1.getExpression().equals("charBlock[20]"));
        Assert.assertTrue((String)"BreakpointService problem: watchpoint mismatch (wrong read state)", (!watchpoint1.isReadWatchpoint() ? 1 : 0) != 0);
        Assert.assertTrue((String)"BreakpointService problem: watchpoint mismatch (wrong write state)", (!watchpoint1.isWriteWatchpoint() ? 1 : 0) != 0);
        Assert.assertTrue((String)"BreakpointService problem: watchpoint mismatch (wrong access state)", (boolean)watchpoint1.isAccessWatchpoint());
        IBreakpoints.IBreakpointDMContext[] watchpoints = this.getBreakpoints(this.fBreakpointsDmc);
        Assert.assertTrue((String)("BreakpointService problem: expected 1 watchpoints(s), received " + watchpoints.length), (watchpoints.length == 1 ? 1 : 0) != 0);
        MIBreakpointDMData watchpoint2 = (MIBreakpointDMData)this.getBreakpoint(watchpoints[0]);
        Assert.assertTrue((String)"BreakpointService problem: breakpoint mismatch", (boolean)watchpoint1.equals(watchpoint2));
    }

    @Test
    public void removeBreakpoint_SimpleCase() throws Throwable {
        HashMap<String, Object> breakpoint = new HashMap<String, Object>();
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.type", "breakpoint");
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.fileName", SOURCE_FILE);
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.lineNumber", 20);
        IBreakpoints.IBreakpointDMContext ref = this.insertBreakpoint(this.fBreakpointsDmc, breakpoint);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        this.waitForBreakpointEvent();
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT_ADDED event(s), received " + this.getBreakpointEventCount(this.BP_ADDED)), (this.getBreakpointEventCount(this.BP_ADDED) == 1 ? 1 : 0) != 0);
        this.clearEventCounters();
        this.removeBreakpoint(ref);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        this.waitForBreakpointEvent();
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT_REMOVED event(s), received " + this.getBreakpointEventCount(this.BP_REMOVED)), (this.getBreakpointEventCount(this.BP_REMOVED) == 1 ? 1 : 0) != 0);
        this.clearEventCounters();
        IBreakpoints.IBreakpointDMContext[] breakpoints = this.getBreakpoints(this.fBreakpointsDmc);
        Assert.assertTrue((String)("BreakpointService problem: expected 0 breakpoint(s), received " + breakpoints.length), (breakpoints.length == 0 ? 1 : 0) != 0);
    }

    @Test
    public void removeBreakpoint_InvalidBreakpoint() throws Throwable {
        IBreakpoints.IBreakpointDMContext ref;
        MIBreakpoints.MIBreakpointDMContext invalid_ref = new MIBreakpoints.MIBreakpointDMContext((MIBreakpoints)this.fBreakpointService, new IDMContext[]{this.fBreakpointsDmc}, 0);
        String expected = "Unknown breakpoint";
        this.removeBreakpoint((IBreakpoints.IBreakpointDMContext)invalid_ref);
        Assert.assertFalse((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        Assert.assertTrue((String)("Wrong error message: expected '" + expected + "', received '" + this.fWait.getMessage() + "'"), (boolean)this.fWait.getMessage().contains(expected));
        Assert.assertTrue((String)("BreakpointEvent problem: expected 0 BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == 0 ? 1 : 0) != 0);
        HashMap<String, Object> breakpoint = new HashMap<String, Object>();
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.type", "breakpoint");
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.fileName", SOURCE_FILE);
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.lineNumber", 20);
        IBreakpoints.IBreakpointDMContext saved_ref = ref = this.insertBreakpoint(this.fBreakpointsDmc, breakpoint);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        this.waitForBreakpointEvent();
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT_ADDED event(s), received " + this.getBreakpointEventCount(this.BP_ADDED)), (this.getBreakpointEventCount(this.BP_ADDED) == 1 ? 1 : 0) != 0);
        this.clearEventCounters();
        IBreakpoints.IBreakpointDMContext[] breakpoints = this.getBreakpoints(this.fBreakpointsDmc);
        Assert.assertTrue((String)("BreakpointService problem: expected 1 breakpoint(s), received " + breakpoints.length), (breakpoints.length == 1 ? 1 : 0) != 0);
        this.removeBreakpoint(ref);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        this.waitForBreakpointEvent();
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT_REMOVED event(s), received " + this.getBreakpointEventCount(this.BP_REMOVED)), (this.getBreakpointEventCount(this.BP_REMOVED) == 1 ? 1 : 0) != 0);
        this.clearEventCounters();
        breakpoints = this.getBreakpoints(this.fBreakpointsDmc);
        Assert.assertTrue((String)("BreakpointService problem: expected 0 breakpoint(s), received " + breakpoints.length), (breakpoints.length == 0 ? 1 : 0) != 0);
        this.removeBreakpoint(saved_ref);
        Assert.assertFalse((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        Assert.assertTrue((String)("Wrong error message: expected '" + expected + "', received '" + this.fWait.getMessage() + "'"), (boolean)this.fWait.getMessage().contains(expected));
        Assert.assertTrue((String)("BreakpointEvent problem: expected 0 BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == 0 ? 1 : 0) != 0);
        breakpoints = this.getBreakpoints(this.fBreakpointsDmc);
        Assert.assertTrue((String)("BreakpointService problem: expected 0 breakpoint(s), received " + breakpoints.length), (breakpoints.length == 0 ? 1 : 0) != 0);
        ref = this.insertBreakpoint(this.fBreakpointsDmc, breakpoint);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        MIBreakpointDMData breakpoint1 = (MIBreakpointDMData)this.getBreakpoint(ref);
        this.waitForBreakpointEvent();
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT_ADDED event(s), received " + this.getBreakpointEventCount(this.BP_ADDED)), (this.getBreakpointEventCount(this.BP_ADDED) == 1 ? 1 : 0) != 0);
        this.clearEventCounters();
        this.removeBreakpoint(saved_ref);
        Assert.assertFalse((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        Assert.assertTrue((String)("Wrong error message: expected '" + expected + "', received '" + this.fWait.getMessage() + "'"), (boolean)this.fWait.getMessage().contains(expected));
        Assert.assertTrue((String)("BreakpointEvent problem: expected 0 BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == 0 ? 1 : 0) != 0);
        breakpoints = this.getBreakpoints(this.fBreakpointsDmc);
        Assert.assertTrue((String)("BreakpointService problem: expected 1 breakpoint(s), received " + breakpoints.length), (breakpoints.length == 1 ? 1 : 0) != 0);
        MIBreakpointDMData breakpoint2 = (MIBreakpointDMData)this.getBreakpoint(breakpoints[0]);
        Assert.assertTrue((String)"BreakpointService problem: breakpoint mismatch", (boolean)breakpoint1.equals(breakpoint2));
    }

    @Test
    public void removeBreakpoint_MixedCase() throws Throwable {
        for (int i = 0; i < 4; ++i) {
            HashMap<String, Object> breakpoint = new HashMap<String, Object>();
            breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.type", "breakpoint");
            breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.fileName", SOURCE_FILE);
            breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.lineNumber", 20 + i);
            this.insertBreakpoint(this.fBreakpointsDmc, breakpoint);
            Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
            int expected = i + 1;
            this.waitForBreakpointEvent();
            Assert.assertTrue((String)("BreakpointEvent problem: expected " + expected + " BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == expected ? 1 : 0) != 0);
            Assert.assertTrue((String)("BreakpointEvent problem: expected " + expected + " BREAKPOINT_ADDED event(s), received " + this.getBreakpointEventCount(this.BP_ADDED)), (this.getBreakpointEventCount(this.BP_ADDED) == expected ? 1 : 0) != 0);
        }
        this.clearEventCounters();
        IBreakpoints.IBreakpointDMContext[] breakpoints = this.getBreakpoints(this.fBreakpointsDmc);
        Assert.assertTrue((String)("BreakpointService problem: expected 4 breakpoint(s), received " + breakpoints.length), (breakpoints.length == 4 ? 1 : 0) != 0);
        int[] indices = new int[]{0, 2, 1, 3};
        int breakpoints_left = 4;
        for (int i = 0; i < breakpoints_left; ++i) {
            IBreakpoints.IBreakpointDMContext index = breakpoints[indices[i]];
            this.removeBreakpoint(index);
            this.fWait.waitUntilDone(0);
            Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
            --breakpoints_left;
            int expected = i + 1;
            this.waitForBreakpointEvent();
            Assert.assertTrue((String)("BreakpointEvent problem: expected " + expected + " BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == expected ? 1 : 0) != 0);
            Assert.assertTrue((String)("BreakpointEvent problem: expected " + expected + " BREAKPOINT_REMOVED event(s), received " + this.getBreakpointEventCount(this.BP_REMOVED)), (this.getBreakpointEventCount(this.BP_REMOVED) == expected ? 1 : 0) != 0);
            IBreakpoints.IBreakpointDMContext[] remaining_breakpoints = this.getBreakpoints(this.fBreakpointsDmc);
            Assert.assertTrue((String)("BreakpointService problem: expected " + breakpoints_left + " breakpoint(s), received " + remaining_breakpoints.length), (remaining_breakpoints.length == breakpoints_left ? 1 : 0) != 0);
            int j = 0;
            while (i < breakpoints_left) {
                Assert.assertTrue((String)("BreakpointService problem: removed breakpoint still present (" + index + ")"), (remaining_breakpoints[j] != index ? 1 : 0) != 0);
                ++i;
            }
        }
        this.clearEventCounters();
    }

    @Test
    public void updateBreakpoint_InvalidBreakpoint() throws Throwable {
        MIBreakpoints.MIBreakpointDMContext invalid_ref = new MIBreakpoints.MIBreakpointDMContext((MIBreakpoints)this.fBreakpointService, new IDMContext[]{this.fBreakpointsDmc}, 0);
        String expected = "Unknown breakpoint";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("org.eclipse.dd.dsf.debug.breakpoint.type", "breakpoint");
        properties.put("org.eclipse.dd.dsf.debug.breakpoint.fileName", SOURCE_FILE);
        properties.put("org.eclipse.dd.dsf.debug.breakpoint.lineNumber", 20);
        this.updateBreakpoint((IBreakpoints.IBreakpointDMContext)invalid_ref, properties);
        Assert.assertFalse((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        Assert.assertTrue((String)("Wrong error message: expected '" + expected + "', received '" + this.fWait.getMessage() + "'"), (boolean)this.fWait.getMessage().contains(expected));
        Assert.assertTrue((String)("BreakpointEvent problem: expected 0 BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == 0 ? 1 : 0) != 0);
    }

    @Test
    public void updateBreakpoint_AddCondition() throws Throwable {
        HashMap<String, Object> breakpoint = new HashMap<String, Object>();
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.type", "breakpoint");
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.fileName", SOURCE_FILE);
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.lineNumber", 20);
        IBreakpoints.IBreakpointDMContext ref = this.insertBreakpoint(this.fBreakpointsDmc, breakpoint);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        this.waitForBreakpointEvent();
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT_ADDED event(s), received " + this.getBreakpointEventCount(this.BP_ADDED)), (this.getBreakpointEventCount(this.BP_ADDED) == 1 ? 1 : 0) != 0);
        this.clearEventCounters();
        HashMap<String, Object> delta = new HashMap<String, Object>();
        delta.put("org.eclipse.dd.dsf.debug.breakpoint.condition", "i == 128");
        this.updateBreakpoint(ref, delta);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        this.waitForBreakpointEvent();
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT_UPDATED event(s), received " + this.getBreakpointEventCount(this.BP_UPDATED)), (this.getBreakpointEventCount(this.BP_UPDATED) == 1 ? 1 : 0) != 0);
        this.clearEventCounters();
        MIBreakpointDMData breakpoint2 = (MIBreakpointDMData)this.getBreakpoint(ref);
        Assert.assertTrue((String)"BreakpointEvent problem: breakpoint mismatch (wrong condition)", (boolean)breakpoint2.getCondition().equals("i == 128"));
    }

    @Test
    public void updateBreakpoint_RemoveCondition() throws Throwable {
        HashMap<String, Object> breakpoint = new HashMap<String, Object>();
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.type", "breakpoint");
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.fileName", SOURCE_FILE);
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.lineNumber", 20);
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.condition", "i == 128");
        IBreakpoints.IBreakpointDMContext ref = this.insertBreakpoint(this.fBreakpointsDmc, breakpoint);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        this.waitForBreakpointEvent();
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT_ADDED event(s), received " + this.getBreakpointEventCount(this.BP_ADDED)), (this.getBreakpointEventCount(this.BP_ADDED) == 1 ? 1 : 0) != 0);
        this.clearEventCounters();
        HashMap<String, Object> delta = new HashMap<String, Object>();
        delta.put("org.eclipse.dd.dsf.debug.breakpoint.condition", null);
        this.updateBreakpoint(ref, delta);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        this.waitForBreakpointEvent();
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT_UPDATED event(s), received " + this.getBreakpointEventCount(this.BP_UPDATED)), (this.getBreakpointEventCount(this.BP_UPDATED) == 1 ? 1 : 0) != 0);
        this.clearEventCounters();
        MIBreakpointDMData breakpoint2 = (MIBreakpointDMData)this.getBreakpoint(ref);
        Assert.assertTrue((String)"BreakpointEvent problem: breakpoint mismatch (wrong condition)", (boolean)breakpoint2.getCondition().equals(""));
    }

    @Test
    public void updateBreakpoint_ModifyCondition() throws Throwable {
        HashMap<String, Object> breakpoint = new HashMap<String, Object>();
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.type", "breakpoint");
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.fileName", SOURCE_FILE);
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.lineNumber", 20);
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.condition", "i == 128");
        IBreakpoints.IBreakpointDMContext ref = this.insertBreakpoint(this.fBreakpointsDmc, breakpoint);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        this.waitForBreakpointEvent();
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT_ADDED event(s), received " + this.getBreakpointEventCount(this.BP_ADDED)), (this.getBreakpointEventCount(this.BP_ADDED) == 1 ? 1 : 0) != 0);
        this.clearEventCounters();
        HashMap<String, Object> delta = new HashMap<String, Object>();
        delta.put("org.eclipse.dd.dsf.debug.breakpoint.condition", "i == 64");
        this.updateBreakpoint(ref, delta);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        this.waitForBreakpointEvent();
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT_UPDATED event(s), received " + this.getBreakpointEventCount(this.BP_UPDATED)), (this.getBreakpointEventCount(this.BP_UPDATED) == 1 ? 1 : 0) != 0);
        this.clearEventCounters();
        MIBreakpointDMData breakpoint2 = (MIBreakpointDMData)this.getBreakpoint(ref);
        Assert.assertTrue((String)"BreakpointEvent problem: breakpoint mismatch (wrong condition)", (boolean)breakpoint2.getCondition().equals("i == 64"));
    }

    @Test
    public void updateWatchpoint_AddCondition() throws Throwable {
        SyncUtil.SyncAddBreakpoint("BreakpointTestApp.cc:20", true);
        SyncUtil.SyncResumeUntilStopped();
        this.clearEventCounters();
        HashMap<String, Object> watchpoint = new HashMap<String, Object>();
        watchpoint.put("org.eclipse.dd.dsf.debug.breakpoint.type", "watchpoint");
        watchpoint.put("org.eclipse.dd.dsf.debug.breakpoint.expression", "charBlock[20]");
        watchpoint.put("org.eclipse.dd.dsf.debug.breakpoint.write", true);
        IBreakpoints.IBreakpointDMContext ref = this.insertBreakpoint(this.fBreakpointsDmc, watchpoint);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        this.waitForBreakpointEvent();
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT_ADDED event(s), received " + this.getBreakpointEventCount(this.BP_ADDED)), (this.getBreakpointEventCount(this.BP_ADDED) == 1 ? 1 : 0) != 0);
        this.clearEventCounters();
        HashMap<String, Object> delta = new HashMap<String, Object>();
        delta.put("org.eclipse.dd.dsf.debug.breakpoint.condition", "i == 128");
        this.updateBreakpoint(ref, delta);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        this.waitForBreakpointEvent();
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT_UPDATED event(s), received " + this.getBreakpointEventCount(this.BP_UPDATED)), (this.getBreakpointEventCount(this.BP_UPDATED) == 1 ? 1 : 0) != 0);
        this.clearEventCounters();
        MIBreakpointDMData watchpoint2 = (MIBreakpointDMData)this.getBreakpoint(ref);
        Assert.assertTrue((String)"BreakpointEvent problem: breakpoint mismatch (wrong condition)", (boolean)watchpoint2.getCondition().equals("i == 128"));
    }

    @Test
    public void updateWatchpoint_RemoveCondition() throws Throwable {
        SyncUtil.SyncAddBreakpoint("BreakpointTestApp.cc:20", true);
        SyncUtil.SyncResumeUntilStopped();
        this.clearEventCounters();
        HashMap<String, Object> watchpoint = new HashMap<String, Object>();
        watchpoint.put("org.eclipse.dd.dsf.debug.breakpoint.type", "watchpoint");
        watchpoint.put("org.eclipse.dd.dsf.debug.breakpoint.expression", "charBlock[20]");
        watchpoint.put("org.eclipse.dd.dsf.debug.breakpoint.write", true);
        watchpoint.put("org.eclipse.dd.dsf.debug.breakpoint.condition", "i == 128");
        IBreakpoints.IBreakpointDMContext ref = this.insertBreakpoint(this.fBreakpointsDmc, watchpoint);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        this.waitForBreakpointEvent();
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT_ADDED event(s), received " + this.getBreakpointEventCount(this.BP_ADDED)), (this.getBreakpointEventCount(this.BP_ADDED) == 1 ? 1 : 0) != 0);
        this.clearEventCounters();
        HashMap<String, Object> delta = new HashMap<String, Object>();
        delta.put("org.eclipse.dd.dsf.debug.breakpoint.condition", null);
        this.updateBreakpoint(ref, delta);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        this.waitForBreakpointEvent();
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT_UPDATED event(s), received " + this.getBreakpointEventCount(this.BP_UPDATED)), (this.getBreakpointEventCount(this.BP_UPDATED) == 1 ? 1 : 0) != 0);
        this.clearEventCounters();
        MIBreakpointDMData watchpoint2 = (MIBreakpointDMData)this.getBreakpoint(ref);
        Assert.assertTrue((String)"BreakpointEvent problem: breakpoint mismatch (wrong condition)", (boolean)watchpoint2.getCondition().equals(""));
    }

    @Test
    public void updateWatchpoint_ModifyCondition() throws Throwable {
        SyncUtil.SyncAddBreakpoint("BreakpointTestApp.cc:20", true);
        SyncUtil.SyncResumeUntilStopped();
        this.clearEventCounters();
        HashMap<String, Object> watchpoint = new HashMap<String, Object>();
        watchpoint.put("org.eclipse.dd.dsf.debug.breakpoint.type", "watchpoint");
        watchpoint.put("org.eclipse.dd.dsf.debug.breakpoint.expression", "charBlock[20]");
        watchpoint.put("org.eclipse.dd.dsf.debug.breakpoint.write", true);
        watchpoint.put("org.eclipse.dd.dsf.debug.breakpoint.condition", "i == 128");
        IBreakpoints.IBreakpointDMContext ref = this.insertBreakpoint(this.fBreakpointsDmc, watchpoint);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        this.waitForBreakpointEvent();
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT_ADDED event(s), received " + this.getBreakpointEventCount(this.BP_ADDED)), (this.getBreakpointEventCount(this.BP_ADDED) == 1 ? 1 : 0) != 0);
        this.clearEventCounters();
        HashMap<String, Object> delta = new HashMap<String, Object>();
        delta.put("org.eclipse.dd.dsf.debug.breakpoint.condition", "i == 64");
        this.updateBreakpoint(ref, delta);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        this.waitForBreakpointEvent();
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT_UPDATED event(s), received " + this.getBreakpointEventCount(this.BP_UPDATED)), (this.getBreakpointEventCount(this.BP_UPDATED) == 1 ? 1 : 0) != 0);
        this.clearEventCounters();
        MIBreakpointDMData watchpoint2 = (MIBreakpointDMData)this.getBreakpoint(ref);
        Assert.assertTrue((String)"BreakpointEvent problem: breakpoint mismatch (wrong condition)", (boolean)watchpoint2.getCondition().equals("i == 64"));
    }

    @Test
    public void updateBreakpoint_AddCount() throws Throwable {
        HashMap<String, Object> breakpoint = new HashMap<String, Object>();
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.type", "breakpoint");
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.fileName", SOURCE_FILE);
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.lineNumber", 20);
        IBreakpoints.IBreakpointDMContext ref = this.insertBreakpoint(this.fBreakpointsDmc, breakpoint);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        this.waitForBreakpointEvent();
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT_ADDED event(s), received " + this.getBreakpointEventCount(this.BP_ADDED)), (this.getBreakpointEventCount(this.BP_ADDED) == 1 ? 1 : 0) != 0);
        this.clearEventCounters();
        HashMap<String, Object> delta = new HashMap<String, Object>();
        delta.put("org.eclipse.dd.dsf.debug.breakpoint.ignoreCount", 20);
        this.updateBreakpoint(ref, delta);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        this.waitForBreakpointEvent();
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT_UPDATED event(s), received " + this.getBreakpointEventCount(this.BP_UPDATED)), (this.getBreakpointEventCount(this.BP_UPDATED) == 1 ? 1 : 0) != 0);
        this.clearEventCounters();
        MIBreakpointDMData breakpoint2 = (MIBreakpointDMData)this.getBreakpoint(ref);
        Assert.assertTrue((String)"BreakpointEvent problem: breakpoint mismatch (wrong count)", (breakpoint2.getIgnoreCount() == 20 ? 1 : 0) != 0);
    }

    @Test
    public void updateBreakpoint_RemoveCount() throws Throwable {
        HashMap<String, Object> breakpoint = new HashMap<String, Object>();
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.type", "breakpoint");
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.fileName", SOURCE_FILE);
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.lineNumber", 20);
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.ignoreCount", 20);
        IBreakpoints.IBreakpointDMContext ref = this.insertBreakpoint(this.fBreakpointsDmc, breakpoint);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        this.waitForBreakpointEvent();
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT_ADDED event(s), received " + this.getBreakpointEventCount(this.BP_ADDED)), (this.getBreakpointEventCount(this.BP_ADDED) == 1 ? 1 : 0) != 0);
        this.clearEventCounters();
        HashMap<String, Object> delta = new HashMap<String, Object>();
        delta.put("org.eclipse.dd.dsf.debug.breakpoint.ignoreCount", null);
        this.updateBreakpoint(ref, delta);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        this.waitForBreakpointEvent();
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT_UPDATED event(s), received " + this.getBreakpointEventCount(this.BP_UPDATED)), (this.getBreakpointEventCount(this.BP_UPDATED) == 1 ? 1 : 0) != 0);
        this.clearEventCounters();
        MIBreakpointDMData breakpoint2 = (MIBreakpointDMData)this.getBreakpoint(ref);
        Assert.assertTrue((String)"BreakpointEvent problem: breakpoint mismatch (wrong count)", (breakpoint2.getIgnoreCount() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void updateBreakpoint_ModifyCount() throws Throwable {
        HashMap<String, Object> breakpoint = new HashMap<String, Object>();
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.type", "breakpoint");
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.fileName", SOURCE_FILE);
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.lineNumber", 20);
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.ignoreCount", 128);
        IBreakpoints.IBreakpointDMContext ref = this.insertBreakpoint(this.fBreakpointsDmc, breakpoint);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        this.waitForBreakpointEvent();
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT_ADDED event(s), received " + this.getBreakpointEventCount(this.BP_ADDED)), (this.getBreakpointEventCount(this.BP_ADDED) == 1 ? 1 : 0) != 0);
        this.clearEventCounters();
        HashMap<String, Object> delta = new HashMap<String, Object>();
        delta.put("org.eclipse.dd.dsf.debug.breakpoint.ignoreCount", 20);
        this.updateBreakpoint(ref, delta);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        this.waitForBreakpointEvent();
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT_UPDATED event(s), received " + this.getBreakpointEventCount(this.BP_UPDATED)), (this.getBreakpointEventCount(this.BP_UPDATED) == 1 ? 1 : 0) != 0);
        this.clearEventCounters();
        MIBreakpointDMData breakpoint2 = (MIBreakpointDMData)this.getBreakpoint(ref);
        Assert.assertTrue((String)"BreakpointEvent problem: breakpoint mismatch (wrong count)", (breakpoint2.getIgnoreCount() == 20 ? 1 : 0) != 0);
    }

    @Test
    public void updateBreakpoint_Disable() throws Throwable {
        HashMap<String, Object> breakpoint = new HashMap<String, Object>();
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.type", "breakpoint");
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.fileName", SOURCE_FILE);
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.lineNumber", 20);
        IBreakpoints.IBreakpointDMContext ref1 = this.insertBreakpoint(this.fBreakpointsDmc, breakpoint);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        breakpoint = new HashMap();
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.type", "breakpoint");
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.fileName", SOURCE_FILE);
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.lineNumber", 21);
        IBreakpoints.IBreakpointDMContext ref2 = this.insertBreakpoint(this.fBreakpointsDmc, breakpoint);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        this.waitForBreakpointEvent();
        Assert.assertTrue((String)("BreakpointEvent problem: expected 2 BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 2 BREAKPOINT_ADDED event(s), received " + this.getBreakpointEventCount(this.BP_ADDED)), (this.getBreakpointEventCount(this.BP_ADDED) == 2 ? 1 : 0) != 0);
        this.clearEventCounters();
        MIBreakpointDMData breakpoint1 = (MIBreakpointDMData)this.getBreakpoint(ref1);
        MIBreakpointDMData breakpoint2 = (MIBreakpointDMData)this.getBreakpoint(ref2);
        Assert.assertTrue((String)"BreakpointService problem: breakpoint state error", (breakpoint1.isEnabled() && breakpoint2.isEnabled() ? 1 : 0) != 0);
        HashMap<String, Object> delta = new HashMap<String, Object>();
        delta.put("org.eclipse.dd.dsf.debug.breakpoint.isEnabled", false);
        this.updateBreakpoint(ref1, delta);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        this.waitForBreakpointEvent();
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT_UPDATED event(s), received " + this.getBreakpointEventCount(this.BP_UPDATED)), (this.getBreakpointEventCount(this.BP_UPDATED) == 1 ? 1 : 0) != 0);
        this.clearEventCounters();
        breakpoint1 = (MIBreakpointDMData)this.getBreakpoint(ref1);
        breakpoint2 = (MIBreakpointDMData)this.getBreakpoint(ref2);
        Assert.assertTrue((String)"BreakpointService problem: breakpoint state error", (!breakpoint1.isEnabled() && breakpoint2.isEnabled() ? 1 : 0) != 0);
        SyncUtil.SyncResumeUntilStopped();
        this.waitForBreakpointEvent();
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT_HIT event(s), received " + this.getBreakpointEventCount(this.BP_HIT)), (this.getBreakpointEventCount(this.BP_HIT) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"BreakpointService problem: breakpoint mismatch", (this.fBreakpointRef == breakpoint2.getNumber() ? 1 : 0) != 0);
        this.clearEventCounters();
    }

    @Test
    public void updateBreakpoint_Enable() throws Throwable {
        HashMap<String, Object> breakpoint = new HashMap<String, Object>();
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.type", "breakpoint");
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.fileName", SOURCE_FILE);
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.lineNumber", 20);
        IBreakpoints.IBreakpointDMContext ref1 = this.insertBreakpoint(this.fBreakpointsDmc, breakpoint);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        breakpoint = new HashMap();
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.type", "breakpoint");
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.fileName", SOURCE_FILE);
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.lineNumber", 21);
        IBreakpoints.IBreakpointDMContext ref2 = this.insertBreakpoint(this.fBreakpointsDmc, breakpoint);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        this.waitForBreakpointEvent();
        Assert.assertTrue((String)("BreakpointEvent problem: expected 2 BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 2 BREAKPOINT_ADDED event(s), received " + this.getBreakpointEventCount(this.BP_ADDED)), (this.getBreakpointEventCount(this.BP_ADDED) == 2 ? 1 : 0) != 0);
        this.clearEventCounters();
        MIBreakpointDMData breakpoint1 = (MIBreakpointDMData)this.getBreakpoint(ref1);
        MIBreakpointDMData breakpoint2 = (MIBreakpointDMData)this.getBreakpoint(ref2);
        Assert.assertTrue((String)"BreakpointService problem: breakpoint state error", (breakpoint1.isEnabled() && breakpoint2.isEnabled() ? 1 : 0) != 0);
        HashMap<String, Object> delta = new HashMap<String, Object>();
        delta.put("org.eclipse.dd.dsf.debug.breakpoint.isEnabled", false);
        this.updateBreakpoint(ref1, delta);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        this.waitForBreakpointEvent();
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT_UPDATED event(s), received " + this.getBreakpointEventCount(this.BP_UPDATED)), (this.getBreakpointEventCount(this.BP_UPDATED) == 1 ? 1 : 0) != 0);
        this.clearEventCounters();
        breakpoint1 = (MIBreakpointDMData)this.getBreakpoint(ref1);
        breakpoint2 = (MIBreakpointDMData)this.getBreakpoint(ref2);
        Assert.assertTrue((String)"BreakpointService problem: breakpoint state error", (!breakpoint1.isEnabled() && breakpoint2.isEnabled() ? 1 : 0) != 0);
        SyncUtil.SyncResumeUntilStopped();
        this.waitForBreakpointEvent();
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT_HIT event(s), received " + this.getBreakpointEventCount(this.BP_HIT)), (this.getBreakpointEventCount(this.BP_HIT) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"BreakpointService problem: breakpoint mismatch", (this.fBreakpointRef == breakpoint2.getNumber() ? 1 : 0) != 0);
        this.clearEventCounters();
        delta = new HashMap();
        delta.put("org.eclipse.dd.dsf.debug.breakpoint.isEnabled", true);
        this.updateBreakpoint(ref1, delta);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        this.waitForBreakpointEvent();
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT_UPDATED event(s), received " + this.getBreakpointEventCount(this.BP_UPDATED)), (this.getBreakpointEventCount(this.BP_UPDATED) == 1 ? 1 : 0) != 0);
        this.clearEventCounters();
        breakpoint1 = (MIBreakpointDMData)this.getBreakpoint(ref1);
        breakpoint2 = (MIBreakpointDMData)this.getBreakpoint(ref2);
        Assert.assertTrue((String)"BreakpointService problem: breakpoint state error", (breakpoint1.isEnabled() && breakpoint2.isEnabled() ? 1 : 0) != 0);
        SyncUtil.SyncResumeUntilStopped();
        this.waitForBreakpointEvent();
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT_HIT event(s), received " + this.getBreakpointEventCount(this.BP_HIT)), (this.getBreakpointEventCount(this.BP_HIT) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"BreakpointService problem: breakpoint mismatch", (this.fBreakpointRef == breakpoint1.getNumber() ? 1 : 0) != 0);
        this.clearEventCounters();
    }

    @Test
    public void breakpointHit_LineNumber() throws Throwable {
        HashMap<String, Object> breakpoint = new HashMap<String, Object>();
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.type", "breakpoint");
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.fileName", SOURCE_FILE);
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.lineNumber", 20);
        MIBreakpoints.MIBreakpointDMContext ref = (MIBreakpoints.MIBreakpointDMContext)this.insertBreakpoint(this.fBreakpointsDmc, breakpoint);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        this.waitForBreakpointEvent();
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT_ADDED event(s), received " + this.getBreakpointEventCount(this.BP_ADDED)), (this.getBreakpointEventCount(this.BP_ADDED) == 1 ? 1 : 0) != 0);
        this.clearEventCounters();
        SyncUtil.SyncResumeUntilStopped();
        this.waitForBreakpointEvent();
        MIBreakpointDMData breakpoint1 = (MIBreakpointDMData)this.getBreakpoint((IBreakpoints.IBreakpointDMContext)ref);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT_HIT event(s), received " + this.getBreakpointEventCount(this.BP_HIT)), (this.getBreakpointEventCount(this.BP_HIT) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"BreakpointService problem: breakpoint mismatch", (this.fBreakpointRef == breakpoint1.getNumber() ? 1 : 0) != 0);
        this.clearEventCounters();
    }

    @Test
    public void breakpointHit_Function() throws Throwable {
        HashMap<String, Object> breakpoint = new HashMap<String, Object>();
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.type", "breakpoint");
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.fileName", SOURCE_FILE);
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.function", "zeroBlocks");
        MIBreakpoints.MIBreakpointDMContext ref = (MIBreakpoints.MIBreakpointDMContext)this.insertBreakpoint(this.fBreakpointsDmc, breakpoint);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        this.waitForBreakpointEvent();
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT_ADDED event(s), received " + this.getBreakpointEventCount(this.BP_ADDED)), (this.getBreakpointEventCount(this.BP_ADDED) == 1 ? 1 : 0) != 0);
        this.clearEventCounters();
        SyncUtil.SyncResumeUntilStopped();
        this.waitForBreakpointEvent();
        MIBreakpointDMData breakpoint1 = (MIBreakpointDMData)this.getBreakpoint((IBreakpoints.IBreakpointDMContext)ref);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT_HIT event(s), received " + this.getBreakpointEventCount(this.BP_HIT)), (this.getBreakpointEventCount(this.BP_HIT) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"BreakpointService problem: breakpoint mismatch", (this.fBreakpointRef == breakpoint1.getNumber() ? 1 : 0) != 0);
        this.clearEventCounters();
    }

    @Test
    public void breakpointHit_Condition() throws Throwable {
        HashMap<String, Object> breakpoint = new HashMap<String, Object>();
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.type", "breakpoint");
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.fileName", SOURCE_FILE);
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.lineNumber", 20);
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.condition", "i == 128");
        MIBreakpoints.MIBreakpointDMContext ref = (MIBreakpoints.MIBreakpointDMContext)this.insertBreakpoint(this.fBreakpointsDmc, breakpoint);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        this.waitForBreakpointEvent();
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT_ADDED event(s), received " + this.getBreakpointEventCount(this.BP_ADDED)), (this.getBreakpointEventCount(this.BP_ADDED) == 1 ? 1 : 0) != 0);
        this.clearEventCounters();
        MIStoppedEvent stoppedEvent = SyncUtil.SyncResumeUntilStopped();
        IStack.IFrameDMContext frameDmc = SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 0);
        this.waitForBreakpointEvent();
        MIBreakpointDMData breakpoint1 = (MIBreakpointDMData)this.getBreakpoint((IBreakpoints.IBreakpointDMContext)ref);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT_HIT event(s), received " + this.getBreakpointEventCount(this.BP_HIT)), (this.getBreakpointEventCount(this.BP_HIT) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"BreakpointService problem: breakpoint mismatch", (this.fBreakpointRef == breakpoint1.getNumber() ? 1 : 0) != 0);
        this.clearEventCounters();
        int i = this.evaluateExpression((IDMContext)frameDmc, "i").intValue();
        Assert.assertTrue((String)"BreakpointEvent problem: breakpoint mismatch (wrong condition)", (i == 128 ? 1 : 0) != 0);
    }

    @Test
    public void breakpointHit_UpdatedCondition() throws Throwable {
        HashMap<String, Object> breakpoint = new HashMap<String, Object>();
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.type", "breakpoint");
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.fileName", SOURCE_FILE);
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.lineNumber", 20);
        MIBreakpoints.MIBreakpointDMContext ref = (MIBreakpoints.MIBreakpointDMContext)this.insertBreakpoint(this.fBreakpointsDmc, breakpoint);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        this.waitForBreakpointEvent();
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT_ADDED event(s), received " + this.getBreakpointEventCount(this.BP_ADDED)), (this.getBreakpointEventCount(this.BP_ADDED) == 1 ? 1 : 0) != 0);
        this.clearEventCounters();
        HashMap<String, Object> delta = new HashMap<String, Object>();
        delta.put("org.eclipse.dd.dsf.debug.breakpoint.condition", "i == 128");
        this.updateBreakpoint((IBreakpoints.IBreakpointDMContext)ref, delta);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        this.waitForBreakpointEvent();
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT_UPDATED event(s), received " + this.getBreakpointEventCount(this.BP_UPDATED)), (this.getBreakpointEventCount(this.BP_UPDATED) == 1 ? 1 : 0) != 0);
        this.clearEventCounters();
        MIStoppedEvent stoppedEvent = SyncUtil.SyncResumeUntilStopped();
        IStack.IFrameDMContext frameDmc = SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 0);
        this.waitForBreakpointEvent();
        MIBreakpointDMData breakpoint1 = (MIBreakpointDMData)this.getBreakpoint((IBreakpoints.IBreakpointDMContext)ref);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT_HIT event(s), received " + this.getBreakpointEventCount(this.BP_HIT)), (this.getBreakpointEventCount(this.BP_HIT) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"BreakpointService problem: breakpoint mismatch", (this.fBreakpointRef == breakpoint1.getNumber() ? 1 : 0) != 0);
        this.clearEventCounters();
        int i = this.evaluateExpression((IDMContext)frameDmc, "i").intValue();
        Assert.assertTrue((String)"BreakpointEvent problem: breakpoint mismatch (wrong condition)", (i == 128 ? 1 : 0) != 0);
    }

    @Test
    public void breakpointHit_Count() throws Throwable {
        HashMap<String, Object> breakpoint = new HashMap<String, Object>();
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.type", "breakpoint");
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.fileName", SOURCE_FILE);
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.lineNumber", 20);
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.ignoreCount", 20);
        MIBreakpoints.MIBreakpointDMContext ref = (MIBreakpoints.MIBreakpointDMContext)this.insertBreakpoint(this.fBreakpointsDmc, breakpoint);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        this.waitForBreakpointEvent();
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT_ADDED event(s), received " + this.getBreakpointEventCount(this.BP_ADDED)), (this.getBreakpointEventCount(this.BP_ADDED) == 1 ? 1 : 0) != 0);
        this.clearEventCounters();
        MIStoppedEvent stoppedEvent = SyncUtil.SyncResumeUntilStopped();
        IStack.IFrameDMContext frameDmc = SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 0);
        this.waitForBreakpointEvent();
        MIBreakpointDMData breakpoint1 = (MIBreakpointDMData)this.getBreakpoint((IBreakpoints.IBreakpointDMContext)ref);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT_HIT event(s), received " + this.getBreakpointEventCount(this.BP_HIT)), (this.getBreakpointEventCount(this.BP_HIT) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"BreakpointService problem: breakpoint mismatch", (this.fBreakpointRef == breakpoint1.getNumber() ? 1 : 0) != 0);
        this.clearEventCounters();
        int i = this.evaluateExpression((IDMContext)frameDmc, "i").intValue();
        Assert.assertTrue((String)"BreakpointEvent problem: breakpoint mismatch (wrong condition)", (i == 20 ? 1 : 0) != 0);
    }

    @Test
    public void breakpointHit_UpdatedCount() throws Throwable {
        HashMap<String, Object> breakpoint = new HashMap<String, Object>();
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.type", "breakpoint");
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.fileName", SOURCE_FILE);
        breakpoint.put("org.eclipse.dd.dsf.debug.breakpoint.lineNumber", 20);
        MIBreakpoints.MIBreakpointDMContext ref = (MIBreakpoints.MIBreakpointDMContext)this.insertBreakpoint(this.fBreakpointsDmc, breakpoint);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        this.waitForBreakpointEvent();
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT_ADDED event(s), received " + this.getBreakpointEventCount(this.BP_ADDED)), (this.getBreakpointEventCount(this.BP_ADDED) == 1 ? 1 : 0) != 0);
        this.clearEventCounters();
        HashMap<String, Object> delta = new HashMap<String, Object>();
        delta.put("org.eclipse.dd.dsf.debug.breakpoint.ignoreCount", 20);
        this.updateBreakpoint((IBreakpoints.IBreakpointDMContext)ref, delta);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        this.waitForBreakpointEvent();
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT_UPDATED event(s), received " + this.getBreakpointEventCount(this.BP_UPDATED)), (this.getBreakpointEventCount(this.BP_UPDATED) == 1 ? 1 : 0) != 0);
        this.clearEventCounters();
        MIStoppedEvent stoppedEvent = SyncUtil.SyncResumeUntilStopped();
        IStack.IFrameDMContext frameDmc = SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 0);
        this.waitForBreakpointEvent();
        MIBreakpointDMData breakpoint1 = (MIBreakpointDMData)this.getBreakpoint((IBreakpoints.IBreakpointDMContext)ref);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT_HIT event(s), received " + this.getBreakpointEventCount(this.BP_HIT)), (this.getBreakpointEventCount(this.BP_HIT) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"BreakpointService problem: breakpoint mismatch", (this.fBreakpointRef == breakpoint1.getNumber() ? 1 : 0) != 0);
        this.clearEventCounters();
        int i = this.evaluateExpression((IDMContext)frameDmc, "i").intValue();
        Assert.assertTrue((String)"BreakpointEvent problem: breakpoint mismatch (wrong condition)", (i == 20 ? 1 : 0) != 0);
    }

    @Test
    public void breakpointHit_WriteWatchpoint() throws Throwable {
        HashMap<String, Object> watchpoint = new HashMap<String, Object>();
        watchpoint.put("org.eclipse.dd.dsf.debug.breakpoint.type", "watchpoint");
        watchpoint.put("org.eclipse.dd.dsf.debug.breakpoint.expression", "charBlock[20]");
        watchpoint.put("org.eclipse.dd.dsf.debug.breakpoint.write", true);
        IBreakpoints.IBreakpointDMContext ref = this.insertBreakpoint(this.fBreakpointsDmc, watchpoint);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        this.waitForBreakpointEvent();
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT_ADDED event(s), received " + this.getBreakpointEventCount(this.BP_ADDED)), (this.getBreakpointEventCount(this.BP_ADDED) == 1 ? 1 : 0) != 0);
        this.clearEventCounters();
        MIStoppedEvent stoppedEvent = SyncUtil.SyncResumeUntilStopped();
        IStack.IFrameDMContext frameDmc = SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 0);
        this.waitForBreakpointEvent();
        MIBreakpointDMData watchpoint1 = (MIBreakpointDMData)this.getBreakpoint(ref);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 WATCHPOINT_HIT event(s), received " + this.getBreakpointEventCount(this.WP_HIT)), (this.getBreakpointEventCount(this.WP_HIT) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"BreakpointService problem: watchpoint mismatch", (this.fBreakpointRef == watchpoint1.getNumber() ? 1 : 0) != 0);
        this.clearEventCounters();
        int i = this.evaluateExpression((IDMContext)frameDmc, "i").intValue();
        Assert.assertTrue((String)"BreakpointEvent problem: breakpoint mismatch (wrong condition)", (i == 20 ? 1 : 0) != 0);
    }

    @Test
    public void breakpointHit_ReadWatchpoint() throws Throwable {
        HashMap<String, Object> watchpoint = new HashMap<String, Object>();
        watchpoint.put("org.eclipse.dd.dsf.debug.breakpoint.type", "watchpoint");
        watchpoint.put("org.eclipse.dd.dsf.debug.breakpoint.expression", "charBlock[20]");
        watchpoint.put("org.eclipse.dd.dsf.debug.breakpoint.read", true);
        IBreakpoints.IBreakpointDMContext ref = this.insertBreakpoint(this.fBreakpointsDmc, watchpoint);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        this.waitForBreakpointEvent();
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT_ADDED event(s), received " + this.getBreakpointEventCount(this.BP_ADDED)), (this.getBreakpointEventCount(this.BP_ADDED) == 1 ? 1 : 0) != 0);
        this.clearEventCounters();
        MIStoppedEvent stoppedEvent = SyncUtil.SyncResumeUntilStopped();
        IStack.IFrameDMContext frameDmc = SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 0);
        this.waitForBreakpointEvent();
        MIBreakpointDMData watchpoint1 = (MIBreakpointDMData)this.getBreakpoint(ref);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 WATCHPOINT_HIT event(s), received " + this.getBreakpointEventCount(this.WP_HIT)), (this.getBreakpointEventCount(this.WP_HIT) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"BreakpointService problem: watchpoint mismatch", (this.fBreakpointRef == watchpoint1.getNumber() ? 1 : 0) != 0);
        this.clearEventCounters();
        int i = this.evaluateExpression((IDMContext)frameDmc, "i").intValue();
        Assert.assertTrue((String)"BreakpointEvent problem: breakpoint mismatch (wrong condition)", (i == 20 ? 1 : 0) != 0);
    }

    @Test
    public void breakpointHit_AccessWatchpoint() throws Throwable {
        HashMap<String, Object> watchpoint = new HashMap<String, Object>();
        watchpoint.put("org.eclipse.dd.dsf.debug.breakpoint.type", "watchpoint");
        watchpoint.put("org.eclipse.dd.dsf.debug.breakpoint.expression", "charBlock[20]");
        watchpoint.put("org.eclipse.dd.dsf.debug.breakpoint.read", true);
        watchpoint.put("org.eclipse.dd.dsf.debug.breakpoint.write", true);
        IBreakpoints.IBreakpointDMContext ref = this.insertBreakpoint(this.fBreakpointsDmc, watchpoint);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        this.waitForBreakpointEvent();
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT_ADDED event(s), received " + this.getBreakpointEventCount(this.BP_ADDED)), (this.getBreakpointEventCount(this.BP_ADDED) == 1 ? 1 : 0) != 0);
        this.clearEventCounters();
        MIStoppedEvent stoppedEvent = SyncUtil.SyncResumeUntilStopped();
        IStack.IFrameDMContext frameDmc = SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 0);
        this.waitForBreakpointEvent();
        MIBreakpointDMData watchpoint1 = (MIBreakpointDMData)this.getBreakpoint(ref);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 WATCHPOINT_HIT event(s), received " + this.getBreakpointEventCount(this.WP_HIT)), (this.getBreakpointEventCount(this.WP_HIT) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"BreakpointService problem: watchpoint mismatch", (this.fBreakpointRef == watchpoint1.getNumber() ? 1 : 0) != 0);
        this.clearEventCounters();
        int i = this.evaluateExpression((IDMContext)frameDmc, "i").intValue();
        Assert.assertTrue((String)"BreakpointEvent problem: breakpoint mismatch (wrong condition)", (i == 20 ? 1 : 0) != 0);
    }

    @Test
    public void breakpointHit_watchpointUpdateCount() throws Throwable {
        SyncUtil.SyncAddBreakpoint("BreakpointTestApp.cc:27", true);
        SyncUtil.SyncAddBreakpoint("BreakpointTestApp.cc:35", true);
        SyncUtil.SyncResumeUntilStopped();
        this.clearEventCounters();
        HashMap<String, Object> watchpoint = new HashMap<String, Object>();
        watchpoint.put("org.eclipse.dd.dsf.debug.breakpoint.type", "watchpoint");
        watchpoint.put("org.eclipse.dd.dsf.debug.breakpoint.expression", "j");
        watchpoint.put("org.eclipse.dd.dsf.debug.breakpoint.write", true);
        IBreakpoints.IBreakpointDMContext ref = this.insertBreakpoint(this.fBreakpointsDmc, watchpoint);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        this.waitForBreakpointEvent();
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT_ADDED event(s), received " + this.getBreakpointEventCount(this.BP_ADDED)), (this.getBreakpointEventCount(this.BP_ADDED) == 1 ? 1 : 0) != 0);
        this.clearEventCounters();
        HashMap<String, Object> delta = new HashMap<String, Object>();
        delta.put("org.eclipse.dd.dsf.debug.breakpoint.ignoreCount", 20);
        this.updateBreakpoint(ref, delta);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        this.waitForBreakpointEvent();
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT_UPDATED event(s), received " + this.getBreakpointEventCount(this.BP_UPDATED)), (this.getBreakpointEventCount(this.BP_UPDATED) == 1 ? 1 : 0) != 0);
        this.clearEventCounters();
        MIStoppedEvent stoppedEvent = SyncUtil.SyncResumeUntilStopped();
        IStack.IFrameDMContext frameDmc = SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 0);
        this.waitForBreakpointEvent();
        MIBreakpointDMData watchpoint1 = (MIBreakpointDMData)this.getBreakpoint(ref);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 WATCHPOINT_HIT event(s), received " + this.getBreakpointEventCount(this.WP_HIT)), (this.getBreakpointEventCount(this.WP_HIT) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"BreakpointService problem: watchpoint mismatch", (this.fBreakpointRef == watchpoint1.getNumber() ? 1 : 0) != 0);
        this.clearEventCounters();
        int j = this.evaluateExpression((IDMContext)frameDmc, "j").intValue();
        Assert.assertTrue((String)"BreakpointEvent problem: breakpoint mismatch (wrong condition)", (j == 20 ? 1 : 0) != 0);
    }

    @Ignore
    @Test
    public void breakpointHit_watchpointUpdateCondition() throws Throwable {
        SyncUtil.SyncAddBreakpoint("BreakpointTestApp.cc:27", true);
        SyncUtil.SyncAddBreakpoint("BreakpointTestApp.cc:35", true);
        SyncUtil.SyncResumeUntilStopped();
        this.clearEventCounters();
        HashMap<String, Object> watchpoint = new HashMap<String, Object>();
        watchpoint.put("org.eclipse.dd.dsf.debug.breakpoint.type", "watchpoint");
        watchpoint.put("org.eclipse.dd.dsf.debug.breakpoint.expression", "j");
        watchpoint.put("org.eclipse.dd.dsf.debug.breakpoint.write", true);
        IBreakpoints.IBreakpointDMContext ref = this.insertBreakpoint(this.fBreakpointsDmc, watchpoint);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        this.waitForBreakpointEvent();
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT_ADDED event(s), received " + this.getBreakpointEventCount(this.BP_ADDED)), (this.getBreakpointEventCount(this.BP_ADDED) == 1 ? 1 : 0) != 0);
        this.clearEventCounters();
        HashMap<String, Object> delta = new HashMap<String, Object>();
        delta.put("org.eclipse.dd.dsf.debug.breakpoint.condition", "j == 20");
        this.updateBreakpoint(ref, delta);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        this.waitForBreakpointEvent();
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT_UPDATED event(s), received " + this.getBreakpointEventCount(this.BP_UPDATED)), (this.getBreakpointEventCount(this.BP_UPDATED) == 1 ? 1 : 0) != 0);
        this.clearEventCounters();
        MIStoppedEvent stoppedEvent = SyncUtil.SyncResumeUntilStopped();
        IStack.IFrameDMContext frameDmc = SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 0);
        this.waitForBreakpointEvent();
        MIBreakpointDMData watchpoint1 = (MIBreakpointDMData)this.getBreakpoint(ref);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 WATCHPOINT_HIT event(s), received " + this.getBreakpointEventCount(this.WP_HIT)), (this.getBreakpointEventCount(this.WP_HIT) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"BreakpointService problem: watchpoint mismatch", (this.fBreakpointRef == watchpoint1.getNumber() ? 1 : 0) != 0);
        this.clearEventCounters();
        int j = this.evaluateExpression((IDMContext)frameDmc, "j").intValue();
        Assert.assertTrue((String)"BreakpointEvent problem: breakpoint mismatch (wrong condition)", (j == 20 ? 1 : 0) != 0);
    }

    @Ignore
    @Test
    public void breakpointHit_WatchpointOutOfScope() throws Throwable {
        SyncUtil.SyncAddBreakpoint("BreakpointTestApp.cc:20", true);
        SyncUtil.SyncAddBreakpoint("BreakpointTestApp.cc:27", true);
        SyncUtil.SyncResumeUntilStopped();
        this.clearEventCounters();
        HashMap<String, Object> watchpoint = new HashMap<String, Object>();
        watchpoint.put("org.eclipse.dd.dsf.debug.breakpoint.type", "watchpoint");
        watchpoint.put("org.eclipse.dd.dsf.debug.breakpoint.expression", "j");
        watchpoint.put("org.eclipse.dd.dsf.debug.breakpoint.read", true);
        watchpoint.put("org.eclipse.dd.dsf.debug.breakpoint.write", true);
        IBreakpoints.IBreakpointDMContext ref = this.insertBreakpoint(this.fBreakpointsDmc, watchpoint);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        this.waitForBreakpointEvent();
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT_ADDED event(s), received " + this.getBreakpointEventCount(this.BP_ADDED)), (this.getBreakpointEventCount(this.BP_ADDED) == 1 ? 1 : 0) != 0);
        this.clearEventCounters();
        SyncUtil.SyncResumeUntilStopped();
        this.waitForBreakpointEvent();
        MIBreakpointDMData watchpoint1 = (MIBreakpointDMData)this.getBreakpoint(ref);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 BREAKPOINT event(s), received " + this.fBreakpointEventCount), (this.fBreakpointEventCount == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("BreakpointEvent problem: expected 1 WATCHPOINT_HIT event(s), received " + this.getBreakpointEventCount(this.WP_OOS)), (this.getBreakpointEventCount(this.WP_OOS) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"BreakpointService problem: watchpoint mismatch", (this.fBreakpointRef == watchpoint1.getNumber() ? 1 : 0) != 0);
        this.clearEventCounters();
        this.getBreakpoints(this.fBreakpointsDmc);
        watchpoint1 = (MIBreakpointDMData)this.getBreakpoint(ref);
        Assert.assertTrue((String)"BreakpointEvent problem: expected watchpoint to be deleted after going out of scope", (watchpoint1 == null ? 1 : 0) != 0);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Events {
        BP_ADDED,
        BP_UPDATED,
        BP_REMOVED,
        BP_HIT,
        WP_HIT,
        WP_OOS;

    }
}

