/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.tests.gdb.framework;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dd.gdb.internal.provisional.launching.GdbLaunch;
import org.eclipse.dd.mi.service.command.events.MIStoppedEvent;
import org.eclipse.dd.tests.gdb.framework.ServiceEventWaitor;
import org.eclipse.dd.tests.gdb.framework.SyncUtil;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;

public class BaseTestCase {
    private static final String DEFAULT_TEST_APP = "data/launch/bin/GDBMIGenericTestApp";
    private static GdbLaunch fLaunch;
    private static Map<String, Object> attrs;
    private MIStoppedEvent fInitialStoppedEvent = null;

    public GdbLaunch getGDBLaunch() {
        return fLaunch;
    }

    public static void setLaunchAttribute(String key, Object value) {
        attrs.put(key, value);
    }

    public MIStoppedEvent getInitialStoppedEvent() {
        return this.fInitialStoppedEvent;
    }

    @BeforeClass
    public static void baseBeforeClassMethod() {
        attrs.put("org.eclipse.cdt.launch.PROGRAM_NAME", DEFAULT_TEST_APP);
        attrs.put("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN", true);
        attrs.put("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN_SYMBOL", "main");
        attrs.put("org.eclipse.dd.gdb.DEBUG_NAME", "gdb");
        attrs.put("org.eclipse.dd.gdb.GDB_INIT", ".gdbinit");
        attrs.put("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "run");
    }

    @Before
    public void baseBeforeMethod() throws Exception {
        System.out.println("====================================================================");
        System.out.println("Launching test application: " + attrs.get("org.eclipse.cdt.launch.PROGRAM_NAME"));
        System.out.println("====================================================================");
        ILaunchManager launchMgr = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType lcType = launchMgr.getLaunchConfigurationType("org.eclipse.dd.tests.gdb.TestLaunch");
        assert (lcType != null);
        ILaunchConfigurationWorkingCopy lcWorkingCopy = lcType.newInstance(null, launchMgr.generateUniqueLaunchConfigurationNameFrom("Test Launch"));
        assert (lcWorkingCopy != null);
        lcWorkingCopy.setAttributes(attrs);
        ILaunchConfiguration lc = lcWorkingCopy.doSave();
        assert (lc != null);
        fLaunch = (GdbLaunch)lc.launch("debug", (IProgressMonitor)new NullProgressMonitor());
        assert (fLaunch != null);
        SyncUtil.initialize(fLaunch.getSession());
        try {
            ServiceEventWaitor<MIStoppedEvent> eventWaitor = new ServiceEventWaitor<MIStoppedEvent>(fLaunch.getSession(), MIStoppedEvent.class);
            this.fInitialStoppedEvent = eventWaitor.waitForEvent(10000);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    @After
    public void baseAfterMethod() throws Exception {
        System.out.println("====================================================================");
        System.out.println("Tearing down test application: " + attrs.get("org.eclipse.cdt.launch.PROGRAM_NAME"));
        System.out.println("====================================================================");
        if (fLaunch != null) {
            fLaunch.terminate();
            fLaunch = null;
        }
    }

    @AfterClass
    public static void baseAfterClassMehod() throws Exception {
    }

    static {
        attrs = new HashMap<String, Object>();
    }
}

