/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.editor.core.library;

import java.io.File;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.dd.ipxact.editor.core.document.Vlnv;
import org.eclipse.dd.ipxact.editor.core.library.FileDetails;
import org.eclipse.dd.ipxact.editor.core.library.SpiritLibrary;

public class SpiritFileLibrary
extends SpiritLibrary {
    private static final long serialVersionUID = -7113777684993598781L;
    public static final QualifiedName EXCLUDED_RESOURCE_PROPERTY = new QualifiedName("org.eclipse.dd.ipxact.editor.core", "SpiritResourceLibrary.ExcludeResourceProperty");
    private static SpiritFileLibrary defaultNonPluginSpiritLibrary;

    private SpiritFileLibrary() {
    }

    public static SpiritFileLibrary getNonPluginDefault() {
        if (defaultNonPluginSpiritLibrary == null) {
            defaultNonPluginSpiritLibrary = new SpiritFileLibrary();
        }
        return defaultNonPluginSpiritLibrary;
    }

    public SpiritFileLibrary(SpiritLibrary original) throws Exception {
        for (FileDetails fileDetails : original.getFileDetails()) {
            File file = fileDetails.getFile();
            if (!file.exists()) continue;
            this.addFileInternal(file);
        }
    }

    public static SpiritFileLibrary getInstance() {
        return new SpiritFileLibrary();
    }

    protected void fireModelChanged() {
    }

    protected void fireDuplicateAdded(FileDetails fileDetails, FileDetails primaryEntry) {
    }

    protected void fireDuplicateRemoved(FileDetails fileDetails, FileDetails primaryEntry) {
    }

    public Vlnv addFile(File file) throws Exception {
        return this.addFileInternal(file);
    }

    public static boolean isSpiritFile(File file) {
        String name = file.getName();
        return SpiritFileLibrary.getSpiritFileExtensionList().contains(SpiritFileLibrary.getExtension(name).toLowerCase());
    }
}

