/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.editor.core.schema;

import java.util.HashMap;

public class SchemaInfo {
    private static HashMap<String, String> translate_1_2 = new HashMap();
    private static HashMap<String, String> translate_1_4 = new HashMap();

    public static boolean isSpiritNamespace(String namespace) {
        String[] SPIRIT_NAMESPACE = new String[]{"http://www.spiritconsortium.org/XMLSchema/SPIRIT/1.0", "http://www.spiritconsortium.org/XMLSchema/SPIRIT/1.1", "http://www.spiritconsortium.org/XMLSchema/SPIRIT/1.2", "http://www.spiritconsortium.org/XMLSchema/SPIRIT/1.4"};
        for (int i = 0; i < SPIRIT_NAMESPACE.length; ++i) {
            if (!SPIRIT_NAMESPACE[i].equals(namespace)) continue;
            return true;
        }
        return false;
    }

    public static IpxactVersion getIpxactVersion(String namespace) {
        IpxactVersion ipxactVersion = null;
        if (SchemaInfo.isSpiritNamespace(namespace)) {
            char integer_AsChar = namespace.charAt(namespace.length() - 3);
            char fraction_AsChar = namespace.charAt(namespace.length() - 1);
            int integer = integer_AsChar - 48;
            int fraction = fraction_AsChar - 48;
            block0 : switch (integer) {
                case 0: 
                case 1: {
                    switch (fraction) {
                        case 1: 
                        case 2: 
                        case 3: {
                            ipxactVersion = IpxactVersion.BEFORE_V14;
                            break block0;
                        }
                        case 4: {
                            ipxactVersion = IpxactVersion.V14;
                        }
                    }
                }
            }
        }
        return ipxactVersion;
    }

    public static String getSpiritString(String in, String namespace) {
        IpxactVersion ipxactVersion = SchemaInfo.getIpxactVersion(namespace);
        return SchemaInfo.getSpiritString(in, ipxactVersion);
    }

    public static String getSpiritString(String in, IpxactVersion version) {
        String out = null;
        switch (version) {
            case BEFORE_V14: {
                out = translate_1_2.get(in);
                break;
            }
            case V14: {
                out = translate_1_4.get(in);
            }
        }
        if (out == null) {
            out = in;
        }
        return out;
    }

    static {
        translate_1_4.put("signal", "port");
        translate_1_4.put("Signal", "Port");
        translate_1_4.put("busSignalName", "busPortName");
        translate_1_4.put("componentSignalName", "componentPortName");
        translate_1_4.put("signalConstraintSets", "portConstraintSets");
        translate_1_4.put("signalMap", "portMaps");
        translate_1_4.put("signalName", "portMap");
        translate_1_4.put("interfaceName", "interfaceRef");
        translate_1_4.put("interfaceType", "interfaceMode");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IpxactVersion {
        BEFORE_V14,
        V14;

    }
}

