/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.editor.core.spiritnodes;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDocument;
import org.eclipse.dd.ipxact.editor.core.document.Vlnv;
import org.eclipse.dd.ipxact.editor.core.library.SpiritLibrary;
import org.eclipse.dd.ipxact.editor.core.library.SpiritResourceLibrary;
import org.eclipse.dd.ipxact.editor.core.schema.SchemaInfo;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.ActiveOrMonitorInterface;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.AddressBlock;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.Bank;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.BusInterface;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.Channel;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.ComponentInstanceNode;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.ComponentSignal;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.DriveConstraint;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.Field;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.Interconnection;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.LoadConstraint;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.ModelParameter;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.OnMaster;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.Register;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.SignalMapElement;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.SpiritSignal;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.TimingConstraint;
import org.eclipse.dd.ipxact.editor.core.utils.Decode;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpiritNode {
    protected final Element node;
    protected Document base;
    protected String namespaceURI = null;
    private SchemaInfo.IpxactVersion schemaVersion = null;
    protected String context;

    public SpiritNode(Element element) {
        this.node = element;
        this.context = "";
    }

    public static SpiritNode createSpiritNode(SpiritNode spiritNode) {
        return SpiritNode.createSpiritNode(spiritNode.node);
    }

    public static SpiritNode createSpiritNode(Element element) {
        if (element == null) {
            return null;
        }
        String tag = element.getLocalName();
        String namespace = element.getNamespaceURI();
        SchemaInfo.IpxactVersion schemaVersion = SchemaInfo.getIpxactVersion(namespace);
        SpiritNode result = SchemaInfo.getSpiritString("activeInterface", schemaVersion).equals(tag) || SchemaInfo.getSpiritString("monitorInterface", schemaVersion).equals(tag) ? new ActiveOrMonitorInterface(element) : (SchemaInfo.getSpiritString("busInterface", schemaVersion).equals(tag) ? new BusInterface(element) : (SchemaInfo.getSpiritString("channel", schemaVersion).equals(tag) ? new Channel(element) : (SchemaInfo.getSpiritString("componentInstance", schemaVersion).equals(tag) ? new ComponentInstanceNode(element) : (SchemaInfo.getSpiritString("field", schemaVersion).equals(tag) ? new Field(element) : (SchemaInfo.getSpiritString("interconnection", schemaVersion).equals(tag) ? new Interconnection(element) : (SchemaInfo.getSpiritString("modelParameter", schemaVersion).equals(tag) ? new ModelParameter(element) : (SchemaInfo.getSpiritString("register", schemaVersion).equals(tag) ? new Register(element) : (SchemaInfo.getSpiritString("signalName", schemaVersion).equals(tag) ? new SignalMapElement(element) : (SchemaInfo.getSpiritString("bank", schemaVersion).equals(tag) ? new Bank(element) : (SchemaInfo.getSpiritString("addressBlock", schemaVersion).equals(tag) ? new AddressBlock(element) : (SchemaInfo.getSpiritString("onMaster", schemaVersion).equals(tag) ? new OnMaster(element) : (SchemaInfo.getSpiritString("timingConstraint", schemaVersion).equals(tag) ? new TimingConstraint(element) : (SchemaInfo.getSpiritString("driveConstraint", schemaVersion).equals(tag) ? new DriveConstraint(element) : (SchemaInfo.getSpiritString("loadConstraint", schemaVersion).equals(tag) ? new LoadConstraint(element) : (SchemaInfo.getSpiritString("signal", schemaVersion).equals(tag) ? (element.getOwnerDocument().getDocumentElement().getLocalName().equals("component") ? new ComponentSignal(element) : new SpiritSignal(element)) : new SpiritNode(element))))))))))))))));
        return result;
    }

    public Element getNode() {
        return this.node;
    }

    public String getName() {
        return this.getUniqueChildText("name");
    }

    public void setContext(String context) {
        this.context = context;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.context != null && this.context.length() > 0) {
            sb.append(this.context);
            sb.append('/');
        }
        sb.append(this.getName());
        return sb.toString();
    }

    public SchemaInfo.IpxactVersion schemaVersion() {
        if (this.schemaVersion == null) {
            this.schemaVersion = SchemaInfo.getIpxactVersion(this.getNamespaceURI());
        }
        return this.schemaVersion;
    }

    protected <T extends SpiritNode> T getUniqueChildElement(String tag, Class<T> clazz) {
        String localTag = SchemaInfo.getSpiritString(tag, this.schemaVersion());
        try {
            Constructor<T> constructor = clazz.getConstructor(Element.class);
            for (Node child = this.node.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getNodeType() != 1 || !child.getNamespaceURI().equals(this.getNamespaceURI()) || !child.getLocalName().equals(localTag)) continue;
                return (T)((SpiritNode)constructor.newInstance(child));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public String getUniqueChildText(String tag) {
        SpiritNode e = this.getUniqueChildElement(tag, SpiritNode.class);
        if (e == null) {
            return "";
        }
        return e.getTextContent().trim();
    }

    public <T extends SpiritNode> T getUniqueDescendantElement(String tag, Class<T> clazz) {
        String localTag = SchemaInfo.getSpiritString(tag, this.schemaVersion());
        NodeList list = this.node.getElementsByTagNameNS(this.getNamespaceURI(), localTag);
        if (list == null || list.getLength() == 0) {
            return null;
        }
        try {
            Constructor<T> c = clazz.getConstructor(Element.class);
            return (T)((SpiritNode)c.newInstance((Element)list.item(0)));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getUniqueDescendantText(String tag) {
        SpiritNode e = this.getUniqueDescendantElement(tag, SpiritNode.class);
        if (e == null) {
            return "";
        }
        return e.getTextContent().trim();
    }

    public NodeList getDescendants(String tag) {
        String localTag = SchemaInfo.getSpiritString(tag, this.schemaVersion());
        return this.node.getElementsByTagNameNS(this.getNamespaceURI(), localTag);
    }

    public <T extends SpiritNode> List<T> getDescendants(String tag, Class<T> target) {
        ArrayList<T> result = new ArrayList<T>();
        try {
            Constructor<T> constructor = target.getConstructor(Element.class);
            NodeList nodes = this.getDescendants(tag);
            for (int i = 0; i < nodes.getLength(); ++i) {
                result.add(constructor.newInstance((Element)nodes.item(i)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String getTextContent(Node n) {
        Node child;
        for (child = n.getFirstChild(); child != null && child.getNodeType() != 3; child = child.getNextSibling()) {
        }
        if (child == null) {
            return "";
        }
        return child.getNodeValue();
    }

    protected <T extends SpiritNode> List<T> getChildren(String tag, Class<T> clazz) {
        ArrayList<T> result = new ArrayList<T>();
        try {
            Constructor<T> constructor = clazz.getConstructor(Element.class);
            String localTag = SchemaInfo.getSpiritString(tag, this.schemaVersion());
            for (Node child = this.node.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getNodeType() != 1 || !child.getNamespaceURI().equals(this.getNamespaceURI()) || !child.getLocalName().equals(localTag)) continue;
                result.add(constructor.newInstance((Element)child));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public String getSpiritAttribute(String a) {
        return this.node.getAttributeNS(this.getNamespaceURI(), SchemaInfo.getSpiritString(a, this.schemaVersion()));
    }

    public boolean hasSpiritAttribute(String a) {
        return this.node.hasAttributeNS(this.getNamespaceURI(), SchemaInfo.getSpiritString(a, this.schemaVersion()));
    }

    public Vlnv getVlnvAttribute() {
        Element node = this.node;
        String vendor = node.getAttributeNS(this.getNamespaceURI(), "vendor");
        String library = node.getAttributeNS(this.getNamespaceURI(), "library");
        String name = node.getAttributeNS(this.getNamespaceURI(), "name");
        String version = node.getAttributeNS(this.getNamespaceURI(), "version");
        Vlnv vlnv = new Vlnv(vendor, library, name, version);
        return vlnv;
    }

    public NodeList getNodeList(Vlnv vlnv, SpiritLibrary Library, String localName) {
        SpiritDocument spiritDocument = Library.get(vlnv);
        return spiritDocument.getDescendants(localName);
    }

    public NodeList getRefNodeList(String tag) {
        return this.getNodeList(this.getVlnvAttribute(), tag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeList getNodeList(Vlnv vlnv, String localName) {
        SpiritResourceLibrary Library = SpiritResourceLibrary.getDefault();
        try {
            Library.lockUpdates();
            SpiritDocument document = Library.get(vlnv);
            NodeList nodeList = document.getDescendants(localName);
            return nodeList;
        }
        finally {
            Library.unlockUpdates();
        }
    }

    public NodeList getNodeList(String localName) {
        Element node = this.node;
        Element rootNode = node.getOwnerDocument().getDocumentElement();
        return rootNode.getElementsByTagNameNS(this.getNamespaceURI(), localName);
    }

    public ArrayList<String> getTextList(NodeList nodelist, String localname, ArrayList<String> textList) {
        String text = null;
        int length = nodelist.getLength();
        for (int i = 0; i < length; ++i) {
            SpiritNode e;
            if (nodelist.item(i).getNodeType() != 1 || (text = (e = SpiritNode.createSpiritNode((Element)nodelist.item(i))).getUniqueChildText(localname)) == null) continue;
            textList.add(text);
        }
        return textList;
    }

    public String getNamespaceURI() {
        if (this.namespaceURI == null) {
            this.namespaceURI = this.node.getNamespaceURI();
        }
        return this.namespaceURI;
    }

    public String getNodeName() {
        return this.node.getNodeName();
    }

    public Document getOwnerDocument() {
        return this.node.getOwnerDocument();
    }

    public String getTextContent() throws DOMException {
        return SpiritNode.getTextContent(this.node);
    }

    public static Long getIpXactInteger(SpiritNode e) {
        String s = e.getTextContent().trim();
        try {
            Long result = Decode.decode(s);
            return result;
        }
        catch (NumberFormatException exception) {
            return null;
        }
    }

    public List<SpiritNode> getAllDescendants() {
        return this.getDescendants("*", SpiritNode.class);
    }

    public SpiritNode getNodeById(String targetId) {
        List<SpiritNode> nodes = this.getAllDescendants();
        for (SpiritNode node : nodes) {
            if (!node.getSpiritAttribute("id").equals(targetId)) continue;
            return node;
        }
        return null;
    }

    public <T extends SpiritNode> T getNamedSubitem(String tag, String name, Class<T> clazz) {
        List<T> candidates = this.getDescendants(tag, clazz);
        for (SpiritNode candidate : candidates) {
            if (!candidate.getName().equals(name)) continue;
            return (T)candidate;
        }
        return null;
    }
}

