/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.checker.core;

import java.text.MessageFormat;
import org.eclipse.dd.ipxact.checker.core.CheckList;
import org.eclipse.dd.ipxact.checker.core.DocumentChecker;
import org.eclipse.dd.ipxact.checker.core.ICheckerReporter;
import org.eclipse.dd.ipxact.checker.core.Messages;
import org.eclipse.dd.ipxact.checker.core.utils.Utilities;
import org.eclipse.dd.ipxact.editor.core.document.SpiritAbstractionDefinitionDocument;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDocument;
import org.eclipse.dd.ipxact.editor.core.document.Vlnv;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.SpiritNode;

public abstract class CheckAbstractionDefinition {
    public static int checkAbstractionExtension(DocumentChecker checker) {
        int nErrors = 0;
        SpiritAbstractionDefinitionDocument abstractionDef = (SpiritAbstractionDefinitionDocument)checker.getSpiritDocument();
        SpiritNode extendsRef = abstractionDef.getExtensionElement();
        if (extendsRef != null) {
            SpiritNode busDefRef = abstractionDef.getBusType();
            Vlnv extendedBusDefVlnv = new Vlnv(busDefRef);
            try {
                SpiritAbstractionDefinitionDocument baseAbsDef = (SpiritAbstractionDefinitionDocument)checker.getLinkedDocument(extendsRef);
                SpiritNode baseBusDefRef = baseAbsDef.getBusType();
                Vlnv baseBusDefVlnv = new Vlnv(baseBusDefRef);
                if (!Utilities.busExtends(checker, extendedBusDefVlnv, baseBusDefVlnv)) {
                    ICheckerReporter reporter = checker.getReporter();
                    reporter.report(CheckList.CHECK_V14_318, (SpiritDocument)abstractionDef, MessageFormat.format(Messages.CheckAbstractionDefinition_SCR3_18, baseAbsDef.getVlnv(), extendedBusDefVlnv, baseBusDefVlnv), extendsRef);
                    ++nErrors;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return nErrors;
    }
}

