/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.examples.dsf.filebrowser;

import org.eclipse.dd.examples.dsf.filebrowser.FileBrowserModelAdapter;
import org.eclipse.dd.examples.dsf.filebrowser.FileVMContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.PresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.TreeModelViewer;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class FileBrowserDialog
extends Dialog {
    private TreeModelViewer fViewer;
    private FileBrowserModelAdapter fModelAdapter;
    private boolean fDisableTextChangeNotifications = false;

    public FileBrowserDialog(Shell parent) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        PresentationContext presentationContext = new PresentationContext("org.eclipse.dd.examples.dsf.filebrowser");
        this.fViewer = new TreeModelViewer(area, 0x10000000, (IPresentationContext)presentationContext);
        this.fViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.fModelAdapter = new FileBrowserModelAdapter((IPresentationContext)presentationContext);
        this.fViewer.setInput(this.fModelAdapter.getVMProvider().getViewerInputObject());
        final Text text = new Text(area, 2052);
        text.setLayoutData((Object)new GridData(768));
        this.fViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!text.isFocusControl() && event.getSelection() instanceof IStructuredSelection && ((IStructuredSelection)event.getSelection()).getFirstElement() instanceof FileVMContext) {
                    FileVMContext fileVmc = (FileVMContext)((Object)((IStructuredSelection)event.getSelection()).getFirstElement());
                    FileBrowserDialog.this.fDisableTextChangeNotifications = true;
                    text.setText(fileVmc.getFile().getAbsolutePath());
                    FileBrowserDialog.this.fDisableTextChangeNotifications = false;
                }
            }
        });
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!FileBrowserDialog.this.fDisableTextChangeNotifications) {
                    FileBrowserDialog.this.fModelAdapter.getVMProvider().selectionTextChanged(text.getText());
                }
            }
        });
        return area;
    }

    public boolean close() {
        if (super.close()) {
            this.fModelAdapter.dispose();
            this.fModelAdapter = null;
            return true;
        }
        return false;
    }
}

