/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.examples.dsf.timers;

import java.text.MessageFormat;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.dd.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.dd.dsf.concurrent.DsfRunnable;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.dsf.ui.viewmodel.VMDelta;
import org.eclipse.dd.dsf.ui.viewmodel.datamodel.AbstractDMVMNode;
import org.eclipse.dd.dsf.ui.viewmodel.datamodel.AbstractDMVMProvider;
import org.eclipse.dd.dsf.ui.viewmodel.properties.IElementPropertiesProvider;
import org.eclipse.dd.dsf.ui.viewmodel.properties.IPropertiesUpdate;
import org.eclipse.dd.dsf.ui.viewmodel.properties.LabelAttribute;
import org.eclipse.dd.dsf.ui.viewmodel.properties.LabelColumnInfo;
import org.eclipse.dd.dsf.ui.viewmodel.properties.LabelImage;
import org.eclipse.dd.dsf.ui.viewmodel.properties.LabelText;
import org.eclipse.dd.dsf.ui.viewmodel.properties.PropertyBasedLabelProvider;
import org.eclipse.dd.examples.dsf.DsfExamplesPlugin;
import org.eclipse.dd.examples.dsf.timers.TimerService;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;

class TimersVMNode
extends AbstractDMVMNode
implements IElementLabelProvider,
IElementPropertiesProvider {
    private static final String PROP_TIMER_NUMBER = "alarmNumber";
    private static final String PROP_TIMER_VALUE = "alarmTriggerValue";
    private static final PropertyBasedLabelProvider fgLabelProvider = new PropertyBasedLabelProvider();

    public TimersVMNode(AbstractDMVMProvider provider, DsfSession session) {
        super(provider, session, TimerService.TimerDMContext.class);
    }

    public String toString() {
        return "TimersVMNode(" + this.getSession().getId() + ")";
    }

    public void update(ILabelUpdate[] updates) {
        fgLabelProvider.update(updates);
    }

    protected void updateElementsInSessionThread(IChildrenUpdate update) {
        TimerService timerService = (TimerService)((Object)this.getServicesTracker().getService(TimerService.class, null));
        if (timerService == null) {
            this.handleFailedUpdate((IViewerUpdate)update);
            return;
        }
        TimerService.TimerDMContext[] timers = timerService.getTimers();
        this.fillUpdateWithVMCs(update, (IDMContext[])timers);
        update.done();
    }

    public void update(final IPropertiesUpdate[] updates) {
        try {
            this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    for (IPropertiesUpdate update : updates) {
                        TimersVMNode.this.updatePropertiesInSessionThread(update);
                    }
                }
            });
        }
        catch (RejectedExecutionException e) {
            for (IPropertiesUpdate update : updates) {
                this.handleFailedUpdate((IViewerUpdate)update);
            }
        }
    }

    @ConfinedToDsfExecutor(value="getSession#getExecutor")
    private void updatePropertiesInSessionThread(IPropertiesUpdate update) {
        TimerService.TimerDMContext dmc = (TimerService.TimerDMContext)this.findDmcInPath(update.getViewerInput(), update.getElementPath(), TimerService.TimerDMContext.class);
        TimerService timerService = (TimerService)((Object)this.getServicesTracker().getService(TimerService.class, null));
        if (dmc == null || timerService == null) {
            this.handleFailedUpdate((IViewerUpdate)update);
            return;
        }
        int value = timerService.getTimerValue(dmc);
        if (value == -1) {
            this.handleFailedUpdate((IViewerUpdate)update);
            return;
        }
        update.setProperty(PROP_TIMER_NUMBER, (Object)dmc.getTimerNumber());
        update.setProperty(PROP_TIMER_VALUE, (Object)value);
        update.done();
    }

    public int getDeltaFlags(Object e) {
        if (e instanceof TimerService.TimerTickDMEvent) {
            return 2048;
        }
        if (e instanceof TimerService.TimersChangedEvent) {
            return 1024;
        }
        return 0;
    }

    public void buildDelta(Object e, VMDelta parentDelta, int nodeOffset, RequestMonitor requestMonitor) {
        if (e instanceof TimerService.TimerTickDMEvent) {
            parentDelta.addNode((Object)this.createVMContext(((TimerService.TimerTickDMEvent)((Object)e)).getDMContext()), 2048);
        } else if (e instanceof TimerService.TimersChangedEvent) {
            parentDelta.setFlags(parentDelta.getFlags() | 0x400);
        }
        requestMonitor.done();
    }

    static {
        LabelColumnInfo idCol = new LabelColumnInfo(new LabelAttribute[]{new LabelText(new MessageFormat("Timer #{0}"), new String[]{PROP_TIMER_NUMBER}), new LabelImage(DsfExamplesPlugin.getDefault().getImageRegistry().getDescriptor("icons/alarm.gif"))});
        fgLabelProvider.setColumnInfo("org.eclipse.dd.examples.dsf.TIMER_COLUMN_PRESENTATION_ID.COL_ID", idCol);
        LabelColumnInfo valueCol = new LabelColumnInfo(new LabelAttribute[]{new LabelText(new MessageFormat("{0}"), new String[]{PROP_TIMER_VALUE})});
        fgLabelProvider.setColumnInfo("org.eclipse.dd.examples.dsf.TIMER_COLUMN_PRESENTATION_ID.COL_VALUE", valueCol);
    }
}

