/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.tests.gdb;

import java.util.concurrent.Executor;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.utils.Addr64;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.debug.service.IExpressions;
import org.eclipse.dd.dsf.debug.service.IFormattedValues;
import org.eclipse.dd.dsf.debug.service.IMemory;
import org.eclipse.dd.dsf.debug.service.IProcesses;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.debug.service.IStack;
import org.eclipse.dd.dsf.debug.service.command.ICommandControlService;
import org.eclipse.dd.dsf.service.DsfServiceEventHandler;
import org.eclipse.dd.dsf.service.DsfServicesTracker;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.mi.service.IMIProcesses;
import org.eclipse.dd.mi.service.MIRunControl;
import org.eclipse.dd.mi.service.command.events.MIStoppedEvent;
import org.eclipse.dd.tests.gdb.framework.AsyncCompletionWaitor;
import org.eclipse.dd.tests.gdb.framework.BackgroundRunner;
import org.eclipse.dd.tests.gdb.framework.BaseTestCase;
import org.eclipse.dd.tests.gdb.framework.SyncUtil;
import org.eclipse.dd.tests.gdb.launching.TestsPlugin;
import org.eclipse.debug.core.model.MemoryByte;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=BackgroundRunner.class)
public class MIMemoryTest
extends BaseTestCase {
    private final AsyncCompletionWaitor fWait = new AsyncCompletionWaitor();
    private DsfSession fSession;
    private DsfServicesTracker fServicesTracker;
    private IMemory.IMemoryDMContext fMemoryDmc;
    private MIRunControl fRunControl;
    private IMemory fMemoryService;
    private IExpressions fExpressionService;
    private final int BLOCK_SIZE = 256;
    private IAddress fBaseAddress;
    private Integer fMemoryChangedEventCount = new Integer(0);
    private boolean[] fMemoryAddressesChanged = new boolean[256];

    @BeforeClass
    public static void testSuiteInitialization() {
        MIMemoryTest.setLaunchAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", "data/launch/bin/MemoryTestApp.exe");
    }

    @AfterClass
    public static void testSuiteCleanup() {
    }

    @Before
    public void testCaseInitialization() {
        this.fSession = this.getGDBLaunch().getSession();
        this.fServicesTracker = new DsfServicesTracker(TestsPlugin.getBundleContext(), this.fSession.getId());
        assert (this.fServicesTracker != null);
        ICommandControlService commandControl = (ICommandControlService)this.fServicesTracker.getService(ICommandControlService.class);
        IMIProcesses procService = (IMIProcesses)this.fServicesTracker.getService(IMIProcesses.class);
        IProcesses.IProcessDMContext procDmc = procService.createProcessContext(commandControl.getContext(), "");
        this.fMemoryDmc = (IMemory.IMemoryDMContext)procService.createContainerContext(procDmc, "");
        assert (this.fMemoryDmc != null);
        this.fRunControl = (MIRunControl)this.fServicesTracker.getService(MIRunControl.class);
        assert (this.fRunControl != null);
        this.fMemoryService = (IMemory)this.fServicesTracker.getService(IMemory.class);
        assert (this.fMemoryService != null);
        this.fExpressionService = (IExpressions)this.fServicesTracker.getService(IExpressions.class);
        assert (this.fExpressionService != null);
        this.fSession.addServiceEventListener((Object)this, null);
        this.fBaseAddress = null;
        this.clearEventCounters();
    }

    @After
    public void testCaseCleanup() {
        this.fBaseAddress = null;
        this.fSession.removeServiceEventListener((Object)this);
        this.fExpressionService = null;
        this.fMemoryService = null;
        this.fRunControl = null;
        this.fServicesTracker.dispose();
        this.fServicesTracker = null;
        this.clearEventCounters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @DsfServiceEventHandler
    public void eventDispatched(IMemory.IMemoryChangedEvent e) {
        Integer n = this.fMemoryChangedEventCount;
        // MONITORENTER : n
        Integer n2 = this.fMemoryChangedEventCount;
        Integer n3 = this.fMemoryChangedEventCount = Integer.valueOf(this.fMemoryChangedEventCount + 1);
        // MONITOREXIT : n
        IAddress[] addresses = e.getAddresses();
        int i = 0;
        while (i < addresses.length) {
            int offset = Math.abs(addresses[i].distanceTo(this.fBaseAddress).intValue());
            if (offset < 256) {
                boolean[] blArray = this.fMemoryAddressesChanged;
                // MONITORENTER : this.fMemoryAddressesChanged
                this.fMemoryAddressesChanged[offset] = true;
                // MONITOREXIT : blArray
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearEventCounters() {
        Object object = this.fMemoryChangedEventCount;
        synchronized (object) {
            this.fMemoryChangedEventCount = 0;
        }
        object = this.fMemoryAddressesChanged;
        synchronized (this.fMemoryAddressesChanged) {
            for (int i = 0; i < 256; ++i) {
                this.fMemoryAddressesChanged[i] = false;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getEventCount() {
        int count;
        Integer n = this.fMemoryChangedEventCount;
        synchronized (n) {
            count = this.fMemoryChangedEventCount;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getAddressCount() {
        int count = 0;
        boolean[] blArray = this.fMemoryAddressesChanged;
        synchronized (this.fMemoryAddressesChanged) {
            for (int i = 0; i < 256; ++i) {
                if (!this.fMemoryAddressesChanged[i]) continue;
                ++count;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return count;
        }
    }

    private IAddress evaluateExpression(IDMContext ctx, String expression) throws Throwable {
        IExpressions.IExpressionDMContext expressionDMC = SyncUtil.SyncCreateExpression(ctx, expression);
        final IFormattedValues.FormattedValueDMContext formattedValueDMC = SyncUtil.SyncGetFormattedValue((IFormattedValues)this.fExpressionService, (IFormattedValues.IFormattedDataDMContext)expressionDMC, "HEX.Format");
        DataRequestMonitor<IFormattedValues.FormattedValueDMData> drm = new DataRequestMonitor<IFormattedValues.FormattedValueDMData>((Executor)this.fSession.getExecutor(), null){

            protected void handleCompleted() {
                if (this.isSuccess()) {
                    MIMemoryTest.this.fWait.setReturnInfo(this.getData());
                }
                MIMemoryTest.this.fWait.waitFinished(this.getStatus());
            }
        };
        this.fSession.getExecutor().submit(new Runnable((DataRequestMonitor)drm){
            final /* synthetic */ DataRequestMonitor val$drm;
            {
                this.val$drm = dataRequestMonitor;
            }

            public void run() {
                MIMemoryTest.this.fExpressionService.getFormattedExpressionValue(formattedValueDMC, this.val$drm);
            }
        });
        this.fWait.waitUntilDone(0);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        String result = "";
        Object returnInfo = this.fWait.getReturnInfo();
        if (returnInfo instanceof IFormattedValues.FormattedValueDMData) {
            result = ((IFormattedValues.FormattedValueDMData)returnInfo).getFormattedValue();
        }
        return new Addr64(result);
    }

    private void readMemory(final IMemory.IMemoryDMContext dmc, final IAddress address, final long offset, final int word_size, final int count) throws InterruptedException {
        DataRequestMonitor<MemoryByte[]> drm = new DataRequestMonitor<MemoryByte[]>((Executor)this.fSession.getExecutor(), null){

            protected void handleCompleted() {
                if (this.isSuccess()) {
                    MIMemoryTest.this.fWait.setReturnInfo(this.getData());
                }
                MIMemoryTest.this.fWait.waitFinished(this.getStatus());
            }
        };
        this.fSession.getExecutor().submit(new Runnable((DataRequestMonitor)drm){
            final /* synthetic */ DataRequestMonitor val$drm;
            {
                this.val$drm = dataRequestMonitor;
            }

            public void run() {
                MIMemoryTest.this.fMemoryService.getMemory(dmc, address, offset, word_size, count, this.val$drm);
            }
        });
    }

    private void readMemoryByteAtOffset(final IMemory.IMemoryDMContext dmc, final IAddress address, final long offset, final int word_size, final int count, final MemoryByte[] result) throws InterruptedException {
        DataRequestMonitor<MemoryByte[]> drm = new DataRequestMonitor<MemoryByte[]>((Executor)this.fSession.getExecutor(), null){

            protected void handleCompleted() {
                if (this.isSuccess()) {
                    result[(int)offset] = ((MemoryByte[])this.getData())[0];
                }
                MIMemoryTest.this.fWait.waitFinished(this.getStatus());
            }
        };
        this.fSession.getExecutor().submit(new Runnable((DataRequestMonitor)drm){
            final /* synthetic */ DataRequestMonitor val$drm;
            {
                this.val$drm = dataRequestMonitor;
            }

            public void run() {
                MIMemoryTest.this.fMemoryService.getMemory(dmc, address, offset, word_size, count, this.val$drm);
            }
        });
    }

    private void writeMemory(final IMemory.IMemoryDMContext dmc, final IAddress address, final long offset, final int word_size, final int count, final byte[] buffer) throws InterruptedException {
        final RequestMonitor rm = new RequestMonitor((Executor)this.fSession.getExecutor(), null){

            protected void handleCompleted() {
                MIMemoryTest.this.fWait.waitFinished(this.getStatus());
            }
        };
        this.fSession.getExecutor().submit(new Runnable(){

            public void run() {
                MIMemoryTest.this.fMemoryService.setMemory(dmc, address, offset, word_size, count, buffer, rm);
            }
        });
    }

    private void fillMemory(final IMemory.IMemoryDMContext dmc, final IAddress address, final long offset, final int word_size, final int count, final byte[] pattern) throws InterruptedException {
        final RequestMonitor rm = new RequestMonitor((Executor)this.fSession.getExecutor(), null){

            protected void handleCompleted() {
                MIMemoryTest.this.fWait.waitFinished(this.getStatus());
            }
        };
        this.fSession.getExecutor().submit(new Runnable(){

            public void run() {
                MIMemoryTest.this.fMemoryService.fillMemory(dmc, address, offset, word_size, count, pattern, rm);
            }
        });
    }

    @Test
    public void readWithNullContext() throws Throwable {
        SyncUtil.SyncAddBreakpoint("MemoryTestApp.cc:zeroBlocks", true);
        SyncUtil.SyncResumeUntilStopped();
        MIStoppedEvent stoppedEvent = SyncUtil.SyncStep(IRunControl.StepType.STEP_RETURN);
        IStack.IFrameDMContext frameDmc = SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 0);
        IMemory.IMemoryDMContext dmc = null;
        long offset = 0L;
        int word_size = 1;
        int count = 1;
        this.fBaseAddress = this.evaluateExpression((IDMContext)frameDmc, "&charBlock");
        String expected = "Unknown context type";
        this.fWait.waitReset();
        this.readMemory(dmc, this.fBaseAddress, offset, word_size, count);
        this.fWait.waitUntilDone(0);
        Assert.assertFalse((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        Assert.assertTrue((String)("Wrong error message: expected '" + expected + "', received '" + this.fWait.getMessage() + "'"), (boolean)this.fWait.getMessage().contains(expected));
        Assert.assertTrue((String)("MemoryChangedEvent problem: expected 0, received " + this.getEventCount()), (this.getEventCount() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void readWithInvalidAddress() throws Throwable {
        SyncUtil.SyncAddBreakpoint("MemoryTestApp.cc:zeroBlocks", true);
        SyncUtil.SyncResumeUntilStopped();
        SyncUtil.SyncStep(IRunControl.StepType.STEP_RETURN);
        long offset = 0L;
        int word_size = 1;
        int count = 1;
        this.fBaseAddress = new Addr64("0");
        this.fWait.waitReset();
        this.readMemory(this.fMemoryDmc, this.fBaseAddress, offset, word_size, count);
        this.fWait.waitUntilDone(0);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        MemoryByte[] buffer = (MemoryByte[])this.fWait.getReturnInfo();
        Assert.assertTrue((String)("Wrong value: expected '-1, 0', received '" + buffer[0].getValue() + ", " + buffer[0].getFlags() + "'"), (buffer[0].getValue() == 0 && buffer[0].getFlags() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)("MemoryChangedEvent problem: expected 0, received " + this.getEventCount()), (this.getEventCount() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void readWithInvalidWordSize() throws Throwable {
        SyncUtil.SyncAddBreakpoint("MemoryTestApp.cc:zeroBlocks", true);
        SyncUtil.SyncResumeUntilStopped();
        MIStoppedEvent stoppedEvent = SyncUtil.SyncStep(IRunControl.StepType.STEP_RETURN);
        IStack.IFrameDMContext frameDmc = SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 0);
        long offset = 0L;
        int count = -1;
        this.fBaseAddress = this.evaluateExpression((IDMContext)frameDmc, "&charBlock");
        String expected = "Word size not supported (!= 1)";
        this.fWait.waitReset();
        this.readMemory(this.fMemoryDmc, this.fBaseAddress, offset, 0, count);
        this.fWait.waitUntilDone(0);
        Assert.assertFalse((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        Assert.assertTrue((String)("Wrong error message: expected '" + expected + "', received '" + this.fWait.getMessage() + "'"), (boolean)this.fWait.getMessage().contains(expected));
        this.fWait.waitReset();
        this.readMemory(this.fMemoryDmc, this.fBaseAddress, offset, 2, count);
        this.fWait.waitUntilDone(0);
        Assert.assertFalse((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        Assert.assertTrue((String)("Wrong error message: expected '" + expected + "', received '" + this.fWait.getMessage() + "'"), (boolean)this.fWait.getMessage().contains(expected));
        Assert.assertTrue((String)("MemoryChangedEvent problem: expected 0, received " + this.getEventCount()), (this.getEventCount() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void readWithInvalidCount() throws Throwable {
        SyncUtil.SyncAddBreakpoint("MemoryTestApp.cc:zeroBlocks", true);
        SyncUtil.SyncResumeUntilStopped();
        MIStoppedEvent stoppedEvent = SyncUtil.SyncStep(IRunControl.StepType.STEP_RETURN);
        IStack.IFrameDMContext frameDmc = SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 0);
        long offset = 0L;
        int word_size = 1;
        int count = -1;
        this.fBaseAddress = this.evaluateExpression((IDMContext)frameDmc, "&charBlock");
        String expected = "Invalid word count (< 0)";
        this.fWait.waitReset();
        this.readMemory(this.fMemoryDmc, this.fBaseAddress, offset, word_size, count);
        this.fWait.waitUntilDone(0);
        Assert.assertFalse((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        Assert.assertTrue((String)("Wrong error message: expected '" + expected + "', received '" + this.fWait.getMessage() + "'"), (boolean)this.fWait.getMessage().contains(expected));
        Assert.assertTrue((String)("MemoryChangedEvent problem: expected 0, received " + this.getEventCount()), (this.getEventCount() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void readCharVaryingBaseAddress() throws Throwable {
        MemoryByte[] buffer;
        IAddress address;
        int i;
        SyncUtil.SyncAddBreakpoint("MemoryTestApp.cc:zeroBlocks", true);
        SyncUtil.SyncResumeUntilStopped();
        MIStoppedEvent stoppedEvent = SyncUtil.SyncStep(IRunControl.StepType.STEP_RETURN);
        IStack.IFrameDMContext frameDmc = SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 0);
        long offset = 0L;
        int word_size = 1;
        int count = 1;
        this.fBaseAddress = this.evaluateExpression((IDMContext)frameDmc, "&charBlock");
        for (i = 0; i < 256; ++i) {
            address = this.fBaseAddress.add((long)i);
            this.fWait.waitReset();
            this.readMemory(this.fMemoryDmc, address, offset, word_size, count);
            this.fWait.waitUntilDone(0);
            Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
            buffer = (MemoryByte[])this.fWait.getReturnInfo();
            Assert.assertTrue((String)("Wrong value read at offset " + i + ": expected '" + 0 + "', received '" + buffer[0].getValue() + "'"), (buffer[0].getValue() == 0 ? 1 : 0) != 0);
        }
        SyncUtil.SyncAddBreakpoint("MemoryTestApp.cc:setBlocks", true);
        SyncUtil.SyncResumeUntilStopped();
        SyncUtil.SyncStep(IRunControl.StepType.STEP_RETURN);
        for (i = 0; i < 256; ++i) {
            address = this.fBaseAddress.add((long)i);
            this.fWait.waitReset();
            this.readMemory(this.fMemoryDmc, address, offset, word_size, count);
            this.fWait.waitUntilDone(0);
            buffer = (MemoryByte[])this.fWait.getReturnInfo();
            Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
            Assert.assertTrue((String)("Wrong value read at offset " + i + ": expected '" + i + "', received '" + buffer[0].getValue() + "'"), (buffer[0].getValue() == (byte)i ? 1 : 0) != 0);
        }
        Assert.assertTrue((String)("MemoryChangedEvent problem: expected 0, received " + this.getEventCount()), (this.getEventCount() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void readCharVaryingOffset() throws Throwable {
        MemoryByte[] buffer;
        int offset;
        SyncUtil.SyncAddBreakpoint("MemoryTestApp.cc:zeroBlocks", true);
        SyncUtil.SyncResumeUntilStopped();
        MIStoppedEvent stoppedEvent = SyncUtil.SyncStep(IRunControl.StepType.STEP_RETURN);
        IStack.IFrameDMContext frameDmc = SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 0);
        int word_size = 1;
        int count = 1;
        this.fBaseAddress = this.evaluateExpression((IDMContext)frameDmc, "&charBlock");
        for (offset = 0; offset < 256; ++offset) {
            this.fWait.waitReset();
            this.readMemory(this.fMemoryDmc, this.fBaseAddress, offset, word_size, count);
            this.fWait.waitUntilDone(0);
            Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
            buffer = (MemoryByte[])this.fWait.getReturnInfo();
            Assert.assertTrue((String)("Wrong value read at offset " + offset + ": expected '" + 0 + "', received '" + buffer[0].getValue() + "'"), (buffer[0].getValue() == 0 ? 1 : 0) != 0);
        }
        SyncUtil.SyncAddBreakpoint("MemoryTestApp.cc:setBlocks", true);
        SyncUtil.SyncResumeUntilStopped();
        SyncUtil.SyncStep(IRunControl.StepType.STEP_RETURN);
        for (offset = 0; offset < 256; ++offset) {
            this.fWait.waitReset();
            this.readMemory(this.fMemoryDmc, this.fBaseAddress, offset, word_size, count);
            this.fWait.waitUntilDone(0);
            Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
            buffer = (MemoryByte[])this.fWait.getReturnInfo();
            Assert.assertTrue((String)("Wrong value read at offset " + offset + ": expected '" + offset + "', received '" + buffer[0].getValue() + "'"), (buffer[0].getValue() == (byte)offset ? 1 : 0) != 0);
        }
        Assert.assertTrue((String)("MemoryChangedEvent problem: expected 0, received " + this.getEventCount()), (this.getEventCount() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void readCharArray() throws Throwable {
        int i;
        SyncUtil.SyncAddBreakpoint("MemoryTestApp.cc:zeroBlocks", true);
        SyncUtil.SyncResumeUntilStopped();
        MIStoppedEvent stoppedEvent = SyncUtil.SyncStep(IRunControl.StepType.STEP_RETURN);
        IStack.IFrameDMContext frameDmc = SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 0);
        long offset = 0L;
        int word_size = 1;
        int count = 256;
        this.fBaseAddress = this.evaluateExpression((IDMContext)frameDmc, "&charBlock");
        this.fWait.waitReset();
        this.readMemory(this.fMemoryDmc, this.fBaseAddress, offset, word_size, count);
        this.fWait.waitUntilDone(0);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        MemoryByte[] buffer = (MemoryByte[])this.fWait.getReturnInfo();
        for (i = 0; i < count; ++i) {
            Assert.assertTrue((String)("Wrong value read at offset " + i + ": expected '" + 0 + "', received '" + buffer[i].getValue() + "'"), (buffer[i].getValue() == 0 ? 1 : 0) != 0);
        }
        SyncUtil.SyncAddBreakpoint("MemoryTestApp.cc:setBlocks", true);
        SyncUtil.SyncResumeUntilStopped();
        SyncUtil.SyncStep(IRunControl.StepType.STEP_RETURN);
        this.fWait.waitReset();
        this.readMemory(this.fMemoryDmc, this.fBaseAddress, offset, word_size, count);
        this.fWait.waitUntilDone(0);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        buffer = (MemoryByte[])this.fWait.getReturnInfo();
        for (i = 0; i < count; ++i) {
            Assert.assertTrue((String)("Wrong value read at offset " + i + ": expected '" + i + "', received '" + buffer[i].getValue() + "'"), (buffer[i].getValue() == (byte)i ? 1 : 0) != 0);
        }
        Assert.assertTrue((String)("MemoryChangedEvent problem: expected 0, received " + this.getEventCount()), (this.getEventCount() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void writeWithNullContext() throws Throwable {
        SyncUtil.SyncAddBreakpoint("MemoryTestApp.cc:zeroBlocks", true);
        SyncUtil.SyncResumeUntilStopped();
        MIStoppedEvent stoppedEvent = SyncUtil.SyncStep(IRunControl.StepType.STEP_RETURN);
        IStack.IFrameDMContext frameDmc = SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 0);
        long offset = 0L;
        int word_size = 1;
        int count = 1;
        byte[] buffer = new byte[count];
        this.fBaseAddress = this.evaluateExpression((IDMContext)frameDmc, "&charBlock");
        String expected = "Unknown context type";
        this.fWait.waitReset();
        this.writeMemory(null, this.fBaseAddress, offset, word_size, count, buffer);
        this.fWait.waitUntilDone(0);
        Assert.assertFalse((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        Assert.assertTrue((String)("Wrong error message: expected '" + expected + "', received '" + this.fWait.getMessage() + "'"), (boolean)this.fWait.getMessage().contains(expected));
        Assert.assertTrue((String)("MemoryChangedEvent problem: expected 0, received " + this.getEventCount()), (this.getEventCount() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void writeWithInvalidAddress() throws Throwable {
        SyncUtil.SyncAddBreakpoint("MemoryTestApp.cc:zeroBlocks", true);
        SyncUtil.SyncResumeUntilStopped();
        SyncUtil.SyncStep(IRunControl.StepType.STEP_RETURN);
        long offset = 0L;
        int word_size = 1;
        int count = 1;
        byte[] buffer = new byte[count];
        this.fBaseAddress = new Addr64("0");
        this.fWait.waitReset();
        this.writeMemory(this.fMemoryDmc, this.fBaseAddress, offset, word_size, count, buffer);
        this.fWait.waitUntilDone(0);
        Assert.assertFalse((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        String expected = "Cannot access memory at address";
        Assert.assertTrue((String)("Wrong error message: expected '" + expected + "', received '" + this.fWait.getMessage() + "'"), (boolean)this.fWait.getMessage().contains(expected));
        Assert.assertTrue((String)("MemoryChangedEvent problem: expected 0, received " + this.getEventCount()), (this.getEventCount() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void writeWithInvalidWordSize() throws Throwable {
        SyncUtil.SyncAddBreakpoint("MemoryTestApp.cc:zeroBlocks", true);
        SyncUtil.SyncResumeUntilStopped();
        MIStoppedEvent stoppedEvent = SyncUtil.SyncStep(IRunControl.StepType.STEP_RETURN);
        IStack.IFrameDMContext frameDmc = SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 0);
        long offset = 0L;
        int count = -1;
        byte[] buffer = new byte[1];
        this.fBaseAddress = this.evaluateExpression((IDMContext)frameDmc, "&charBlock");
        String expected = "Word size not supported (!= 1)";
        this.fWait.waitReset();
        this.writeMemory(this.fMemoryDmc, this.fBaseAddress, offset, 0, count, buffer);
        this.fWait.waitUntilDone(0);
        Assert.assertFalse((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        Assert.assertTrue((String)("Wrong error message: expected '" + expected + "', received '" + this.fWait.getMessage() + "'"), (boolean)this.fWait.getMessage().contains(expected));
        this.fWait.waitReset();
        this.writeMemory(this.fMemoryDmc, this.fBaseAddress, offset, 2, count, buffer);
        this.fWait.waitUntilDone(0);
        Assert.assertFalse((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        Assert.assertTrue((String)("Wrong error message: expected '" + expected + "', received '" + this.fWait.getMessage() + "'"), (boolean)this.fWait.getMessage().contains(expected));
        Assert.assertTrue((String)("MemoryChangedEvent problem: expected 0, received " + this.getEventCount()), (this.getEventCount() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void writeWithInvalidCount() throws Throwable {
        SyncUtil.SyncAddBreakpoint("MemoryTestApp.cc:zeroBlocks", true);
        SyncUtil.SyncResumeUntilStopped();
        MIStoppedEvent stoppedEvent = SyncUtil.SyncStep(IRunControl.StepType.STEP_RETURN);
        IStack.IFrameDMContext frameDmc = SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 0);
        long offset = 0L;
        int word_size = 1;
        int count = -1;
        byte[] buffer = new byte[1];
        this.fBaseAddress = this.evaluateExpression((IDMContext)frameDmc, "&charBlock");
        String expected = "Invalid word count (< 0)";
        this.fWait.waitReset();
        this.writeMemory(this.fMemoryDmc, this.fBaseAddress, offset, word_size, count, buffer);
        this.fWait.waitUntilDone(0);
        Assert.assertFalse((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        Assert.assertTrue((String)("Wrong error message: expected '" + expected + "', received '" + this.fWait.getMessage() + "'"), (boolean)this.fWait.getMessage().contains(expected));
        Assert.assertTrue((String)("MemoryChangedEvent problem: expected 0, received " + this.getEventCount()), (this.getEventCount() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void writeWithInvalidBuffer() throws Throwable {
        SyncUtil.SyncAddBreakpoint("MemoryTestApp.cc:zeroBlocks", true);
        SyncUtil.SyncResumeUntilStopped();
        MIStoppedEvent stoppedEvent = SyncUtil.SyncStep(IRunControl.StepType.STEP_RETURN);
        IStack.IFrameDMContext frameDmc = SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 0);
        long offset = 0L;
        int word_size = 1;
        int count = 10;
        byte[] buffer = new byte[count - 1];
        this.fBaseAddress = this.evaluateExpression((IDMContext)frameDmc, "&charBlock");
        String expected = "Buffer too short";
        this.fWait.waitReset();
        this.writeMemory(this.fMemoryDmc, this.fBaseAddress, offset, word_size, count, buffer);
        this.fWait.waitUntilDone(0);
        Assert.assertFalse((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        Assert.assertTrue((String)("Wrong error message: expected '" + expected + "', received '" + this.fWait.getMessage() + "'"), (boolean)this.fWait.getMessage().contains(expected));
        Assert.assertTrue((String)("MemoryChangedEvent problem: expected 0, received " + this.getEventCount()), (this.getEventCount() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void writeCharVaryingAddress() throws Throwable {
        SyncUtil.SyncAddBreakpoint("MemoryTestApp.cc:zeroBlocks", true);
        SyncUtil.SyncResumeUntilStopped();
        MIStoppedEvent stoppedEvent = SyncUtil.SyncStep(IRunControl.StepType.STEP_RETURN);
        IStack.IFrameDMContext frameDmc = SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 0);
        long offset = 0L;
        int word_size = 1;
        int count = 256;
        byte[] buffer = new byte[count];
        this.fBaseAddress = this.evaluateExpression((IDMContext)frameDmc, "&charBlock");
        for (int i = 0; i < count; ++i) {
            byte expected;
            this.fWait.waitReset();
            this.readMemory(this.fMemoryDmc, this.fBaseAddress, i, word_size, 1);
            this.fWait.waitUntilDone(0);
            Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
            MemoryByte[] block = (MemoryByte[])this.fWait.getReturnInfo();
            Assert.assertTrue((String)("Wrong value read at offset " + i + ": expected '" + 0 + "', received '" + block[0].getValue() + "'"), (block[0].getValue() == 0 ? 1 : 0) != 0);
            IAddress address = this.fBaseAddress.add((long)i);
            this.fWait.waitReset();
            buffer[0] = expected = (byte)(count - i - 1);
            this.writeMemory(this.fMemoryDmc, address, offset, word_size, 1, buffer);
            this.fWait.waitUntilDone(0);
            Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
            Assert.assertTrue((String)("MemoryChangedEvent problem at offset " + i + ": expected " + (i + 1) + " events, received " + this.getEventCount()), (this.getEventCount() == i + 1 ? 1 : 0) != 0);
            Assert.assertTrue((String)("MemoryChangedEvent problem at offset " + i), (boolean)this.fMemoryAddressesChanged[i]);
            this.fWait.waitReset();
            this.readMemory(this.fMemoryDmc, this.fBaseAddress, i, word_size, 1);
            this.fWait.waitUntilDone(0);
            Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
            block = (MemoryByte[])this.fWait.getReturnInfo();
            Assert.assertTrue((String)("Wrong value read at offset " + i + ": expected '" + expected + "', received '" + block[0].getValue() + "'"), (block[0].getValue() == expected ? 1 : 0) != 0);
        }
        Assert.assertTrue((String)("MemoryChangedEvent problem: expected 256 events, received " + this.getEventCount()), (this.getEventCount() == 256 ? 1 : 0) != 0);
        Assert.assertTrue((String)("MemoryChangedEvent problem: expected 256 distinct addresses, received " + this.getAddressCount()), (this.getEventCount() == 256 ? 1 : 0) != 0);
    }

    @Test
    public void writeCharVaryingOffset() throws Throwable {
        SyncUtil.SyncAddBreakpoint("MemoryTestApp.cc:zeroBlocks", true);
        SyncUtil.SyncResumeUntilStopped();
        MIStoppedEvent stoppedEvent = SyncUtil.SyncStep(IRunControl.StepType.STEP_RETURN);
        IStack.IFrameDMContext frameDmc = SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 0);
        int word_size = 1;
        int count = 256;
        byte[] buffer = new byte[count];
        this.fBaseAddress = this.evaluateExpression((IDMContext)frameDmc, "&charBlock");
        for (int offset = 0; offset < count; ++offset) {
            byte expected;
            this.fWait.waitReset();
            this.readMemory(this.fMemoryDmc, this.fBaseAddress, offset, word_size, 1);
            this.fWait.waitUntilDone(0);
            Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
            MemoryByte[] block = (MemoryByte[])this.fWait.getReturnInfo();
            Assert.assertTrue((String)("Wrong value read at offset " + offset + ": expected '" + 0 + "', received '" + block[0].getValue() + "'"), (block[0].getValue() == 0 ? 1 : 0) != 0);
            this.fWait.waitReset();
            buffer[0] = expected = (byte)(count - offset - 1);
            this.writeMemory(this.fMemoryDmc, this.fBaseAddress, offset, word_size, 1, buffer);
            this.fWait.waitUntilDone(0);
            Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
            Assert.assertTrue((String)("MemoryChangedEvent problem at offset " + offset + ": expected " + (offset + 1) + " events, received " + this.getEventCount()), (this.getEventCount() == offset + 1 ? 1 : 0) != 0);
            Assert.assertTrue((String)("MemoryChangedEvent problem at offset " + offset), (boolean)this.fMemoryAddressesChanged[offset]);
            this.fWait.waitReset();
            this.readMemory(this.fMemoryDmc, this.fBaseAddress, offset, word_size, 1);
            this.fWait.waitUntilDone(0);
            Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
            block = (MemoryByte[])this.fWait.getReturnInfo();
            Assert.assertTrue((String)("Wrong value read at offset " + offset + ": expected '" + expected + "', received '" + block[0].getValue() + "'"), (block[0].getValue() == expected ? 1 : 0) != 0);
        }
        Assert.assertTrue((String)("MemoryChangedEvent problem: expected 256 events, received " + this.getEventCount()), (this.getEventCount() == 256 ? 1 : 0) != 0);
        Assert.assertTrue((String)("MemoryChangedEvent problem: expected 256 distinct addresses, received " + this.getAddressCount()), (this.getAddressCount() == 256 ? 1 : 0) != 0);
    }

    @Test
    public void writeCharArray() throws Throwable {
        int i;
        SyncUtil.SyncAddBreakpoint("MemoryTestApp.cc:zeroBlocks", true);
        SyncUtil.SyncResumeUntilStopped();
        MIStoppedEvent stoppedEvent = SyncUtil.SyncStep(IRunControl.StepType.STEP_RETURN);
        IStack.IFrameDMContext frameDmc = SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 0);
        long offset = 0L;
        int word_size = 1;
        int count = 256;
        this.fBaseAddress = this.evaluateExpression((IDMContext)frameDmc, "&charBlock");
        this.fWait.waitReset();
        this.readMemory(this.fMemoryDmc, this.fBaseAddress, offset, word_size, count);
        this.fWait.waitUntilDone(0);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        MemoryByte[] block = (MemoryByte[])this.fWait.getReturnInfo();
        for (int i2 = 0; i2 < count; ++i2) {
            Assert.assertTrue((String)("Wrong value read at offset " + i2 + ": expected '" + 0 + "', received '" + block[i2].getValue() + "'"), (block[i2].getValue() == 0 ? 1 : 0) != 0);
        }
        byte[] buffer = new byte[count];
        for (i = 0; i < count; ++i) {
            buffer[i] = (byte)i;
        }
        this.fWait.waitReset();
        this.writeMemory(this.fMemoryDmc, this.fBaseAddress, offset, word_size, count, buffer);
        this.fWait.waitUntilDone(0);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        this.fWait.waitReset();
        this.readMemory(this.fMemoryDmc, this.fBaseAddress, offset, word_size, count);
        this.fWait.waitUntilDone(0);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        block = (MemoryByte[])this.fWait.getReturnInfo();
        for (i = 0; i < count; ++i) {
            Assert.assertTrue((String)("Wrong value read at offset " + i + ": expected '" + 0 + "', received '" + block[i].getValue() + "'"), (block[i].getValue() == (byte)i ? 1 : 0) != 0);
        }
        Assert.assertTrue((String)("MemoryChangedEvent problem: expected 1 event, received " + this.getEventCount()), (this.getEventCount() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("MemoryChangedEvent problem: expected 256 distinct addresses, received " + this.getAddressCount()), (this.getAddressCount() == 256 ? 1 : 0) != 0);
    }

    @Test
    public void fillWithNullContext() throws Throwable {
        SyncUtil.SyncAddBreakpoint("MemoryTestApp.cc:zeroBlocks", true);
        SyncUtil.SyncResumeUntilStopped();
        MIStoppedEvent stoppedEvent = SyncUtil.SyncStep(IRunControl.StepType.STEP_RETURN);
        IStack.IFrameDMContext frameDmc = SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 0);
        long offset = 0L;
        int word_size = 1;
        int count = 1;
        byte[] pattern = new byte[count];
        this.fBaseAddress = this.evaluateExpression((IDMContext)frameDmc, "&charBlock");
        String expected = "Unknown context type";
        this.fWait.waitReset();
        this.fillMemory(null, this.fBaseAddress, offset, word_size, count, pattern);
        this.fWait.waitUntilDone(0);
        Assert.assertFalse((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        Assert.assertTrue((String)("Wrong error message: expected '" + expected + "', received '" + this.fWait.getMessage() + "'"), (boolean)this.fWait.getMessage().contains(expected));
        Assert.assertTrue((String)("MemoryChangedEvent problem: expected 0, received " + this.getEventCount()), (this.getEventCount() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void fillWithInvalidAddress() throws Throwable {
        SyncUtil.SyncAddBreakpoint("MemoryTestApp.cc:zeroBlocks", true);
        SyncUtil.SyncResumeUntilStopped();
        SyncUtil.SyncStep(IRunControl.StepType.STEP_RETURN);
        long offset = 0L;
        int word_size = 1;
        int count = 1;
        byte[] pattern = new byte[count];
        this.fBaseAddress = new Addr64("0");
        this.fWait.waitReset();
        this.fillMemory(this.fMemoryDmc, this.fBaseAddress, offset, word_size, count, pattern);
        this.fWait.waitUntilDone(0);
        Assert.assertFalse((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        String expected = "Cannot access memory at address";
        Assert.assertTrue((String)("Wrong error message: expected '" + expected + "', received '" + this.fWait.getMessage() + "'"), (boolean)this.fWait.getMessage().contains(expected));
        Assert.assertTrue((String)("MemoryChangedEvent problem: expected 0, received " + this.getEventCount()), (this.getEventCount() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void fillWithInvalidWordSize() throws Throwable {
        SyncUtil.SyncAddBreakpoint("MemoryTestApp.cc:zeroBlocks", true);
        SyncUtil.SyncResumeUntilStopped();
        MIStoppedEvent stoppedEvent = SyncUtil.SyncStep(IRunControl.StepType.STEP_RETURN);
        IStack.IFrameDMContext frameDmc = SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 0);
        long offset = 0L;
        int count = 1;
        byte[] pattern = new byte[1];
        this.fBaseAddress = this.evaluateExpression((IDMContext)frameDmc, "&charBlock");
        String expected = "Word size not supported (!= 1)";
        this.fWait.waitReset();
        this.fillMemory(this.fMemoryDmc, this.fBaseAddress, offset, 0, count, pattern);
        this.fWait.waitUntilDone(0);
        Assert.assertFalse((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        Assert.assertTrue((String)("Wrong error message: expected '" + expected + "', received '" + this.fWait.getMessage() + "'"), (boolean)this.fWait.getMessage().contains(expected));
        this.fWait.waitReset();
        this.fillMemory(this.fMemoryDmc, this.fBaseAddress, offset, 2, count, pattern);
        this.fWait.waitUntilDone(0);
        Assert.assertFalse((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        Assert.assertTrue((String)("Wrong error message: expected '" + expected + "', received '" + this.fWait.getMessage() + "'"), (boolean)this.fWait.getMessage().contains(expected));
        Assert.assertTrue((String)("MemoryChangedEvent problem: expected 0, received " + this.getEventCount()), (this.getEventCount() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void fillWithInvalidCount() throws Throwable {
        SyncUtil.SyncAddBreakpoint("MemoryTestApp.cc:zeroBlocks", true);
        SyncUtil.SyncResumeUntilStopped();
        MIStoppedEvent stoppedEvent = SyncUtil.SyncStep(IRunControl.StepType.STEP_RETURN);
        IStack.IFrameDMContext frameDmc = SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 0);
        long offset = 0L;
        int word_size = 1;
        int count = -1;
        byte[] pattern = new byte[1];
        this.fBaseAddress = this.evaluateExpression((IDMContext)frameDmc, "&charBlock");
        String expected = "Invalid repeat count (< 0)";
        this.fWait.waitReset();
        this.fillMemory(this.fMemoryDmc, this.fBaseAddress, offset, word_size, count, pattern);
        this.fWait.waitUntilDone(0);
        Assert.assertFalse((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        Assert.assertTrue((String)("Wrong error message: expected '" + expected + "', received '" + this.fWait.getMessage() + "'"), (boolean)this.fWait.getMessage().contains(expected));
        Assert.assertTrue((String)("MemoryChangedEvent problem: expected 0, received " + this.getEventCount()), (this.getEventCount() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void fillWithInvalidPattern() throws Throwable {
        SyncUtil.SyncAddBreakpoint("MemoryTestApp.cc:zeroBlocks", true);
        SyncUtil.SyncResumeUntilStopped();
        MIStoppedEvent stoppedEvent = SyncUtil.SyncStep(IRunControl.StepType.STEP_RETURN);
        IStack.IFrameDMContext frameDmc = SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 0);
        long offset = 0L;
        int word_size = 1;
        int count = 1;
        byte[] pattern = new byte[]{};
        this.fBaseAddress = this.evaluateExpression((IDMContext)frameDmc, "&charBlock");
        String expected = "Empty pattern";
        this.fWait.waitReset();
        this.fillMemory(this.fMemoryDmc, this.fBaseAddress, offset, word_size, count, pattern);
        this.fWait.waitUntilDone(0);
        Assert.assertFalse((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        Assert.assertTrue((String)("Wrong error message: expected '" + expected + "', received '" + this.fWait.getMessage() + "'"), (boolean)this.fWait.getMessage().contains(expected));
        Assert.assertTrue((String)("MemoryChangedEvent problem: expected 0, received " + this.getEventCount()), (this.getEventCount() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void writePatternVaryingAddress() throws Throwable {
        int i;
        SyncUtil.SyncAddBreakpoint("MemoryTestApp.cc:zeroBlocks", true);
        SyncUtil.SyncResumeUntilStopped();
        MIStoppedEvent stoppedEvent = SyncUtil.SyncStep(IRunControl.StepType.STEP_RETURN);
        IStack.IFrameDMContext frameDmc = SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 0);
        long offset = 0L;
        int word_size = 1;
        int count = 1;
        int length = 4;
        byte[] pattern = new byte[length];
        for (int i2 = 0; i2 < length; ++i2) {
            pattern[i2] = (byte)i2;
        }
        this.fBaseAddress = this.evaluateExpression((IDMContext)frameDmc, "&charBlock");
        this.fWait.waitReset();
        this.readMemory(this.fMemoryDmc, this.fBaseAddress, offset, word_size, count * length);
        this.fWait.waitUntilDone(0);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        MemoryByte[] block = (MemoryByte[])this.fWait.getReturnInfo();
        for (i = 0; i < count * length; ++i) {
            Assert.assertTrue((String)("Wrong value read at offset " + i + ": expected '" + 0 + "', received '" + block[i].getValue() + "'"), (block[i].getValue() == 0 ? 1 : 0) != 0);
        }
        for (i = 0; i < 256; i += length) {
            IAddress address = this.fBaseAddress.add((long)i);
            this.fWait.waitReset();
            this.fillMemory(this.fMemoryDmc, address, offset, word_size, count, pattern);
            this.fWait.waitUntilDone(0);
            Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        }
        this.fWait.waitReset();
        this.readMemory(this.fMemoryDmc, this.fBaseAddress, 0L, word_size, count * length);
        this.fWait.waitUntilDone(0);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        block = (MemoryByte[])this.fWait.getReturnInfo();
        for (i = 0; i < count; ++i) {
            for (int j = 0; j < length; ++j) {
                int index = i * length + j;
                Assert.assertTrue((String)("Wrong value read at offset " + index + ": expected '" + j + "', received '" + block[index].getValue() + "'"), (block[index].getValue() == (byte)j ? 1 : 0) != 0);
            }
        }
        Assert.assertTrue((String)("MemoryChangedEvent problem: expected " + 256 / length + " events, received " + this.getEventCount()), (this.getEventCount() == 256 / length ? 1 : 0) != 0);
        Assert.assertTrue((String)("MemoryChangedEvent problem: expected 256 distinct addresses, received " + this.getAddressCount()), (this.getAddressCount() == 256 ? 1 : 0) != 0);
    }

    @Test
    public void writePatternVaryingOffset() throws Throwable {
        int i;
        SyncUtil.SyncAddBreakpoint("MemoryTestApp.cc:zeroBlocks", true);
        SyncUtil.SyncResumeUntilStopped();
        MIStoppedEvent stoppedEvent = SyncUtil.SyncStep(IRunControl.StepType.STEP_RETURN);
        IStack.IFrameDMContext frameDmc = SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 0);
        long offset = 0L;
        int word_size = 1;
        int count = 64;
        int length = 4;
        byte[] pattern = new byte[length];
        for (int i2 = 0; i2 < length; ++i2) {
            pattern[i2] = (byte)i2;
        }
        this.fBaseAddress = this.evaluateExpression((IDMContext)frameDmc, "&charBlock");
        this.fWait.waitReset();
        this.readMemory(this.fMemoryDmc, this.fBaseAddress, offset, word_size, count * length);
        this.fWait.waitUntilDone(0);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        MemoryByte[] block = (MemoryByte[])this.fWait.getReturnInfo();
        for (i = 0; i < count * length; ++i) {
            Assert.assertTrue((String)("Wrong value read at offset " + i + ": expected '" + 0 + "', received '" + block[i].getValue() + "'"), (block[i].getValue() == 0 ? 1 : 0) != 0);
        }
        for (i = 0; i < 256 / length; ++i) {
            offset = i * length;
            this.fWait.waitReset();
            this.fillMemory(this.fMemoryDmc, this.fBaseAddress, offset, word_size, 1, pattern);
            this.fWait.waitUntilDone(0);
            Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        }
        this.fWait.waitReset();
        this.readMemory(this.fMemoryDmc, this.fBaseAddress, 0L, word_size, count * length);
        this.fWait.waitUntilDone(0);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        block = (MemoryByte[])this.fWait.getReturnInfo();
        for (i = 0; i < count; ++i) {
            for (int j = 0; j < length; ++j) {
                int index = i * length + j;
                Assert.assertTrue((String)("Wrong value read at offset " + index + ": expected '" + j + "', received '" + block[index].getValue() + "'"), (block[index].getValue() == (byte)j ? 1 : 0) != 0);
            }
        }
        Assert.assertTrue((String)("MemoryChangedEvent problem: expected " + 256 / length + " events, received " + this.getEventCount()), (this.getEventCount() == 256 / length ? 1 : 0) != 0);
        Assert.assertTrue((String)("MemoryChangedEvent problem: expected 256 distinct addresses, received " + this.getAddressCount()), (this.getAddressCount() == 256 ? 1 : 0) != 0);
    }

    @Test
    public void writePatternCountTimes() throws Throwable {
        int i;
        SyncUtil.SyncAddBreakpoint("MemoryTestApp.cc:zeroBlocks", true);
        SyncUtil.SyncResumeUntilStopped();
        MIStoppedEvent stoppedEvent = SyncUtil.SyncStep(IRunControl.StepType.STEP_RETURN);
        IStack.IFrameDMContext frameDmc = SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 0);
        long offset = 0L;
        int word_size = 1;
        int count = 64;
        int length = 4;
        byte[] pattern = new byte[length];
        for (int i2 = 0; i2 < length; ++i2) {
            pattern[i2] = (byte)i2;
        }
        this.fBaseAddress = this.evaluateExpression((IDMContext)frameDmc, "&charBlock");
        this.fWait.waitReset();
        this.readMemory(this.fMemoryDmc, this.fBaseAddress, offset, word_size, count * length);
        this.fWait.waitUntilDone(0);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        MemoryByte[] block = (MemoryByte[])this.fWait.getReturnInfo();
        for (i = 0; i < count * length; ++i) {
            Assert.assertTrue((String)("Wrong value read at offset " + i + ": expected '" + 0 + "', received '" + block[i].getValue() + "'"), (block[i].getValue() == 0 ? 1 : 0) != 0);
        }
        this.fWait.waitReset();
        this.fillMemory(this.fMemoryDmc, this.fBaseAddress, offset, word_size, count, pattern);
        this.fWait.waitUntilDone(0);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        this.fWait.waitReset();
        this.readMemory(this.fMemoryDmc, this.fBaseAddress, offset, word_size, count * length);
        this.fWait.waitUntilDone(0);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        block = (MemoryByte[])this.fWait.getReturnInfo();
        for (i = 0; i < count; ++i) {
            for (int j = 0; j < length; ++j) {
                int index = i * length + j;
                Assert.assertTrue((String)("Wrong value read at offset " + index + ": expected '" + j + "', received '" + block[index].getValue() + "'"), (block[index].getValue() == (byte)j ? 1 : 0) != 0);
            }
        }
        Assert.assertTrue((String)("MemoryChangedEvent problem: expected 1 events, received " + this.getEventCount()), (this.getEventCount() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("MemoryChangedEvent problem: expected 256 distinct addresses, received " + this.getAddressCount()), (this.getAddressCount() == 256 ? 1 : 0) != 0);
    }

    @Test
    public void asynchronousReadWrite() throws Throwable {
        int offset;
        SyncUtil.SyncAddBreakpoint("MemoryTestApp.cc:zeroBlocks", true);
        SyncUtil.SyncResumeUntilStopped();
        MIStoppedEvent stoppedEvent = SyncUtil.SyncStep(IRunControl.StepType.STEP_RETURN);
        IStack.IFrameDMContext frameDmc = SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 0);
        int word_size = 1;
        int count = 1;
        this.fBaseAddress = this.evaluateExpression((IDMContext)frameDmc, "&charBlock");
        this.fWait.waitReset();
        MemoryByte[] buffer = new MemoryByte[256];
        for (offset = 0; offset < 256; ++offset) {
            this.fWait.increment();
            this.readMemoryByteAtOffset(this.fMemoryDmc, this.fBaseAddress, offset, word_size, count, buffer);
        }
        this.fWait.waitUntilDone(0);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        for (offset = 0; offset < 256; ++offset) {
            Assert.assertTrue((String)("Wrong value read at offset " + offset + ": expected '" + 0 + "', received '" + buffer[offset].getValue() + "'"), (buffer[offset].getValue() == 0 ? 1 : 0) != 0);
        }
        this.fWait.waitReset();
        for (offset = 0; offset < 256; ++offset) {
            this.fWait.increment();
            byte[] block = new byte[count];
            block[0] = (byte)offset;
            this.writeMemory(this.fMemoryDmc, this.fBaseAddress, offset, word_size, count, block);
        }
        this.fWait.waitUntilDone(0);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        Assert.assertTrue((String)("MemoryChangedEvent problem: expected 256 events, received " + this.getEventCount()), (this.getEventCount() == 256 ? 1 : 0) != 0);
        Assert.assertTrue((String)("MemoryChangedEvent problem: expected 256 distinct addresses, received " + this.getAddressCount()), (this.getAddressCount() == 256 ? 1 : 0) != 0);
        this.fWait.waitReset();
        for (offset = 0; offset < 256; ++offset) {
            this.fWait.increment();
            this.readMemoryByteAtOffset(this.fMemoryDmc, this.fBaseAddress, offset, word_size, count, buffer);
        }
        this.fWait.waitUntilDone(0);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        for (offset = 0; offset < 256; ++offset) {
            Assert.assertTrue((String)("Wrong value read at offset " + offset + ": expected '" + offset + "', received '" + buffer[offset].getValue() + "'"), (buffer[offset].getValue() == (byte)offset ? 1 : 0) != 0);
        }
    }

    @Test
    public void memoryCacheRead() throws Throwable {
        int i;
        SyncUtil.SyncAddBreakpoint("MemoryTestApp.cc:setBlocks", true);
        SyncUtil.SyncResumeUntilStopped();
        MIStoppedEvent stoppedEvent = SyncUtil.SyncStep(IRunControl.StepType.STEP_RETURN);
        IStack.IFrameDMContext frameDmc = SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 0);
        long offset = 0L;
        int word_size = 1;
        int count = 256;
        this.fBaseAddress = this.evaluateExpression((IDMContext)frameDmc, "&charBlock");
        this.fWait.waitReset();
        this.readMemory(this.fMemoryDmc, this.fBaseAddress, offset, word_size, count);
        this.fWait.waitUntilDone(0);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        MemoryByte[] buffer = (MemoryByte[])this.fWait.getReturnInfo();
        for (i = 0; i < count; ++i) {
            Assert.assertTrue((String)("Wrong value read at offset " + i + ": expected '" + i + "', received '" + buffer[i].getValue() + "'"), (buffer[i].getValue() == (byte)i ? 1 : 0) != 0);
        }
        SyncUtil.SyncStep(IRunControl.StepType.STEP_OVER);
        this.fWait.waitReset();
        offset = 0L;
        count = 64;
        this.readMemory(this.fMemoryDmc, this.fBaseAddress, offset, word_size, count);
        this.fWait.waitUntilDone(0);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        buffer = (MemoryByte[])this.fWait.getReturnInfo();
        for (i = 0; i < count; ++i) {
            Assert.assertTrue((String)("Wrong value read at offset " + i + ": expected '" + offset + i + "', received '" + buffer[i].getValue() + "'"), (buffer[i].getValue() == (byte)(offset + (long)i) ? 1 : 0) != 0);
        }
        this.fWait.waitReset();
        offset = 128L;
        count = 64;
        this.readMemory(this.fMemoryDmc, this.fBaseAddress, offset, word_size, count);
        this.fWait.waitUntilDone(0);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        buffer = (MemoryByte[])this.fWait.getReturnInfo();
        for (i = 0; i < count; ++i) {
            Assert.assertTrue((String)("Wrong value read at offset " + i + ": expected '" + offset + i + "', received '" + buffer[i].getValue() + "'"), (buffer[i].getValue() == (byte)(offset + (long)i) ? 1 : 0) != 0);
        }
        this.fWait.waitReset();
        offset = 80L;
        count = 32;
        this.readMemory(this.fMemoryDmc, this.fBaseAddress, offset, word_size, count);
        this.fWait.waitUntilDone(0);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        buffer = (MemoryByte[])this.fWait.getReturnInfo();
        for (i = 0; i < count; ++i) {
            Assert.assertTrue((String)("Wrong value read at offset " + i + ": expected '" + offset + i + "', received '" + buffer[i].getValue() + "'"), (buffer[i].getValue() == (byte)(offset + (long)i) ? 1 : 0) != 0);
        }
        this.fWait.waitReset();
        offset = 192L;
        count = 32;
        this.readMemory(this.fMemoryDmc, this.fBaseAddress, offset, word_size, count);
        this.fWait.waitUntilDone(0);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        buffer = (MemoryByte[])this.fWait.getReturnInfo();
        for (i = 0; i < count; ++i) {
            Assert.assertTrue((String)("Wrong value read at offset " + i + ": expected '" + offset + i + "', received '" + buffer[i].getValue() + "'"), (buffer[i].getValue() == (byte)(offset + (long)i) ? 1 : 0) != 0);
        }
        this.fWait.waitReset();
        offset = 192L;
        count = 64;
        this.readMemory(this.fMemoryDmc, this.fBaseAddress, offset, word_size, count);
        this.fWait.waitUntilDone(0);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        buffer = (MemoryByte[])this.fWait.getReturnInfo();
        for (i = 0; i < count; ++i) {
            Assert.assertTrue((String)("Wrong value read at offset " + i + ": expected '" + offset + i + "', received '" + buffer[i].getValue() + "'"), (buffer[i].getValue() == (byte)(offset + (long)i) ? 1 : 0) != 0);
        }
        this.fWait.waitReset();
        offset = 32L;
        count = 128;
        this.readMemory(this.fMemoryDmc, this.fBaseAddress, offset, word_size, count);
        this.fWait.waitUntilDone(0);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        buffer = (MemoryByte[])this.fWait.getReturnInfo();
        for (i = 0; i < count; ++i) {
            Assert.assertTrue((String)("Wrong value read at offset " + i + ": expected '" + offset + i + "', received '" + buffer[i].getValue() + "'"), (buffer[i].getValue() == (byte)(offset + (long)i) ? 1 : 0) != 0);
        }
        this.fWait.waitReset();
        offset = 48L;
        count = 192;
        this.readMemory(this.fMemoryDmc, this.fBaseAddress, offset, word_size, count);
        this.fWait.waitUntilDone(0);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        buffer = (MemoryByte[])this.fWait.getReturnInfo();
        for (i = 0; i < count; ++i) {
            Assert.assertTrue((String)("Wrong value read at offset " + i + ": expected '" + offset + i + "', received '" + buffer[i].getValue() + "'"), (buffer[i].getValue() == (byte)(offset + (long)i) ? 1 : 0) != 0);
        }
        this.fWait.waitReset();
        offset = 0L;
        count = 256;
        this.readMemory(this.fMemoryDmc, this.fBaseAddress, offset, word_size, count);
        this.fWait.waitUntilDone(0);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        buffer = (MemoryByte[])this.fWait.getReturnInfo();
        for (i = 0; i < count; ++i) {
            Assert.assertTrue((String)("Wrong value read at offset " + i + ": expected '" + offset + i + "', received '" + buffer[i].getValue() + "'"), (buffer[i].getValue() == (byte)(offset + (long)i) ? 1 : 0) != 0);
        }
        Assert.assertTrue((String)("MemoryChangedEvent problem: expected 0, received " + this.getEventCount()), (this.getEventCount() == 0 ? 1 : 0) != 0);
    }
}

