/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.editor.ui.propertysheet;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Stack;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySource2;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.ui.views.properties.IPropertySourceExtension;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDataType;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.contentmodel.util.DOMNamespaceHelper;
import org.eclipse.wst.xml.core.internal.document.DocumentTypeAdapter;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.Logger;
import org.eclipse.wst.xml.ui.internal.properties.EnumeratedStringPropertyDescriptor;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XMLPropertySource
implements IPropertySource,
IPropertySourceExtension,
IPropertySource2 {
    protected static final String CATEGORY_ATTRIBUTES = "Attributes";
    private static final boolean fSetExpertFilter = false;
    private static final boolean fShouldDeriveCategories = false;
    private static final boolean fSortEnumeratedValues = true;
    private boolean fCaseSensitive;
    private IPropertyDescriptor[] fDescriptors = null;
    private Node fNode = null;
    private Stack fValuesBeingSet = new Stack();

    public XMLPropertySource(INodeNotifier target) {
        this.fNode = this.initNode(target);
        this.fCaseSensitive = this.initCaseSensitive(this.fNode);
    }

    private Node initNode(INodeNotifier target) {
        Node node = null;
        if (!(target instanceof Node)) {
            throw new IllegalArgumentException("XMLPropertySource is only for Nodes");
        }
        node = (Node)target;
        return node;
    }

    private boolean initCaseSensitive(Node node) {
        boolean caseSensitive = true;
        DocumentTypeAdapter adapter = null;
        if (node instanceof IDOMNode) {
            adapter = this.getDocTypeFromDOMNode(node);
        }
        if (adapter != null) {
            caseSensitive = adapter.getTagNameCase() == 0;
        }
        return caseSensitive;
    }

    private DocumentTypeAdapter getDocTypeFromDOMNode(Node node) {
        DocumentTypeAdapter adapter = null;
        Document ownerDocument = node.getOwnerDocument();
        if (ownerDocument == null && node instanceof Document) {
            ownerDocument = (Document)node;
        }
        if (ownerDocument != null) {
            adapter = (DocumentTypeAdapter)((INodeNotifier)ownerDocument).getAdapterFor(DocumentTypeAdapter.class);
        }
        return adapter;
    }

    private String[] _getValidFixedStrings(CMAttributeDeclaration attrDecl, CMDataType helper) {
        boolean checkIfCurrentValueIsIncluded;
        String attributeName = DOMNamespaceHelper.computeName((CMNode)attrDecl, (Node)this.fNode, null);
        ArrayList<String> values = new ArrayList<String>(1);
        String impliedValue = helper.getImpliedValue();
        if (impliedValue != null) {
            values.add(impliedValue);
        }
        boolean bl = checkIfCurrentValueIsIncluded = this.fNode.getAttributes() != null && this.fNode.getAttributes().getNamedItem(attributeName) != null && this.fNode.getAttributes().getNamedItem(attributeName).getNodeValue() != null;
        if (checkIfCurrentValueIsIncluded) {
            String currentValue = null;
            currentValue = this.fNode.getAttributes().getNamedItem(attributeName).getNodeValue();
            if (!currentValue.equals(impliedValue)) {
                values.add(currentValue);
            }
        }
        String[] validStrings = new String[values.size()];
        validStrings = values.toArray(validStrings);
        return validStrings;
    }

    private String[] _getValidStrings(CMAttributeDeclaration attrDecl, CMDataType valuesHelper) {
        String attributeName = DOMNamespaceHelper.computeName((CMNode)attrDecl, (Node)this.fNode, null);
        ArrayList<String> values = new ArrayList<String>(1);
        boolean currentValueKnown = false;
        boolean checkIfCurrentValueIsKnown = this.fNode.getAttributes() != null && this.fNode.getAttributes().getNamedItem(attributeName) != null && this.fNode.getAttributes().getNamedItem(attributeName).getNodeValue() != null;
        String currentValue = null;
        if (checkIfCurrentValueIsKnown) {
            currentValue = this.fNode.getAttributes().getNamedItem(attributeName).getNodeValue();
        }
        if (valuesHelper.getImpliedValueKind() == 2 && valuesHelper.getImpliedValue() != null) {
            currentValueKnown = currentValue != null && valuesHelper.getImpliedValue().equals(currentValue);
            values.add(valuesHelper.getImpliedValue());
        } else {
            String[] valueStrings = null;
            ModelQuery modelQuery = ModelQueryUtil.getModelQuery((Document)this.fNode.getOwnerDocument());
            valueStrings = modelQuery != null && this.fNode.getNodeType() == 1 ? modelQuery.getPossibleDataTypeValues((Element)this.fNode, (CMNode)attrDecl) : attrDecl.getAttrType().getEnumeratedValues();
            if (valueStrings != null) {
                for (int i = 0; i < valueStrings.length; ++i) {
                    if (checkIfCurrentValueIsKnown && valueStrings[i].equals(currentValue)) {
                        currentValueKnown = true;
                    }
                    values.add(valueStrings[i]);
                }
            }
        }
        if (valuesHelper.getImpliedValueKind() != 1 && valuesHelper.getImpliedValue() != null && !values.contains(valuesHelper.getImpliedValue())) {
            values.add(valuesHelper.getImpliedValue());
        }
        if (checkIfCurrentValueIsKnown && !currentValueKnown && currentValue != null && currentValue.length() > 0) {
            values.add(currentValue);
        }
        String[] validStrings = new String[values.size()];
        validStrings = values.toArray(validStrings);
        return validStrings;
    }

    private IPropertyDescriptor createDefaultPropertyDescriptor(String attributeName) {
        return this.createDefaultPropertyDescriptor(attributeName, false);
    }

    private IPropertyDescriptor createDefaultPropertyDescriptor(String attributeName, boolean hideOnFilter) {
        TextPropertyDescriptor descriptor = new TextPropertyDescriptor((Object)attributeName, attributeName);
        descriptor.setCategory(this.getCategory(null));
        descriptor.setDescription(attributeName);
        if (hideOnFilter) {
            // empty if block
        }
        return descriptor;
    }

    private IPropertyDescriptor createEnumeratedPropertyDescriptor(CMAttributeDeclaration attrDecl, CMDataType valuesHelper) {
        String attrName = DOMNamespaceHelper.computeName((CMNode)attrDecl, (Node)this.fNode, null);
        EnumeratedStringPropertyDescriptor descriptor = new EnumeratedStringPropertyDescriptor((Object)attrName, attrDecl.getAttrName(), this._getValidStrings(attrDecl, valuesHelper));
        descriptor.setCategory(this.getCategory(attrDecl));
        descriptor.setDescription(attrName);
        if (attrDecl.getUsage() != 2) {
            // empty if block
        }
        return descriptor;
    }

    private IPropertyDescriptor createFixedPropertyDescriptor(CMAttributeDeclaration attrDecl, CMDataType helper) {
        EnumeratedStringPropertyDescriptor descriptor = new EnumeratedStringPropertyDescriptor((Object)attrDecl.getNodeName(), attrDecl.getNodeName(), this._getValidFixedStrings(attrDecl, helper));
        descriptor.setCategory(this.getCategory(attrDecl));
        descriptor.setDescription(DOMNamespaceHelper.computeName((CMNode)attrDecl, (Node)this.fNode, null));
        return descriptor;
    }

    protected IPropertyDescriptor createPropertyDescriptor(CMAttributeDeclaration attrDecl) {
        IPropertyDescriptor descriptor = null;
        CMDataType attrType = attrDecl.getAttrType();
        descriptor = attrType != null ? (attrType.getEnumeratedValues() != null && attrType.getEnumeratedValues().length > 0 ? this.createEnumeratedPropertyDescriptor(attrDecl, attrType) : ((attrDecl.getUsage() == 3 || attrType.getImpliedValueKind() == 2) && attrType.getImpliedValue() != null ? this.createFixedPropertyDescriptor(attrDecl, attrType) : this.createTextPropertyDescriptor(attrDecl))) : this.createTextPropertyDescriptor(attrDecl);
        return descriptor;
    }

    private IPropertyDescriptor[] createPropertyDescriptors() {
        int i;
        CMNamedNodeMap attrMap = null;
        CMElementDeclaration ed = this.getDeclaration();
        if (ed != null) {
            attrMap = ed.getAttributes();
        }
        ArrayList<IPropertyDescriptor> descriptorList = new ArrayList<IPropertyDescriptor>();
        ArrayList<String> names = new ArrayList<String>();
        CMAttributeDeclaration attrDecl = null;
        NamedNodeMap attributes = this.fNode.getAttributes();
        if (attributes != null) {
            for (i = 0; i < attributes.getLength(); ++i) {
                IPropertyDescriptor descriptor;
                Attr attr = (Attr)attributes.item(i);
                if (attrMap != null) {
                    String attrName = attr.getName();
                    if (this.fCaseSensitive) {
                        attrDecl = (CMAttributeDeclaration)attrMap.getNamedItem(attrName);
                    } else {
                        attrDecl = null;
                        for (int j = 0; j < attrMap.getLength(); ++j) {
                            if (this.fCaseSensitive || !attrMap.item(j).getNodeName().equalsIgnoreCase(attrName)) continue;
                            attrDecl = (CMAttributeDeclaration)attrMap.item(j);
                            break;
                        }
                    }
                }
                if (attrDecl != null) {
                    descriptor = this.createPropertyDescriptor(attrDecl);
                    if (descriptor != null) {
                        names.add(attrDecl.getNodeName());
                    }
                } else {
                    descriptor = this.createDefaultPropertyDescriptor(attr.getName());
                    if (descriptor != null) {
                        names.add(attr.getName());
                    }
                }
                if (descriptor == null) continue;
                descriptorList.add(descriptor);
            }
        }
        if (attrMap != null) {
            for (i = 0; i < attrMap.getLength(); ++i) {
                IPropertyDescriptor holdDescriptor;
                attrDecl = (CMAttributeDeclaration)attrMap.item(i);
                String attrName = DOMNamespaceHelper.computeName((CMNode)attrDecl, (Node)this.fNode, null);
                if (names.contains(attrName) || (holdDescriptor = this.createPropertyDescriptor(attrDecl)) == null) continue;
                descriptorList.add(holdDescriptor);
            }
        }
        IPropertyDescriptor[] descriptors = new IPropertyDescriptor[descriptorList.size()];
        for (int i2 = 0; i2 < descriptors.length; ++i2) {
            descriptors[i2] = (IPropertyDescriptor)descriptorList.get(i2);
        }
        return descriptors;
    }

    private IPropertyDescriptor createTextPropertyDescriptor(CMAttributeDeclaration attrDecl) {
        String attrName = DOMNamespaceHelper.computeName((CMNode)attrDecl, (Node)this.fNode, null);
        TextPropertyDescriptor descriptor = new TextPropertyDescriptor((Object)attrName, attrName);
        descriptor.setCategory(this.getCategory(attrDecl));
        descriptor.setDescription(attrName);
        if (attrDecl.getUsage() != 2) {
            // empty if block
        }
        return descriptor;
    }

    private String getCategory(CMAttributeDeclaration attrDecl) {
        if (attrDecl != null && attrDecl.supports("category")) {
            return (String)attrDecl.getProperty("category");
        }
        return CATEGORY_ATTRIBUTES;
    }

    private CMElementDeclaration getDeclaration() {
        if (this.fNode == null || this.fNode.getNodeType() != 1) {
            return null;
        }
        ModelQuery modelQuery = ModelQueryUtil.getModelQuery((Document)this.fNode.getOwnerDocument());
        if (modelQuery != null) {
            return modelQuery.getCMElementDeclaration((Element)this.fNode);
        }
        return null;
    }

    private Display getDisplay() {
        return PlatformUI.getWorkbench().getDisplay();
    }

    public Object getEditableValue() {
        return null;
    }

    public final IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.fDescriptors == null || this.fDescriptors.length == 0) {
            this.fDescriptors = this.createPropertyDescriptors();
        } else {
            this.updatePropertyDescriptors();
        }
        return this.fDescriptors;
    }

    public Object getPropertyValue(Object nameObject) {
        Node attribute;
        String name = nameObject.toString();
        String returnedValue = null;
        NamedNodeMap attrMap = this.fNode.getAttributes();
        if (attrMap != null && (attribute = attrMap.getNamedItem(name)) != null) {
            returnedValue = attribute instanceof IDOMNode ? ((IDOMNode)attribute).getValueSource() : attribute.getNodeValue();
        }
        if (returnedValue == null) {
            returnedValue = "";
        }
        return returnedValue;
    }

    private String[] getValidValues(CMAttributeDeclaration attrDecl) {
        if (attrDecl == null) {
            return new String[0];
        }
        Object[] validValues = null;
        CMDataType attrType = attrDecl.getAttrType();
        if (attrType != null) {
            validValues = this._getValidStrings(attrDecl, attrType);
            Arrays.sort(validValues);
        }
        if (validValues == null) {
            validValues = new String[]{};
        }
        return validValues;
    }

    public boolean isPropertyRemovable(Object id) {
        return true;
    }

    public boolean isPropertyResettable(Object id) {
        CMDataType helper;
        CMAttributeDeclaration attrDecl;
        boolean resettable = false;
        String property = id.toString();
        CMNamedNodeMap attrDecls = null;
        CMElementDeclaration ed = this.getDeclaration();
        if (ed != null) {
            attrDecls = ed.getAttributes();
        }
        if (attrDecls != null && (attrDecl = (CMAttributeDeclaration)attrDecls.getNamedItem(property)) != null && attrDecl.getAttrType() != null && (helper = attrDecl.getAttrType()).getImpliedValueKind() != 1 && helper.getImpliedValue() != null) {
            resettable = true;
        }
        return resettable;
    }

    public boolean isPropertySet(Object propertyObject) {
        String property = propertyObject.toString();
        NamedNodeMap attrMap = this.fNode.getAttributes();
        if (attrMap != null) {
            return attrMap.getNamedItem(property) != null;
        }
        return false;
    }

    public void removeProperty(Object propertyObject) {
        block3: {
            Node attribute;
            NamedNodeMap attrMap = this.fNode.getAttributes();
            if (attrMap != null && (attribute = attrMap.getNamedItem(propertyObject.toString())) != null) {
                try {
                    attrMap.removeNamedItem(propertyObject.toString());
                }
                catch (DOMException e) {
                    if (e.code == 13) break block3;
                    Logger.logException((Throwable)e);
                }
            }
        }
    }

    public void resetPropertyValue(Object propertyObject) {
        String property = propertyObject.toString();
        CMNamedNodeMap attrDecls = null;
        CMElementDeclaration ed = this.getDeclaration();
        if (ed != null) {
            attrDecls = ed.getAttributes();
        }
        NamedNodeMap attrMap = this.fNode.getAttributes();
        if (attrDecls != null) {
            CMDataType helper;
            CMAttributeDeclaration attrDecl = (CMAttributeDeclaration)attrDecls.getNamedItem(property);
            String defValue = null;
            if (attrDecl != null && attrDecl.getAttrType() != null && (helper = attrDecl.getAttrType()).getImpliedValueKind() != 1 && helper.getImpliedValue() != null) {
                defValue = helper.getImpliedValue();
            }
            if (defValue != null && defValue.length() > 0) {
                ((Attr)attrMap.getNamedItem(property)).setValue(defValue);
            } else {
                attrMap.removeNamedItem(property);
            }
        } else {
            attrMap.removeNamedItem(property);
        }
    }

    public void setPropertyValue(Object nameObject, Object value) {
        block15: {
            if (!this.fValuesBeingSet.isEmpty() && this.fValuesBeingSet.peek() == nameObject) {
                return;
            }
            this.fValuesBeingSet.push(nameObject);
            String name = nameObject.toString();
            String valueString = null;
            if (value != null) {
                valueString = value.toString();
            }
            NamedNodeMap attrMap = this.fNode.getAttributes();
            try {
                if (attrMap != null) {
                    Attr attr = (Attr)attrMap.getNamedItem(name);
                    if (attr != null) {
                        if (attr.getValue() == null || !attr.getValue().equals(valueString)) {
                            if (attr instanceof IDOMNode) {
                                ((IDOMNode)attr).setValueSource(valueString);
                            } else {
                                attr.setValue(valueString);
                            }
                        }
                    } else if (value != null) {
                        Attr newAttr = this.fNode.getOwnerDocument().createAttribute(name);
                        if (newAttr instanceof IDOMNode) {
                            ((IDOMNode)newAttr).setValueSource(valueString);
                        } else {
                            newAttr.setValue(valueString);
                        }
                        attrMap.setNamedItem(newAttr);
                    }
                } else if (this.fNode instanceof Element) {
                    ((Element)this.fNode).setAttribute(name, valueString);
                }
            }
            catch (DOMException e) {
                Display d = this.getDisplay();
                if (d == null) break block15;
                d.beep();
            }
        }
        this.fValuesBeingSet.pop();
    }

    protected void updatePropertyDescriptors() {
        int i;
        if (this.fDescriptors == null || this.fDescriptors.length == 0) {
            return;
        }
        ArrayList<String> declaredNames = new ArrayList<String>();
        ArrayList<IPropertyDescriptor> descriptors = new ArrayList<IPropertyDescriptor>();
        ArrayList<String> descriptorNames = new ArrayList<String>();
        CMElementDeclaration ed = this.getDeclaration();
        CMNamedNodeMap attrMap = null;
        if (ed != null) {
            attrMap = ed.getAttributes();
        }
        if (attrMap != null) {
            CMAttributeDeclaration attrDecl = null;
            for (i = 0; i < attrMap.getLength(); ++i) {
                attrDecl = (CMAttributeDeclaration)attrMap.item(i);
                String attrName = DOMNamespaceHelper.computeName((CMNode)attrDecl, (Node)this.fNode, null);
                if (!declaredNames.contains(attrName)) {
                    declaredNames.add(attrName);
                }
                for (int j = 0; j < this.fDescriptors.length; ++j) {
                    boolean sameName;
                    boolean bl = sameName = this.fCaseSensitive && this.fDescriptors[j].getId().equals(attrDecl.getNodeName()) || !this.fCaseSensitive && attrDecl.getNodeName().equals(this.fDescriptors[j].getId().toString());
                    if (!sameName) continue;
                    String[] validValues = this.getValidValues(attrDecl);
                    if (this.fDescriptors[j] instanceof EnumeratedStringPropertyDescriptor) {
                        ((EnumeratedStringPropertyDescriptor)this.fDescriptors[j]).updateValues(validValues);
                        continue;
                    }
                    if (validValues == null || validValues.length <= 0) continue;
                    this.fDescriptors[j] = this.createPropertyDescriptor(attrDecl);
                }
            }
        } else {
            for (int j = 0; j < this.fDescriptors.length; ++j) {
                if (this.fDescriptors[j] instanceof TextPropertyDescriptor) continue;
                this.fDescriptors[j] = this.createDefaultPropertyDescriptor((String)this.fDescriptors[j].getId());
            }
        }
        NamedNodeMap attributes = this.fNode.getAttributes();
        for (i = 0; i < this.fDescriptors.length; ++i) {
            String descriptorName;
            if (this.fDescriptors[i] == null || !declaredNames.contains(descriptorName = this.fDescriptors[i].getId().toString()) && attributes.getNamedItem(descriptorName) == null || descriptorNames.contains(descriptorName)) continue;
            descriptorNames.add(descriptorName);
            descriptors.add(this.fDescriptors[i]);
        }
        if (attrMap != null) {
            CMAttributeDeclaration attrDecl = null;
            for (int i2 = 0; i2 < attrMap.getLength(); ++i2) {
                attrDecl = (CMAttributeDeclaration)attrMap.item(i2);
                String attrName = DOMNamespaceHelper.computeName((CMNode)attrDecl, (Node)this.fNode, null);
                if (this.fCaseSensitive) {
                    IPropertyDescriptor descriptor;
                    if (descriptorNames.contains(attrName) || (descriptor = this.createPropertyDescriptor(attrDecl)) == null) continue;
                    descriptorNames.add(attrName);
                    descriptors.add(descriptor);
                    continue;
                }
                boolean exists = false;
                for (int j = 0; j < descriptorNames.size(); ++j) {
                    exists = descriptorNames.get(j).toString().equalsIgnoreCase(attrName) || exists;
                }
                if (exists) continue;
                descriptorNames.add(attrName);
                IPropertyDescriptor descriptor = this.createPropertyDescriptor(attrDecl);
                if (descriptor == null) continue;
                descriptorNames.add(attrName);
                descriptors.add(descriptor);
            }
        }
        if (attributes != null) {
            for (int i3 = 0; i3 < attributes.getLength(); ++i3) {
                Attr attr = (Attr)attributes.item(i3);
                String attrName = attr.getName();
                if (this.fCaseSensitive) {
                    if (descriptorNames.contains(attrName)) continue;
                    descriptorNames.add(attrName);
                    descriptors.add(this.createDefaultPropertyDescriptor(attrName));
                    continue;
                }
                boolean exists = false;
                for (int j = 0; j < descriptorNames.size(); ++j) {
                    exists = descriptorNames.get(j).toString().equalsIgnoreCase(attrName) || exists;
                }
                if (exists) continue;
                descriptorNames.add(attrName);
                descriptors.add(this.createDefaultPropertyDescriptor(attrName));
            }
        }
        IPropertyDescriptor[] newDescriptors = new IPropertyDescriptor[descriptors.size()];
        for (int i4 = 0; i4 < newDescriptors.length; ++i4) {
            newDescriptors[i4] = (IPropertyDescriptor)descriptors.get(i4);
        }
        this.fDescriptors = newDescriptors;
    }
}

