/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.concurrent;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dd.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.dd.dsf.concurrent.DefaultDsfExecutor;
import org.eclipse.dd.dsf.concurrent.DsfExecutor;
import org.eclipse.dd.dsf.concurrent.DsfRunnable;
import org.eclipse.dd.dsf.concurrent.ImmediateExecutor;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.concurrent.RequestMonitorWithProgress;
import org.eclipse.dd.dsf.concurrent.ThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public abstract class Sequence
extends DsfRunnable
implements Future<Object> {
    final Sync fSync = new Sync();
    private final DsfExecutor fExecutor;
    private final RequestMonitor fRequestMonitor;
    @ConfinedToDsfExecutor(value="getExecutor")
    private IStatus fStatus = Status.OK_STATUS;
    @ConfinedToDsfExecutor(value="getExecutor")
    private int fCurrentStepIdx = 0;
    private final String fTaskName;
    private final String fRollbackTaskName;
    private final IProgressMonitor fProgressMonitor;

    public Sequence(DsfExecutor executor) {
        this(executor, (IProgressMonitor)new NullProgressMonitor(), "", "", null);
    }

    public Sequence(DsfExecutor executor, RequestMonitor rm) {
        this(executor, (IProgressMonitor)new NullProgressMonitor(), "", "", rm);
    }

    public Sequence(DsfExecutor executor, IProgressMonitor pm, String taskName, String rollbackTaskName) {
        this(executor, pm, taskName, rollbackTaskName, new RequestMonitorWithProgress(ImmediateExecutor.getInstance(), pm));
    }

    public Sequence(DsfExecutor executor, RequestMonitorWithProgress rm, String taskName, String rollbackTaskName) {
        this(executor, rm.getProgressMonitor(), taskName, rollbackTaskName, rm);
    }

    @Deprecated
    public Sequence(DsfExecutor executor, IProgressMonitor pm, String taskName, String rollbackTaskName, RequestMonitor rm) {
        this.fExecutor = executor;
        this.fProgressMonitor = pm;
        this.fTaskName = taskName;
        this.fRollbackTaskName = rollbackTaskName;
        this.fRequestMonitor = rm;
        if (this.fRequestMonitor != null) {
            this.fRequestMonitor.addCancelListener(new RequestMonitor.ICanceledListener(){

                public void requestCanceled(RequestMonitor rm) {
                    Sequence.this.fSync.doCancel();
                }
            });
        }
    }

    public abstract Step[] getSteps();

    public DsfExecutor getExecutor() {
        return this.fExecutor;
    }

    public RequestMonitor getRequestMonitor() {
        return this.fRequestMonitor;
    }

    @Override
    public Object get() throws InterruptedException, ExecutionException {
        this.fSync.doGet();
        return null;
    }

    @Override
    public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.fSync.doGet();
        return null;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.fRequestMonitor != null) {
            this.fRequestMonitor.cancel();
        }
        return this.fSync.doCancel();
    }

    @Override
    public boolean isCancelled() {
        return this.fSync.doIsCancelled();
    }

    @Override
    public boolean isDone() {
        return this.fSync.doIsDone();
    }

    @Override
    public void run() {
        if (this.fSync.doRun()) {
            int totalTicks = 0;
            for (Step step : this.getSteps()) {
                step.setSequence(this);
                totalTicks += step.getTicks();
            }
            if (this.fTaskName != null) {
                this.fProgressMonitor.beginTask(this.fTaskName, totalTicks);
            }
            this.executeStep(0);
        } else {
            this.fSync.doFinish();
        }
    }

    private void executeStep(int nextStepIndex) {
        if (this.fProgressMonitor.isCanceled()) {
            this.cancel(false);
        }
        if (this.isCancelled()) {
            this.cancelExecution();
            return;
        }
        if (nextStepIndex >= this.getSteps().length) {
            this.finish();
            return;
        }
        this.fCurrentStepIdx = nextStepIndex;
        try {
            Step currentStep = this.getSteps()[this.fCurrentStepIdx];
            final boolean stepControlsProgress = currentStep instanceof StepWithProgress;
            RequestMonitor rm = new RequestMonitor(this.fExecutor, this.fRequestMonitor){
                private final int fStepIdx;
                {
                    super(x0, x1);
                    this.fStepIdx = Sequence.this.fCurrentStepIdx;
                }

                public void handleSuccess() {
                    assert (this.fStepIdx == Sequence.this.fCurrentStepIdx);
                    if (!stepControlsProgress) {
                        Sequence.this.fProgressMonitor.worked(Sequence.this.getSteps()[this.fStepIdx].getTicks());
                    }
                    Sequence.this.executeStep(this.fStepIdx + 1);
                }

                protected void handleCancel() {
                    Sequence.this.cancel(false);
                    Sequence.this.cancelExecution();
                }

                protected void handleErrorOrWarning() {
                    Sequence.this.abortExecution(this.getStatus());
                }

                public String toString() {
                    return "Sequence \"" + Sequence.this.fTaskName + "\", result for executing step #" + this.fStepIdx + " = " + this.getStatus();
                }
            };
            this.fProgressMonitor.subTask(currentStep.getTaskName());
            if (stepControlsProgress) {
                SubProgressMonitor subMon = new SubProgressMonitor(this.fProgressMonitor, currentStep.getTicks(), 4);
                ((StepWithProgress)currentStep).execute(rm, (IProgressMonitor)subMon);
            } else {
                currentStep.execute(rm);
            }
        }
        catch (Throwable t) {
            this.abortExecution((IStatus)new Status(4, "org.eclipse.dd.dsf", 0, "Unhandled exception when executing Sequence " + this + ", step #" + this.fCurrentStepIdx, t));
            DefaultDsfExecutor.logException(t);
        }
    }

    private void rollBackStep(int stepIdx) {
        if (stepIdx < 0) {
            this.finish();
            return;
        }
        this.fCurrentStepIdx = stepIdx;
        try {
            this.getSteps()[this.fCurrentStepIdx].rollBack(new RequestMonitor(this.fExecutor, null){
                private final int fStepIdx;
                {
                    this.fStepIdx = Sequence.this.fCurrentStepIdx;
                }

                public void handleCompleted() {
                    assert (this.fStepIdx == Sequence.this.fCurrentStepIdx);
                    if (this.isSuccess()) {
                        Sequence.this.fProgressMonitor.worked(Sequence.this.getSteps()[this.fStepIdx].getTicks());
                        Sequence.this.rollBackStep(this.fStepIdx - 1);
                    } else {
                        Sequence.this.abortRollBack(this.getStatus());
                    }
                }

                public String toString() {
                    return "Sequence \"" + Sequence.this.fTaskName + "\", result for rolling back step #" + this.fStepIdx + " = " + this.getStatus();
                }
            });
        }
        catch (Throwable t) {
            this.abortRollBack((IStatus)new Status(4, "org.eclipse.dd.dsf", 0, "Unhandled exception when rolling back Sequence " + this + ", step #" + this.fCurrentStepIdx, t));
            DefaultDsfExecutor.logException(t);
        }
    }

    private void cancelExecution() {
        if (this.fRollbackTaskName != null) {
            this.fProgressMonitor.subTask(this.fRollbackTaskName);
        }
        this.fStatus = new Status(8, "org.eclipse.dd.dsf", -1, "Sequence \"" + this.fTaskName + "\" cancelled.", null);
        if (this.fRequestMonitor != null) {
            this.fRequestMonitor.setStatus(this.fStatus);
        }
        this.rollBackStep(this.fCurrentStepIdx);
    }

    private void abortExecution(IStatus error) {
        if (this.fRollbackTaskName != null) {
            this.fProgressMonitor.subTask(this.fRollbackTaskName);
        }
        this.fStatus = error;
        if (this.fRequestMonitor != null) {
            this.fRequestMonitor.setStatus(error);
        }
        this.fSync.doAbort((Throwable)new CoreException(error));
        this.rollBackStep(this.fCurrentStepIdx - 1);
    }

    private void abortRollBack(IStatus error) {
        if (this.fRollbackTaskName != null) {
            this.fProgressMonitor.subTask(this.fRollbackTaskName);
        }
        MultiStatus newStatus = new MultiStatus("org.eclipse.dd.dsf", error.getCode(), "Sequence \"" + this.fTaskName + "\" failed while rolling back.", null);
        newStatus.merge(error);
        newStatus.merge(this.fStatus);
        this.fStatus = newStatus;
        if (this.fRequestMonitor != null) {
            this.fRequestMonitor.setStatus((IStatus)newStatus);
        }
        this.finish();
    }

    private void finish() {
        if (this.fRequestMonitor != null) {
            this.fRequestMonitor.done();
        }
        this.fSync.doFinish();
    }

    final class Sync
    extends AbstractQueuedSynchronizer {
        private static final int STATE_RUNNING = 1;
        private static final int STATE_FINISHED = 2;
        private static final int STATE_ABORTING = 4;
        private static final int STATE_ABORTED = 8;
        private static final int STATE_CANCELLING = 16;
        private static final int STATE_CANCELLED = 32;
        private Throwable fException;

        Sync() {
        }

        private boolean isFinished(int state) {
            return (state & 0x2A) != 0;
        }

        protected int tryAcquireShared(int ignore) {
            return this.doIsDone() ? 1 : -1;
        }

        protected boolean tryReleaseShared(int ignore) {
            return true;
        }

        boolean doIsCancelled() {
            int state = this.getState();
            return (state & 0x30) != 0;
        }

        boolean doIsDone() {
            return this.isFinished(this.getState());
        }

        void doGet() throws InterruptedException, ExecutionException {
            this.acquireSharedInterruptibly(0);
            if (this.getState() == 32) {
                throw new CancellationException();
            }
            if (this.fException != null) {
                throw new ExecutionException(this.fException);
            }
        }

        void doGet(long nanosTimeout) throws InterruptedException, ExecutionException, TimeoutException {
            if (!this.tryAcquireSharedNanos(0, nanosTimeout)) {
                throw new TimeoutException();
            }
            if (this.getState() == 32) {
                throw new CancellationException();
            }
            if (this.fException != null) {
                throw new ExecutionException(this.fException);
            }
        }

        void doAbort(Throwable t) {
            int s;
            do {
                if (!this.isFinished(s = this.getState())) continue;
                return;
            } while (!this.compareAndSetState(s, 4));
            this.fException = t;
        }

        boolean doCancel() {
            int s;
            do {
                if (this.isFinished(s = this.getState())) {
                    return false;
                }
                if (s != 4) continue;
                return false;
            } while (!this.compareAndSetState(s, 16));
            return true;
        }

        void doFinish() {
            int s;
            do {
                if (!this.isFinished(s = this.getState())) continue;
                return;
            } while (!(s == 4 ? this.compareAndSetState(s, 8) : (s == 16 ? this.compareAndSetState(s, 32) : this.compareAndSetState(s, 2))));
            this.releaseShared(0);
        }

        boolean doRun() {
            return this.compareAndSetState(0, 1);
        }
    }

    public static abstract class StepWithProgress
    extends Step {
        public final void execute(RequestMonitor rm) {
            assert (false) : "execute(RequestMonitor rm, IProgressMonitor pm) should be called instead";
        }

        public void execute(RequestMonitor rm, IProgressMonitor pm) {
            rm.done();
            pm.done();
        }
    }

    public static abstract class Step {
        private Sequence fSequence;

        void setSequence(Sequence sequence) {
            this.fSequence = sequence;
        }

        public Sequence getSequence() {
            return this.fSequence;
        }

        public void execute(RequestMonitor rm) {
            rm.done();
        }

        public void rollBack(RequestMonitor rm) {
            rm.done();
        }

        public int getTicks() {
            return 1;
        }

        public String getTaskName() {
            return "";
        }
    }
}

