/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dd.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DsfRunnable;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.concurrent.ThreadSafe;
import org.eclipse.dd.dsf.datamodel.DMContexts;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.debug.internal.DsfDebugPlugin;
import org.eclipse.dd.dsf.debug.service.IBreakpointAttributeTranslator;
import org.eclipse.dd.dsf.debug.service.IBreakpoints;
import org.eclipse.dd.dsf.service.AbstractDsfService;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.IBreakpointManagerListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BreakpointsMediator
extends AbstractDsfService
implements IBreakpointManagerListener,
IBreakpointListener {
    private IBreakpointAttributeTranslator fAttributeTranslator;
    IBreakpoints fBreakpoints;
    IBreakpointManager fBreakpointManager;
    private Map<IBreakpoints.IBreakpointsTargetDMContext, Map<IBreakpoint, List<Map<String, Object>>>> fPlatformBPs = new HashMap<IBreakpoints.IBreakpointsTargetDMContext, Map<IBreakpoint, List<Map<String, Object>>>>();
    private Map<IBreakpoints.IBreakpointsTargetDMContext, Map<IBreakpoint, List<IBreakpoints.IBreakpointDMContext>>> fBreakpointDMContexts = new HashMap<IBreakpoints.IBreakpointsTargetDMContext, Map<IBreakpoint, List<IBreakpoints.IBreakpointDMContext>>>();
    private Set<IBreakpoint> fPendingRequests = new HashSet<IBreakpoint>();
    private Set<IBreakpoint> fPendingBreakpoints = new HashSet<IBreakpoint>();

    public BreakpointsMediator(DsfSession session, IBreakpointAttributeTranslator attributeTranslator) {
        super(session);
        this.fAttributeTranslator = attributeTranslator;
    }

    public void initialize(final RequestMonitor rm) {
        super.initialize(new RequestMonitor((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                BreakpointsMediator.this.doInitialize(rm);
            }
        });
    }

    private void doInitialize(RequestMonitor rm) {
        this.fBreakpoints = (IBreakpoints)this.getServicesTracker().getService(IBreakpoints.class);
        this.fBreakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        this.fAttributeTranslator.initialize(this);
        this.fBreakpointManager.addBreakpointListener((IBreakpointListener)this);
        this.fBreakpointManager.addBreakpointManagerListener((IBreakpointManagerListener)this);
        this.register(new String[]{BreakpointsMediator.class.getName()}, new Hashtable());
        rm.done();
    }

    public void shutdown(final RequestMonitor rm) {
        this.unregister();
        this.fBreakpointManager.removeBreakpointListener((IBreakpointListener)this);
        this.fBreakpointManager.removeBreakpointManagerListener((IBreakpointManagerListener)this);
        this.fAttributeTranslator.dispose();
        CountingRequestMonitor countingRm = new CountingRequestMonitor((Executor)this.getExecutor(), rm){

            protected void handleCompleted() {
                BreakpointsMediator.super.shutdown(rm);
            }
        };
        ArrayList<IBreakpoints.IBreakpointsTargetDMContext> platformBPKeysCopy = new ArrayList<IBreakpoints.IBreakpointsTargetDMContext>(this.fPlatformBPs.size());
        platformBPKeysCopy.addAll(0, this.fPlatformBPs.keySet());
        for (IBreakpoints.IBreakpointsTargetDMContext dmc : platformBPKeysCopy) {
            this.stopTrackingBreakpoints(dmc, (RequestMonitor)countingRm);
        }
        countingRm.setDoneCount(platformBPKeysCopy.size());
    }

    protected BundleContext getBundleContext() {
        return DsfDebugPlugin.getBundleContext();
    }

    public void startTrackingBreakpoints(IBreakpoints.IBreakpointsTargetDMContext dmc, final RequestMonitor rm) {
        final IBreakpoints.IBreakpointsTargetDMContext breakpointsDmc = (IBreakpoints.IBreakpointsTargetDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IBreakpoints.IBreakpointsTargetDMContext.class);
        if (breakpointsDmc == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.debug.debug.service", 10005, "Invalid context type", null));
            rm.done();
            return;
        }
        Map<IBreakpoint, List<Map<String, Object>>> platformBPs = this.fPlatformBPs.get(dmc);
        if (platformBPs != null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.debug.debug.service", 10005, "Context already initialized", null));
            rm.done();
            return;
        }
        this.fPlatformBPs.put(breakpointsDmc, new HashMap());
        this.fBreakpointDMContexts.put(breakpointsDmc, new HashMap());
        new Job("MI Debugger: Install initial breakpoint list."){
            {
                super(x0);
                this.setSystem(true);
            }

            protected IStatus run(IProgressMonitor monitor) {
                final HashMap<IBreakpoint, List<Map<String, Object>>> initialPlatformBPs = new HashMap<IBreakpoint, List<Map<String, Object>>>();
                try {
                    IBreakpoint[] bps;
                    for (IBreakpoint bp : bps = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints()) {
                        if (!BreakpointsMediator.this.fAttributeTranslator.supportsBreakpoint(bp)) continue;
                        List<Map<String, Object>> attrsArray = BreakpointsMediator.this.fAttributeTranslator.getBreakpointAttributes(bp, BreakpointsMediator.this.fBreakpointManager.isEnabled());
                        initialPlatformBPs.put(bp, attrsArray);
                    }
                }
                catch (CoreException e) {
                    Status status = new Status(4, "org.eclipse.dd.dsf.debug.debug.service", 10004, "Unable to read initial breakpoint attributes", (Throwable)e);
                    rm.setStatus((IStatus)status);
                    rm.done();
                    return status;
                }
                BreakpointsMediator.this.getExecutor().submit(new Runnable(){

                    public void run() {
                        BreakpointsMediator.this.installInitialBreakpoints(breakpointsDmc, initialPlatformBPs, rm);
                    }
                });
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private void installInitialBreakpoints(IBreakpoints.IBreakpointsTargetDMContext dmc, Map<IBreakpoint, List<Map<String, Object>>> initialPlatformBPs, RequestMonitor rm) {
        Map<IBreakpoint, List<Map<String, Object>>> platformBPs = this.fPlatformBPs.get(dmc);
        if (platformBPs == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.debug.debug.service", 10002, "Invalid context", null));
            rm.done();
            return;
        }
        CountingRequestMonitor countingRm = new CountingRequestMonitor((Executor)this.getExecutor(), rm);
        countingRm.setDoneCount(initialPlatformBPs.size());
        for (IBreakpoint bp : initialPlatformBPs.keySet()) {
            List<Map<String, Object>> attrs = initialPlatformBPs.get(bp);
            this.installBreakpoint(dmc, bp, attrs, new RequestMonitor((Executor)this.getExecutor(), (RequestMonitor)countingRm));
        }
    }

    public void stopTrackingBreakpoints(IBreakpoints.IBreakpointsTargetDMContext dmc, RequestMonitor rm) {
        Map<IBreakpoint, List<Map<String, Object>>> platformBPs = this.fPlatformBPs.get(dmc);
        if (platformBPs == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.debug.debug.service", 10005, "Breakpoints not installed for given context", null));
            rm.done();
            return;
        }
        final CountingRequestMonitor countingRm = new CountingRequestMonitor((Executor)this.getExecutor(), rm);
        countingRm.setDoneCount(platformBPs.size());
        for (final IBreakpoint bp : platformBPs.keySet()) {
            this.uninstallBreakpoint(dmc, bp, new RequestMonitor((Executor)this.getExecutor(), (RequestMonitor)countingRm){

                protected void handleCompleted() {
                    new Job("Breakpoint status update"){
                        {
                            this.setSystem(true);
                        }

                        protected IStatus run(IProgressMonitor monitor) {
                            BreakpointsMediator.this.fAttributeTranslator.updateBreakpointStatus(bp);
                            return Status.OK_STATUS;
                        }
                    }.schedule();
                    countingRm.done();
                }
            });
        }
    }

    private void installBreakpoint(IBreakpoints.IBreakpointsTargetDMContext dmc, final IBreakpoint breakpoint, final List<Map<String, Object>> attrsList, final RequestMonitor rm) {
        final Map<IBreakpoint, List<Map<String, Object>>> platformBPs = this.fPlatformBPs.get(dmc);
        assert (platformBPs != null);
        final Map<IBreakpoint, List<IBreakpoints.IBreakpointDMContext>> breakpointIDs = this.fBreakpointDMContexts.get(dmc);
        assert (breakpointIDs != null);
        if (platformBPs.containsKey(breakpoint)) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.debug.debug.service", 10001, "Breakpoint already installed", null));
            rm.done();
            return;
        }
        final CountingRequestMonitor installRM = new CountingRequestMonitor((Executor)this.getExecutor(), rm){

            protected void handleCompleted() {
                platformBPs.put(breakpoint, attrsList);
                new Job("Breakpoint status update"){
                    {
                        this.setSystem(true);
                    }

                    protected IStatus run(IProgressMonitor monitor) {
                        BreakpointsMediator.this.fAttributeTranslator.updateBreakpointStatus(breakpoint);
                        return Status.OK_STATUS;
                    }
                }.schedule();
                rm.done();
            }
        };
        installRM.setDoneCount(attrsList.size());
        for (Map<String, Object> attrs : attrsList) {
            this.fBreakpoints.insertBreakpoint(dmc, attrs, new DataRequestMonitor<IBreakpoints.IBreakpointDMContext>((Executor)this.getExecutor(), (RequestMonitor)installRM){

                protected void handleCompleted() {
                    LinkedList<Object> list = (LinkedList<Object>)breakpointIDs.get(breakpoint);
                    if (list == null) {
                        list = new LinkedList<Object>();
                        breakpointIDs.put(breakpoint, list);
                    }
                    if (this.isSuccess()) {
                        list.add(this.getData());
                    }
                    installRM.done();
                }
            });
        }
    }

    private void uninstallBreakpoint(final IBreakpoints.IBreakpointsTargetDMContext dmc, final IBreakpoint breakpoint, final RequestMonitor rm) {
        CountingRequestMonitor removeRM = new CountingRequestMonitor((Executor)this.getExecutor(), rm){

            protected void handleCompleted() {
                Map platformBPs = (Map)BreakpointsMediator.this.fPlatformBPs.get(dmc);
                if (platformBPs == null) {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.debug.debug.service", 10002, "Invalid context", null));
                    rm.done();
                    return;
                }
                platformBPs.remove(breakpoint);
                Map breakpointIDs = (Map)BreakpointsMediator.this.fBreakpointDMContexts.get(dmc);
                if (breakpointIDs == null) {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.debug.debug.service", 10002, "Invalid breakpoint", null));
                    rm.done();
                    return;
                }
                ((List)breakpointIDs.get(breakpoint)).clear();
                breakpointIDs.remove(breakpoint);
                new Job("Breakpoint status update"){
                    {
                        this.setSystem(true);
                    }

                    protected IStatus run(IProgressMonitor monitor) {
                        BreakpointsMediator.this.fAttributeTranslator.updateBreakpointStatus(breakpoint);
                        return Status.OK_STATUS;
                    }
                }.schedule();
                rm.done();
            }
        };
        Map<IBreakpoint, List<IBreakpoints.IBreakpointDMContext>> breakpointIDs = this.fBreakpointDMContexts.get(dmc);
        if (breakpointIDs == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.debug.debug.service", 10002, "Invalid breakpoint", null));
            rm.done();
            return;
        }
        List<IBreakpoints.IBreakpointDMContext> list = breakpointIDs.get(breakpoint);
        int count = 0;
        if (list != null) {
            for (IBreakpoints.IBreakpointDMContext bp : list) {
                this.fBreakpoints.removeBreakpoint(bp, (RequestMonitor)removeRM);
            }
            count = list.size();
        }
        removeRM.setDoneCount(count);
    }

    private void modifyBreakpoint(final IBreakpoints.IBreakpointsTargetDMContext context, final IBreakpoint breakpoint, List<Map<String, Object>> newAttrsList0, IMarkerDelta oldValues, RequestMonitor rm) {
        final Map<IBreakpoint, List<Map<String, Object>>> platformBPs = this.fPlatformBPs.get(context);
        final Map<IBreakpoint, List<IBreakpoints.IBreakpointDMContext>> breakpointIDs = this.fBreakpointDMContexts.get(context);
        if (platformBPs == null || breakpointIDs == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.debug.debug.service", 10002, "Invalid context", null));
            rm.done();
            return;
        }
        List<Map<String, Object>> oldAttrsList0 = platformBPs.get(breakpoint);
        if (oldAttrsList0 == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.debug.debug.service", 10002, "Invalid breakpoint", null));
            rm.done();
            return;
        }
        ArrayList oldBpContexts = new ArrayList(breakpointIDs.get(breakpoint));
        if (oldBpContexts == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.debug.debug.service", 10002, "Invalid breakpoint", null));
            rm.done();
            return;
        }
        final List<Map<String, Object>> commonAttrsList = this.getCommonAttributeMaps(newAttrsList0, oldAttrsList0);
        final ArrayList newBpContexts = new ArrayList(commonAttrsList.size());
        final ArrayList<Map<String, Object>> newAttrsList = new ArrayList<Map<String, Object>>(newAttrsList0);
        newAttrsList.removeAll(commonAttrsList);
        ArrayList<Map<String, Object>> oldAttrsList = new ArrayList<Map<String, Object>>(oldAttrsList0);
        for (int i = 0; i < oldAttrsList.size(); ++i) {
            if (!commonAttrsList.contains(oldAttrsList.get(i)) || oldBpContexts.size() <= i) continue;
            newBpContexts.add(oldBpContexts.remove(i));
        }
        oldAttrsList.removeAll(commonAttrsList);
        List<Map<String, Object>> attrDeltasList = this.getAttributesDeltas(oldAttrsList, newAttrsList);
        final CountingRequestMonitor countingRM = new CountingRequestMonitor((Executor)this.getExecutor(), rm){

            protected void handleCompleted() {
                breakpointIDs.put(breakpoint, newBpContexts);
                newAttrsList.addAll(commonAttrsList);
                platformBPs.put(breakpoint, newAttrsList);
                new Job("Breakpoint status update"){
                    {
                        this.setSystem(true);
                    }

                    protected IStatus run(IProgressMonitor monitor) {
                        BreakpointsMediator.this.fAttributeTranslator.updateBreakpointStatus(breakpoint);
                        return Status.OK_STATUS;
                    }
                }.schedule();
                super.handleCompleted();
            }
        };
        countingRM.setDoneCount(attrDeltasList.size());
        for (int i = 0; i < attrDeltasList.size(); ++i) {
            Map attrs;
            if (attrDeltasList.get(i) == null) {
                this.fBreakpoints.removeBreakpoint((IBreakpoints.IBreakpointDMContext)oldBpContexts.get(i), (RequestMonitor)countingRM);
                continue;
            }
            if (i >= oldBpContexts.size()) {
                attrs = (Map)newAttrsList.get(i);
                this.fBreakpoints.insertBreakpoint(context, attrs, new DataRequestMonitor<IBreakpoints.IBreakpointDMContext>((Executor)this.getExecutor(), (RequestMonitor)countingRM){

                    protected void handleSuccess() {
                        newBpContexts.add(this.getData());
                        countingRM.done();
                    }
                });
                continue;
            }
            if (!this.fAttributeTranslator.canUpdateAttributes((IBreakpoints.IBreakpointDMContext)oldBpContexts.get(i), attrDeltasList.get(i))) {
                attrs = (Map)newAttrsList.get(i);
                this.fBreakpoints.removeBreakpoint((IBreakpoints.IBreakpointDMContext)oldBpContexts.get(i), new RequestMonitor((Executor)this.getExecutor(), (RequestMonitor)countingRM){

                    protected void handleCompleted() {
                        BreakpointsMediator.this.fBreakpoints.insertBreakpoint(context, attrs, new DataRequestMonitor<IBreakpoints.IBreakpointDMContext>((Executor)BreakpointsMediator.this.getExecutor(), (RequestMonitor)countingRM){

                            protected void handleCompleted() {
                                if (this.isSuccess()) {
                                    newBpContexts.add(this.getData());
                                }
                                countingRM.done();
                            }
                        });
                    }
                });
                continue;
            }
            final IBreakpoints.IBreakpointDMContext bpCtx = (IBreakpoints.IBreakpointDMContext)oldBpContexts.get(i);
            this.fBreakpoints.updateBreakpoint((IBreakpoints.IBreakpointDMContext)oldBpContexts.get(i), (Map)newAttrsList.get(i), new RequestMonitor((Executor)this.getExecutor(), (RequestMonitor)countingRM){

                protected void handleSuccess() {
                    newBpContexts.add(bpCtx);
                    countingRM.done();
                }
            });
        }
    }

    private List<Map<String, Object>> getCommonAttributeMaps(List<Map<String, Object>> array1, List<Map<String, Object>> array2) {
        LinkedList<Map<String, Object>> intersection = new LinkedList<Map<String, Object>>();
        ArrayList<Map<String, Object>> list2 = new ArrayList<Map<String, Object>>(array2);
        for (Map<String, Object> array1Map : array1) {
            if (!list2.remove(array1Map)) continue;
            intersection.add(array1Map);
        }
        return intersection;
    }

    private List<Map<String, Object>> getAttributesDeltas(List<Map<String, Object>> oldAttributesList, List<Map<String, Object>> newAttributesList) {
        int i;
        ArrayList<Map<String, Object>> deltas = new ArrayList<Map<String, Object>>(oldAttributesList.size());
        for (i = 0; i < oldAttributesList.size() && i < newAttributesList.size(); ++i) {
            Map<String, Object> oldAttributes = oldAttributesList.get(i);
            Map<String, Object> newAttributes = newAttributesList.get(i);
            HashMap<String, Object> delta = new HashMap<String, Object>();
            Set<String> oldKeySet = oldAttributes.keySet();
            Set<String> newKeySet = newAttributes.keySet();
            HashSet<String> commonKeys = new HashSet<String>(newKeySet);
            commonKeys.retainAll(oldKeySet);
            HashSet<String> addedKeys = new HashSet<String>(newKeySet);
            addedKeys.removeAll(oldKeySet);
            HashSet<String> removedKeys = new HashSet<String>(oldKeySet);
            removedKeys.removeAll(newKeySet);
            for (String key : commonKeys) {
                if (oldAttributes.get(key).equals(newAttributes.get(key))) continue;
                delta.put(key, newAttributes.get(key));
            }
            for (String key : addedKeys) {
                delta.put(key, newAttributes.get(key));
            }
            for (String key : removedKeys) {
                delta.put(key, null);
            }
            deltas.add(delta);
        }
        for (i = deltas.size(); i < newAttributesList.size(); ++i) {
            deltas.add(newAttributesList.get(i));
        }
        for (i = deltas.size(); i < oldAttributesList.size(); ++i) {
            deltas.add(null);
        }
        return deltas;
    }

    public void breakpointManagerEnablementChanged(boolean enabled) {
        for (IBreakpoint breakpoint : this.fBreakpointManager.getBreakpoints()) {
            this.breakpointChanged(breakpoint, null);
        }
    }

    @ThreadSafe
    public void breakpointAdded(final IBreakpoint breakpoint) {
        if (this.fAttributeTranslator.supportsBreakpoint(breakpoint)) {
            try {
                final List<Map<String, Object>> attrsArray = this.fAttributeTranslator.getBreakpointAttributes(breakpoint, this.fBreakpointManager.isEnabled());
                this.getExecutor().execute((Runnable)new DsfRunnable(){

                    public void run() {
                        CountingRequestMonitor countingRm = new CountingRequestMonitor((Executor)BreakpointsMediator.this.getExecutor(), null){

                            protected void handleError() {
                                if (this.getStatus().getSeverity() == 4) {
                                    DsfDebugPlugin.getDefault().getLog().log(this.getStatus());
                                }
                            }
                        };
                        countingRm.setDoneCount(BreakpointsMediator.this.fPlatformBPs.size());
                        for (IBreakpoints.IBreakpointsTargetDMContext dmc : BreakpointsMediator.this.fPlatformBPs.keySet()) {
                            BreakpointsMediator.this.installBreakpoint(dmc, breakpoint, attrsArray, new RequestMonitor((Executor)BreakpointsMediator.this.getExecutor(), (RequestMonitor)countingRm));
                        }
                    }
                });
            }
            catch (CoreException e) {
                DsfDebugPlugin.getDefault().getLog().log(e.getStatus());
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
    }

    public void breakpointChanged(final IBreakpoint breakpoint, final IMarkerDelta delta) {
        if (this.fAttributeTranslator.supportsBreakpoint(breakpoint)) {
            try {
                final List<Map<String, Object>> attrsArray = this.fAttributeTranslator.getBreakpointAttributes(breakpoint, this.fBreakpointManager.isEnabled());
                this.getExecutor().execute((Runnable)new DsfRunnable(){

                    public void run() {
                        if (BreakpointsMediator.this.fPendingRequests.contains(breakpoint)) {
                            BreakpointsMediator.this.fPendingBreakpoints.add(breakpoint);
                            return;
                        }
                        CountingRequestMonitor countingRm = new CountingRequestMonitor((Executor)BreakpointsMediator.this.getExecutor(), null){

                            protected void handleCompleted() {
                                if (!this.isSuccess() && this.getStatus().getSeverity() == 4) {
                                    DsfDebugPlugin.getDefault().getLog().log(this.getStatus());
                                }
                                BreakpointsMediator.this.fPendingRequests.remove(breakpoint);
                                if (BreakpointsMediator.this.fPendingBreakpoints.contains(breakpoint)) {
                                    BreakpointsMediator.this.fPendingBreakpoints.remove(breakpoint);
                                    new Job("Deferred breakpoint changed job"){
                                        {
                                            this.setSystem(true);
                                        }

                                        protected IStatus run(IProgressMonitor monitor) {
                                            BreakpointsMediator.this.breakpointChanged(breakpoint, delta);
                                            return Status.OK_STATUS;
                                        }
                                    }.schedule();
                                }
                            }
                        };
                        countingRm.setDoneCount(BreakpointsMediator.this.fPlatformBPs.size());
                        BreakpointsMediator.this.fPendingRequests.add(breakpoint);
                        for (IBreakpoints.IBreakpointsTargetDMContext dmc : BreakpointsMediator.this.fPlatformBPs.keySet()) {
                            BreakpointsMediator.this.modifyBreakpoint(dmc, breakpoint, attrsArray, delta, new RequestMonitor((Executor)BreakpointsMediator.this.getExecutor(), (RequestMonitor)countingRm));
                        }
                    }
                });
            }
            catch (CoreException e) {
                DsfDebugPlugin.getDefault().getLog().log(e.getStatus());
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
    }

    public void breakpointRemoved(final IBreakpoint breakpoint, IMarkerDelta delta) {
        if (this.fAttributeTranslator.supportsBreakpoint(breakpoint)) {
            try {
                this.getExecutor().execute((Runnable)new DsfRunnable(){

                    public void run() {
                        CountingRequestMonitor countingRm = new CountingRequestMonitor((Executor)BreakpointsMediator.this.getExecutor(), null){

                            protected void handleError() {
                                if (this.getStatus().getSeverity() == 4) {
                                    DsfDebugPlugin.getDefault().getLog().log(this.getStatus());
                                }
                            }
                        };
                        countingRm.setDoneCount(BreakpointsMediator.this.fPlatformBPs.size());
                        for (IBreakpoints.IBreakpointsTargetDMContext dmc : BreakpointsMediator.this.fPlatformBPs.keySet()) {
                            if (((Map)BreakpointsMediator.this.fPlatformBPs.get(dmc)).remove(breakpoint) == null) continue;
                            BreakpointsMediator.this.uninstallBreakpoint(dmc, breakpoint, (RequestMonitor)countingRm);
                        }
                    }
                });
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
    }
}

