/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.mi.service.command.output;

import java.util.ArrayList;
import org.eclipse.dd.dsf.debug.service.command.ICommand;
import org.eclipse.dd.dsf.debug.service.command.ICommandResult;
import org.eclipse.dd.mi.service.command.commands.MIDataListRegisterValues;
import org.eclipse.dd.mi.service.command.output.MIInfo;
import org.eclipse.dd.mi.service.command.output.MIList;
import org.eclipse.dd.mi.service.command.output.MIOutput;
import org.eclipse.dd.mi.service.command.output.MIRegisterValue;
import org.eclipse.dd.mi.service.command.output.MIResult;
import org.eclipse.dd.mi.service.command.output.MIResultRecord;
import org.eclipse.dd.mi.service.command.output.MIValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MIDataListRegisterValuesInfo
extends MIInfo {
    MIRegisterValue[] registers = null;

    public MIDataListRegisterValuesInfo(MIOutput rr) {
        super(rr);
        MIOutput out;
        MIResultRecord outr;
        if (this.isDone() && (outr = (out = this.getMIOutput()).getMIResultRecord()) != null) {
            MIResult[] results = outr.getMIResults();
            for (int i = 0; i < results.length; ++i) {
                MIValue value;
                String var = results[i].getVariable();
                if (!var.equals("register-values") || !((value = results[i].getMIValue()) instanceof MIList)) continue;
                this.registers = MIRegisterValue.getMIRegisterValues((MIList)value);
            }
        }
        if (this.registers == null) {
            this.registers = new MIRegisterValue[0];
        }
    }

    public MIRegisterValue[] getMIRegisterValues() {
        return this.registers;
    }

    @Override
    public <V extends ICommandResult> V getSubsetResult(ICommand<V> cmd) {
        if (cmd instanceof MIDataListRegisterValues) {
            MIDataListRegisterValues command = (MIDataListRegisterValues)cmd;
            ArrayList<MIRegisterValue> aList = new ArrayList<MIRegisterValue>();
            int[] wantedRegNos = command.getRegList();
            for (MIRegisterValue regVal : this.registers) {
                for (int curRegNo : wantedRegNos) {
                    if (regVal.getNumber() != curRegNo) continue;
                    aList.add(regVal);
                }
            }
            MIRegisterValue[] finalRegSet = aList.toArray(new MIRegisterValue[aList.size()]);
            MIDataListRegisterValuesInfo finalSubset = new MIDataListRegisterValuesInfo(this.getMIOutput());
            finalSubset.registers = finalRegSet;
            MIDataListRegisterValuesInfo vFinalSubset = finalSubset;
            return (V)vFinalSubset;
        }
        return super.getSubsetResult(cmd);
    }
}

