/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.mi.service.command.output;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.dd.dsf.concurrent.Immutable;
import org.eclipse.dd.mi.service.command.output.MIConst;
import org.eclipse.dd.mi.service.command.output.MIFrame;
import org.eclipse.dd.mi.service.command.output.MIResult;
import org.eclipse.dd.mi.service.command.output.MITuple;
import org.eclipse.dd.mi.service.command.output.MIValue;

@Immutable
public class MIThread {
    private final String fThreadId;
    private final String fTargetId;
    private final String fOsId;
    private final String fParentId;
    private final MIFrame fTopFrame;
    private final String fDetails;
    private final String fState;
    private static Pattern fgOsIdPattern1 = Pattern.compile("(Thread\\s*)(0x[0-9a-fA-F]+|-?\\d+)(\\s*\\(LWP\\s*)(\\d*)", 0);
    private static Pattern fgOsIdPattern2 = Pattern.compile("Thread\\s*\\d+\\.(\\d+)", 0);
    private static Pattern fgIdPattern = Pattern.compile("Thread\\s*(\\d+)\\.\\d+", 0);

    private MIThread(String threadId, String targetId, String osId, String parentId, MIFrame topFrame, String details, String state) {
        this.fThreadId = threadId;
        this.fTargetId = targetId;
        this.fOsId = osId;
        this.fParentId = parentId;
        this.fTopFrame = topFrame;
        this.fDetails = details;
        this.fState = state;
    }

    public String getThreadId() {
        return this.fThreadId;
    }

    public String getTargetId() {
        return this.fTargetId;
    }

    public String getOsId() {
        return this.fOsId;
    }

    public String getParentId() {
        return this.fParentId;
    }

    public MIFrame getTopFrame() {
        return this.fTopFrame;
    }

    public String getDetails() {
        return this.fDetails;
    }

    public String getState() {
        return this.fState;
    }

    public static MIThread parse(MITuple tuple) {
        MIResult[] results = tuple.getMIResults();
        String threadId = null;
        String targetId = null;
        String osId = null;
        String parentId = null;
        MIFrame topFrame = null;
        String state = null;
        String details = null;
        for (int j = 0; j < results.length; ++j) {
            MIValue val;
            MIResult result = results[j];
            String var = result.getVariable();
            if (var.equals("id")) {
                val = results[j].getMIValue();
                if (!(val instanceof MIConst)) continue;
                threadId = ((MIConst)val).getCString().trim();
                continue;
            }
            if (var.equals("target-id")) {
                val = results[j].getMIValue();
                if (!(val instanceof MIConst)) continue;
                targetId = ((MIConst)val).getCString().trim();
                osId = MIThread.parseOsId(targetId);
                parentId = MIThread.parseParentId(targetId);
                continue;
            }
            if (var.equals("frame")) {
                val = (MITuple)results[j].getMIValue();
                topFrame = new MIFrame((MITuple)val);
                continue;
            }
            if (var.equals("state")) {
                val = results[j].getMIValue();
                if (!(val instanceof MIConst)) continue;
                state = ((MIConst)val).getCString().trim();
                continue;
            }
            if (!var.equals("details") || !((val = results[j].getMIValue()) instanceof MIConst)) continue;
            details = ((MIConst)val).getCString().trim();
        }
        return new MIThread(threadId, targetId, osId, parentId, topFrame, details, state);
    }

    private static String parseOsId(String str) {
        Matcher matcher = fgOsIdPattern1.matcher(str);
        if (matcher.find()) {
            return matcher.group(4);
        }
        matcher = fgOsIdPattern2.matcher(str);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    private static String parseParentId(String str) {
        Matcher matcher = fgIdPattern.matcher(str);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }
}

