/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.editor.core.spiritnodes;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dd.ipxact.editor.core.schema.SchemaInfo;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.GenericBusInterface;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.OnMaster;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.OnMode;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.OnSlave;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.OnSystem;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.SpiritNode;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpiritSignal
extends SpiritNode {
    public static final int ON_SYSTEM = 0;
    public static final int ON_MASTER = 1;
    public static final int ON_SLAVE = 2;
    private static final String[] logicalNames = new String[]{"onSystem", "onMaster", "onSlave"};
    public SignalInfo[] signalInfos = new SignalInfo[]{null, null, null};

    public SpiritSignal(Element signalElement) {
        super(signalElement);
        for (int index = 0; index <= 2; ++index) {
            SpiritNode element = this.getUniqueDescendantElement(logicalNames[index], SpiritNode.class);
            if (element == null) continue;
            this.signalInfos[index] = this.getSignalInfo(element);
        }
    }

    @Override
    public String getName() {
        return this.getUniqueDescendantText("logicalName");
    }

    private SignalInfo getSignalInfo(SpiritNode busTypeElement) {
        SignalInfo signalInfo = new SignalInfo();
        SpiritNode element = busTypeElement.getUniqueDescendantElement("bitWidth", SpiritNode.class);
        signalInfo.bitWidth = element != null ? element.getTextContent() : null;
        element = busTypeElement.getUniqueDescendantElement("direction", SpiritNode.class);
        signalInfo.direction = element != null ? element.getTextContent() : null;
        return signalInfo;
    }

    public SignalInfo getSignalInfo(int index) {
        switch (index) {
            case 0: 
            case 1: 
            case 2: {
                return this.signalInfos[index];
            }
        }
        return null;
    }

    public boolean isAddressable() {
        String isAddress = this.getUniqueChildText("isAddress");
        return "true".equals(isAddress);
    }

    public OnMaster getOnMasterNode() {
        return this.getUniqueDescendantElement("onMaster", OnMaster.class);
    }

    public OnSlave getOnSlaveNode() {
        return this.getUniqueDescendantElement("onSlave", OnSlave.class);
    }

    public List<OnSystem> getOnSystemNodes() {
        return this.getDescendants("onSystem", OnSystem.class);
    }

    public List<OnMode> getOnModeNodes() {
        OnMaster m;
        ArrayList<OnMode> result = new ArrayList<OnMode>();
        result.addAll(this.getOnSystemNodes());
        OnSlave s = this.getOnSlaveNode();
        if (s != null) {
            result.add(s);
        }
        if ((m = this.getOnMasterNode()) != null) {
            result.add(m);
        }
        return result;
    }

    public boolean isWirePort() {
        if (this.schemaVersion() == SchemaInfo.IpxactVersion.BEFORE_V14) {
            return true;
        }
        return this.getUniqueChildElement("wire", SpiritNode.class) != null;
    }

    public OnMode getModeInfoForBusInterface(GenericBusInterface busInterface) {
        String busInterfaceMode = busInterface.getModeString();
        if (busInterfaceMode.equals("monitor")) {
            busInterfaceMode = busInterface.getMonitorInterfaceType();
        }
        if (busInterfaceMode.equals("master") || busInterfaceMode.equals("mirroredMaster")) {
            return this.getOnMasterNode();
        }
        if (busInterfaceMode.equals("slave") || busInterfaceMode.equals("mirroredSlave")) {
            return this.getOnSlaveNode();
        }
        String group = busInterface.getSystemGroup();
        List<OnSystem> systemNodes = this.getOnSystemNodes();
        for (OnSystem systemNode : systemNodes) {
            if (!systemNode.getGroup().equals(group)) continue;
            return systemNode;
        }
        return null;
    }

    public class SignalInfo {
        public String bitWidth;
        public String direction;

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.direction);
            stringBuilder.append(',');
            stringBuilder.append(this.bitWidth);
            return stringBuilder.toString();
        }
    }
}

