/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.editor.ui.utils;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dd.ipxact.editor.ui.SpiritUiPlugin;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class OverlayImageDescriptor
extends CompositeImageDescriptor {
    private final ImageDescriptor baseImage;
    private final ImageDescriptor[] overlayImages;
    private ImageDescriptor overlayImage;
    private final int width;
    private final int height;

    public OverlayImageDescriptor(ImageDescriptor baseImage, ImageDescriptor[] overlayImages, int width, int height) {
        Assert.isNotNull((Object)baseImage);
        Assert.isNotNull((Object)overlayImages);
        Assert.isLegal((width > 0 ? 1 : 0) != 0);
        Assert.isLegal((height > 0 ? 1 : 0) != 0);
        this.baseImage = baseImage;
        this.overlayImages = overlayImages;
        this.width = width;
        this.height = height;
    }

    public void showOverlay(int index) {
        this.overlayImage = index >= 0 && index < this.overlayImages.length ? this.overlayImages[index] : null;
    }

    protected Point getSize() {
        return new Point(this.width, this.height);
    }

    protected void drawCompositeImage(int w, int h) {
        ImageData bg = this.getImageData(this.baseImage);
        this.drawImage(bg, 0, 0);
        if (this.overlayImage != null) {
            ImageData data = this.getImageData(this.overlayImage);
            this.drawImage(data, 0, this.height - data.height);
        }
    }

    private ImageData getImageData(ImageDescriptor descriptor) {
        ImageData data = descriptor.getImageData();
        if (data == null) {
            data = DEFAULT_IMAGE_DATA;
            SpiritUiPlugin.logErrorMessage("Image data not available: " + descriptor.toString());
        }
        return data;
    }
}

