/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.internal.ui.disassembly;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import org.eclipse.cdt.internal.ui.text.CWordFinder;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DsfExecutor;
import org.eclipse.dd.dsf.concurrent.Query;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.debug.internal.ui.DsfDebugUIPlugin;
import org.eclipse.dd.dsf.debug.internal.ui.disassembly.DisassemblyPart;
import org.eclipse.dd.dsf.debug.internal.ui.disassembly.model.AddressRangePosition;
import org.eclipse.dd.dsf.debug.internal.ui.disassembly.model.DisassemblyDocument;
import org.eclipse.dd.dsf.debug.internal.ui.disassembly.model.DisassemblyPosition;
import org.eclipse.dd.dsf.debug.internal.ui.disassembly.model.LabelPosition;
import org.eclipse.dd.dsf.debug.internal.ui.disassembly.model.SourcePosition;
import org.eclipse.dd.dsf.debug.service.IExpressions;
import org.eclipse.dd.dsf.debug.service.IFormattedValues;
import org.eclipse.dd.dsf.debug.service.IStack;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;

public class DisassemblyTextHover
implements ITextHover {
    private final DisassemblyPart fDisassemblyPart;

    public DisassemblyTextHover(DisassemblyPart part) {
        this.fDisassemblyPart = part;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        IDocument doc = textViewer.getDocument();
        return CWordFinder.findWord((IDocument)doc, (int)offset);
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        block8: {
            DisassemblyDocument doc = (DisassemblyDocument)textViewer.getDocument();
            int offset = hoverRegion.getOffset();
            try {
                String ident = doc.get(offset, hoverRegion.getLength());
                String value = null;
                AddressRangePosition pos = doc.getModelPosition(offset);
                if (pos instanceof SourcePosition) {
                    value = this.evaluateExpression(ident);
                } else if (pos instanceof LabelPosition) {
                    value = this.evaluateExpression(ident);
                } else if (pos instanceof DisassemblyPosition && (value = this.evaluateRegister(ident)) == null) {
                    value = this.evaluateExpression(ident);
                }
                if (value != null) {
                    return ident + " = " + value;
                }
            }
            catch (BadLocationException e) {
                if (!DsfDebugUIPlugin.getDefault().isDebugging()) break block8;
                DsfDebugUIPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.dd.dsf.debug.ui", "Internal Error", (Throwable)e));
            }
        }
        return null;
    }

    private String evaluateRegister(String register) {
        return null;
    }

    private String evaluateExpression(String expr) {
        final IExpressions expressions = this.fDisassemblyPart.getService(IExpressions.class);
        if (expressions == null) {
            return null;
        }
        IStack.IFrameDMContext frameDmc = this.fDisassemblyPart.getTargetFrameContext();
        if (frameDmc == null || !this.fDisassemblyPart.isSuspended()) {
            return null;
        }
        IExpressions.IExpressionDMContext exprDmc = expressions.createExpression((IDMContext)frameDmc, expr);
        final IFormattedValues.FormattedValueDMContext valueDmc = expressions.getFormattedValueContext((IFormattedValues.IFormattedDataDMContext)exprDmc, "NATURAL.Format");
        final DsfExecutor executor = this.fDisassemblyPart.getSession().getExecutor();
        Query<IFormattedValues.FormattedValueDMData> query = new Query<IFormattedValues.FormattedValueDMData>(){

            protected void execute(final DataRequestMonitor<IFormattedValues.FormattedValueDMData> rm) {
                expressions.getFormattedExpressionValue(valueDmc, (DataRequestMonitor)new DataRequestMonitor<IFormattedValues.FormattedValueDMData>((Executor)executor, rm){

                    protected void handleSuccess() {
                        IFormattedValues.FormattedValueDMData data = (IFormattedValues.FormattedValueDMData)this.getData();
                        rm.setData((Object)data);
                        rm.done();
                    }
                });
            }
        };
        executor.execute((Runnable)query);
        IFormattedValues.FormattedValueDMData data = null;
        try {
            data = (IFormattedValues.FormattedValueDMData)query.get();
        }
        catch (InterruptedException exc) {
        }
        catch (ExecutionException exc) {
            // empty catch block
        }
        if (data != null) {
            return data.getFormattedValue();
        }
        return null;
    }
}

