/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.ui.viewmodel.datamodel;

import java.util.concurrent.RejectedExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DsfRunnable;
import org.eclipse.dd.dsf.concurrent.Immutable;
import org.eclipse.dd.dsf.datamodel.DMContexts;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.datamodel.IDMEvent;
import org.eclipse.dd.dsf.internal.ui.DsfUIPlugin;
import org.eclipse.dd.dsf.service.DsfServicesTracker;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.dsf.service.IDsfService;
import org.eclipse.dd.dsf.ui.viewmodel.AbstractVMContext;
import org.eclipse.dd.dsf.ui.viewmodel.AbstractVMNode;
import org.eclipse.dd.dsf.ui.viewmodel.IVMContext;
import org.eclipse.dd.dsf.ui.viewmodel.IVMNode;
import org.eclipse.dd.dsf.ui.viewmodel.VMDelta;
import org.eclipse.dd.dsf.ui.viewmodel.datamodel.AbstractDMVMProvider;
import org.eclipse.dd.dsf.ui.viewmodel.datamodel.CompositeDMVMContext;
import org.eclipse.dd.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDMVMNode
extends AbstractVMNode
implements IVMNode {
    private DsfSession fSession;
    private DsfServicesTracker fServicesTracker;
    private Class<? extends IDMContext> fDMCClassType;

    public AbstractDMVMNode(AbstractDMVMProvider provider, DsfSession session, Class<? extends IDMContext> dmcClassType) {
        super(provider);
        this.fSession = session;
        this.fServicesTracker = new DsfServicesTracker(DsfUIPlugin.getBundleContext(), session.getId());
        this.fDMCClassType = dmcClassType;
    }

    @Override
    public void dispose() {
        this.fServicesTracker.dispose();
        super.dispose();
    }

    @Override
    public void getContextsForEvent(VMDelta parentDelta, Object event, DataRequestMonitor<IVMContext[]> rm) {
        IDMEvent dmEvent;
        IDMContext dmc;
        if (event instanceof IDMEvent && (dmc = DMContexts.getAncestorOfType((IDMContext)(dmEvent = (IDMEvent)event).getDMContext(), this.fDMCClassType)) != null) {
            rm.setData((Object)new IVMContext[]{this.createVMContext(dmc)});
            rm.done();
            return;
        }
        super.getContextsForEvent(parentDelta, event, rm);
    }

    protected AbstractDMVMProvider getDMVMProvider() {
        return (AbstractDMVMProvider)this.getVMProvider();
    }

    protected DsfSession getSession() {
        return this.fSession;
    }

    protected DsfServicesTracker getServicesTracker() {
        return this.fServicesTracker;
    }

    @Override
    protected boolean checkUpdate(IViewerUpdate update) {
        IDMContext dmc;
        if (!super.checkUpdate(update)) {
            return false;
        }
        Object element = update.getElement();
        if (element instanceof IDMVMContext && ((dmc = ((IDMVMContext)element).getDMContext()).getSessionId() != this.getSession().getId() || !DsfSession.isSessionActive((String)dmc.getSessionId()))) {
            this.handleFailedUpdate(update);
            return false;
        }
        return true;
    }

    @Deprecated
    protected boolean checkDmc(IDMContext dmc, IViewerUpdate update) {
        if (dmc == null) {
            update.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.ui", 10001, "No valid context found.", null));
            this.handleFailedUpdate(update);
            return false;
        }
        return true;
    }

    @Deprecated
    protected boolean checkService(Class<? extends IDsfService> serviceClass, String filter, IViewerUpdate update) {
        if (this.getServicesTracker().getService(serviceClass, filter) == null) {
            update.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.ui", 10001, "Service " + serviceClass.getName() + " not available.", null));
            this.handleFailedUpdate(update);
            return false;
        }
        return true;
    }

    public void update(final IHasChildrenUpdate[] updates) {
        try {
            this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    for (IHasChildrenUpdate update : updates) {
                        if (!AbstractDMVMNode.this.checkUpdate((IViewerUpdate)update)) continue;
                        AbstractDMVMNode.this.updateHasElementsInSessionThread(update);
                    }
                }
            });
        }
        catch (RejectedExecutionException e) {
            for (IHasChildrenUpdate update : updates) {
                this.handleFailedUpdate((IViewerUpdate)update);
            }
        }
    }

    @ConfinedToDsfExecutor(value="getSession().getExecutor()")
    protected void updateHasElementsInSessionThread(IHasChildrenUpdate update) {
        update.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.ui", 10003, "Not implemented, clients should call to update all children instead.", null));
        update.done();
    }

    public void update(final IChildrenCountUpdate[] updates) {
        try {
            this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    for (IChildrenCountUpdate update : updates) {
                        if (!AbstractDMVMNode.this.checkUpdate((IViewerUpdate)update)) continue;
                        AbstractDMVMNode.this.updateElementCountInSessionThread(update);
                    }
                }
            });
        }
        catch (RejectedExecutionException e) {
            for (IChildrenCountUpdate update : updates) {
                this.handleFailedUpdate((IViewerUpdate)update);
            }
        }
    }

    @ConfinedToDsfExecutor(value="getSession().getExecutor()")
    protected void updateElementCountInSessionThread(IChildrenCountUpdate update) {
        update.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.ui", 10003, "Not implemented, clients should call to update all children instead.", null));
        update.done();
    }

    public void update(final IChildrenUpdate[] updates) {
        try {
            this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    for (IChildrenUpdate update : updates) {
                        if (!AbstractDMVMNode.this.checkUpdate((IViewerUpdate)update)) continue;
                        AbstractDMVMNode.this.updateElementsInSessionThread(update);
                    }
                }
            });
        }
        catch (RejectedExecutionException e) {
            for (IChildrenUpdate update : updates) {
                this.handleFailedUpdate((IViewerUpdate)update);
            }
        }
    }

    @ConfinedToDsfExecutor(value="getSession().getExecutor()")
    protected abstract void updateElementsInSessionThread(IChildrenUpdate var1);

    protected IVMContext[] dmcs2vmcs(IDMContext[] dmcs) {
        IVMContext[] vmContexts = new IVMContext[dmcs.length];
        for (int i = 0; i < dmcs.length; ++i) {
            vmContexts[i] = this.createVMContext(dmcs[i]);
        }
        return vmContexts;
    }

    protected void fillUpdateWithVMCs(IChildrenUpdate update, IDMContext[] dmcs) {
        this.fillUpdateWithVMCs(update, dmcs, 0);
    }

    protected void fillUpdateWithVMCs(IChildrenUpdate update, IDMContext[] dmcs, int firstIndex) {
        int updateIdx = update.getOffset() != -1 ? update.getOffset() : 0;
        int endIdx = updateIdx + (update.getLength() != -1 ? update.getLength() : dmcs.length);
        int dmcIdx = updateIdx - firstIndex;
        if (dmcIdx < 0) {
            updateIdx -= dmcIdx;
            dmcIdx = 0;
        }
        while (updateIdx < endIdx && dmcIdx < dmcs.length) {
            update.setChild((Object)this.createVMContext(dmcs[dmcIdx++]), updateIdx++);
        }
    }

    protected IDMVMContext createVMContext(IDMContext dmc) {
        return new DMVMContext(dmc);
    }

    protected IDMContext createCompositeDMVMContext(IViewerUpdate update) {
        return new CompositeDMVMContext(update);
    }

    protected <T extends IDMContext> T findDmcInPath(Object inputObject, TreePath path, Class<T> dmcType) {
        IDMContext dmc;
        Object retVal = null;
        for (int i = path.getSegmentCount() - 1; !(i < 0 || path.getSegment(i) instanceof IDMVMContext && (dmc = ((IDMVMContext)path.getSegment(i)).getDMContext()).getSessionId().equals(this.getSession().getId()) && (retVal = DMContexts.getAncestorOfType((IDMContext)dmc, dmcType)) != null); --i) {
        }
        if (retVal == null) {
            if (inputObject instanceof ITreeSelection) {
                ITreeSelection inputSelection = (ITreeSelection)inputObject;
                if (inputSelection.getPaths().length == 1) {
                    retVal = this.findDmcInPath(null, inputSelection.getPaths()[0], dmcType);
                }
            } else if (inputObject instanceof IStructuredSelection) {
                Object rootElement = ((IStructuredSelection)inputObject).getFirstElement();
                if (rootElement instanceof IDMVMContext) {
                    retVal = DMContexts.getAncestorOfType((IDMContext)((IDMVMContext)rootElement).getDMContext(), dmcType);
                }
            } else if (inputObject instanceof IDMVMContext) {
                retVal = DMContexts.getAncestorOfType((IDMContext)((IDMVMContext)inputObject).getDMContext(), dmcType);
            }
        }
        return (T)retVal;
    }

    @Immutable
    protected class DMVMContext
    extends AbstractVMContext
    implements IDMVMContext {
        private final IDMContext fDmc;

        public DMVMContext(IDMContext dmc) {
            super(AbstractDMVMNode.this);
            this.fDmc = dmc;
        }

        public IDMContext getDMContext() {
            return this.fDmc;
        }

        public Object getAdapter(Class adapter) {
            Object superAdapter = super.getAdapter(adapter);
            if (superAdapter != null) {
                return superAdapter;
            }
            if (adapter.isInstance(this.fDmc)) {
                return this.fDmc;
            }
            return this.fDmc.getAdapter(adapter);
        }

        public boolean equals(Object other) {
            if (!(other instanceof DMVMContext)) {
                return false;
            }
            DMVMContext otherVmc = (DMVMContext)other;
            return AbstractDMVMNode.this.equals(otherVmc.getVMNode()) && this.fDmc.equals(otherVmc.fDmc);
        }

        public int hashCode() {
            return AbstractDMVMNode.this.hashCode() + this.fDmc.hashCode();
        }

        public String toString() {
            return this.fDmc.toString();
        }
    }
}

